/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.metagen.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.Utils;
import com.ibm.ws.jca.utils.metagen.internal.XmlFileSet;
import com.ibm.ws.jca.utils.xml.metatype.Metatype;
import com.ibm.ws.jca.utils.xml.ra.RaConnector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

@Trivial
public class MetaGenInstance {
    public final XmlFileSet xmlFileSet = new XmlFileSet();
    public final String adapterName;
    public final Metatype metatype = new Metatype();
    private boolean isProcessed = false;
    private String moduleName;

    public MetaGenInstance(String adapterName, String rarFilePath) throws IOException {
        this.adapterName = adapterName;
        File _rarFile = new File(rarFilePath);
        if (!_rarFile.getName().endsWith(".rar")) {
            throw new IOException("The file " + _rarFile.getName() + " uses an unexpected file type. The expected file type is .rar");
        }
        if (!Utils.doesFileExistPrivileged(_rarFile)) {
            throw new FileNotFoundException(_rarFile.getAbsolutePath());
        }
        this.xmlFileSet.rarFile = _rarFile;
    }

    public MetaGenInstance(String adapterName, String raXmlFilePath, String wlpRaXmlFilePath) throws IOException {
        this.adapterName = adapterName;
        File _raXmlFile = new File(raXmlFilePath);
        if (!_raXmlFile.getName().endsWith("ra.xml")) {
            throw new IOException("Expecting ra.xml but found " + _raXmlFile.getName());
        }
        this.xmlFileSet.raXmlFile = _raXmlFile;
        if (wlpRaXmlFilePath == null) {
            return;
        }
        File _wlpRaXmlFile = new File(wlpRaXmlFilePath);
        if (!_wlpRaXmlFile.getName().endsWith("wlp-ra.xml")) {
            throw new IOException("Expecting wlp-ra.xml but found " + _wlpRaXmlFile.getName());
        }
        this.xmlFileSet.wlpRaXmlFile = _wlpRaXmlFile;
    }

    public MetaGenInstance(String adapterName, RaConnector mergedConnector, String moduleName) throws IOException {
        this.adapterName = adapterName;
        this.xmlFileSet.parsedXml = mergedConnector;
        this.moduleName = moduleName;
    }

    public void markAsProcessed() {
        this.isProcessed = true;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetaGenInstance{");
        sb.append("adapterName='").append(this.adapterName);
        sb.append("' isProcessed='").append(this.isProcessed);
        sb.append("' xmlFileSet=").append(this.xmlFileSet);
        sb.append('}');
        return sb.toString();
    }
}

