/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.api.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class JobOperatorImplSuspendTran
implements JobOperator {
    private TransactionManager tranMgr;
    private JobOperator jobOperator;
    static final long serialVersionUID = -8839145975293738640L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
    }

    @Deactivate
    protected void deactivate() {
    }

    @Reference(service=EmbeddableWebSphereTransactionManager.class)
    protected void setTransactionManager(TransactionManager tranMgr) {
        this.tranMgr = tranMgr;
    }

    @Reference(target="(component.name=com.ibm.jbatch.container.api.impl.JobOperatorImpl)")
    protected void setJobOperator(JobOperator jobOperator) {
        this.jobOperator = jobOperator;
    }

    /*
     * WARNING - void declaration
     */
    private Transaction suspendTran() {
        try {
            return this.tranMgr.suspend();
        }
        catch (SystemException systemException) {
            void se;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImplSuspendTran", (String)"101", (Object)this, (Object[])new Object[0]);
            throw new BatchRuntimeException("Failed to suspend current transaction before JobOperator method", (Throwable)se);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resumeTran(Transaction tran) {
        if (tran != null) {
            try {
                this.tranMgr.resume(tran);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImplSuspendTran", (String)"113", (Object)this, (Object[])new Object[]{tran});
                throw new BatchRuntimeException("Failed to resume transaction after JobOperator method", (Throwable)e);
            }
        }
    }

    public Set<String> getJobNames() throws JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            Set set = this.jobOperator.getJobNames();
            return set;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            int n = this.jobOperator.getJobInstanceCount(jobName);
            return n;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List list = this.jobOperator.getJobInstances(jobName, start, count);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List list = this.jobOperator.getRunningExecutions(jobName);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            Properties properties = this.jobOperator.getParameters(executionId);
            return properties;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            long l = this.jobOperator.start(jobXMLName, jobParameters);
            return l;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long restart(long executionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            long l = this.jobOperator.restart(executionId, restartParameters);
            return l;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            this.jobOperator.stop(executionId);
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            this.jobOperator.abandon(executionId);
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            JobInstance jobInstance = this.jobOperator.getJobInstance(executionId);
            return jobInstance;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List list = this.jobOperator.getJobExecutions(instance);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            JobExecution jobExecution = this.jobOperator.getJobExecution(executionId);
            return jobExecution;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List list = this.jobOperator.getStepExecutions(jobExecutionId);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JobOperatorImplSuspendTran.class, (String)"wsbatch", null);
    }
}

