/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class BatchXMLMapper {
    private static final Logger logger = Logger.getLogger(BatchXMLMapper.class.getName());
    private static final String BATCH_XML = "META-INF/batch.xml";
    private static final QName BATCH_ROOT_ELEM = new QName("http://xmlns.jcp.org/xml/ns/javaee", "batch-artifacts");
    private ArtifactMap artifactMap;
    private static final Map<ClassLoader, ArtifactMap> loader2ArtifactMap = new WeakHashMap<ClassLoader, ArtifactMap>();
    private final ClassLoader loader;
    static final long serialVersionUID = -723176284427592097L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchXMLMapper(ClassLoader loader) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.cdi.BatchXMLMapper", "<init>", new Object[]{loader});
        }
        this.loader = loader;
        this.artifactMap = loader2ArtifactMap.get(loader);
        if (this.artifactMap == null) {
            this.artifactMap = BatchXMLMapper.populateArtifactMap(loader);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.cdi.BatchXMLMapper", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getArtifactById(String id) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.cdi.BatchXMLMapper", "getArtifactById", new Object[]{id});
        }
        Class clazz = (Class)this.artifactMap.idToArtifactClassMap.get(id);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            clazz = clazz;
            logger.exiting("com.ibm.jbatch.container.cdi.BatchXMLMapper", "getArtifactById", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static synchronized ArtifactMap populateArtifactMap(ClassLoader loader) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.cdi.BatchXMLMapper", "populateArtifactMap", new Object[]{loader});
        }
        ArtifactMap artifactMap = loader2ArtifactMap.get(loader);
        if (artifactMap != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Map already initialized for loader: " + loader);
            }
            ArtifactMap artifactMap2 = artifactMap;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                artifactMap2 = artifactMap2;
                logger.exiting("com.ibm.jbatch.container.cdi.BatchXMLMapper", "populateArtifactMap", artifactMap2);
            }
            return artifactMap2;
        }
        artifactMap = new ArtifactMap(loader);
        InputStream is = loader.getResourceAsStream(BATCH_XML);
        if (is != null) {
            artifactMap = BatchXMLMapper.populateArtifactMapFromStream(artifactMap, is);
            loader2ArtifactMap.put(loader, artifactMap);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("Did not find batch.xml in classloader: " + loader);
        }
        ArtifactMap artifactMap3 = artifactMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            artifactMap3 = artifactMap3;
            logger.exiting("com.ibm.jbatch.container.cdi.BatchXMLMapper", "populateArtifactMap", artifactMap3);
        }
        return artifactMap3;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static ArtifactMap populateArtifactMapFromStream(ArtifactMap tempMap, InputStream is) {
        ArtifactMap artifactMap;
        block8: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.cdi.BatchXMLMapper", "populateArtifactMapFromStream", new Object[]{tempMap, is});
            }
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            try {
                int event;
                XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Loaded XMLStreamReader = " + xmlStreamReader);
                }
                boolean processedRoot = false;
                while (xmlStreamReader.hasNext() && (event = xmlStreamReader.next()) != 8) {
                    if (event != 1) continue;
                    if (!processedRoot) {
                        QName rootQName = xmlStreamReader.getName();
                        if (!rootQName.equals(BATCH_ROOT_ELEM)) {
                            throw new IllegalStateException("Expecting document with root element QName: " + BATCH_ROOT_ELEM + ", but found root element with QName: " + rootQName);
                        }
                        processedRoot = true;
                        continue;
                    }
                    String annotationShortName = xmlStreamReader.getLocalName();
                    String id = xmlStreamReader.getAttributeValue(null, "id");
                    String className = xmlStreamReader.getAttributeValue(null, "class");
                    tempMap.addEntry(annotationShortName, id, className);
                    while (event != 2) {
                        event = xmlStreamReader.next();
                    }
                }
                xmlStreamReader.close();
                is.close();
                artifactMap = tempMap;
                if (logger == null || !logger.isLoggable(Level.FINER)) break block8;
            }
            catch (Exception xmlStreamReader) {
                void e;
                FFDCFilter.processException((Throwable)xmlStreamReader, (String)"com.ibm.jbatch.container.cdi.BatchXMLMapper", (String)"159", null, (Object[])new Object[]{tempMap, is});
                throw new RuntimeException((Throwable)e);
            }
            artifactMap = artifactMap;
            logger.exiting("com.ibm.jbatch.container.cdi.BatchXMLMapper", "populateArtifactMapFromStream", artifactMap);
        }
        return artifactMap;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArtifactMap {
        private final ClassLoader loader;
        private final Map<String, Class<?>> idToArtifactClassMap = new HashMap();
        private final Map<String, List<String>> idToArtifactTypeListMap = new HashMap<String, List<String>>();
        static final long serialVersionUID = -6954832915358959132L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactMap(ClassLoader loader) {
            this.loader = loader;
        }

        /*
         * WARNING - void declaration
         */
        void addEntry(String batchTypeName, String id, String className) {
            try {
                if (!this.idToArtifactClassMap.containsKey(id)) {
                    Class<?> artifactClass = this.loader.loadClass(className);
                    this.idToArtifactClassMap.put(id, artifactClass);
                    ArrayList<String> typeList = new ArrayList<String>();
                    typeList.add(batchTypeName);
                    this.idToArtifactTypeListMap.put(id, typeList);
                } else {
                    Class<?> artifactClass = this.loader.loadClass(className);
                    if (!this.idToArtifactClassMap.get(id).equals(artifactClass)) {
                        Class<?> alreadyLoaded = this.idToArtifactClassMap.get(id);
                        String msg = "Attempted to load batch artifact with id: " + id + ", and className: " + className + ". Found: " + artifactClass + ", however the artifact id: " + id + " is already associated with: " + alreadyLoaded + ", of className: " + alreadyLoaded.getCanonicalName();
                        throw new IllegalArgumentException(msg);
                    }
                    List<String> typeList = this.idToArtifactTypeListMap.get(id);
                    typeList.add(batchTypeName);
                }
            }
            catch (Exception artifactClass) {
                void e;
                FFDCFilter.processException((Throwable)artifactClass, (String)"com.ibm.jbatch.container.cdi.BatchXMLMapper$ArtifactMap", (String)"207", (Object)this, (Object[])new Object[]{batchTypeName, id, className});
                throw new RuntimeException((Throwable)e);
            }
        }

        private List<String> getBatchTypeList(String id) {
            return this.idToArtifactTypeListMap.get(id);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ArtifactMap.class, (String)"wsbatch", null);
        }
    }
}

