/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.osgi.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.EARApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.ApplicationMetaDataListener;
import com.ibm.ws.container.service.metadata.ComponentMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.MetaDataUtils;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.injectionengine.AbstractInjectionEngine;
import com.ibm.ws.injectionengine.osgi.internal.EJBLinkReferenceFactoryImpl;
import com.ibm.ws.injectionengine.osgi.internal.IndirectJndiLookupReferenceFactoryImpl;
import com.ibm.ws.injectionengine.osgi.internal.IndirectReference;
import com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionScopeData;
import com.ibm.ws.injectionengine.osgi.internal.OSGiReferenceContextImpl;
import com.ibm.ws.injectionengine.osgi.internal.ResAutoLinkReferenceFactoryImpl;
import com.ibm.ws.injectionengine.osgi.internal.ResRefReferenceFactoryImpl;
import com.ibm.ws.injectionengine.osgi.internal.ResourceBindingImpl;
import com.ibm.ws.injectionengine.osgi.internal.ResourceBindingListenerManager;
import com.ibm.ws.injectionengine.osgi.internal.ResourceFactoryReference;
import com.ibm.ws.injectionengine.osgi.util.OSGiJNDIEnvironmentRefBindingHelper;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.appbnd.ApplicationBnd;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRefs;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.resource.ResourceRefConfig;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import com.ibm.wsspi.injectionengine.InjectionProcessorContextImpl;
import com.ibm.wsspi.injectionengine.InjectionProcessorProvider;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefBindingHelper;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.injectionengine.factory.EJBLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.IndirectJndiLookupReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.ResAutoLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.ResRefReferenceFactory;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSetMap;
import com.ibm.wsspi.resource.ResourceBindingListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OSGiInjectionEngineImpl.class, InjectionEngine.class, ApplicationMetaDataListener.class, ModuleMetaDataListener.class, ComponentMetaDataListener.class, ApplicationStateListener.class}, property={"service.vendor=IBM"})
public class OSGiInjectionEngineImpl
extends AbstractInjectionEngine
implements InjectionEngine,
ApplicationMetaDataListener,
ModuleMetaDataListener,
ComponentMetaDataListener,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(OSGiInjectionEngineImpl.class, (String)"Injection", (String)"com.ibm.ws.injection.resources.InjectionMessages");
    private static final TraceComponent tcTWAS = Tr.register(OSGiInjectionEngineImpl.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private static final String REFERENCE_RESOURCE_BINDING_LISTENERS = "resourceBindingListeners";
    private static final String REFERENCE_RESOURCE_FACTORY_BUILDERS = "resourceFactoryBuilders";
    private static final String REFERENCE_EJB_LINK_REFERENCE_FACTORY = "ejbLinkReferenceFactory";
    private static final Bundle bundle = FrameworkUtil.getBundle(OSGiInjectionEngineImpl.class);
    private static final BundleContext bundleContext = bundle.getBundleContext();
    private static final String OBJECT_FACTORY_NAME = ObjectFactory.class.getName();
    private static final String OBJECT_FACTORY_FILTER = "(objectClass=" + OBJECT_FACTORY_NAME + ")";
    private static final AtomicServiceReference<EJBLinkReferenceFactory> ejbLinkReferenceFactorySRRef = new AtomicServiceReference("ejbLinkReferenceFactory");
    private final ConcurrentServiceReferenceSet<ResourceBindingListener> resourceBindingListeners = new ConcurrentServiceReferenceSet("resourceBindingListeners");
    private final ResourceBindingListenerManager resourceBindingListenerManager = new ResourceBindingListenerManager(this.resourceBindingListeners);
    private final IndirectJndiLookupReferenceFactory indirectJndiLookupReferenceFactory = new IndirectJndiLookupReferenceFactoryImpl(null);
    private final IndirectJndiLookupReferenceFactoryImpl resIndirectJndiLookupReferenceFactory = new IndirectJndiLookupReferenceFactoryImpl(this.resourceBindingListenerManager);
    private final ResRefReferenceFactoryImpl resRefReferenceFactory = new ResRefReferenceFactoryImpl(this.resourceBindingListenerManager);
    private final ResAutoLinkReferenceFactory resAutoLinkReferenceFactory = new ResAutoLinkReferenceFactoryImpl(this.resRefReferenceFactory);
    private final EJBLinkReferenceFactory ejbLinkReferenceFactory = new EJBLinkReferenceFactoryImpl(ejbLinkReferenceFactorySRRef);
    private MetaDataSlot applicationMetaDataSlot;
    private MetaDataSlot moduleMetaDataSlot;
    private MetaDataSlot componentMetaDataSlot;
    private final ConcurrentServiceReferenceSetMap<String, ResourceFactoryBuilder> resourceFactoryBuilders = new ConcurrentServiceReferenceSetMap("resourceFactoryBuilders");
    ResourceRefConfigFactory resourceRefConfigFactory;
    private ResourceRefConfig defaultResourceRefConfig;
    private final ReentrantReadWriteLock nonCompLock = new ReentrantReadWriteLock();
    private final OSGiInjectionScopeData globalScopeData = new OSGiInjectionScopeData(null, NamingConstants.JavaColonNamespace.GLOBAL, null, this.nonCompLock);
    static final long serialVersionUID = -8146233880954075378L;

    public OSGiInjectionEngineImpl() {
        this.initialize();
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.resourceBindingListeners.activate(context);
        this.resourceFactoryBuilders.activate(context);
        ejbLinkReferenceFactorySRRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.resourceBindingListeners.deactivate(context);
        this.resourceFactoryBuilders.deactivate(context);
        ejbLinkReferenceFactorySRRef.deactivate(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    protected void processInjectionMetaData(final ComponentNameSpaceConfiguration compNSConfig, List<Class<?>> annotatedClasses) throws InjectionException {
        Lock writeLock;
        Map<String, InjectionBinding<?>> bindings = compNSConfig.getJavaColonCompEnvMap();
        if (bindings == null) {
            bindings = new LinkedHashMap();
            compNSConfig.setJavaColonCompEnvMap(bindings);
        }
        if (annotatedClasses == null && !compNSConfig.isMetaDataComplete()) {
            annotatedClasses = compNSConfig.getInjectionClasses();
        }
        if (annotatedClasses == null) {
            annotatedClasses = Collections.emptyList();
        }
        InjectionProcessorContextImpl context = (InjectionProcessorContextImpl)compNSConfig.getInjectionProcessorContext();
        context.ivSaveNonCompInjectionBindings = true;
        context.ivSavedGlobalInjectionBindings = new HashMap();
        context.ivSavedAppInjectionBindings = new HashMap();
        context.ivSavedModuleInjectionBindings = new HashMap();
        OSGiInjectionScopeData compScopeData = this.getCompInjectionScopeData(compNSConfig);
        ModuleMetaData mmd = compNSConfig.getModuleMetaData();
        OSGiInjectionScopeData moduleScopeData = mmd == null ? null : this.getInjectionScopeData(mmd);
        OSGiInjectionScopeData appScopeData = this.getInjectionScopeData(compNSConfig.getApplicationMetaData());
        OSGiInjectionScopeData contributorScopeData = compScopeData != null ? compScopeData : appScopeData;
        Lock lock = writeLock = compScopeData == null ? null : compScopeData.compLock().writeLock();
        if (writeLock != null) {
            writeLock.lock();
        }
        try {
            if (compScopeData != null && compScopeData.compEnvBindings != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"dynamic update to injection metadata", (Object[])new Object[0]);
                }
                context.ivCompletedInjectionBindings = compScopeData.compEnvBindings;
            }
            if (compNSConfig.getMBLinkReferenceFactory() == null) {
                compNSConfig.setMBLinkReferenceFactory(this.ivMBLinkRefFactory);
            }
            if (System.getSecurityManager() == null) {
                super.processInjectionMetaData(compNSConfig, annotatedClasses);
            } else {
                try {
                    final List<Class<Object>> privAnnotatedClasses = annotatedClasses;
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                        static final long serialVersionUID = 977456262439207526L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() throws InjectionException {
                            OSGiInjectionEngineImpl.this.processInjectionMetaDataPrivileged(compNSConfig, privAnnotatedClasses);
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String)"Injection", (String)"com.ibm.ws.injection.resources.InjectionMessages");
                        }
                    });
                }
                catch (PrivilegedActionException paex) {
                    Throwable cause = paex.getCause();
                    if (cause instanceof InjectionException) {
                        throw (InjectionException)cause;
                    }
                    throw new Error(cause);
                }
            }
            if (!bindings.isEmpty() && compScopeData == null && !this.isManagedBean(compNSConfig)) {
                this.applicationReferenceNameError(compNSConfig, bindings.keySet());
            }
            ReentrantReadWriteLock.WriteLock nonCompWriteLock = this.nonCompLock.writeLock();
            nonCompWriteLock.lock();
            try {
                if (moduleScopeData != null) {
                    moduleScopeData.validateNonCompBindings(context.ivSavedModuleInjectionBindings);
                } else if (!context.ivSavedModuleInjectionBindings.isEmpty()) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (Map newModuleBindings : context.ivSavedModuleInjectionBindings.values()) {
                        names.addAll(newModuleBindings.keySet());
                    }
                    this.applicationReferenceNameError(compNSConfig, names);
                }
                appScopeData.validateNonCompBindings(context.ivSavedAppInjectionBindings);
                this.globalScopeData.validateNonCompBindings(context.ivSavedGlobalInjectionBindings);
                if (compScopeData != null) {
                    compScopeData.addCompEnvBindings(bindings);
                }
                if (moduleScopeData != null) {
                    moduleScopeData.addNonCompBindings(context.ivSavedModuleInjectionBindings, contributorScopeData);
                }
                appScopeData.addNonCompBindings(context.ivSavedAppInjectionBindings, contributorScopeData);
                this.globalScopeData.addNonCompBindings(context.ivSavedGlobalInjectionBindings, contributorScopeData);
            }
            finally {
                nonCompWriteLock.unlock();
            }
        }
        finally {
            if (writeLock != null) {
                writeLock.unlock();
            }
        }
    }

    private void processInjectionMetaDataPrivileged(ComponentNameSpaceConfiguration compNSConfig, List<Class<?>> annotatedClasses) throws InjectionException {
        super.processInjectionMetaData(compNSConfig, annotatedClasses);
    }

    private void applicationReferenceNameError(ComponentNameSpaceConfiguration compNSConfig, Collection<String> names) throws InjectionConfigurationException {
        String appName = compNSConfig.getJ2EEName().getApplication();
        String anyName = null;
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name;
            anyName = name = iterator.next();
            Tr.error((TraceComponent)tc, (String)"APPXML_REF_NAMESPACE_CWNEN1002E", (Object[])new Object[]{name, appName});
        }
        throw new InjectionConfigurationException(Tr.formatMessage((TraceComponent)tc, (String)"APPXML_REF_NAMESPACE_CWNEN1002E", (Object[])new Object[]{anyName, appName}));
    }

    @Override
    @Trivial
    public boolean isEmbeddable() {
        return false;
    }

    @Override
    @Trivial
    protected IndirectJndiLookupReferenceFactory getDefaultIndirectJndiLookupReferenceFactory() {
        return this.indirectJndiLookupReferenceFactory;
    }

    @Override
    @Trivial
    protected IndirectJndiLookupReferenceFactory getDefaultResIndirectJndiLookupReferenceFactory() {
        return this.resIndirectJndiLookupReferenceFactory;
    }

    @Override
    @Trivial
    protected ResRefReferenceFactory getDefaultResRefReferenceFactory() {
        return this.resRefReferenceFactory;
    }

    @Override
    @Trivial
    protected ResAutoLinkReferenceFactory getDefaultResAutoLinkReferenceFactory() {
        return this.resAutoLinkReferenceFactory;
    }

    @Override
    @Trivial
    protected EJBLinkReferenceFactory getDefaultEJBLinkReferenceFactory() {
        return this.ejbLinkReferenceFactory;
    }

    @Override
    @Trivial
    public boolean isValidationLoggable(boolean checkAppConfig) {
        return checkAppConfig;
    }

    @Override
    @Trivial
    public boolean isValidationFailable(boolean checkAppConfig) {
        return checkAppConfig;
    }

    @Override
    public OSGiInjectionScopeData getInjectionScopeData(MetaData metaData) {
        if (metaData == null) {
            return this.globalScopeData;
        }
        if (metaData instanceof ApplicationMetaData) {
            return this.getInjectionScopeData((ApplicationMetaData)metaData);
        }
        if (metaData instanceof ModuleMetaData) {
            return this.getInjectionScopeData((ModuleMetaData)metaData);
        }
        return this.getInjectionScopeData((ComponentMetaData)metaData);
    }

    private OSGiInjectionScopeData getInjectionScopeData(ApplicationMetaData amd) {
        OSGiInjectionScopeData scopeData = (OSGiInjectionScopeData)amd.getMetaData(this.applicationMetaDataSlot);
        if (scopeData == null) {
            scopeData = new OSGiInjectionScopeData(amd.getJ2EEName(), NamingConstants.JavaColonNamespace.APP, this.globalScopeData, this.nonCompLock);
            amd.setMetaData(this.applicationMetaDataSlot, (Object)scopeData);
        }
        return scopeData;
    }

    private OSGiInjectionScopeData getInjectionScopeData(ModuleMetaData mmd) {
        OSGiInjectionScopeData scopeData = (OSGiInjectionScopeData)mmd.getMetaData(this.moduleMetaDataSlot);
        if (scopeData == null) {
            OSGiInjectionScopeData parentScopeData = this.getInjectionScopeData(mmd.getApplicationMetaData());
            scopeData = new OSGiInjectionScopeData(mmd.getJ2EEName(), NamingConstants.JavaColonNamespace.MODULE, parentScopeData, this.nonCompLock);
            mmd.setMetaData(this.moduleMetaDataSlot, (Object)scopeData);
        }
        return scopeData;
    }

    private OSGiInjectionScopeData getInjectionScopeData(ComponentMetaData cmd) {
        OSGiInjectionScopeData scopeData = (OSGiInjectionScopeData)cmd.getMetaData(this.componentMetaDataSlot);
        if (scopeData == null) {
            OSGiInjectionScopeData parentScopeData = this.getInjectionScopeData(cmd.getModuleMetaData());
            scopeData = new OSGiInjectionScopeData(cmd.getJ2EEName(), NamingConstants.JavaColonNamespace.COMP, parentScopeData, null);
            cmd.setMetaData(this.componentMetaDataSlot, (Object)scopeData);
        }
        return scopeData;
    }

    private boolean isManagedBean(ComponentNameSpaceConfiguration compNSConfig) {
        return compNSConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.MANAGED_BEAN;
    }

    private OSGiInjectionScopeData getCompInjectionScopeData(ComponentNameSpaceConfiguration compNSConfig) {
        if (this.isManagedBean(compNSConfig)) {
            return null;
        }
        ComponentMetaData cmd = compNSConfig.getComponentMetaData();
        if (cmd == null) {
            ModuleMetaData mmd = compNSConfig.getModuleMetaData();
            if (mmd == null) {
                return null;
            }
            return this.getInjectionScopeData(mmd);
        }
        return this.getInjectionScopeData(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInjectionScopeData(MetaData metaData, MetaDataSlot slot) {
        OSGiInjectionScopeData scopeData = (OSGiInjectionScopeData)metaData.getMetaData(slot);
        if (scopeData != null) {
            Lock lock = scopeData.compLock().writeLock();
            lock.lock();
            try {
                ReentrantReadWriteLock.WriteLock nonCompWriteLock = this.nonCompLock.writeLock();
                nonCompWriteLock.lock();
                try {
                    scopeData.destroy();
                }
                finally {
                    nonCompWriteLock.unlock();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public OSGiInjectionScopeData getInjectionScopeData(ComponentMetaData cmd, NamingConstants.JavaColonNamespace namespace) {
        if (cmd == null) {
            return null;
        }
        if (namespace == NamingConstants.JavaColonNamespace.GLOBAL) {
            return this.globalScopeData;
        }
        if (namespace == NamingConstants.JavaColonNamespace.COMP || namespace == NamingConstants.JavaColonNamespace.COMP_ENV) {
            OSGiInjectionScopeData isd = (OSGiInjectionScopeData)cmd.getMetaData(this.componentMetaDataSlot);
            if (isd == null) {
                ModuleMetaData mmd = cmd.getModuleMetaData();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("trying module " + mmd), (Object[])new Object[0]);
                }
                if ((isd = (OSGiInjectionScopeData)cmd.getModuleMetaData().getMetaData(this.moduleMetaDataSlot)) == null || !isd.isCompAllowed()) {
                    return null;
                }
            }
            return isd;
        }
        ModuleMetaData mmd = cmd.getModuleMetaData();
        if (namespace == NamingConstants.JavaColonNamespace.MODULE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("trying " + mmd), (Object[])new Object[0]);
            }
            return (OSGiInjectionScopeData)mmd.getMetaData(this.moduleMetaDataSlot);
        }
        if (namespace == NamingConstants.JavaColonNamespace.APP) {
            ApplicationMetaData amd = mmd.getApplicationMetaData();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("trying " + amd), (Object[])new Object[0]);
            }
            return (OSGiInjectionScopeData)amd.getMetaData(this.applicationMetaDataSlot);
        }
        return null;
    }

    @Override
    public void injectClient(ComponentNameSpaceConfiguration compNSConfig) throws InjectionException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void processClientInjections(ComponentNameSpaceConfiguration compNSConfig, InjectionProcessorContextImpl processorContext) throws InjectionConfigurationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reference createDefinitionReference(ComponentNameSpaceConfiguration nameSpaceConfig, InjectionScope scope, String refName, String bindingName, String type, @Sensitive Map<String, Object> properties) throws Exception {
        Reference listenerReference = this.createDefinitionResourceBindingListenerReference(refName, bindingName, type, properties);
        if (listenerReference != null) {
            return listenerReference;
        }
        if (bindingName != null) {
            return new IndirectReference(refName, bindingName, type, null, null, false);
        }
        return this.createDefinitionResourceFactoryReference(nameSpaceConfig, scope, refName, type, properties);
    }

    private Reference createDefinitionResourceBindingListenerReference(String refName, String bindingName, String type, @Sensitive Map<String, Object> properties) {
        Boolean transactional = (Boolean)properties.get("transactional");
        Map<String, Object> bindingProperties = Collections.singletonMap("transactional", transactional == null || transactional != false);
        ResourceBindingImpl binding = this.resourceBindingListenerManager.binding(refName, bindingName, type, bindingProperties);
        if (binding != null) {
            return new IndirectReference(refName, binding.getBindingName(), type, null, binding.getBindingListenerName(), false);
        }
        return null;
    }

    @Override
    public void registerResourceFactoryBuilder(String type, ResourceFactoryBuilder builder) {
        throw new UnsupportedOperationException("ResourceFactoryBuilder implementations should be registered in the service registry with the ResourceFactory.CREATES_OBJECT_CLASS property.");
    }

    @Override
    public ResourceFactoryBuilder unregisterResourceFactoryBuilder(String type) {
        throw new UnsupportedOperationException("ResourceFactoryBuilder implementations should be registered in the service registry with the ResourceFactory.CREATES_OBJECT_CLASS property.");
    }

    @Override
    public ResourceFactoryBuilder getResourceFactoryBuilder(String type) throws InjectionException {
        ResourceFactoryBuilder builder;
        Iterator builderIter = this.resourceFactoryBuilders.getServices((Object)type);
        ResourceFactoryBuilder resourceFactoryBuilder = builder = builderIter.hasNext() ? (ResourceFactoryBuilder)builderIter.next() : null;
        if (builder == null) {
            throw new InjectionException(type + " definitions are not supported in this server configuration");
        }
        return builder;
    }

    private Reference createDefinitionResourceFactoryReference(ComponentNameSpaceConfiguration compNSConfig, InjectionScope scope, String refName, String type, @Sensitive Map<String, Object> properties) throws Exception {
        String appName;
        String moduleName;
        String compName;
        ApplicationMetaData metaData;
        ResourceFactoryBuilder builder = this.getResourceFactoryBuilder(type);
        J2EEName j2eeName = compNSConfig.getJ2EEName();
        if (scope == InjectionScope.GLOBAL) {
            metaData = null;
            compName = null;
            moduleName = null;
            appName = null;
        } else {
            appName = j2eeName.getApplication();
            if (scope == InjectionScope.APP) {
                metaData = compNSConfig.getApplicationMetaData();
                compName = null;
                moduleName = null;
            } else {
                moduleName = j2eeName.getModule();
                if (scope == InjectionScope.MODULE) {
                    metaData = compNSConfig.getModuleMetaData();
                    compName = null;
                } else {
                    compName = j2eeName.getComponent();
                    metaData = compNSConfig.getComponentMetaData();
                    if (metaData == null) {
                        metaData = compNSConfig.getModuleMetaData();
                    }
                }
            }
        }
        if (appName == null) {
            properties.remove("application");
        } else {
            properties.put("application", appName);
        }
        if (moduleName == null) {
            properties.remove("module");
        } else {
            properties.put("module", moduleName);
        }
        if (compName == null) {
            properties.remove("component");
        } else {
            properties.put("component", compName);
        }
        properties.put("declaringApplication", j2eeName.getApplication());
        properties.put("jndiName", InjectionScope.denormalize(refName));
        ResourceFactory resourceFactory = builder.createResourceFactory(properties);
        ResourceFactoryReference ref = new ResourceFactoryReference(type, resourceFactory, properties);
        this.getInjectionScopeData((MetaData)metaData).addDefinitionReference(refName, ref);
        return ref;
    }

    @Override
    public void destroyDefinitionReference(Reference ref) throws Exception {
        if (ref instanceof ResourceFactoryReference) {
            ResourceFactoryReference resourceFactoryReference = (ResourceFactoryReference)ref;
            resourceFactoryReference.getResourceFactory().destroy();
        }
    }

    @Override
    public void bindJavaNameSpaceObject(ComponentNameSpaceConfiguration compNSConfig, InjectionScope scope, String name, InjectionBinding<?> binding, Object bindingObject) throws InjectionException {
        if (scope == InjectionScope.COMP && binding != null) {
            OSGiInjectionScopeData scopeData = this.getCompInjectionScopeData(compNSConfig);
            if (scopeData == null) {
                if (this.isManagedBean(compNSConfig)) {
                    return;
                }
                this.applicationReferenceNameError(compNSConfig, Arrays.asList(name));
            }
            scopeData.addCompBinding(name, binding);
        }
    }

    @Override
    public Context createComponentNameSpaceContext(Object componentNameSpace) throws NamingException {
        return null;
    }

    @Override
    public Object createJavaNameSpace(String logicalAppName, String moduleName, String logicalModuleName, String componentName) throws NamingException {
        return null;
    }

    @Override
    public ResourceRefConfigList createResourceRefConfigList() {
        return this.resourceRefConfigFactory.createResourceRefConfigList();
    }

    @Override
    public synchronized ResourceRefConfig getDefaultResourceRefConfig() {
        if (this.defaultResourceRefConfig == null) {
            this.defaultResourceRefConfig = this.resourceRefConfigFactory.createResourceRefConfig("default");
        }
        return this.defaultResourceRefConfig;
    }

    @Override
    public Object getInjectableObject(InjectionBinding<?> binding, Object targetObject, InjectionTargetContext targetContext) throws InjectionException {
        return binding.getInjectionObject(targetObject, targetContext);
    }

    @Override
    public ReferenceContext createReferenceContext(MetaData md) {
        OSGiInjectionScopeData scopeData = this.getInjectionScopeData(md);
        return new OSGiReferenceContextImpl(this, scopeData);
    }

    @Override
    public ReferenceContext getCommonReferenceContext(ModuleMetaData mmd) {
        OSGiInjectionScopeData scopeData = this.getInjectionScopeData(mmd);
        ReferenceContext rc = scopeData.ivReferenceContext;
        if (rc == null) {
            scopeData.ivReferenceContext = rc = new OSGiReferenceContextImpl(this, scopeData);
        }
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ObjectFactory getObjectFactory(final String objectFactoryClassName, Class<? extends ObjectFactory> objectFactoryClass) throws InjectionException {
        ObjectFactory objectFactory;
        try {
            objectFactory = AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectFactory>(){
                static final long serialVersionUID = -3454696788185077530L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ObjectFactory run() throws InjectionException {
                    return OSGiInjectionEngineImpl.this.getOSGiObjectFactory(objectFactoryClassName);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"Injection", (String)"com.ibm.ws.injection.resources.InjectionMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void paex;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl", (String)"757", (Object)this, (Object[])new Object[]{objectFactoryClassName, objectFactoryClass});
            Throwable cause = paex.getCause();
            if (cause instanceof InjectionException) {
                throw (InjectionException)cause;
            }
            throw new Error(cause);
        }
        if (objectFactory != null) {
            return objectFactory;
        }
        if (objectFactoryClass != null) {
            return super.getObjectFactory(objectFactoryClassName, objectFactoryClass);
        }
        Tr.error((TraceComponent)tcTWAS, (String)"OBJECT_FACTORY_CLASS_FAILED_TO_LOAD_CWNEN0024E", (Object[])new Object[]{objectFactoryClassName});
        throw new InjectionException("The injection engine failed to load the " + objectFactoryClassName + " ObjectFactory class.");
    }

    /*
     * WARNING - void declaration
     */
    private ObjectFactory getOSGiObjectFactory(String objectFactoryClassName) throws InjectionException {
        ServiceReference[] references;
        if (objectFactoryClassName == null) {
            throw new IllegalStateException();
        }
        try {
            references = bundleContext.getAllServiceReferences(objectFactoryClassName, OBJECT_FACTORY_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl", (String)"793", (Object)this, (Object[])new Object[]{objectFactoryClassName});
            throw new IllegalStateException((Throwable)e);
        }
        if (references != null) {
            for (ServiceReference reference : references) {
                ObjectFactory objectFactory;
                if (!reference.isAssignableTo(bundle, OBJECT_FACTORY_NAME) || (objectFactory = (ObjectFactory)bundleContext.getService(reference)) == null) continue;
                return objectFactory;
            }
        }
        return null;
    }

    public void applicationMetaDataCreated(MetaDataEvent<ApplicationMetaData> event) {
        OSGiInjectionScopeData scopeData = this.getInjectionScopeData((ApplicationMetaData)event.getMetaData());
        scopeData.enableDeferredReferenceData();
    }

    public void applicationMetaDataDestroyed(MetaDataEvent<ApplicationMetaData> event) {
        this.destroyInjectionScopeData(event.getMetaData(), this.applicationMetaDataSlot);
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
        if (!MetaDataUtils.copyModuleMetaDataSlot(event, (MetaDataSlot)this.moduleMetaDataSlot)) {
            OSGiInjectionScopeData scopeData = this.getInjectionScopeData((ModuleMetaData)event.getMetaData());
            scopeData.enableDeferredReferenceData();
        }
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        this.destroyInjectionScopeData(event.getMetaData(), this.moduleMetaDataSlot);
    }

    public void componentMetaDataCreated(MetaDataEvent<ComponentMetaData> event) {
    }

    public void componentMetaDataDestroyed(MetaDataEvent<ComponentMetaData> event) {
        this.destroyInjectionScopeData(event.getMetaData(), this.componentMetaDataSlot);
    }

    /*
     * WARNING - void declaration
     */
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        if (appInfo instanceof EARApplicationInfo) {
            Application app;
            EARApplicationInfo earAppInfo = (EARApplicationInfo)appInfo;
            try {
                app = (Application)appInfo.getContainer().adapt(Application.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl", (String)"851", (Object)this, (Object[])new Object[]{appInfo});
                throw new StateChangeException((Throwable)e);
            }
            if (app != null) {
                this.processApplicationReferences(earAppInfo, app);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processApplicationReferences(EARApplicationInfo appInfo, Application app) throws StateChangeException {
        EnumMap<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> allRefs = new EnumMap<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>>(JNDIEnvironmentRefType.class);
        boolean anyRefs = false;
        for (JNDIEnvironmentRefType refType : JNDIEnvironmentRefType.VALUES) {
            List<? extends JNDIEnvironmentRef> refs = refType.getRefs((JNDIEnvironmentRefs)app);
            allRefs.put(refType, refs);
            anyRefs |= !refs.isEmpty();
        }
        if (anyRefs) {
            ApplicationBnd appBnd;
            try {
                appBnd = (ApplicationBnd)appInfo.getContainer().adapt(ApplicationBnd.class);
            }
            catch (UnableToAdaptException refType) {
                void e;
                FFDCFilter.processException((Throwable)refType, (String)"com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl", (String)"878", (Object)this, (Object[])new Object[]{appInfo, app});
                throw new StateChangeException((Throwable)e);
            }
            String compNSConfigName = appInfo.getName() + " META-INF/application.xml";
            ComponentNameSpaceConfiguration compNSConfig = new ComponentNameSpaceConfiguration(compNSConfigName, ((ExtendedApplicationInfo)appInfo).getMetaData().getJ2EEName());
            compNSConfig.setClassLoader(appInfo.getApplicationClassLoader());
            compNSConfig.setApplicationMetaData(((ExtendedApplicationInfo)appInfo).getMetaData());
            JNDIEnvironmentRefType.setAllRefs(compNSConfig, allRefs);
            if (appBnd != null) {
                Map<JNDIEnvironmentRefType, Map<String, String>> allBindings = JNDIEnvironmentRefBindingHelper.createAllBindingsMap();
                HashMap<String, String> envEntryValues = new HashMap<String, String>();
                ResourceRefConfigList resourceRefConfigList = this.resourceRefConfigFactory.createResourceRefConfigList();
                OSGiJNDIEnvironmentRefBindingHelper.processBndAndExt(allBindings, envEntryValues, resourceRefConfigList, (RefBindingsGroup)appBnd, null);
                JNDIEnvironmentRefBindingHelper.setAllBndAndExt(compNSConfig, allBindings, envEntryValues, resourceRefConfigList);
            }
            try {
                this.processInjectionMetaData(null, compNSConfig);
            }
            catch (InjectionException allBindings) {
                void e;
                FFDCFilter.processException((Throwable)allBindings, (String)"com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl", (String)"899", (Object)this, (Object[])new Object[]{appInfo, app});
                throw new StateChangeException((Throwable)e);
            }
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }

    @org.osgi.service.component.annotations.Reference(name="resourceBindingListeners", service=ResourceBindingListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setResourceBindingListener(ServiceReference<ResourceBindingListener> reference) {
        this.resourceBindingListeners.addReference(reference);
    }

    protected void unsetResourceBindingListener(ServiceReference<ResourceBindingListener> reference) {
        this.resourceBindingListeners.removeReference(reference);
    }

    private String[] getResourceFactoryTypes(ServiceReference<ResourceFactoryBuilder> reference) {
        Object createsObjectClass = reference.getProperty("creates.objectClass");
        if (createsObjectClass instanceof String[]) {
            return (String[])createsObjectClass;
        }
        if (createsObjectClass instanceof String) {
            return new String[]{(String)createsObjectClass};
        }
        return new String[0];
    }

    @org.osgi.service.component.annotations.Reference(name="resourceFactoryBuilders", service=ResourceFactoryBuilder.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setResourceFactoryBuilder(ServiceReference<ResourceFactoryBuilder> reference) {
        for (String type : this.getResourceFactoryTypes(reference)) {
            this.resourceFactoryBuilders.putReference((Object)type, reference);
        }
    }

    protected void unsetResourceFactoryBuilder(ServiceReference<ResourceFactoryBuilder> reference) {
        for (String type : this.getResourceFactoryTypes(reference)) {
            this.resourceFactoryBuilders.removeReference((Object)type, reference);
        }
    }

    @org.osgi.service.component.annotations.Reference
    protected void setMetaDataSlotService(MetaDataSlotService slotService) {
        this.applicationMetaDataSlot = slotService.reserveMetaDataSlot(ApplicationMetaData.class);
        this.moduleMetaDataSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
        this.componentMetaDataSlot = slotService.reserveMetaDataSlot(ComponentMetaData.class);
    }

    protected void unsetMetaDataSlotService(MetaDataSlotService slotService) {
    }

    @org.osgi.service.component.annotations.Reference
    protected void setResourceRefConfigFactory(ResourceRefConfigFactory resourceRefConfigFactory) {
        this.resourceRefConfigFactory = resourceRefConfigFactory;
    }

    protected void unsetResourceRefConfigFactory(ResourceRefConfigFactory resourceRefConfigFactory) {
    }

    @org.osgi.service.component.annotations.Reference(name="ejbLinkReferenceFactory", service=EJBLinkReferenceFactory.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBLinkReferenceFactory(ServiceReference<EJBLinkReferenceFactory> ejbLinkReferenceFactory) {
        ejbLinkReferenceFactorySRRef.setReference(ejbLinkReferenceFactory);
    }

    protected void unsetEJBLinkReferenceFactory(ServiceReference<EJBLinkReferenceFactory> ref) {
        ejbLinkReferenceFactorySRRef.unsetReference(ref);
    }

    @Override
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerObjectFactoryInfo(ObjectFactoryInfo info) throws InjectionException {
        super.registerObjectFactoryInfo(info);
    }

    @Override
    public void unregisterObjectFactoryInfo(ObjectFactoryInfo info) throws InjectionException {
        super.unregisterObjectFactoryInfo(info);
    }

    @Override
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerInjectionProcessorProvider(InjectionProcessorProvider<?, ?> provider) throws InjectionException {
        super.registerInjectionProcessorProvider(provider);
    }

    @Override
    public void unregisterInjectionProcessorProvider(InjectionProcessorProvider<?, ?> provider) throws InjectionException {
        super.unregisterInjectionProcessorProvider(provider);
    }

    @Override
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerInjectionMetaDataListener(InjectionMetaDataListener listener) {
        super.registerInjectionMetaDataListener(listener);
    }

    @Override
    public void unregisterInjectionMetaDataListener(InjectionMetaDataListener listener) {
        super.unregisterInjectionMetaDataListener(listener);
    }
}

