/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.manager;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.request.timing.RequestTimingService;
import com.ibm.ws.request.timing.queue.DelayedRequestQueue;
import com.ibm.ws.request.timing.queue.SlowRequest;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class SlowRequestManager {
    private static final TraceComponent tc = Tr.register(SlowRequestManager.class, (String)"requestTiming", (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS(SlowRequestManager.class, (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private final ConcurrentHashMap<String, RequestContext> slowRequests;
    private final DelayedRequestQueue<SlowRequest> requestQueue;
    private final Object syncHandlerObject = new Object(){};
    private volatile Future<?> future = null;
    private final Runnable slowRequestHandler = new Runnable(){

        @Override
        @Trivial
        public void run() {
            while (true) {
                try {
                    while (true) {
                        final SlowRequest slowRequest = (SlowRequest)SlowRequestManager.this.requestQueue.processNext();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Removing request from the queue...", (Object[])new Object[]{slowRequest.toString()});
                        }
                        Runnable slowRequestTask = new Runnable(){

                            @Override
                            @Trivial
                            public void run() {
                                try {
                                    SlowRequest request = slowRequest;
                                    boolean includeContextInfo = request.includeContextInfo();
                                    RequestContext requestContext = request.getRequestContext();
                                    long slowReqThreshold = request.getSlowRequestThreshold();
                                    if (requestContext.getRequestState() != 100) {
                                        if (tc.isWarningEnabled() && request.incIterationCount() <= request.getSlowRequestIterationsReq()) {
                                            double activeTime = (double)(System.nanoTime() - requestContext.getRootEvent().getStartTime()) / 1000000.0;
                                            String threadId = DataFormatHelper.padHexString((int)((int)requestContext.getThreadId()), (int)8);
                                            String requestDuration = String.format("%.3f", activeTime);
                                            String stackTrace = requestContext.getStackTrace().toString();
                                            String dumpTree = RequestContext.dumpTree((Event)requestContext.getRootEvent(), (boolean)includeContextInfo);
                                            if (requestContext.getRequestState() == 11) {
                                                dumpTree = dumpTree + nls.getString("TRUNCATED_REQUEST_MESSAGE", null);
                                            }
                                            if (requestContext.getRootEvent().getEndTime() == 0L) {
                                                Tr.warning((TraceComponent)tc, (String)"REQUEST_TIMER_WARNING", (Object[])new Object[]{requestContext.getRequestId().getId(), threadId, requestDuration, stackTrace, dumpTree});
                                            }
                                        }
                                        String requestId = requestContext.getRequestId().getId();
                                        SlowRequestManager.this.slowRequests.putIfAbsent(requestId, requestContext);
                                        request.resetDelay(slowReqThreshold);
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Re-queuing request ...", (Object[])new Object[]{request.toString()});
                                        }
                                        SlowRequestManager.this.requestQueue.requeueRequest(request);
                                    } else {
                                        SlowRequestManager.this.requestQueue.removeRequest(request);
                                        SlowRequestManager.this.slowRequests.remove(requestContext.getRequestId().getId());
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Discarding request..", (Object[])new Object[]{request.toString()});
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"131", (Object)this);
                                }
                            }
                        };
                        RequestTimingService.getExecutorService().submit(slowRequestTask);
                    }
                }
                catch (InterruptedException exit) {
                }
                catch (Exception e) {
                    SlowRequestManager.this.stopHandler();
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"142", (Object)this);
                    continue;
                }
                break;
            }
        }
    };

    public SlowRequestManager(DelayedRequestQueue<SlowRequest> queue) {
        this.requestQueue = queue;
        this.slowRequests = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHandler() {
        if (this.future == null) {
            boolean startedHandler = false;
            Object object = this.syncHandlerObject;
            synchronized (object) {
                if (this.future == null) {
                    this.future = RequestTimingService.getExecutorService().submit(this.slowRequestHandler);
                    startedHandler = true;
                }
            }
            if (startedHandler && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Starting slow request handler", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHandler() {
        boolean stoppedHandler = false;
        Object object = this.syncHandlerObject;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                stoppedHandler = true;
            }
        }
        if (stoppedHandler && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Stopping slow request handler.", (Object[])new Object[0]);
        }
    }

    public long countSlowRequests(String type) {
        long count = 0L;
        for (RequestContext requestContext : this.slowRequests.values()) {
            if (requestContext.getRequestState() != 10 || !requestContext.getRootEvent().getType().equals(type)) continue;
            ++count;
        }
        return count;
    }
}

