/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.TraceComponentChangeListener;
import com.ibm.ws.logging.internal.osgi.CollectorManagerPipelineConfigurator;
import com.ibm.ws.logging.internal.osgi.LoggingConfigurationService;
import com.ibm.ws.logging.internal.osgi.MessageRouterConfigurator;
import com.ibm.ws.logging.internal.osgi.TrOSGiLogForwarder;
import com.ibm.ws.logging.internal.osgi.TraceComponentChangeListenerTracker;
import com.ibm.ws.logging.internal.osgi.TraceRouterConfigurator;
import com.ibm.ws.ras.instrument.internal.main.LibertyJava8WorkaroundRuntimeTransformer;
import com.ibm.ws.ras.instrument.internal.main.LibertyRuntimeTransformer;
import java.lang.instrument.Instrumentation;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class Activator
implements BundleActivator {
    private MessageRouterConfigurator msgRouter;
    private TraceRouterConfigurator traceRouter;
    private CollectorManagerPipelineConfigurator collectorMgrPipeConfigurator;
    private LoggingConfigurationService logCfgService;
    private Instrumentation inst;
    private RuntimeTransformerComponentListener runtimeTransformer = null;
    private static TraceComponentChangeListenerTracker listenerTracker = null;

    public void start(BundleContext context) throws Exception {
        ServiceReference instReference = context.getServiceReference(Instrumentation.class);
        if (instReference != null) {
            this.inst = (Instrumentation)context.getService(instReference);
            LibertyRuntimeTransformer.setInstrumentation(this.inst);
            LibertyJava8WorkaroundRuntimeTransformer.setInstrumentation(this.inst);
        } else {
            LibertyRuntimeTransformer.setInstrumentation(null);
            LibertyJava8WorkaroundRuntimeTransformer.setInstrumentation(null);
        }
        this.runtimeTransformer = new RuntimeTransformerComponentListener();
        TrConfigurator.addTraceComponentListener((TraceComponentChangeListener)this.runtimeTransformer);
        listenerTracker = new TraceComponentChangeListenerTracker(context);
        listenerTracker.open(true);
        this.logCfgService = new LoggingConfigurationService(context, this.inst != null);
        this.msgRouter = new MessageRouterConfigurator(context);
        this.traceRouter = new TraceRouterConfigurator(context);
        this.collectorMgrPipeConfigurator = new CollectorManagerPipelineConfigurator(context);
        LogReaderService logReader = (LogReaderService)context.getService(context.getServiceReference(ExtendedLogReaderService.class));
        logReader.addLogListener((LogListener)new TrOSGiLogForwarder());
    }

    public void stop(BundleContext context) throws Exception {
        this.msgRouter.stop();
        this.traceRouter.stop();
        if (this.logCfgService != null) {
            this.logCfgService.stop();
            this.logCfgService = null;
        }
        TrConfigurator.removeTraceComponentListener((TraceComponentChangeListener)this.runtimeTransformer);
        listenerTracker.close();
    }

    public static class RuntimeTransformerComponentListener
    implements TraceComponentChangeListener {
        public void traceComponentRegistered(TraceComponent tc) {
        }

        public void traceComponentUpdated(TraceComponent tc) {
            LibertyRuntimeTransformer.traceStateChanged(tc);
        }
    }
}

