/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCConfigurator;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.admin.LoggerAdmin;

public class LoggingConfigurationService
implements ManagedService {
    private static final TraceComponent tc = Tr.register(LoggingConfigurationService.class, (String)"osgilogging", (String)"com.ibm.ws.logging.internal.osgi.resources.OSGiMessages");
    public static final String RAS_TR_CFG_PID = "com.ibm.ws.logging";
    private ServiceRegistration<ManagedService> configRef = null;
    protected BundleContext context;
    private final boolean instrumentation;
    private final LoggerAdmin loggerAdmin;
    private final Map<String, Map<String, LogLevel>> contextLogLevels = Collections.synchronizedMap(new HashMap());
    private static final Map<String, LogLevel> traceMapToLevel = new HashMap<String, LogLevel>();

    public LoggingConfigurationService(BundleContext context, boolean instrumentationActive) {
        this.context = context;
        this.instrumentation = instrumentationActive;
        this.configRef = context.registerService(ManagedService.class, (Object)this, LoggingConfigurationService.defaultProperties());
        TrConfigurator.setInstrumentation((boolean)this.instrumentation);
        this.loggerAdmin = this.getService(LoggerAdmin.class, context);
        this.configureLoggerAdmin();
    }

    <T> T getService(Class<T> type, BundleContext context) {
        ServiceReference ref = context.getServiceReference(type);
        if (ref == null) {
            return null;
        }
        return (T)context.getService(ref);
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Stopping the Logging managed service", (Object[])new Object[0]);
        }
        this.configRef.unregister();
        this.configRef = null;
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("properties updated " + properties), (Object[])new Object[0]);
        }
        if (properties == null) {
            return;
        }
        HashMap newMap = null;
        if (properties instanceof Map) {
            newMap = (HashMap)((Object)properties);
        } else {
            newMap = new HashMap();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                newMap.put(key, properties.get(key));
            }
        }
        TrConfigurator.update(newMap);
        FFDCConfigurator.update(newMap);
        this.configureLoggerAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLoggerAdmin() {
        String[] specs;
        if (this.loggerAdmin == null) {
            return;
        }
        HashMap<String, Map<String, LogLevel>> newContextLogLevels = new HashMap<String, Map<String, LogLevel>>();
        String traceSpec = TrConfigurator.getEffectiveTraceSpec();
        for (String spec : specs = traceSpec.split(":")) {
            String enabled;
            String[] comps = spec.split("=");
            if (comps.length < 2) continue;
            String comp = comps[0];
            LogLevel logLevel = this.mapLogLevel(comps[1]);
            String string = enabled = comps.length > 2 ? comps[2] : "enabled";
            if (logLevel == null || !"enabled".equalsIgnoreCase(enabled)) continue;
            if ("logservice".equalsIgnoreCase(comp)) {
                LoggingConfigurationService.add(newContextLogLevels, null, "ROOT", logLevel, true);
                continue;
            }
            if (comp.equals("OSGi.Events")) {
                LoggingConfigurationService.add(newContextLogLevels, null, "Events", logLevel, true);
                continue;
            }
            if (comp.indexOf(42) == -1) {
                LoggingConfigurationService.add(newContextLogLevels, comp, "ROOT", logLevel, true);
            }
            if (!logLevel.implies(LogLevel.DEBUG)) continue;
            LoggingConfigurationService.add(newContextLogLevels, null, "Events", logLevel, false);
        }
        LoggingConfigurationService.add(newContextLogLevels, "com.ibm.ws.org.eclipse.equinox.metatype", "ROOT", LogLevel.WARN, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configuring loggers: " + newContextLogLevels), (Object[])new Object[0]);
        }
        Map<String, Map<String, LogLevel>> map = this.contextLogLevels;
        synchronized (map) {
            if (!this.contextLogLevels.equals(newContextLogLevels)) {
                this.contextLogLevels.putAll(newContextLogLevels);
                Iterator<Map.Entry<String, Map<String, LogLevel>>> iEntries = this.contextLogLevels.entrySet().iterator();
                while (iEntries.hasNext()) {
                    Map.Entry<String, Map<String, LogLevel>> entry = iEntries.next();
                    if (!newContextLogLevels.containsKey(entry.getKey())) {
                        this.loggerAdmin.getLoggerContext(entry.getKey()).setLogLevels(Collections.emptyMap());
                        iEntries.remove();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Removed: " + entry.getKey() + " - " + entry.getValue()), (Object[])new Object[0]);
                        continue;
                    }
                    this.loggerAdmin.getLoggerContext(entry.getKey()).setLogLevels(entry.getValue());
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Configured: " + entry.getKey() + " - " + entry.getValue()), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Log levels already configured " + newContextLogLevels), (Object[])new Object[0]);
            }
        }
    }

    private static void add(Map<String, Map<String, LogLevel>> contextLogLevels, String contextName, String loggerName, LogLevel logLevel, boolean replace) {
        Map<String, LogLevel> logLevels = contextLogLevels.get(contextName);
        if (logLevels == null) {
            logLevels = new HashMap<String, LogLevel>();
            contextLogLevels.put(contextName, logLevels);
        }
        if (replace || !logLevels.containsKey(loggerName)) {
            logLevels.put(loggerName, logLevel);
        }
    }

    private LogLevel mapLogLevel(String logLevelSpec) {
        return traceMapToLevel.get(logLevelSpec.toLowerCase());
    }

    protected static Hashtable<String, String> defaultProperties() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("service.pid", RAS_TR_CFG_PID);
        return ht;
    }

    static {
        traceMapToLevel.put("all", LogLevel.TRACE);
        traceMapToLevel.put("dump", LogLevel.TRACE);
        traceMapToLevel.put("finest", LogLevel.DEBUG);
        traceMapToLevel.put("debug", LogLevel.DEBUG);
        traceMapToLevel.put("finer", LogLevel.DEBUG);
        traceMapToLevel.put("entryexit", LogLevel.DEBUG);
        traceMapToLevel.put("fine", LogLevel.DEBUG);
        traceMapToLevel.put("event", LogLevel.DEBUG);
        traceMapToLevel.put("detail", LogLevel.DEBUG);
        traceMapToLevel.put("info", LogLevel.INFO);
        traceMapToLevel.put("audit", LogLevel.INFO);
        traceMapToLevel.put("warning", LogLevel.WARN);
        traceMapToLevel.put("severe", LogLevel.ERROR);
        traceMapToLevel.put("error", LogLevel.ERROR);
        traceMapToLevel.put("fatal", LogLevel.ERROR);
        traceMapToLevel.put("off", LogLevel.AUDIT);
    }
}

