/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutorBuilder;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class FaultToleranceProviderResolver {
    private static volatile FaultToleranceProviderResolver instance;
    static final long serialVersionUID = 8042266188951315097L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected FaultToleranceProviderResolver() {
    }

    public abstract RetryPolicy newRetryPolicy();

    public abstract CircuitBreakerPolicy newCircuitBreakerPolicy();

    public abstract BulkheadPolicy newBulkheadPolicy();

    public abstract FallbackPolicy newFallbackPolicy();

    public abstract TimeoutPolicy newTimeoutPolicy();

    public abstract <R> ExecutorBuilder<R> newExecutionBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaultToleranceProviderResolver instance() {
        if (instance != null) return instance;
        Class<FaultToleranceProviderResolver> clazz = FaultToleranceProviderResolver.class;
        synchronized (FaultToleranceProviderResolver.class) {
            FaultToleranceProviderResolver newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = 2152505444220752134L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.spi.resources.FaultToleranceSPI");
                }
            });
            if (cl == null) {
                cl = FaultToleranceProviderResolver.class.getClassLoader();
            }
            if ((newInstance = FaultToleranceProviderResolver.loadSpi(cl)) == null) {
                throw new IllegalStateException("No FaultToleranceProviderResolver implementation found!");
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static FaultToleranceProviderResolver loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        FaultToleranceProviderResolver instance = FaultToleranceProviderResolver.loadSpi(FaultToleranceProviderResolver.getParentClassLoader(cl));
        if (instance == null) {
            ServiceLoader<FaultToleranceProviderResolver> sl = ServiceLoader.load(FaultToleranceProviderResolver.class, cl);
            for (FaultToleranceProviderResolver spi : sl) {
                if (instance != null) {
                    throw new IllegalStateException("Multiple FaultToleranceResolverProvider implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName());
                }
                instance = spi;
            }
        }
        return instance;
    }

    private static ClassLoader getParentClassLoader(final ClassLoader classLoader) {
        ClassLoader parent = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 2522916518939045719L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return classLoader.getParent();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.spi.resources.FaultToleranceSPI");
            }
        });
        return parent;
    }

    public static void setInstance(FaultToleranceProviderResolver resolver) {
        instance = resolver;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FaultToleranceProviderResolver.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.spi.resources.FaultToleranceSPI");
        instance = null;
    }
}

