/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FTDebug {
    static final long serialVersionUID = 1823233422607308970L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public static void debugRelativeTime(TraceComponent tc, String id, String message, long relativePointA) {
        FTDebug.debugRelativeTime(tc, id, message, relativePointA, System.nanoTime());
    }

    @Trivial
    public static void debugRelativeTime(TraceComponent tc, String id, String message, long relativePointA, long relativePointB) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"{0}: {1}: {2}", (Object[])new Object[]{id, message, FTDebug.relativeSeconds(relativePointA, relativePointB)});
        }
    }

    @Trivial
    public static void debugTime(TraceComponent tc, String message, long time) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"{0}: {1}", (Object[])new Object[]{message, FTDebug.toSeconds(time)});
        }
    }

    @Trivial
    public static void debugTime(TraceComponent tc, String id, String message, long time) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"{0}: {1}: {2}", (Object[])new Object[]{id, message, FTDebug.toSeconds(time)});
        }
    }

    @Trivial
    public static String formatMethod(Method m) {
        if (m == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(m.getDeclaringClass().getName());
        sb.append(".");
        sb.append(m.getName());
        sb.append("(");
        sb.append(Arrays.stream(m.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")));
        sb.append(")");
        return sb.toString();
    }

    @Trivial
    public static double relativeSeconds(long relativePointA, long relativePointB) {
        long diff = relativePointB - relativePointA;
        double seconds = FTDebug.toSeconds(diff);
        return seconds;
    }

    @Trivial
    public static double toSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FTDebug.class, null, null);
    }
}

