/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.credentials.CredentialProvider;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Hashtable;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UnauthenticatedSubjectServiceImpl
implements UnauthenticatedSubjectService,
UserRegistryChangeListener {
    private static final TraceComponent tc = Tr.register(UnauthenticatedSubjectServiceImpl.class, null, null);
    static final String KEY_SECURITY_SERVICE = "securityService";
    static final String KEY_CREDENTIALS_SERVICE = "credentialsService";
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    protected final AtomicServiceReference<CredentialsService> credentialsServiceRef = new AtomicServiceReference("credentialsService");
    private Subject unauthenticatedSubject = null;
    private final Object unauthenticatedSubjectLock = new Object(){
        static final long serialVersionUID = 2234913038336933277L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, null, null);
        }
    };
    static final long serialVersionUID = -259576979582176405L;

    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    protected void setCredentialsService(ServiceReference<CredentialsService> ref) {
        this.credentialsServiceRef.setReference(ref);
    }

    protected void unsetCredentialsService(ServiceReference<CredentialsService> ref) {
        this.credentialsServiceRef.unsetReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCredentialProvider(ServiceReference<CredentialProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Resetting unauthenticatedSubject as new CredentialProvider has been set", (Object[])new Object[0]);
        }
        Object object = this.unauthenticatedSubjectLock;
        synchronized (object) {
            this.unauthenticatedSubject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetCredentialProvider(ServiceReference<CredentialProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Resetting unauthenticatedSubject as CredentialProvider has been unset", (Object[])new Object[0]);
        }
        Object object = this.unauthenticatedSubjectLock;
        synchronized (object) {
            this.unauthenticatedSubject = null;
        }
    }

    protected void activate(ComponentContext cc) {
        this.securityServiceRef.activate(cc);
        this.credentialsServiceRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.securityServiceRef.deactivate(cc);
        this.credentialsServiceRef.deactivate(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfUserRegistryChange() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Resetting unauthenticatedSubject as UserRegistry configuration has changed", (Object[])new Object[0]);
        }
        Object object = this.unauthenticatedSubjectLock;
        synchronized (object) {
            this.unauthenticatedSubject = null;
        }
    }

    @FFDCIgnore(value={RegistryException.class})
    private String getUserRegistryRealm() {
        String realm;
        block3: {
            realm = "defaultRealm";
            try {
                SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                UserRegistryService userRegistryService = securityService.getUserRegistryService();
                if (userRegistryService.isUserRegistryConfigured()) {
                    realm = userRegistryService.getUserRegistry().getRealm();
                }
            }
            catch (RegistryException re) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"RegistryException while trying to get the realm", (Object[])new Object[]{re});
            }
        }
        return realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Exception.class})
    public Subject getUnauthenticatedSubject() {
        block7: {
            if (this.unauthenticatedSubject == null) {
                CredentialsService cs = (CredentialsService)this.credentialsServiceRef.getService();
                String unauthenticatedUserid = cs.getUnauthenticatedUserid();
                try {
                    Subject subject = new Subject();
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("com.ibm.wsspi.security.cred.securityName", unauthenticatedUserid);
                    hashtable.put("com.ibm.wsspi.security.cred.uniqueId", AccessIdUtil.createAccessId((String)"user", (String)this.getUserRegistryRealm(), (String)unauthenticatedUserid));
                    subject.getPublicCredentials().add(hashtable);
                    SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                    AuthenticationService authenticationService = securityService.getAuthenticationService();
                    Subject tempUnauthenticatedSubject = authenticationService.authenticate("system.UNAUTHENTICATED", subject);
                    tempUnauthenticatedSubject.setReadOnly();
                    Object object = this.unauthenticatedSubjectLock;
                    synchronized (object) {
                        if (this.unauthenticatedSubject == null) {
                            this.unauthenticatedSubject = tempUnauthenticatedSubject;
                        }
                    }
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"Internal error creating UNAUTHENTICATED subject.", (Object[])new Object[]{e});
                }
            }
        }
        return this.unauthenticatedSubject;
    }
}

