/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.ClientWindow;
import org.apache.myfaces.application.StateCache;
import org.apache.myfaces.application.viewstate.CsrfSessionTokenFactory;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.application.viewstate.RandomCsrfSessionTokenFactory;
import org.apache.myfaces.application.viewstate.RandomKeyFactory;
import org.apache.myfaces.application.viewstate.RandomSessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.SecureRandomCsrfSessionTokenFactory;
import org.apache.myfaces.application.viewstate.SecureRandomKeyFactory;
import org.apache.myfaces.application.viewstate.SerializedViewCollection;
import org.apache.myfaces.application.viewstate.SerializedViewKey;
import org.apache.myfaces.application.viewstate.SessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.token.ServiceSideStateTokenProcessor;
import org.apache.myfaces.application.viewstate.token.StateTokenProcessor;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.MyFacesObjectInputStream;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.spi.ViewScopeProvider;
import org.apache.myfaces.spi.ViewScopeProviderFactory;
import org.apache.myfaces.view.ViewScopeProxyMap;

class ServerSideStateCacheImpl
extends StateCache<Object, Object> {
    private static final Logger log = Logger.getLogger(ServerSideStateCacheImpl.class.getName());
    public static final String SERIALIZED_VIEW_SESSION_ATTR = ServerSideStateCacheImpl.class.getName() + ".SERIALIZED_VIEW";
    public static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = ServerSideStateCacheImpl.class.getName() + ".RESTORED_SERIALIZED_VIEW";
    public static final String RESTORED_SERIALIZED_VIEW_ID_REQUEST_ATTR = ServerSideStateCacheImpl.class.getName() + ".RESTORED_SERIALIZED_VIEW_ID";
    public static final String RESTORED_SERIALIZED_VIEW_KEY_REQUEST_ATTR = ServerSideStateCacheImpl.class.getName() + ".RESTORED_SERIALIZED_VIEW_KEY";
    public static final String RESTORED_VIEW_KEY_REQUEST_ATTR = ServerSideStateCacheImpl.class.getName() + ".RESTORED_VIEW_KEY";
    public static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    public static final String NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION";
    public static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    @Deprecated
    public static final String SERIALIZE_STATE_IN_SESSION_PARAM = "org.apache.myfaces.SERIALIZE_STATE_IN_SESSION";
    public static final String COMPRESS_SERVER_STATE_PARAM = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    public static final boolean DEFAULT_COMPRESS_SERVER_STATE_PARAM = true;
    public static final boolean DEFAULT_SERIALIZE_STATE_IN_SESSION = false;
    public static final String USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION = "org.apache.myfaces.USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM = "secureRandom";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_RANDOM = "random";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_PARAM_DEFAULT = "random";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH";
    public static final int RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH_PARAM_DEFAULT = 8;
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM";
    public static final int UNCOMPRESSED_FLAG = 0;
    public static final int COMPRESSED_FLAG = 1;
    private Boolean _useFlashScopePurgeViewsInSession = null;
    private Integer _numberOfSequentialViewsInSession = null;
    private boolean _numberOfSequentialViewsInSessionSet = false;
    private SessionViewStorageFactory sessionViewStorageFactory;
    private CsrfSessionTokenFactory csrfSessionTokenFactory;
    private StateTokenProcessor stateTokenProcessor;

    public ServerSideStateCacheImpl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String randomMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_PARAM, "random");
        if (RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM.equals(randomMode)) {
            this.sessionViewStorageFactory = new RandomSessionViewStorageFactory(new SecureRandomKeyFactory(facesContext));
        } else if ("random".equals(randomMode)) {
            this.sessionViewStorageFactory = new RandomSessionViewStorageFactory(new RandomKeyFactory(facesContext));
        } else {
            if (randomMode != null && !randomMode.isEmpty()) {
                log.warning("org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN \"" + randomMode + "\" is not supported (anymore). Fallback to \"random\"");
            }
            this.sessionViewStorageFactory = new RandomSessionViewStorageFactory(new RandomKeyFactory(facesContext));
        }
        String csrfRandomMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN", "random");
        this.csrfSessionTokenFactory = RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM.equals(csrfRandomMode) ? new SecureRandomCsrfSessionTokenFactory(facesContext) : new RandomCsrfSessionTokenFactory(facesContext);
        this.stateTokenProcessor = new ServiceSideStateTokenProcessor();
    }

    protected Object getServerStateId(FacesContext facesContext, Object state) {
        if (state != null) {
            return this.getKeyFactory(facesContext).decode((String)state);
        }
        return null;
    }

    protected void saveSerializedViewInServletSession(FacesContext context, Object serializedView) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        SerializedViewCollection viewCollection = (SerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = this.getSessionViewStorageFactory().createSerializedViewCollection(context);
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        Map attributeMap = context.getAttributes();
        SerializedViewKey key = null;
        if (this.getNumberOfSequentialViewsInSession(context.getExternalContext()) != null && this.getNumberOfSequentialViewsInSession(context.getExternalContext()) > 0 && (key = (SerializedViewKey)attributeMap.get(RESTORED_VIEW_KEY_REQUEST_ATTR)) == null) {
            ClientWindow clientWindow = context.getExternalContext().getClientWindow();
            if (clientWindow != null) {
                key = viewCollection.getLastWindowKey(context, clientWindow.getId());
            } else if (this.isUseFlashScopePurgeViewsInSession(context.getExternalContext()) && Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get("oam.Flash.REDIRECT.PREVIOUSREQUEST"))) {
                key = (SerializedViewKey)context.getExternalContext().getFlash().get((Object)RESTORED_VIEW_KEY_REQUEST_ATTR);
            }
        }
        SerializedViewKey nextKey = this.getSessionViewStorageFactory().createSerializedViewKey(context, context.getViewRoot().getViewId(), this.getNextViewSequence(context));
        ViewScopeProxyMap viewScopeProxyMap = null;
        Object viewMap = context.getViewRoot().getViewMap(false);
        if (viewMap != null) {
            while (viewMap != null) {
                if (viewMap instanceof ViewScopeProxyMap) {
                    viewScopeProxyMap = (ViewScopeProxyMap)viewMap;
                    break;
                }
                if (!(viewMap instanceof FacesWrapper)) continue;
                viewMap = ((FacesWrapper)viewMap).getWrapped();
            }
        }
        if (viewScopeProxyMap != null) {
            ViewScopeProviderFactory factory = ViewScopeProviderFactory.getViewScopeHandlerFactory(context.getExternalContext());
            ViewScopeProvider handler = factory.getViewScopeHandler(context.getExternalContext());
            viewCollection.put(context, this.serializeView(context, serializedView), nextKey, key, handler, viewScopeProxyMap.getViewScopeId());
        } else {
            viewCollection.put(context, this.serializeView(context, serializedView), nextKey, key);
        }
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow != null) {
            viewCollection.putLastWindowKey(context, clientWindow.getId(), nextKey);
        }
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected Object getSerializedViewFromServletSession(FacesContext context, String viewId, Object sequence) {
        ExternalContext externalContext = context.getExternalContext();
        Map attributeMap = context.getAttributes();
        Object serializedView = null;
        if (attributeMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = attributeMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            Object state;
            SerializedViewCollection viewCollection = (SerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null && sequence != null && (state = viewCollection.get(this.getSessionViewStorageFactory().createSerializedViewKey(context, viewId, sequence))) != null) {
                serializedView = this.deserializeView(state);
            }
            attributeMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            if (this.getNumberOfSequentialViewsInSession(externalContext) != null && this.getNumberOfSequentialViewsInSession(externalContext) > 0) {
                SerializedViewKey key = this.getSessionViewStorageFactory().createSerializedViewKey(context, viewId, sequence);
                attributeMap.put(RESTORED_VIEW_KEY_REQUEST_ATTR, key);
                if (this.isUseFlashScopePurgeViewsInSession(externalContext)) {
                    externalContext.getFlash().put((Object)RESTORED_VIEW_KEY_REQUEST_ATTR, (Object)key);
                    externalContext.getFlash().keep(RESTORED_VIEW_KEY_REQUEST_ATTR);
                }
            }
            if (context.getPartialViewContext().isAjaxRequest() || context.getPartialViewContext().isPartialRequest()) {
                attributeMap.put(RESTORED_SERIALIZED_VIEW_KEY_REQUEST_ATTR, sequence);
                attributeMap.put(RESTORED_SERIALIZED_VIEW_ID_REQUEST_ATTR, viewId);
            } else {
                this.nextViewSequence(context);
            }
        }
        return serializedView;
    }

    protected Object getNextViewSequence(FacesContext context) {
        Object sequence = context.getAttributes().get("jsf_sequence");
        if (sequence == null) {
            if (context.getPartialViewContext().isAjaxRequest() || context.getPartialViewContext().isPartialRequest()) {
                String restoredViewId = (String)context.getAttributes().get(RESTORED_SERIALIZED_VIEW_ID_REQUEST_ATTR);
                Object restoredKey = context.getAttributes().get(RESTORED_SERIALIZED_VIEW_KEY_REQUEST_ATTR);
                if (restoredViewId != null && restoredKey != null && restoredViewId.equals(context.getViewRoot().getViewId())) {
                    sequence = restoredKey;
                }
            }
            if (sequence == null) {
                sequence = this.nextViewSequence(context);
            }
            context.getAttributes().put("jsf_sequence", sequence);
        }
        return sequence;
    }

    protected Object nextViewSequence(FacesContext facescontext) {
        Object sequence = this.getKeyFactory(facescontext).generateKey(facescontext);
        facescontext.getAttributes().put("jsf_sequence", sequence);
        return sequence;
    }

    protected Object serializeView(FacesContext context, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering serializeView");
        }
        if (this.isSerializeStateInSession(context)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.isCompressStateInSession(context)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(serializedView);
                out.close();
                baos.close();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Exiting serializeView - serialized. Bytes : " + baos.size());
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Exiting serializeView - Could not serialize state: " + e.getMessage(), e);
                return null;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting serializeView - do not serialize state in session.");
        }
        return serializedView;
    }

    protected boolean isSerializeStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter("javax.faces.SERIALIZE_SERVER_STATE");
        boolean serialize = false;
        if (value != null) {
            serialize = value.toLowerCase().equals("true");
            return serialize;
        }
        value = context.getExternalContext().getInitParameter(SERIALIZE_STATE_IN_SESSION_PARAM);
        if (value != null) {
            serialize = Boolean.valueOf(value);
        }
        return serialize;
    }

    protected boolean isCompressStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(COMPRESS_SERVER_STATE_PARAM);
        boolean compress = true;
        if (value != null) {
            compress = Boolean.valueOf(value);
        }
        return compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeView(Object state) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering deserializeView");
        }
        if (state instanceof byte[]) {
            Object object;
            block13: {
                ByteArrayInputStream bais;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length);
                }
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                MyFacesObjectInputStream ois = null;
                try {
                    MyFacesObjectInputStream in;
                    ois = in = new MyFacesObjectInputStream(is);
                    Object object2 = null;
                    object2 = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws PrivilegedActionException, IOException, ClassNotFoundException {
                            return in.readObject();
                        }
                    }) : in.readObject();
                    object = object2;
                    if (ois == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ois != null) {
                            ois.close();
                            ois = null;
                        }
                        throw throwable;
                    }
                    catch (IOException | ClassNotFoundException | PrivilegedActionException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                }
                ois.close();
                ois = null;
            }
            return object;
        }
        if (state instanceof Object[]) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting deserializeView - state not serialized.");
            }
            return state;
        }
        if (state == null) {
            log.severe("Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.severe("Exiting deserializeView - this method should not be called with a state of type : " + state.getClass());
        return null;
    }

    @Override
    public Object saveSerializedView(FacesContext facesContext, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing saveSerializedView - server-side state saving - save state");
        }
        this.saveSerializedViewInServletSession(facesContext, serializedView);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting saveSerializedView - server-side state saving - saved state");
        }
        return this.encodeSerializedState(facesContext, serializedView);
    }

    @Override
    public Object restoreSerializedView(FacesContext facesContext, String viewId, Object viewState) {
        Object serverStateId;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Restoring view from session");
        }
        return (serverStateId = this.getServerStateId(facesContext, viewState)) == null ? null : this.getSerializedViewFromServletSession(facesContext, viewId, serverStateId);
    }

    @Override
    public Object encodeSerializedState(FacesContext facesContext, Object serializedView) {
        return this.getKeyFactory(facesContext).encode(this.getNextViewSequence(facesContext));
    }

    @Override
    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        return false;
    }

    private boolean isUseFlashScopePurgeViewsInSession(ExternalContext externalContext) {
        if (this._useFlashScopePurgeViewsInSession == null) {
            this._useFlashScopePurgeViewsInSession = WebConfigParamUtils.getBooleanInitParameter(externalContext, USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION, false);
        }
        return this._useFlashScopePurgeViewsInSession;
    }

    private Integer getNumberOfSequentialViewsInSession(ExternalContext externalContext) {
        if (!this._numberOfSequentialViewsInSessionSet) {
            this._numberOfSequentialViewsInSession = MyfacesConfig.getCurrentInstance(externalContext).getNumberOfSequentialViewsInSession();
            this._numberOfSequentialViewsInSessionSet = true;
        }
        return this._numberOfSequentialViewsInSession;
    }

    protected KeyFactory getKeyFactory(FacesContext facesContext) {
        return this.sessionViewStorageFactory.getKeyFactory();
    }

    protected SessionViewStorageFactory getSessionViewStorageFactory() {
        return this.sessionViewStorageFactory;
    }

    @Override
    public String createCryptographicallyStrongTokenFromSession(FacesContext context) {
        return this.csrfSessionTokenFactory.createCryptographicallyStrongTokenFromSession(context);
    }

    @Override
    public StateTokenProcessor getStateTokenProcessor(FacesContext context) {
        return this.stateTokenProcessor;
    }
}

