/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.globalhandler;

import com.ibm.webservices.handler.impl.GlobalHandlerService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.globalhandler.AbstractJAXWSGlobalHandlerInterceptor;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerInterceptor;
import com.ibm.ws.jaxws.globalhandler.JaxwsGlobalHandlerServiceImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.ListIterator;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GlobalHandlerEntryOutInterceptor
extends AbstractJAXWSGlobalHandlerInterceptor<Message> {
    private final GlobalHandlerInterceptor globalHandlerOutInterceptor;
    private static final SAAJOutInterceptor SAAJ_OUT = new SAAJOutInterceptor();
    private static final TraceComponent tc = Tr.register(GlobalHandlerEntryOutInterceptor.class, null, null);
    static final long serialVersionUID = -3564344867532303862L;

    public GlobalHandlerEntryOutInterceptor(String flowType, LibertyApplicationBus.Type bus) {
        super("pre-protocol");
        this.addBefore(SAAJOutInterceptor.class.getName());
        this.globalHandlerOutInterceptor = new GlobalHandlerInterceptor("user-protocol", "out", bus);
    }

    public void handleMessage(Message message) {
        GlobalHandlerService globalHandlerService = (GlobalHandlerService)JaxwsGlobalHandlerServiceImpl.globalHandlerServiceSR.getService();
        List registeredHandlers1 = globalHandlerService.getJAXWSClientSideInFlowGlobalHandlers();
        List registeredHandlers2 = globalHandlerService.getJAXWSClientSideOutFlowGlobalHandlers();
        List registeredHandlers3 = globalHandlerService.getJAXWSServerSideInFlowGlobalHandlers();
        List registeredHandlers4 = globalHandlerService.getJAXWSServerSideOutFlowGlobalHandlers();
        if (registeredHandlers1.isEmpty() && registeredHandlers2.isEmpty() && registeredHandlers3.isEmpty() && registeredHandlers4.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no registered global handlers", (Object[])new Object[0]);
            }
            return;
        }
        boolean saajEnabled = globalHandlerService.getSaajFlag();
        if (!GlobalHandlerEntryOutInterceptor.chainAlreadyContainsSAAJ((SoapMessage)message) && saajEnabled) {
            message.getInterceptorChain().add((Interceptor)SAAJ_OUT);
        }
        message.getInterceptorChain().add((Interceptor)this.globalHandlerOutInterceptor);
    }

    private static boolean chainAlreadyContainsSAAJ(SoapMessage message) {
        ListIterator listIterator = message.getInterceptorChain().getIterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof SAAJOutInterceptor)) continue;
            return true;
        }
        return false;
    }
}

