/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.ContainerClassLoader;
import com.ibm.ws.classloading.internal.IdentifiedLoader;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ShadowClassLoader
extends IdentifiedLoader {
    static final TraceComponent tc = Tr.register(ShadowClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private static final Enumeration<URL> EMPTY_ENUMERATION = new Enumeration<URL>(){
        static final long serialVersionUID = 6781143533374470504L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ShadowClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    };
    private final AppClassLoader shadowedLoader;
    private final Iterable<ClassLoader> delegateLoaders;
    static final long serialVersionUID = -7655444978429731823L;

    ShadowClassLoader(AppClassLoader shadowed) {
        super(ShadowClassLoader.getShadow(shadowed.getParent()));
        this.shadowedLoader = shadowed;
        this.delegateLoaders = ShadowClassLoader.getShadows(shadowed.getDelegateLoaders());
    }

    private static ClassLoader getShadow(ClassLoader loader) {
        return loader instanceof AppClassLoader ? new ShadowClassLoader((AppClassLoader)loader) : loader;
    }

    private static List<ClassLoader> getShadows(Iterable<? extends ClassLoader> loaders) {
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : loaders) {
            result.add(ShadowClassLoader.getShadow(classLoader));
        }
        return result;
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    public Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(className);
        if (result != null) {
            return result;
        }
        ClassNotFoundException lastException = null;
        block9: for (AppClassLoader.SearchLocation what : this.shadowedLoader.getSearchOrder()) {
            try {
                switch (what) {
                    case PARENT: {
                        return this.getParent().loadClass(className);
                    }
                    case SELF: {
                        return this.findClass(className);
                    }
                    case DELEGATES: {
                        for (ClassLoader delegate : this.delegateLoaders) {
                            try {
                                return delegate.loadClass(className);
                            }
                            catch (ClassNotFoundException e) {
                                lastException = e;
                            }
                        }
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException("Unknown class loader search ordering element: " + (Object)((Object)what));
                    }
                }
            }
            catch (ClassNotFoundException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String packageName;
        ContainerClassLoader.ByteResourceInformation classBytesResourceInformation = this.shadowedLoader.findClassBytes(name);
        if (classBytesResourceInformation == null) {
            throw new ClassNotFoundException(name);
        }
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex != -1 && this.getPackage(packageName = name.substring(0, lastDotIndex)) == null) {
            this.definePackage(classBytesResourceInformation, packageName);
        }
        byte[] bytes = classBytesResourceInformation.getBytes();
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private void definePackage(ContainerClassLoader.ByteResourceInformation classBytesResourceInformation, String packageName) {
        Manifest manifest = classBytesResourceInformation.getManifest();
        try {
            if (manifest == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            } else {
                String classResourceName = classBytesResourceInformation.getResourcePath();
                String packageResourceName = classResourceName.substring(0, classResourceName.lastIndexOf(47) + 1);
                String specTitle = null;
                String specVersion = null;
                String specVendor = null;
                String implTitle = null;
                String implVersion = null;
                String implVendor = null;
                URL sealBaseUrl = null;
                Attributes packageAttributes = manifest.getAttributes(packageResourceName);
                if (packageAttributes != null && !packageAttributes.isEmpty()) {
                    specTitle = packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    specVersion = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    specVendor = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    implTitle = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    implVersion = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    implVendor = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    String sealedValue = packageAttributes.getValue(Attributes.Name.SEALED);
                    if (sealedValue != null && Boolean.parseBoolean(sealedValue)) {
                        sealBaseUrl = classBytesResourceInformation.getResourceUrl();
                    }
                }
                this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBaseUrl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public URL getResource(String name) {
        return name == null ? null : this.shadowedLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return name == null ? null : this.shadowedLoader.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return name == null ? EMPTY_ENUMERATION : this.shadowedLoader.getResources(name);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.shadowedLoader.getApiTypeVisibility();
    }

    @Override
    public ClassLoaderIdentity getKey() {
        return this.shadowedLoader.getKey();
    }

    @Override
    public Bundle getBundle() {
        return this.shadowedLoader.getBundle();
    }
}

