/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.SpringLoader;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UnifiedClassLoader
extends LibertyLoader
implements SpringLoader {
    private static final TraceComponent tc = Tr.register(UnifiedClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final List<ClassLoader> followOnClassLoaders = new ArrayList<ClassLoader>();
    static final long serialVersionUID = 8829649920524275888L;

    @Override
    public boolean addTransformer(ClassFileTransformer cft) {
        boolean added = false;
        for (ClassLoader loader : this.followOnClassLoaders) {
            if (!(loader instanceof SpringLoader)) continue;
            added |= ((SpringLoader)((Object)loader)).addTransformer(cft);
        }
        return added;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        ClassLoader newParent = this.getThrowawayVersion(this.getParent());
        ClassLoader[] newFollowOns = new ClassLoader[this.followOnClassLoaders.size()];
        for (int i = 0; i < newFollowOns.length; ++i) {
            newFollowOns[i] = this.getThrowawayVersion(this.followOnClassLoaders.get(i));
        }
        return new UnifiedClassLoader(newParent, newFollowOns);
    }

    private ClassLoader getThrowawayVersion(ClassLoader loader) {
        return loader instanceof SpringLoader ? ((SpringLoader)((Object)loader)).getThrowawayClassLoader() : loader;
    }

    public UnifiedClassLoader(ClassLoader parent, ClassLoader ... followOns) {
        super(parent);
        Collections.addAll(this.followOnClassLoaders, followOns);
    }

    @Override
    @Trivial
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return Delegation.loadClass(name, resolve, this);
    }

    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    Class<?> loadClass0(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CNFE from super classloader " + super.toString()), (Object[])new Object[]{ex});
            }
            throw ex;
        }
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findClass(String arg0) throws ClassNotFoundException {
        for (ClassLoader cl : this.followOnClassLoaders) {
            try {
                return cl.loadClass(arg0);
            }
            catch (ClassNotFoundException swallowed) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("CNFE from followOnClassLoader " + cl), (Object[])new Object[]{swallowed});
            }
        }
        throw new ClassNotFoundException(arg0);
    }

    @Override
    protected URL findResource(String arg0) {
        ClassLoader cl;
        URL result = null;
        Iterator<ClassLoader> iterator = this.followOnClassLoaders.iterator();
        while (iterator.hasNext() && (result = (cl = iterator.next()).getResource(arg0)) == null) {
        }
        return result;
    }

    @Override
    protected Enumeration<URL> findResources(String arg0) throws IOException {
        ArrayList<Enumeration<URL>> rawResult = new ArrayList<Enumeration<URL>>();
        for (ClassLoader cl : this.followOnClassLoaders) {
            Enumeration<URL> result = cl.getResources(arg0);
            if (result == null) continue;
            rawResult.add(result);
        }
        final Iterator allURLs = rawResult.iterator();
        return new Enumeration<URL>(){
            private Enumeration<URL> current;
            static final long serialVersionUID = -2427758562650295738L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean hasMoreElements() {
                while (this.current == null || !this.current.hasMoreElements()) {
                    if (!allURLs.hasNext()) {
                        return false;
                    }
                    this.current = (Enumeration)allURLs.next();
                }
                return true;
            }

            @Override
            public URL nextElement() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                return this.current.nextElement();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.UnifiedClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader parent = null;
        try {
            final UnifiedClassLoader thisClassLoader = this;
            parent = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){
                static final long serialVersionUID = -7903829429995339921L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() throws Exception {
                    return thisClassLoader.getParent();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.UnifiedClassLoader$2", 2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (PrivilegedActionException thisClassLoader) {
            // empty catch block
        }
        if (parent == null) {
            return super.getResources(name);
        }
        try {
            final String f_name = name;
            final ClassLoader f_parent = parent;
            Enumeration<URL> eURL = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){
                static final long serialVersionUID = -7497257227190650503L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Enumeration<URL> run() throws Exception {
                    return f_parent.getResources(f_name);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.UnifiedClassLoader$3", 3.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
            return new CompositeEnumeration(eURL).add(this.findResources(name));
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    synchronized void addFollowOnClassLoader(ClassLoader cl) {
        if (!this.followOnClassLoaders.contains(cl)) {
            this.followOnClassLoaders.add(cl);
        }
    }

    List<ClassLoader> getFollowOnClassLoaders() {
        return this.followOnClassLoaders;
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return null;
    }

    @Override
    public Bundle getBundle() {
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class Delegation {
        static final long serialVersionUID = 5287839534531883424L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Delegation() {
        }

        @Trivial
        static Class<?> loadClass(String className, boolean resolve, UnifiedClassLoader loader) throws ClassNotFoundException {
            return loader.loadClass0(className, resolve);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.UnifiedClassLoader$Delegation", Delegation.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }
}

