/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.consumer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MessageDigestUtil {
    private static final TraceComponent tc;
    private static Object locker;
    private static MessageDigest md;
    private static final char[] map;
    private static final SecureRandom srandom;
    static final long serialVersionUID = -8172471141289135528L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String getDigest() {
        String digest;
        block5: {
            digest = null;
            try {
                byte[] digestBytes = null;
                Object object = locker;
                synchronized (object) {
                    md.reset();
                    byte[] seed = new byte[20];
                    srandom.nextBytes(seed);
                    md.update(seed);
                    digestBytes = md.digest();
                }
                digest = MessageDigestUtil.toHex(digestBytes);
            }
            catch (Exception digestBytes) {
                void e;
                FFDCFilter.processException((Throwable)digestBytes, (String)"com.ibm.ws.security.openid20.consumer.MessageDigestUtil", (String)"61", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Internal error calculating message digest of :", (Object[])new Object[]{e});
            }
        }
        return digest;
    }

    private static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(map[b >>> 4 & 0xF]);
            sb.append(map[b & 0xF]);
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        block2: {
            tc = Tr.register(MessageDigestUtil.class, (String)"OpenId", (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages");
            locker = new Object();
            md = null;
            map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            srandom = new SecureRandom();
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                void e;
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.openid20.consumer.MessageDigestUtil", (String)"34", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Internal error initializing message digest", (Object[])new Object[]{e});
            }
        }
    }
}

