/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultInInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class Soap12FaultInInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(Soap12FaultInInterceptor.class);
    static final long serialVersionUID = 3428575290046530509L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Soap12FaultInInterceptor() {
        super("unmarshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor", "<init>", new Object[0]);
        }
        this.addBefore(ClientFaultConverter.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor", "handleMessage", new Object[]{message});
        }
        if (message.getVersion() == Soap11.getInstance()) {
            new Soap11FaultInInterceptor().handleMessage(message);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor", "handleMessage");
            }
            return;
        }
        XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        message.setContent(Exception.class, (Object)Soap12FaultInInterceptor.unmarshalFault(message, reader));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SoapFault unmarshalFault(SoapMessage message, XMLStreamReader reader) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor", "unmarshalFault", new Object[]{message, reader});
        }
        String exMessage = null;
        QName faultCode = null;
        QName subCode = null;
        String role = null;
        String node = null;
        Element detail = null;
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("s", "http://www.w3.org/2003/05/soap-envelope");
        XPathUtils xu = new XPathUtils(ns);
        try {
            Node mainNode = (Node)message.getContent(Node.class);
            Node fault = null;
            if (reader instanceof W3CDOMStreamReader) {
                W3CDOMStreamReader dr = (W3CDOMStreamReader)reader;
                fault = dr.getCurrentElement();
                dr.consumeFrame();
            } else if (mainNode != null) {
                Node bodyNode = (Node)xu.getValue("//s:Body", mainNode, XPathConstants.NODE);
                StaxUtils.readDocElements((Document)bodyNode.getOwnerDocument(), (Node)bodyNode, (XMLStreamReader)new FragmentStreamReader(reader), (boolean)false, (boolean)false);
                fault = (Element)xu.getValue("//s:Fault", bodyNode, XPathConstants.NODE);
            } else {
                fault = StaxUtils.read((XMLStreamReader)new FragmentStreamReader(reader));
            }
            Element el = (Element)xu.getValue("//s:Fault/s:Code/s:Value", fault, XPathConstants.NODE);
            if (el != null) {
                faultCode = XMLUtils.getQName((String)el.getTextContent(), (Node)el);
            }
            if ((el = (Element)xu.getValue("//s:Fault/s:Code/s:Subcode/s:Value", fault, XPathConstants.NODE)) != null) {
                subCode = XMLUtils.getQName((String)el.getTextContent(), (Node)el);
            }
            exMessage = (String)xu.getValue("//s:Fault/s:Reason/s:Text/text()", fault, XPathConstants.STRING);
            Node detailNode = (Node)xu.getValue("//s:Fault/s:Detail", fault, XPathConstants.NODE);
            if (detailNode != null) {
                detail = (Element)detailNode;
            }
            role = (String)xu.getValue("//s:Fault/s:Role/text()", fault, XPathConstants.STRING);
            node = (String)xu.getValue("//s:Fault/s:Node/text()", fault, XPathConstants.STRING);
        }
        catch (XMLStreamException e) {
            throw new SoapFault("Could not parse message.", (Throwable)e, message.getVersion().getSender());
        }
        if (faultCode == null) {
            faultCode = Soap12.getInstance().getReceiver();
            exMessage = new Message("INVALID_FAULT", LOG, new Object[0]).toString();
        }
        SoapFault fault = new SoapFault(exMessage, faultCode);
        fault.setSubCode(subCode);
        fault.setDetail(detail);
        fault.setRole(role);
        fault.setNode(node);
        SoapFault soapFault = fault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapFault = soapFault;
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor", "unmarshalFault", (Object)soapFault);
        }
        return soapFault;
    }
}

