/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.tcp.SoapTcpChannel;
import org.apache.cxf.binding.soap.tcp.SoapTcpUtils;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpMessage;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public final class ChannelService {
    static final long serialVersionUID = -4747152466602254858L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ChannelService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void service(IoSession session, SoapTcpMessage message) {
        XMLStreamReader xmlReader = null;
        try {
            xmlReader = StaxUtils.createXMLStreamReader((InputStream)message.getContentAsStream(), (String)"UTF-8");
            while (xmlReader.hasNext()) {
                xmlReader.next();
                if (xmlReader.getEventType() != 1) continue;
                if (xmlReader.getLocalName().equals("initiateSession")) {
                    ChannelService.initiateSession(session);
                    continue;
                }
                if (xmlReader.getLocalName().equals("openChannel")) {
                    String targetWSURI = null;
                    ArrayList<String> negotiatedMimeTypes = new ArrayList<String>();
                    ArrayList<String> negotiatedParams = new ArrayList<String>();
                    while (xmlReader.hasNext()) {
                        xmlReader.next();
                        if (xmlReader.getEventType() != 1) continue;
                        if (xmlReader.getLocalName().equals("targetWSURI")) {
                            targetWSURI = xmlReader.getElementText();
                            continue;
                        }
                        if (xmlReader.getLocalName().equals("negotiatedMimeTypes")) {
                            negotiatedMimeTypes.add(xmlReader.getElementText());
                            continue;
                        }
                        if (!xmlReader.getLocalName().equals("negotiatedParams")) continue;
                        negotiatedParams.add(xmlReader.getElementText());
                    }
                    ChannelService.openChannel(session, targetWSURI, negotiatedMimeTypes, negotiatedParams);
                    continue;
                }
                if (!xmlReader.getLocalName().equals("closeChannel")) continue;
                int channelId = -1;
                while (xmlReader.hasNext()) {
                    if (xmlReader.getEventType() != 1 || !xmlReader.getLocalName().equals("channelId")) continue;
                    channelId = Integer.parseInt(xmlReader.getElementText());
                }
                ChannelService.closeChannel(session, channelId);
            }
        }
        catch (XMLStreamException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StaxUtils.close(xmlReader);
                throw throwable;
            }
            StaxUtils.close((XMLStreamReader)xmlReader);
        }
        StaxUtils.close((XMLStreamReader)xmlReader);
    }

    private static void initiateSession(IoSession session) {
        System.out.println("initiateSession service");
        String response = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><initiateSessionResponse xmlns=\"http://servicechannel.tcp.transport.ws.xml.sun.com/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"/></s:Body></s:Envelope>";
        SoapTcpMessage soapTcpMessage = SoapTcpMessage.createSoapTcpMessage(response, 0);
        IoBuffer buffer = IoBuffer.allocate((int)512);
        buffer.setAutoExpand(true);
        try {
            SoapTcpUtils.writeSoapTcpMessage(buffer.asOutputStream(), soapTcpMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buffer.flip();
        session.write((Object)buffer);
    }

    private static void openChannel(IoSession session, String targetWSURI, List<String> negotiatedMimeTypes, List<String> negotiatedParams) {
        System.out.println("openChannel service");
        List channels = (List)session.getAttribute((Object)"channels");
        int max = 0;
        for (SoapTcpChannel channel : channels) {
            if (channel.getChannelId() <= max) continue;
            max = channel.getChannelId();
        }
        channels.add(new SoapTcpChannel(max + 1, targetWSURI));
        String response = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><openChannelResponse xmlns=\"http://servicechannel.tcp.transport.ws.xml.sun.com/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><channelId xmlns=\"\">" + (max + 1) + "</channelId><negotiatedMimeTypes xmlns=\"\">application/soap+xml</negotiatedMimeTypes><negotiatedParams xmlns=\"\">charset</negotiatedParams><negotiatedParams xmlns=\"\">SOAPAction</negotiatedParams><negotiatedParams xmlns=\"\">action</negotiatedParams></openChannelResponse></s:Body></s:Envelope>";
        SoapTcpMessage soapTcpMessage = SoapTcpMessage.createSoapTcpMessage(response, 0);
        IoBuffer buffer = IoBuffer.allocate((int)512);
        buffer.setAutoExpand(true);
        try {
            SoapTcpUtils.writeSoapTcpMessage(buffer.asOutputStream(), soapTcpMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buffer.flip();
        session.write((Object)buffer);
    }

    private static void closeChannel(IoSession session, int channelId) {
        System.out.println("closeChannel service");
        List channels = (List)session.getAttribute((Object)"channels");
        for (SoapTcpChannel channel : channels) {
            if (channel.getChannelId() != channelId) continue;
            channels.remove(channel);
            break;
        }
        String response = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><closeChannelResponse xmlns=\"http://servicechannel.tcp.transport.ws.xml.sun.com/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"/></s:Body></s:Envelope>";
        SoapTcpMessage soapTcpMessage = SoapTcpMessage.createSoapTcpMessage(response, 0);
        IoBuffer buffer = IoBuffer.allocate((int)512);
        buffer.setAutoExpand(true);
        try {
            SoapTcpUtils.writeSoapTcpMessage(buffer.asOutputStream(), soapTcpMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buffer.flip();
        session.write((Object)buffer);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.binding.soap.tcp.ChannelService", ChannelService.class, null, null);
    }
}

