/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.memory;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionManagerRegistry;
import com.ibm.ws.session.SessionStatistics;
import com.ibm.ws.session.store.memory.MemorySession;
import com.ibm.ws.session.store.memory.SessionSimpleHashMap;
import com.ibm.ws.session.store.memory.TooManySessionsException;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IGenericSessionManager;
import com.ibm.wsspi.session.ILoader;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.IStoreCallback;
import com.ibm.wsspi.session.ITimer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletContext;

public class MemoryStore
implements IStore {
    public HashMap _sessions = null;
    public static final String ANONYMOUS_USER = "anonymous";
    protected String _storeId = null;
    protected IStoreCallback _storeCallback;
    protected MemoryStoreHelper _storeHelper;
    protected ITimer _invalidator;
    protected SessionManagerConfig _smc;
    private MemorySession overflowSession;
    private static final String overflowId = "overflowed-session";
    protected ServletContext _servletContext = null;
    private boolean httpSessListener = false;
    private boolean _removeAttrOnInvalidate = false;
    protected boolean distributableWebApp;
    protected boolean inProcessOfStopping = false;
    private static final String methodClassName = "MemoryStore";
    protected String appNameForLogging = "";
    protected SessionStatistics _sessionStatistics;
    protected boolean _isApplicationSessionStore = false;
    private static final int CREATE_SESSION = 0;
    private static final int GET_SESSION = 1;
    private static final int ID_EXISTS = 2;
    private static final int RUN_INVALIDATION = 3;
    private static final int INVALIDATE_ALL_MEMORY_SESSIONS = 4;
    private static final int REMOVE_INVALIDATE = 5;
    private static final int CHECK_SESSION_STILL_VALID = 6;
    private static final String[] methodNames = new String[]{"createSession", "getSession", "idExists", "runInvalidation", "invalidateAllMemorySessions", "remoteInvalidate", "checkSessionStillValid"};

    public MemoryStore(SessionManagerConfig smc, String storeId, ServletContext sc, MemoryStoreHelper storeHelper) {
        this._smc = smc;
        this._storeId = storeId;
        this._servletContext = sc;
        this._storeHelper = storeHelper;
        if (this._smc.isUsingMemory()) {
            int _initialTableSize = smc.getInMemorySize();
            boolean _allowOverflow = smc.getEnableOverflow();
            if (!_allowOverflow) {
                this.overflowSession = new MemorySession(this, overflowId, this._storeCallback);
                this.overflowSession.setOverflow();
                this.overflowSession.setIsValid(false);
            }
            this._sessions = new SessionSimpleHashMap(this, _initialTableSize, _allowOverflow);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            this.appNameForLogging = " AppName=" + this._storeId;
        }
    }

    public MemoryStore(SessionManagerConfig smc, String storeId, ServletContext sc, MemoryStoreHelper storeHelper, boolean isApplicationSessionStore) {
        this(smc, storeId, sc, storeHelper);
        this._isApplicationSessionStore = isApplicationSessionStore;
    }

    public MemoryStore(SessionManagerConfig smc, String storeId, ServletContext sc, MemoryStoreHelper storeHelper, boolean isApplicationSessionStore, boolean removeAttrOnInvalidate) {
        this._smc = smc;
        this._storeId = storeId;
        this._servletContext = sc;
        this._storeHelper = storeHelper;
        this._removeAttrOnInvalidate = removeAttrOnInvalidate;
        if (this._smc.isUsingMemory()) {
            int _initialTableSize = smc.getInMemorySize();
            boolean _allowOverflow = smc.getEnableOverflow();
            if (!_allowOverflow) {
                if (!removeAttrOnInvalidate) {
                    this.overflowSession = new MemorySession(this, overflowId, this._storeCallback);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodClassName, "Create MemorySession with _removeAttrOnInvalidate -->" + this._removeAttrOnInvalidate);
                    }
                    this.overflowSession = new MemorySession(this, overflowId, this._storeCallback, removeAttrOnInvalidate);
                }
                this.overflowSession.setOverflow();
                this.overflowSession.setIsValid(false);
            }
            this._sessions = new SessionSimpleHashMap(this, _initialTableSize, _allowOverflow);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            this.appNameForLogging = " AppName=" + this._storeId;
        }
        this._isApplicationSessionStore = isApplicationSessionStore;
    }

    @Override
    public void setID(String storeId) {
        this._storeId = storeId;
    }

    @Override
    public ISession createSession(String id, boolean newId) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("{").append(id).append(",").append(newId).append("} ").append(this.appNameForLogging);
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], sb.toString());
        }
        MemorySession sess = null;
        if (this.inProcessOfStopping) {
            this.throwException("SessionContext.createWhenStop");
        }
        if (!this._smc.getEnableOverflow() && this._sessions.size() >= this._smc.getInMemorySize()) {
            if (this._sessionStatistics != null) {
                this._sessionStatistics.incNoRoomForNewSession();
            }
            sess = this.overflowSession;
        }
        if (sess == null && this._sessions.get(id) == null) {
            if (!this._removeAttrOnInvalidate) {
                sess = new MemorySession(this, id, this._storeCallback);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "Create MemorySession with _removeAttrOnInvalidate -->" + this._removeAttrOnInvalidate);
                }
                sess = new MemorySession(this, id, this._storeCallback, this._removeAttrOnInvalidate);
            }
            sess.setUserName(ANONYMOUS_USER);
            sess.updateLastAccessTime(sess.getCreationTime());
            try {
                this._sessions.put(id, sess);
            }
            catch (TooManySessionsException tmse) {
                sess = this.overflowSession;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], sess);
        }
        return sess;
    }

    public ISession getSession(String id, int version, boolean isSessionAccess) {
        ISession isess;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("{").append(id).append(",").append(version).append("} ").append(this.appNameForLogging);
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1], sb.toString());
        }
        if (this.inProcessOfStopping) {
            this.throwException("SessionContext.accessWhenStop");
        }
        if ((isess = (ISession)this._sessions.get(id)) != null && isSessionAccess) {
            ((MemorySession)isess).updateLastAccessTime(System.currentTimeMillis());
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], isess);
        }
        return isess;
    }

    @Override
    public boolean idExists(String id) {
        IGenericSessionManager sm;
        IStore tempStore;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2], id);
        }
        boolean found = false;
        SessionManagerRegistry _sessionManagerRegistry = SessionManagerRegistry.getSessionManagerRegistry();
        Enumeration vEnum = _sessionManagerRegistry.getSessionManagers();
        while (vEnum.hasMoreElements() && !found) {
            Object sessInUse;
            IGenericSessionManager sm2 = (IGenericSessionManager)vEnum.nextElement();
            if (sm2 == null || (tempStore = sm2.getIStore()) == this || (sessInUse = tempStore.getFromMemory(id)) == null) continue;
            found = true;
        }
        if (found) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                String s = "Found in Cache/Mem";
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], s);
            }
            return found;
        }
        found = this.isPresentInExternalStore(id);
        if (found) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], found);
            }
            return found;
        }
        Enumeration enum3 = _sessionManagerRegistry.getSessionManagers();
        while (enum3.hasMoreElements() && ((sm = (IGenericSessionManager)enum3.nextElement()) == null || (tempStore = sm.getIStore()) == this || !(found = tempStore.isPresentInExternalStore(id)))) {
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            String s = "After persistent store scan returning: " + found;
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], s);
        }
        return found;
    }

    @Override
    public void setLoader(ILoader loader) {
    }

    @Override
    public void setStoreCallback(IStoreCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = callback + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setStoreCallback", s);
        }
        this._storeCallback = callback;
    }

    @Override
    public IStoreCallback getStoreCallback() {
        return this._storeCallback;
    }

    @Override
    public void setShareAcrossWebapp(boolean flag) {
    }

    @Override
    public void setNumOfPartitions(int num) {
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this._smc.setSessionInvalidationTime(interval);
    }

    @Override
    public String getId() {
        return this._storeId;
    }

    @Override
    public void removeSession(String id) {
        Object removedEntry;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = id + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "removeSession", s);
        }
        if ((removedEntry = this._sessions.remove(id)) != null) {
            this._storeCallback.sessionLiveCountDec(removedEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runInvalidation() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[3], this.appNameForLogging);
        }
        long nowTime = System.currentTimeMillis();
        Iterator iter = this._sessions.keySet().iterator();
        try {
            if (this.isInProcessOfStopping()) {
                if (!TraceComponent.isAnyTracingEnabled()) return;
                if (!LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) return;
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[3], "application in the process of stopping - " + this.appNameForLogging);
                return;
            }
            try {
                this.setThreadContextDuringRunInvalidation();
            }
            catch (RuntimeException e) {
                if (!this.isInProcessOfStopping()) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, MemoryStore.class.getSimpleName(), methodNames[3], "CommonMessage.exception", e);
                }
                this.unsetThreadContext();
                return;
            }
            while (iter.hasNext()) {
                String key = (String)iter.next();
                ISession s = (ISession)this._sessions.get(key);
                if (s == null) continue;
                ISession iSession = s;
                synchronized (iSession) {
                    if (s.isValid() && s.getMaxInactiveInterval() != -1) {
                        boolean timedOut;
                        boolean active;
                        long currentAccessTime = s.getCurrentAccessTime();
                        long maxinact = 1000L * (long)s.getMaxInactiveInterval();
                        boolean bl = active = s.getRefCount() > 0;
                        if (this._isApplicationSessionStore) {
                            s.setRefCount(0);
                            active = false;
                        }
                        boolean bl2 = timedOut = currentAccessTime <= nowTime - maxinact;
                        if (timedOut && (!active || this._smc.getForceSessionInvalidationMultiple() != 0 && currentAccessTime <= nowTime - (long)this._smc.getForceSessionInvalidationMultiple() * maxinact)) {
                            this._storeCallback.sessionInvalidatedByTimeout(s);
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                                String message = "Going to invalidate session with id=" + s.getId();
                                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[3], message);
                            }
                            s.invalidate();
                        }
                    }
                }
            }
        }
        finally {
            this.unsetThreadContext();
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) return;
        LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3]);
    }

    @Override
    public void runTimeBasedWrites() {
    }

    @Override
    public void setThreadContext() {
        if (this._storeHelper != null) {
            this._storeHelper.setThreadContext();
        }
    }

    protected void setThreadContextDuringRunInvalidation() {
        if (this._storeHelper != null) {
            this._storeHelper.setThreadContextDuringRunInvalidation();
        }
    }

    @Override
    public void unsetThreadContext() {
        if (this._storeHelper != null) {
            this._storeHelper.unsetThreadContext();
        }
    }

    private void invalidateAllMemorySessions() {
        Set s;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[4], this.appNameForLogging);
        }
        if ((s = this._sessions.keySet()) != null) {
            Iterator it = s.iterator();
            while (it.hasNext()) {
                MemorySession ms = (MemorySession)this._sessions.get(it.next());
                ms.internalInvalidate(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[4]);
        }
    }

    public Enumeration tableKeys() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "tableKeys", this.appNameForLogging);
        }
        Set keys = this._sessions != null ? this._sessions.keySet() : new HashMap(1).keySet();
        final Iterator iter = keys.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    @Override
    public Object getFromMemory(Object key) {
        return this._sessions.get(key);
    }

    public SessionManagerConfig getSessionManagerConfig() {
        return this._smc;
    }

    @Override
    public SessionStatistics getSessionStatistics() {
        return this._sessionStatistics;
    }

    @Override
    public void setSessionStatistics(SessionStatistics statistics) {
        this._sessionStatistics = statistics;
    }

    @Override
    public synchronized void stop() {
        this.inProcessOfStopping = true;
        this.invalidateAllMemorySessions();
    }

    public boolean isInProcessOfStopping() {
        return this.inProcessOfStopping;
    }

    public void remoteInvalidate(String sessionId, boolean backendUpdate) {
        ISession iSess;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("{").append(sessionId).append(",").append(backendUpdate).append("} ").append(this.appNameForLogging);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[5], sb.toString());
        }
        if ((iSess = (ISession)this._sessions.get(sessionId)) != null) {
            iSess.setMaxInactiveInterval(0);
        }
    }

    @Override
    public boolean isPresentInExternalStore(String id) {
        return false;
    }

    @Override
    public boolean getShouldReuseId() {
        return SessionManagerConfig.isIdReuse();
    }

    @Override
    public void releaseSession(ISession session) {
    }

    @Override
    public void refreshSession(String sessionID) {
    }

    @Override
    public void refreshSession(String sessionID, int currentVersion) {
    }

    @Override
    public boolean isHttpSessionListener() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = this.httpSessListener + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "isHttpSessionListener", s);
        }
        return this.httpSessListener;
    }

    @Override
    public void setHttpSessionListener(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            String s = b + this.appNameForLogging;
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setHttpSessionListener", s);
        }
        this.httpSessListener = b;
    }

    public String toHTML() {
        return "";
    }

    public void throwException(String errorString) {
        ResourceBundle rb = ResourceBundle.getBundle(LoggingUtil.SESSION_LOGGER_CORE.getResourceBundleName());
        String msg = (String)rb.getObject(errorString);
        RuntimeException re = new RuntimeException(msg);
        throw re;
    }

    @Override
    public String getAffinityToken(String id, String appName) {
        return null;
    }

    @Override
    public void setDistributable(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setDistributable", b + this.appNameForLogging);
        }
        this.distributableWebApp = b;
    }

    @Override
    public boolean isDistributable() {
        return this.distributableWebApp;
    }

    @Override
    public ISession createSession(String id, Object multiProtocolCorrelator) {
        return null;
    }

    @Override
    public ISession getSession(String id, Object multiProtocolCorrelator) {
        return null;
    }

    @Override
    public boolean idExists(String id, Object multiProtocolCorrelator) {
        return this.idExists(id);
    }

    @Override
    public void refreshSession(String sessionID, Object multiProtocolCorrelator) {
    }

    @Override
    public void refreshSession(String sessionID, int currentVersion, Object multiProtocolCorrelator) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public ISession getSession(String id, int version, boolean isSessionAccess, Object xdCorrelator) {
        return this.getSession(id, version, isSessionAccess);
    }

    @Override
    public boolean needToRedirect(Object multiProtocolCorrelator) {
        return false;
    }

    @Override
    public void removeFromMemory(String id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSessionStillValid(ISession s, long accessedTime) {
        String methodName = "checkSessionStillValid";
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[6]);
        }
        long nowTime = System.currentTimeMillis();
        boolean rc = true;
        ISession iSession = s;
        synchronized (iSession) {
            if (s.isValid()) {
                if (s.getMaxInactiveInterval() != -1) {
                    boolean timedOut;
                    boolean active;
                    long maxinact = 1000L * (long)s.getMaxInactiveInterval();
                    boolean bl = active = s.getRefCount() > 0;
                    if (this._isApplicationSessionStore) {
                        s.setRefCount(0);
                        active = false;
                    }
                    boolean bl2 = timedOut = accessedTime <= nowTime - maxinact;
                    if (timedOut && (!active || this._smc.getForceSessionInvalidationMultiple() != 0 && accessedTime <= nowTime - (long)this._smc.getForceSessionInvalidationMultiple() * maxinact)) {
                        if (maxinact != 0L) {
                            this._storeCallback.sessionInvalidatedByTimeout(s);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                            String message = "Going to invalidate session with id=" + s.getId();
                            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], message);
                        }
                        s.invalidate();
                        rc = false;
                    }
                }
            } else {
                rc = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[6]);
        }
        return rc;
    }

    @Override
    public void updateSessionId(String oldId, ISession newSession) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "updateSessionId", oldId);
        }
        this.removeSession(oldId);
        this._sessions.put(newSession.getId(), newSession);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "updateSessionId", newSession.getId());
        }
    }
}

