/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin.ee;

import java.io.Serializable;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.builtin.CallableMethodHandler;
import org.jboss.weld.bean.builtin.ee.AbstractEECallable;
import org.jboss.weld.bean.proxy.EnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;

public class EEResourceProducerField<X, T>
extends ProducerField<X, T> {
    private ProxyFactory<T> proxyFactory;
    private final Class<T> rawType;

    public static <X, T> EEResourceProducerField<X, T> of(BeanAttributes<T> attributes, EnhancedAnnotatedField<T, ? super X> field, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl manager, ServiceRegistry services) {
        return new EEResourceProducerField<X, T>(attributes, field, declaringBean, disposalMethod, manager, services);
    }

    public static boolean isEEResourceProducerField(BeanManagerImpl beanManager, AnnotatedField<?> field) {
        EJBApiAbstraction ejbApiAbstraction = beanManager.getServices().get(EJBApiAbstraction.class);
        PersistenceApiAbstraction persistenceApiAbstraction = beanManager.getServices().get(PersistenceApiAbstraction.class);
        WSApiAbstraction wsApiAbstraction = beanManager.getServices().get(WSApiAbstraction.class);
        return field.isAnnotationPresent(ejbApiAbstraction.EJB_ANNOTATION_CLASS) || field.isAnnotationPresent(ejbApiAbstraction.RESOURCE_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS) || field.isAnnotationPresent(wsApiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS);
    }

    protected EEResourceProducerField(BeanAttributes<T> attributes, EnhancedAnnotatedField<T, ? super X> field, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl manager, ServiceRegistry services) {
        super(attributes, field, declaringBean, disposalMethod, manager, services);
        this.rawType = field.getJavaClass();
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.checkEEResource();
        this.proxyFactory = new ProxyFactory(this.getBeanManager().getContextId(), this.getType(), this.getTypes(), this);
    }

    protected void checkEEResource() {
        if (!this.getScope().equals(Dependent.class)) {
            throw BeanLogger.LOG.nonDependentResourceProducerField(this);
        }
        if (this.getName() != null) {
            throw BeanLogger.LOG.namedResourceProducerField(this);
        }
        if (!EEResourceProducerField.isEEResourceProducerField(this.beanManager, this.getAnnotated())) {
            throw BeanLogger.LOG.invalidResourceProducerField(this.getAnnotated());
        }
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        Object beanInstance = this.getProducer().produce(creationalContext);
        if (Reflections.isFinal(this.rawType) || Serializable.class.isAssignableFrom(beanInstance.getClass())) {
            return (T)this.checkReturnValue(beanInstance);
        }
        EnterpriseTargetBeanInstance proxyBeanInstance = new EnterpriseTargetBeanInstance(this.getTypes(), (MethodHandler)new CallableMethodHandler(new EEResourceCallable(this.getBeanManager(), this, creationalContext, beanInstance)));
        return this.checkReturnValue(this.proxyFactory.create(proxyBeanInstance));
    }

    private T createUnderlying(CreationalContext<T> creationalContext) {
        return super.create(creationalContext);
    }

    @Override
    public boolean isPassivationCapableBean() {
        return true;
    }

    @Override
    public String toString() {
        return "Resource " + super.toString();
    }

    private static class EEResourceCallable<T>
    extends AbstractEECallable<T> {
        private static final long serialVersionUID = 6287931036073200963L;
        private final BeanIdentifier beanId;
        private transient T instance;
        private final CreationalContext<T> creationalContext;

        private EEResourceCallable(BeanManagerImpl beanManager, ProducerField<?, T> producerField, CreationalContext<T> creationalContext, T instance) {
            super(beanManager);
            this.beanId = producerField.getIdentifier();
            this.creationalContext = creationalContext;
            this.instance = instance;
        }

        @Override
        public T call() throws Exception {
            if (this.instance == null) {
                Object contextual = this.getBeanManager().getServices().get(ContextualStore.class).getContextual(this.beanId);
                if (contextual instanceof EEResourceProducerField) {
                    this.instance = ((EEResourceProducerField)Reflections.cast(contextual)).createUnderlying(this.creationalContext);
                } else {
                    throw BeanLogger.LOG.beanNotEeResourceProducer(contextual);
                }
            }
            return this.instance;
        }

        public String toString() {
            return this.instance == null ? "null" : this.instance.toString();
        }
    }
}

