/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31.customization;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.openapi31.OpenAPIAggregator;
import com.ibm.ws.openapi31.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OpenAPICustomizer.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class OpenAPICustomizer
implements FileMonitor {
    private static final TraceComponent tc = Tr.register(OpenAPICustomizer.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    private WsLocationAdmin locationAdminProvider;
    private final String KEY_OAS_AGGREGATOR = "OpenAPIAggregator";
    private final AtomicServiceReference<OpenAPIAggregator> oasAggregatorRef = new AtomicServiceReference("OpenAPIAggregator");
    private ComponentContext context;
    private ServiceRegistration<FileMonitor> fileMonitor;
    private final String LOCATION_YAML = "${server.config.dir}/openapi-3.1/customization.yaml";
    private final String LOCATION_YML = "${server.config.dir}/openapi-3.1/customization.yml";
    private final String LOCATION_JSON = "${server.config.dir}/openapi-3.1/customization.json";
    private static final String FILE_POLLING_INTERVAL = "mp.openapi.extensions.liberty.file.polling.interval";
    private static final int FILE_POLLING_INTERVAL_DEFAULT_VALUE = 2;
    private final List<File> customizationFiles = new ArrayList<File>();
    private Integer pollingInterval = 2;
    static final long serialVersionUID = -3534560219339530422L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.context = context;
        Config config = ConfigProvider.getConfig((ClassLoader)OpenAPICustomizer.class.getClassLoader());
        this.pollingInterval = OpenAPIUtils.getOptionalValue(config, FILE_POLLING_INTERVAL, Integer.class, 2, v -> v >= 0);
        this.oasAggregatorRef.activate(context);
        this.normalizeDefaultCustomizerPaths();
        this.processCustomizationFiles();
    }

    private File normalizeCustomizerPath(String path) {
        String normalizedPath = PathUtils.normalize((String)path);
        WsResource resource = this.getLocationAdmin().resolveResource(normalizedPath);
        File customizationFile = resource.asFile();
        return customizationFile;
    }

    private void normalizeDefaultCustomizerPaths() {
        this.customizationFiles.add(this.normalizeCustomizerPath("${server.config.dir}/openapi-3.1/customization.yaml"));
        this.customizationFiles.add(this.normalizeCustomizerPath("${server.config.dir}/openapi-3.1/customization.yml"));
        this.customizationFiles.add(this.normalizeCustomizerPath("${server.config.dir}/openapi-3.1/customization.json"));
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.deactivateFileMonitor();
        this.oasAggregatorRef.deactivate(context);
    }

    private void setCustomization(File customizationFile) {
        OpenAPI parsedOpenAPI = OpenAPIUtils.parseOpenAPI(OpenAPIUtils.getAPIDocFromFile(customizationFile));
        if (parsedOpenAPI == null) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Document is null/empty for OpenAPI Definition: " + customizationFile), (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"CUSTOMIZATION_IS_NULL", (Object[])new Object[]{customizationFile});
        }
        this.getOASProviderAggregator().setOpenAPICustomization(parsedOpenAPI);
        if (OpenAPIUtils.isDebugEnabled(tc)) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Default customization file was pushed : location=" + customizationFile), (Object[])new Object[0]);
        }
    }

    @Reference(service=OpenAPIAggregator.class, name="OpenAPIAggregator")
    protected void setOASProviderAggregator(ServiceReference<OpenAPIAggregator> oasProviderAggregator) {
        this.oasAggregatorRef.setReference(oasProviderAggregator);
    }

    protected void unsetOASProviderAggregator(ServiceReference<OpenAPIAggregator> oasProviderAggregator) {
        this.oasAggregatorRef.unsetReference(oasProviderAggregator);
    }

    protected OpenAPIAggregator getOASProviderAggregator() {
        OpenAPIAggregator oasProviderAggregator = (OpenAPIAggregator)this.oasAggregatorRef.getService();
        if (oasProviderAggregator == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "OASProviderAggregator"));
        }
        return oasProviderAggregator;
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    private WsLocationAdmin getLocationAdmin() {
        if (this.locationAdminProvider == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "WsLocationAdmin"));
        }
        return this.locationAdminProvider;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processCustomizationFiles() {
        List<Object> existingFiles;
        block6: {
            existingFiles = new ArrayList();
            try {
                existingFiles = this.customizationFiles.stream().filter(f -> f.exists()).collect(Collectors.toList());
            }
            catch (SecurityException securityException) {
                void se;
                FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.openapi31.customization.OpenAPICustomizer", (String)"155", (Object)this, (Object[])new Object[0]);
                if (!OpenAPIUtils.isDebugEnabled(tc)) break block6;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("SecurityException occurred while checking whether default files exist: " + se), (Object[])new Object[0]);
            }
        }
        int fileCount = existingFiles.size();
        if (fileCount == 0) {
            if (OpenAPIUtils.isDebugEnabled(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"None of the default customization files exist. Set up monitoring on all of them.", (Object[])new Object[0]);
            }
        } else {
            File file = (File)existingFiles.iterator().next();
            if (fileCount > 1) {
                Tr.warning((TraceComponent)tc, (String)"MULTIPLE_DEFAULT_OPENAPI_FILES", (Object[])new Object[]{existingFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(", ", "{", "}")), file.getAbsolutePath()});
            }
            this.monitorFiles(Arrays.asList(file.getAbsolutePath()));
            this.setCustomization(file);
            return true;
        }
        this.monitorFiles(this.customizationFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()));
        return false;
    }

    public void onBaseline(Collection<File> arg0) {
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        File file;
        if (OpenAPIUtils.isDebugEnabled(tc)) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Received notification from FileMonitor: createdFiles=" + createdFiles + " : modifiedFiles=" + modifiedFiles + " : deletedFiles=" + deletedFiles), (Object[])new Object[0]);
        }
        if (deletedFiles != null && !deletedFiles.isEmpty()) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Default customization file was deleted : location=" + deletedFiles.iterator().next().toString()), (Object[])new Object[0]);
            }
            this.getOASProviderAggregator().setOpenAPICustomization(null);
            this.processCustomizationFiles();
        }
        if (createdFiles != null && !createdFiles.isEmpty()) {
            file = createdFiles.iterator().next();
            if (createdFiles.size() > 1) {
                Tr.warning((TraceComponent)tc, (String)"MULTIPLE_DEFAULT_OPENAPI_FILES", (Object[])new Object[]{createdFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(", ", "{", "}")), file});
            }
            this.monitorFiles(Arrays.asList(file.getAbsolutePath()));
            this.setCustomization(file);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Customization file was created : location=" + file.toString()), (Object[])new Object[0]);
            }
        }
        if (modifiedFiles != null && !modifiedFiles.isEmpty()) {
            file = modifiedFiles.iterator().next();
            this.setCustomization(file);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Customization file was modified : location=" + file.toString()), (Object[])new Object[0]);
            }
        }
    }

    private synchronized void deactivateFileMonitor() {
        if (this.fileMonitor != null) {
            this.fileMonitor.unregister();
            this.fileMonitor = null;
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivated FileMonitor service.", (Object[])new Object[0]);
            }
        }
    }

    private synchronized void monitorFiles(List<String> fileLocations) {
        if (this.pollingInterval == 0) {
            this.deactivateFileMonitor();
            return;
        }
        BundleContext bundleContext = this.context.getBundleContext();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.vendor", "IBM");
        ((Dictionary)props).put("monitor.interval", String.valueOf(this.pollingInterval) + "s");
        ((Dictionary)props).put("monitor.files", fileLocations);
        if (this.fileMonitor == null) {
            this.fileMonitor = bundleContext.registerService(FileMonitor.class, (Object)this, props);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Registered FileMonitor service : fileLocations=" + fileLocations.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", "}"))), (Object[])new Object[0]);
            }
        } else {
            this.fileMonitor.setProperties(props);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Updated FileMonitor service : fileLocations=" + fileLocations.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", "}"))), (Object[])new Object[0]);
            }
        }
    }
}

