/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.SocialLoginService;
import com.ibm.ws.security.social.SslRefInfo;
import com.ibm.ws.security.social.UserApiConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.SslRefInfoImpl;
import com.ibm.ws.security.social.internal.UserApiConfigImpl;
import com.ibm.ws.security.social.internal.utils.Cache;
import com.ibm.ws.security.social.internal.utils.SocialHashUtils;
import com.ibm.ws.security.social.tai.SocialLoginTAI;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.social.oauth2login", configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={SocialLoginConfig.class}, property={"service.vendor=IBM", "type=oauth2Login"})
public class Oauth2LoginConfigImpl
implements SocialLoginConfig {
    public static final TraceComponent tc = Tr.register(Oauth2LoginConfigImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    protected final boolean IS_REQUIRED = true;
    protected final boolean IS_NOT_REQUIRED = false;
    protected static final String KEY_UNIQUE_ID = "id";
    protected String uniqueId = null;
    protected Cache cache = null;
    public static final String KEY_clientId = "clientId";
    protected String clientId = null;
    public static final String KEY_clientSecret = "clientSecret";
    @Sensitive
    protected String clientSecret = null;
    public static final String KEY_displayName = "displayName";
    protected String displayName = null;
    public static final String KEY_website = "website";
    protected String website = null;
    public static final String KEY_authorizationEndpoint = "authorizationEndpoint";
    protected String authorizationEndpoint = null;
    public static final String KEY_tokenEndpoint = "tokenEndpoint";
    protected String tokenEndpoint = null;
    public static final String KEY_userApi = "userApi";
    protected String userApi = null;
    protected String[] userApis = null;
    public static final String KEY_authFilterRef = "authFilterRef";
    protected String authFilterRef;
    protected String authFilterId;
    protected AuthenticationFilter authFilter = null;
    protected SSLContext sslContext = null;
    protected SSLSocketFactory sslSocketFactory = null;
    public static final String KEY_sslRef = "sslRef";
    protected String sslRef;
    public static final String KEY_keyAliasName = "keyAliasName";
    protected String keyAliasName;
    protected String algorithm = "AES";
    public static final String KEY_scope = "scope";
    protected String scope = null;
    public static final String KEY_responseType = "responseType";
    protected String responseType = null;
    private final String DEFAULT_RESPONSE_TYPE = "code";
    protected String grantType = null;
    public static final String KEY_nonce = "nonce";
    protected boolean nonce = false;
    public static final String KEY_resource = "resource";
    protected String resource = null;
    public static final String KEY_isClientSideRedirectSupported = "isClientSideRedirectSupported";
    protected boolean isClientSideRedirectSupported = true;
    public static final String KEY_tokenEndpointAuthMethod = "tokenEndpointAuthMethod";
    protected String tokenEndpointAuthMethod = null;
    private final String DEFAULT_TOKEN_ENDPOINT_AUTH_METHOD = "client_secret_post";
    public static final String KEY_userApiNeedsSpecialHeader = "userApiNeedsSpecialHeader";
    protected boolean userApiNeedsSpecialHeader = false;
    public static final String KEY_redirectToRPHostAndPort = "redirectToRPHostAndPort";
    protected String redirectToRPHostAndPort = null;
    protected UserApiConfig[] userApiConfigs = null;
    protected String userApiResponseIdentifier = null;
    protected SslRefInfo sslRefInfo = null;
    public static final String KEY_jwksUri = "jwksUri";
    protected String jwksUri = null;
    public static final String KEY_realmName = "realmName";
    protected String realmName = null;
    public static final String KEY_realmNameAttribute = "realmNameAttribute";
    protected String realmNameAttribute = null;
    public static final String KEY_userNameAttribute = "userNameAttribute";
    protected String userNameAttribute = null;
    private final String DEFAULT_USER_NAME_ATTRIBUTE = "email";
    public static final String KEY_groupNameAttribute = "groupNameAttribute";
    protected String groupNameAttribute = null;
    public static final String KEY_userUniqueIdAttribute = "userUniqueIdAttribute";
    protected String userUniqueIdAttribute = null;
    public static final String KEY_mapToUserRegistry = "mapToUserRegistry";
    protected boolean mapToUserRegistry = false;
    public static final String KEY_requestTokenUrl = "requestTokenUrl";
    protected String requestTokenUrl = null;
    public static final String CFG_KEY_jwt = "jwt";
    public static final String CFG_KEY_jwtRef = "builder";
    public static final String CFG_KEY_jwtClaims = "claims";
    protected String jwtRef = null;
    protected String[] jwtClaims;
    public static final String DEFAULT_JWT_BUILDER = "defaultJWT";
    static final String KEY_SOCIAL_LOGIN_SERVICE = "socialLoginService";
    public static final String DEFAULT_CONTEXT_ROOT = "/ibm/api/social-login";
    static String contextRoot = "/ibm/api/social-login";
    public static final String KEY_USE_SYSPROPS_FOR_HTTPCLIENT_CONNECTONS = "useSystemPropertiesForHttpClientConnections";
    protected boolean useSystemPropertiesForHttpClientConnections = false;
    public static final String KEY_userApiType = "userApiType";
    protected String userApiType = null;
    private final String DEFAULT_USER_API_TYPE = "basic";
    public static final String KEY_userApiToken = "userApiToken";
    protected String userApiToken = null;
    public static final String KEY_accessTokenRequired = "accessTokenRequired";
    protected boolean accessTokenRequired = false;
    public static final String KEY_accessTokenSupported = "accessTokenSupported";
    protected boolean accessTokenSupported = false;
    public static final String KEY_accessTokenHeaderName = "accessTokenHeaderName";
    protected String accessTokenHeaderName = null;
    protected CommonConfigUtils configUtils = new CommonConfigUtils();
    final AtomicServiceReference<SocialLoginService> socialLoginServiceRef = new AtomicServiceReference("socialLoginService");
    private String bundleLocation;
    static final long serialVersionUID = 5009767815118676707L;

    @Reference(service=SocialLoginService.class, name="socialLoginService", cardinality=ReferenceCardinality.MANDATORY)
    protected void setSocialLoginService(ServiceReference<SocialLoginService> ref) {
        this.socialLoginServiceRef.setReference(ref);
    }

    public static String getContextRoot() {
        return contextRoot;
    }

    public static void setContextRoot(String ctx) {
        contextRoot = ctx;
    }

    protected void unsetSocialLoginService(ServiceReference<SocialLoginService> ref) {
        this.socialLoginServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) throws SocialLoginException {
        this.socialLoginServiceRef.activate(cc);
        this.bundleLocation = cc.getBundleContext().getBundle().getLocation();
        this.uniqueId = this.configUtils.getConfigAttribute(props, KEY_UNIQUE_ID);
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"SOCIAL_LOGIN_CONFIG_PROCESSED", (Object[])new Object[]{this.uniqueId});
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) throws SocialLoginException {
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"SOCIAL_LOGIN_CONFIG_MODIFIED", (Object[])new Object[]{this.uniqueId});
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.socialLoginServiceRef.deactivate(cc);
        Tr.info((TraceComponent)tc, (String)"SOCIAL_LOGIN_CONFIG_DEACTIVATED", (Object[])new Object[]{this.uniqueId});
    }

    public void initProps(ComponentContext cc, Map<String, Object> props) throws SocialLoginException {
        this.checkForRequiredConfigAttributes(props);
        this.setAllConfigAttributes(props);
        this.initializeMembersAfterConfigAttributesPopulated(props);
        this.debug();
    }

    protected void checkForRequiredConfigAttributes(Map<String, Object> props) {
        if (this.isConfiguredForProxyFlow(props)) {
            this.checkForRequiredConfigAttributesForProxyFlow(props);
        }
        if (this.isKubeConfiguration(props)) {
            this.checkForRequiredConfigAttributesForKubernetes(props);
        } else {
            this.getRequiredConfigAttribute(props, KEY_clientId);
            this.getRequiredSerializableProtectedStringConfigAttribute(props, KEY_clientSecret);
            this.getRequiredConfigAttribute(props, KEY_authorizationEndpoint);
            this.getRequiredConfigAttribute(props, KEY_scope);
        }
    }

    boolean isConfiguredForProxyFlow(Map<String, Object> props) {
        return this.configUtils.getBooleanConfigAttribute(props, KEY_accessTokenRequired, this.accessTokenRequired);
    }

    protected void checkForRequiredConfigAttributesForProxyFlow(Map<String, Object> props) {
        this.configUtils.getRequiredConfigAttributeWithConfigId(props, KEY_userApi, this.uniqueId);
    }

    boolean isKubeConfiguration(Map<String, Object> props) {
        String userApiType = this.configUtils.getConfigAttribute(props, KEY_userApiType);
        return userApiType != null && "kube".equals(userApiType);
    }

    protected void checkForRequiredConfigAttributesForKubernetes(Map<String, Object> props) {
        this.getRequiredSerializableProtectedStringConfigAttribute(props, KEY_userApiToken);
        this.configUtils.getRequiredConfigAttributeWithConfigId(props, KEY_userApi, this.uniqueId);
    }

    protected void setAllConfigAttributes(Map<String, Object> props) throws SocialLoginException {
        this.clientId = this.configUtils.getConfigAttribute(props, KEY_clientId);
        this.clientSecret = this.configUtils.processProtectedString(props, KEY_clientSecret);
        this.authorizationEndpoint = this.configUtils.getConfigAttribute(props, KEY_authorizationEndpoint);
        this.scope = this.configUtils.getConfigAttribute(props, KEY_scope);
        this.useSystemPropertiesForHttpClientConnections = this.configUtils.getBooleanConfigAttribute(props, KEY_USE_SYSPROPS_FOR_HTTPCLIENT_CONNECTONS, false);
        this.displayName = this.configUtils.getConfigAttribute(props, KEY_displayName);
        this.website = this.configUtils.getConfigAttribute(props, KEY_website);
        this.tokenEndpoint = this.configUtils.getConfigAttribute(props, KEY_tokenEndpoint);
        this.jwksUri = this.configUtils.getConfigAttribute(props, KEY_jwksUri);
        this.responseType = this.configUtils.getConfigAttributeWithDefaultValue(props, KEY_responseType, "code");
        this.tokenEndpointAuthMethod = this.configUtils.getConfigAttributeWithDefaultValue(props, KEY_tokenEndpointAuthMethod, "client_secret_post");
        this.sslRef = this.configUtils.getConfigAttribute(props, KEY_sslRef);
        this.authFilterRef = this.configUtils.getConfigAttribute(props, KEY_authFilterRef);
        this.redirectToRPHostAndPort = this.configUtils.getConfigAttribute(props, KEY_redirectToRPHostAndPort);
        this.userNameAttribute = this.configUtils.getConfigAttributeWithDefaultValue(props, KEY_userNameAttribute, "email");
        this.userApi = this.configUtils.getConfigAttribute(props, KEY_userApi);
        this.realmName = this.configUtils.getConfigAttribute(props, KEY_realmName);
        this.realmNameAttribute = this.configUtils.getConfigAttribute(props, KEY_realmNameAttribute);
        this.groupNameAttribute = this.configUtils.getConfigAttribute(props, KEY_groupNameAttribute);
        this.userUniqueIdAttribute = this.configUtils.getConfigAttribute(props, KEY_userUniqueIdAttribute);
        this.mapToUserRegistry = this.configUtils.getBooleanConfigAttribute(props, KEY_mapToUserRegistry, this.mapToUserRegistry);
        this.isClientSideRedirectSupported = this.configUtils.getBooleanConfigAttribute(props, KEY_isClientSideRedirectSupported, this.isClientSideRedirectSupported);
        this.nonce = this.configUtils.getBooleanConfigAttribute(props, KEY_nonce, this.nonce);
        this.userApiNeedsSpecialHeader = this.configUtils.getBooleanConfigAttribute(props, KEY_userApiNeedsSpecialHeader, this.userApiNeedsSpecialHeader);
        this.userApiType = this.configUtils.getConfigAttributeWithDefaultValue(props, KEY_userApiType, "basic");
        this.userApiToken = this.configUtils.processProtectedString(props, KEY_userApiToken);
        this.accessTokenRequired = this.configUtils.getBooleanConfigAttribute(props, KEY_accessTokenRequired, this.accessTokenRequired);
        this.accessTokenSupported = this.configUtils.getBooleanConfigAttribute(props, KEY_accessTokenSupported, this.accessTokenSupported);
        this.accessTokenHeaderName = this.configUtils.getConfigAttribute(props, KEY_accessTokenHeaderName);
        if (this.isKubeConfiguration(props)) {
            this.checkForRequiredAttributesForKubernetesAuthorizationCodeFlow(props);
        }
    }

    protected void checkForRequiredAttributesForKubernetesAuthorizationCodeFlow(Map<String, Object> props) {
        if (!this.accessTokenRequired && !this.accessTokenSupported) {
            this.configUtils.getRequiredConfigAttributeWithConfigId(props, KEY_authorizationEndpoint, this.uniqueId);
            this.configUtils.getRequiredConfigAttributeWithConfigId(props, KEY_tokenEndpoint, this.uniqueId);
        }
    }

    protected void initializeMembersAfterConfigAttributesPopulated(Map<String, Object> props) throws SocialLoginException {
        this.initializeUserApiConfigs();
        this.initializeJwt(props);
        this.resetLazyInitializedMembers();
        this.setGrantType();
    }

    protected void initializeUserApiConfigs() throws SocialLoginException {
        this.userApiConfigs = this.initUserApiConfigs(this.userApi);
    }

    protected Configuration getCustomConfiguration(String customParam) {
        if (this.socialLoginServiceRef.getService() != null) {
            try {
                return ((SocialLoginService)this.socialLoginServiceRef.getService()).getConfigAdmin().getConfiguration(customParam, "");
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl", (String)"337", (Object)this, (Object[])new Object[]{customParam});
            }
        }
        return null;
    }

    protected void initializeJwt(Map<String, Object> props) {
        Dictionary jwtProps;
        Configuration jwtConfig = null;
        if (this.socialLoginServiceRef.getService() != null) {
            jwtConfig = this.handleJwtElement(props, ((SocialLoginService)this.socialLoginServiceRef.getService()).getConfigAdmin());
        }
        if (jwtConfig != null && (jwtProps = jwtConfig.getProperties()) != null) {
            this.jwtRef = CommonConfigUtils.trim((String)((String)jwtProps.get(CFG_KEY_jwtRef)));
            this.jwtClaims = CommonConfigUtils.trim((String[])((String[])jwtProps.get(CFG_KEY_jwtClaims)));
        }
    }

    protected Configuration handleJwtElement(Map<String, Object> props, ConfigurationAdmin configurationAdmin) {
        String jwt = this.configUtils.getConfigAttribute(props, CFG_KEY_jwt);
        Configuration config = null;
        if (jwt != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"jwt element exists", (Object[])new Object[0]);
            }
            try {
                if (configurationAdmin != null) {
                    config = configurationAdmin.getConfiguration(jwt, this.bundleLocation);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl", (String)"368", (Object)this, (Object[])new Object[]{props, configurationAdmin});
            }
        }
        return config;
    }

    protected void resetLazyInitializedMembers() {
        this.userApis = null;
        this.sslRefInfo = null;
        this.authFilter = null;
        this.sslContext = null;
        this.sslSocketFactory = null;
    }

    protected void setGrantType() {
        this.grantType = "authorization_code";
        if (this.responseType != null && this.responseType.contains("token")) {
            this.grantType = "implicit";
        }
    }

    protected String getRequiredConfigAttribute(Map<String, Object> props, String key) {
        String value = this.configUtils.getConfigAttribute(props, key);
        if (value == null) {
            this.logErrorForMissingRequiredAttribute(key);
        }
        return value;
    }

    @Sensitive
    protected String getRequiredSerializableProtectedStringConfigAttribute(Map<String, Object> props, String key) {
        String result = SocialHashUtils.decodeString((SerializableProtectedString)props.get(key));
        if (result == null) {
            this.logErrorForMissingRequiredAttribute(key);
        }
        return result;
    }

    void logErrorForMissingRequiredAttribute(String key) {
        Tr.error((TraceComponent)tc, (String)"CONFIG_REQUIRED_ATTRIBUTE_NULL", (Object[])new Object[]{key, this.uniqueId});
    }

    protected String defaultJwtBuilder() {
        return DEFAULT_JWT_BUILDER;
    }

    protected void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("" + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientId = " + this.clientId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientSecret is null = " + (this.clientSecret == null)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("displayName = " + this.displayName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("website = " + this.website), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authorizationEndpoint = " + this.authorizationEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpoint = " + this.tokenEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwksUri = " + this.jwksUri), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("responseType = " + this.responseType), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpointAuthMethod = " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef = " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("scope = " + this.scope), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef = " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("redirectToRPHostAndPort = " + this.redirectToRPHostAndPort), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userNameAttribute = " + this.userNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userApi = " + this.userApi), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userApiConfigs = " + (this.userApiConfigs == null ? "null" : Integer.valueOf(this.userApiConfigs.length))), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmName = " + this.realmName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmNameAttribute = " + this.realmNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupNameAttribute = " + this.groupNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userUniqueIdAttribute = " + this.userUniqueIdAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapToUserRegistry = " + this.mapToUserRegistry), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("builder = " + this.jwtRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("claims = " + (this.jwtClaims == null ? null : Arrays.toString(this.jwtClaims))), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("isClientSideRedirectSupported = " + this.isClientSideRedirectSupported), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("nonce = " + this.nonce), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userApiNeedsSpecialHeader = " + this.userApiNeedsSpecialHeader), (Object[])new Object[0]);
        }
    }

    UserApiConfig[] initUserApiConfigs(String userApi) throws SocialLoginException {
        if (userApi != null) {
            UserApiConfig[] results = new UserApiConfig[]{new UserApiConfigImpl(userApi)};
            return results;
        }
        return null;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public AuthenticationFilter getAuthFilter() {
        if (this.authFilter == null) {
            this.authFilter = SocialLoginTAI.getAuthFilter(this.authFilterRef);
        }
        return this.authFilter;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Sensitive
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    @Override
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Override
    public UserApiConfig[] getUserApis() {
        if (this.userApiConfigs == null) {
            return null;
        }
        return (UserApiConfig[])this.userApiConfigs.clone();
    }

    @Override
    public String getUserApi() {
        return this.userApi;
    }

    @Override
    public Cache getSocialLoginCookieCache() {
        if (this.cache == null) {
            this.cache = new Cache(0, 0L);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("socialLoginCockieCache cache:" + this.cache), (Object[])new Object[0]);
        }
        return this.cache;
    }

    @Override
    public String getSslRef() {
        return this.sslRef;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getResponseType() {
        return this.responseType;
    }

    @Override
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    public boolean createNonce() {
        return this.nonce;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public boolean isClientSideRedirectSupported() {
        return this.isClientSideRedirectSupported;
    }

    @Override
    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    @Override
    public String getRedirectToRPHostAndPort() {
        return this.redirectToRPHostAndPort;
    }

    @Override
    public HashMap<String, PublicKey> getPublicKeys() throws SocialLoginException {
        if (this.sslRefInfo == null) {
            SocialLoginService service = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            this.sslRefInfo = this.createSslRefInfoImpl(service);
        }
        return this.sslRefInfo.getPublicKeys();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLContext getSSLContext() throws SocialLoginException {
        if (this.sslContext == null) {
            SocialLoginService service = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            SSLSupport sslSupport = service.getSslSupport();
            if (sslSupport == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL support could not be found for social login service", (Object[])new Object[0]);
                }
                return null;
            }
            try {
                JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
                if (jsseHelper != null) {
                    this.sslContext = jsseHelper.getSSLContext(this.sslRef, null, null, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sslContext (" + this.sslRef + ") get: " + this.sslContext), (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl", (String)"642", (Object)this, (Object[])new Object[0]);
                throw new SocialLoginException("FAILED_TO_GET_SSL_CONTEXT", (Exception)e, new Object[]{this.uniqueId, e.getLocalizedMessage()});
            }
        }
        return this.sslContext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLSocketFactory getSSLSocketFactory() throws SocialLoginException {
        if (this.sslContext == null) {
            SocialLoginService service = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            SSLSupport sslSupport = service.getSslSupport();
            if (sslSupport == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL support could not be found for social login service", (Object[])new Object[0]);
                }
                return null;
            }
            try {
                this.sslSocketFactory = sslSupport.getSSLSocketFactory(this.sslRef);
                JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sslSocketFactory (" + this.sslRef + ") get: " + this.sslSocketFactory), (Object[])new Object[0]);
                }
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl", (String)"673", (Object)this, (Object[])new Object[0]);
                throw new SocialLoginException("FAILED_TO_GET_SSL_CONTEXT", (Exception)e, new Object[]{this.uniqueId, e.getLocalizedMessage()});
            }
        }
        return this.sslSocketFactory;
    }

    @Override
    public String getJwksUri() {
        return this.jwksUri;
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public String getRealmNameAttribute() {
        return this.realmNameAttribute;
    }

    @Override
    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    @Override
    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    @Override
    public String getUserUniqueIdAttribute() {
        return this.userUniqueIdAttribute;
    }

    @Override
    public boolean getMapToUserRegistry() {
        return this.mapToUserRegistry;
    }

    @Override
    public String getJwtRef() {
        return this.jwtRef;
    }

    @Override
    public String[] getJwtClaims() {
        if (this.jwtClaims != null) {
            return (String[])this.jwtClaims.clone();
        }
        return null;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public PublicKey getPublicKey() throws SocialLoginException {
        if (this.sslRefInfo == null) {
            SocialLoginService service = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            this.sslRefInfo = this.createSslRefInfoImpl(service);
        }
        return this.sslRefInfo.getPublicKey();
    }

    @Override
    public PrivateKey getPrivateKey() throws SocialLoginException {
        if (this.sslRefInfo == null) {
            SocialLoginService service = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            this.sslRefInfo = this.createSslRefInfoImpl(service);
        }
        return this.sslRefInfo.getPrivateKey();
    }

    @Override
    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    @Override
    public String getUserApiResponseIdentifier() {
        return this.userApiResponseIdentifier;
    }

    @Override
    public boolean getUserApiNeedsSpecialHeader() {
        return this.userApiNeedsSpecialHeader;
    }

    protected SslRefInfoImpl createSslRefInfoImpl(SocialLoginService socialLoginService) {
        return new SslRefInfoImpl(socialLoginService.getSslSupport(), socialLoginService.getKeyStoreServiceRef(), this.sslRef, this.keyAliasName);
    }

    @Override
    public String getResponseMode() {
        return null;
    }

    @Override
    public boolean getUseSystemPropertiesForHttpClientConnections() {
        return this.useSystemPropertiesForHttpClientConnections;
    }

    @Override
    public String getUserApiType() {
        return this.userApiType;
    }

    @Override
    @Sensitive
    public String getUserApiToken() {
        return this.userApiToken;
    }

    @Override
    public boolean isAccessTokenRequired() {
        return this.accessTokenRequired;
    }

    @Override
    public boolean isAccessTokenSupported() {
        return this.accessTokenSupported;
    }

    @Override
    public String getAccessTokenHeaderName() {
        return this.accessTokenHeaderName;
    }
}

