/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import javax.net.ssl.SSLSocketFactory;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OpenShiftUserApiUtils {
    public static final TraceComponent tc = Tr.register(OpenShiftUserApiUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    Oauth2LoginConfigImpl config = null;
    HttpUtils httpUtils = new HttpUtils();
    static final long serialVersionUID = 5175227351374013323L;

    public OpenShiftUserApiUtils(Oauth2LoginConfigImpl config) {
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    public String getUserApiResponse(@Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws SocialLoginException {
        String response = null;
        try {
            HttpURLConnection connection = this.sendUserApiRequest(accessToken, sslSocketFactory);
            response = this.readUserApiResponse(connection);
        }
        catch (Exception connection) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive java.lang.String>";
            objectArray[1] = sslSocketFactory;
            FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.security.social.internal.utils.OpenShiftUserApiUtils", (String)"57", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("KUBERNETES_ERROR_GETTING_USER_INFO", (Exception)e, new Object[]{e});
        }
        return response;
    }

    HttpURLConnection sendUserApiRequest(@Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws IOException, SocialLoginException {
        HttpURLConnection connection = this.httpUtils.createConnection(HttpUtils.RequestMethod.POST, this.config.getUserApi(), sslSocketFactory);
        connection = this.httpUtils.setHeaders(connection, this.getUserApiRequestHeaders());
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        String bodyString = this.createUserApiRequestBody(accessToken);
        streamWriter.write(bodyString);
        streamWriter.close();
        outputStream.close();
        connection.connect();
        return connection;
    }

    @Sensitive
    Map<String, String> getUserApiRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.config.getUserApiToken());
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return headers;
    }

    String createUserApiRequestBody(@Sensitive String accessToken) throws SocialLoginException {
        if (accessToken == null) {
            throw new SocialLoginException("KUBERNETES_ACCESS_TOKEN_MISSING", null, null);
        }
        JsonObjectBuilder bodyBuilder = Json.createObjectBuilder();
        bodyBuilder.add("kind", "TokenReview");
        bodyBuilder.add("apiVersion", "authentication.k8s.io/v1");
        bodyBuilder.add("spec", Json.createObjectBuilder().add("token", accessToken));
        return bodyBuilder.build().toString();
    }

    String readUserApiResponse(HttpURLConnection connection) throws IOException, SocialLoginException, JoseException {
        int responseCode = connection.getResponseCode();
        String response = this.httpUtils.readConnectionResponse(connection);
        if (responseCode != 201) {
            throw new SocialLoginException("KUBERNETES_USER_API_BAD_STATUS", null, new Object[]{responseCode, response});
        }
        return this.modifyExistingResponseToJSON(response);
    }

    String modifyExistingResponseToJSON(String response) throws JoseException, SocialLoginException {
        JsonObject jsonResponse = this.getJsonResponseIfValid(response);
        JsonObject statusInnerMap = this.getStatusJsonObjectFromResponse(jsonResponse);
        JsonObject userInnerMap = this.getUserJsonObjectFromResponse(statusInnerMap);
        return this.createModifiedResponse(userInnerMap);
    }

    /*
     * WARNING - void declaration
     */
    private JsonObject getJsonResponseIfValid(String response) throws SocialLoginException {
        if (response == null || response.isEmpty()) {
            throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_NULL_EMPTY", null, null);
        }
        try {
            return Json.createReader((Reader)new StringReader(response)).readObject();
        }
        catch (JsonParsingException jsonParsingException) {
            void e;
            FFDCFilter.processException((Throwable)jsonParsingException, (String)"com.ibm.ws.security.social.internal.utils.OpenShiftUserApiUtils", (String)"121", (Object)this, (Object[])new Object[]{response});
            throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_NOT_JSON", null, new Object[]{response, e});
        }
    }

    String createModifiedResponse(JsonObject userInnerMap) throws SocialLoginException {
        JsonObjectBuilder modifiedResponse = Json.createObjectBuilder();
        if ("email".equals(this.config.getUserNameAttribute())) {
            this.addUserAttributeToResponseWithEmail(userInnerMap, modifiedResponse);
        } else {
            this.addUserToResponseWithoutEmail(userInnerMap, modifiedResponse);
        }
        this.addGroupNameToResponse(userInnerMap, modifiedResponse);
        return modifiedResponse.build().toString();
    }

    void addGroupNameToResponse(JsonObject userInnerMap, JsonObjectBuilder modifiedResponse) throws SocialLoginException {
        if (userInnerMap.containsKey((Object)this.config.getGroupNameAttribute())) {
            JsonValue groupsValue = (JsonValue)userInnerMap.get((Object)this.config.getGroupNameAttribute());
            if (groupsValue.getValueType() != JsonValue.ValueType.ARRAY) {
                throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_WRONG_JSON_TYPE", null, new Object[]{this.config.getGroupNameAttribute(), JsonValue.ValueType.ARRAY, groupsValue.getValueType(), userInnerMap});
            }
            modifiedResponse.add(this.config.getGroupNameAttribute(), (JsonValue)userInnerMap.getJsonArray(this.config.getGroupNameAttribute()));
        }
    }

    void addUserToResponseWithoutEmail(JsonObject userInnerMap, JsonObjectBuilder modifiedResponse) throws SocialLoginException {
        if (userInnerMap.containsKey((Object)this.config.getUserNameAttribute())) {
            JsonValue userInnerMapUsername = (JsonValue)userInnerMap.get((Object)this.config.getUserNameAttribute());
            if (userInnerMapUsername.getValueType() != JsonValue.ValueType.STRING) {
                throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_WRONG_JSON_TYPE", null, new Object[]{this.config.getUserNameAttribute(), JsonValue.ValueType.STRING, userInnerMapUsername.getValueType(), userInnerMap});
            }
        } else {
            throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_MISSING_KEY", null, new Object[]{this.config.getUserNameAttribute(), userInnerMap});
        }
        modifiedResponse.add(this.config.getUserNameAttribute(), userInnerMap.getString(this.config.getUserNameAttribute()));
    }

    void addUserAttributeToResponseWithEmail(JsonObject userInnerMap, JsonObjectBuilder modifiedResponse) throws SocialLoginException {
        if (userInnerMap.containsKey((Object)"email")) {
            JsonValue emailJsonString = (JsonValue)userInnerMap.get((Object)"email");
            if (emailJsonString.getValueType() != JsonValue.ValueType.STRING) {
                throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_WRONG_JSON_TYPE", null, new Object[]{"email", JsonValue.ValueType.STRING, emailJsonString.getValueType(), userInnerMap});
            }
            modifiedResponse.add(this.config.getUserNameAttribute(), userInnerMap.getString("email"));
        } else {
            String defaultKey = "username";
            Tr.warning((TraceComponent)tc, (String)"KUBERNETES_USER_API_RESPONSE_DEFAULT_USER_ATTR_NOT_FOUND", (Object[])new Object[]{this.config.getUniqueId(), "email", "userNameAttribute", defaultKey});
            if (userInnerMap.containsKey((Object)defaultKey)) {
                modifiedResponse.add(this.config.getUserNameAttribute(), userInnerMap.getString(defaultKey));
            } else {
                throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_MISSING_KEY", null, new Object[]{defaultKey, userInnerMap});
            }
        }
    }

    JsonObject getUserJsonObjectFromResponse(JsonObject statusResponse) throws SocialLoginException {
        if (statusResponse.containsKey((Object)"error")) {
            throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_ERROR", null, new Object[]{statusResponse.get((Object)"error")});
        }
        if (statusResponse.containsKey((Object)"user")) {
            JsonValue userInnerMapValue = (JsonValue)statusResponse.get((Object)"user");
            if (userInnerMapValue.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_WRONG_JSON_TYPE", null, new Object[]{"user", JsonValue.ValueType.OBJECT, userInnerMapValue.getValueType(), statusResponse});
            }
            return statusResponse.getJsonObject("user");
        }
        throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_MISSING_KEY", null, new Object[]{"user", statusResponse});
    }

    JsonObject getStatusJsonObjectFromResponse(JsonObject currentResponse) throws SocialLoginException {
        if (currentResponse.containsKey((Object)"status")) {
            JsonValue statusValue = (JsonValue)currentResponse.get((Object)"status");
            if (JsonValue.ValueType.STRING == statusValue.getValueType() && currentResponse.getString("status").equals("Failure") && currentResponse.containsKey((Object)"message") && ((JsonValue)currentResponse.get((Object)"message")).getValueType() == JsonValue.ValueType.STRING) {
                throw new SocialLoginException(currentResponse.getString("message"), null, null);
            }
            if (statusValue.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_WRONG_JSON_TYPE", null, new Object[]{"status", JsonValue.ValueType.OBJECT, statusValue.getValueType(), currentResponse});
            }
            return currentResponse.getJsonObject("status");
        }
        throw new SocialLoginException("KUBERNETES_USER_API_RESPONSE_MISSING_KEY", null, new Object[]{"status", currentResponse});
    }
}

