/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.OAuthClientUtil;
import com.ibm.ws.security.social.tai.TAIJwtUtils;
import com.ibm.ws.security.social.tai.TAIUserApiUtils;
import com.ibm.ws.security.social.tai.TAIWebUtils;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthorizationCodeAuthenticator {
    public static final TraceComponent tc = Tr.register(AuthorizationCodeAuthenticator.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    String authzCode = null;
    SocialLoginConfig socialConfig = null;
    SSLSocketFactory sslSocketFactory = null;
    private Map<String, Object> tokens = new HashMap<String, Object>();
    private String accessToken = null;
    private String userApiResponse = null;
    private JwtToken jwt = null;
    private JwtToken issuedJwt = null;
    OAuthClientUtil clientUtil = new OAuthClientUtil();
    TAIWebUtils taiWebUtils = new TAIWebUtils();
    TAIJwtUtils taiJwtUtils = new TAIJwtUtils();
    TAIUserApiUtils userApiUtils = new TAIUserApiUtils();
    static final long serialVersionUID = 1515041167892823199L;

    public AuthorizationCodeAuthenticator(HttpServletRequest req, HttpServletResponse res, String authzCode, SocialLoginConfig socialConfig) {
        this.request = req;
        this.response = res;
        this.authzCode = authzCode;
        this.socialConfig = socialConfig;
    }

    public AuthorizationCodeAuthenticator(SocialLoginConfig config, Map<String, Object> tokens) {
        this.socialConfig = config;
        this.tokens = tokens;
        this.accessToken = this.getAccessTokenFromTokens();
    }

    public AuthorizationCodeAuthenticator(HttpServletRequest req, HttpServletResponse res, SocialLoginConfig socialConfig, String accessToken, boolean openShift) {
        this.request = req;
        this.response = res;
        this.socialConfig = socialConfig;
        this.tokens.put("access_token", accessToken);
    }

    public Map<String, Object> getTokens() {
        return this.tokens;
    }

    public String getUserApiResponse() {
        return this.userApiResponse;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public JwtToken getJwt() {
        return this.jwt;
    }

    public JwtToken getIssuedJwt() {
        return this.issuedJwt;
    }

    public void generateJwtAndTokenInformation() throws SocialLoginException {
        this.createSslSocketFactory();
        this.getTokensFromTokenEndpoint();
        this.createJwtUserApiResponseAndIssuedJwtWithAppropriateToken();
    }

    public void generateJwtAndTokensFromTokenReviewResult() throws SocialLoginException {
        this.createSslSocketFactory();
        this.createJwtUserApiResponseAndIssuedJwtWithAppropriateToken();
    }

    @FFDCIgnore(value={Exception.class})
    void createSslSocketFactory() throws SocialLoginException {
        try {
            this.sslSocketFactory = this.socialConfig.getSSLSocketFactory();
        }
        catch (Exception e) {
            throw this.createExceptionAndLogMessage(e, "AUTH_CODE_ERROR_SSL_CONTEXT", new Object[]{this.socialConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    /*
     * WARNING - void declaration
     */
    void getTokensFromTokenEndpoint() throws SocialLoginException {
        try {
            this.tokens = this.getTokensUsingAuthzCode();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.AuthorizationCodeAuthenticator", (String)"119", (Object)this, (Object[])new Object[0]);
            throw this.createExceptionAndLogMessage((Exception)e, "AUTH_CODE_ERROR_GETTING_TOKENS", new Object[]{this.socialConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    Map<String, Object> getTokensUsingAuthzCode() throws SocialLoginException {
        return this.clientUtil.getTokensFromAuthzCode(this.socialConfig.getTokenEndpoint(), this.socialConfig.getClientId(), this.socialConfig.getClientSecret(), this.taiWebUtils.getRedirectUrl(this.request, this.socialConfig), this.authzCode, "authorization_code", this.sslSocketFactory, false, this.socialConfig.getTokenEndpointAuthMethod(), this.socialConfig.getResource(), this.socialConfig.getUseSystemPropertiesForHttpClientConnections());
    }

    public void createJwtUserApiResponseAndIssuedJwtWithAppropriateToken() throws SocialLoginException {
        String idToken = this.getIdTokenFromTokens();
        this.accessToken = this.getAccessTokenFromTokens();
        if (idToken == null) {
            this.createJwtUserApiResponseAndIssuedJwtFromUserApi();
        } else {
            this.createJwtUserApiResponseAndIssuedJwtFromIdToken(idToken);
        }
    }

    String getIdTokenFromTokens() {
        return (String)this.tokens.get("id_token");
    }

    String getAccessTokenFromTokens() {
        return (String)this.tokens.get("access_token");
    }

    void createJwtUserApiResponseAndIssuedJwtFromUserApi() throws SocialLoginException {
        this.createUserApiResponseFromAccessToken();
        this.createIssuedJwtFromUserApiResponse();
    }

    void createUserApiResponseFromAccessToken() throws SocialLoginException {
        this.userApiResponse = this.userApiUtils.getUserApiResponse(this.clientUtil, this.socialConfig, this.accessToken, this.sslSocketFactory);
        if (this.userApiResponse == null || this.userApiResponse.isEmpty()) {
            throw this.createExceptionAndLogMessage(null, "USER_API_RESPONSE_NULL_OR_EMPTY", new Object[]{this.socialConfig.getUniqueId()});
        }
    }

    /*
     * WARNING - void declaration
     */
    void createIssuedJwtFromUserApiResponse() throws SocialLoginException {
        try {
            if (this.socialConfig.getJwtRef() != null) {
                this.issuedJwt = this.taiJwtUtils.createJwtTokenFromJson(this.userApiResponse, this.socialConfig, false);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.AuthorizationCodeAuthenticator", (String)"177", (Object)this, (Object[])new Object[0]);
            throw this.createExceptionAndLogMessage((Exception)e, "AUTH_CODE_FAILED_TO_CREATE_JWT", new Object[]{this.socialConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    void createJwtUserApiResponseAndIssuedJwtFromIdToken(String idToken) throws SocialLoginException {
        this.createJwtAndIssuedJwtFromIdToken(idToken);
        this.createUserApiResponseFromIdToken(idToken);
    }

    /*
     * WARNING - void declaration
     */
    void createJwtAndIssuedJwtFromIdToken(String idToken) throws SocialLoginException {
        try {
            this.createJwtFromIdToken(idToken);
            this.createIssuedJwtFromIdToken(idToken);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.AuthorizationCodeAuthenticator", (String)"191", (Object)this, (Object[])new Object[]{idToken});
            throw this.createExceptionAndLogMessage((Exception)e, "AUTH_CODE_FAILED_TO_CREATE_JWT", new Object[]{this.socialConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    void createJwtFromIdToken(String idToken) throws SocialLoginException {
        this.jwt = this.taiJwtUtils.createJwtTokenFromIdToken(idToken, this.socialConfig.getUniqueId());
    }

    void createIssuedJwtFromIdToken(String idToken) throws Exception {
        if (this.socialConfig.getJwtRef() != null) {
            this.issuedJwt = this.taiJwtUtils.createJwtTokenFromJson(idToken, this.socialConfig, true);
        }
    }

    void createUserApiResponseFromIdToken(String idToken) {
        String payload = JsonUtils.getPayload((String)idToken);
        this.userApiResponse = JsonUtils.decodeFromBase64String((String)payload);
    }

    SocialLoginException createExceptionAndLogMessage(Exception cause, String msgKey, Object[] objects) {
        SocialLoginException exception = new SocialLoginException(msgKey, cause, objects);
        exception.logErrorMessage();
        return exception;
    }
}

