/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.twitter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.ErrorHandlerImpl;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.security.social.twitter.TwitterEndpointServices;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TwitterTokenServices {
    private static TraceComponent tc = Tr.register(TwitterTokenServices.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    SocialWebUtils webUtils = new SocialWebUtils();
    static final long serialVersionUID = -1138610379368419889L;

    protected TwitterEndpointServices getTwitterEndpointServices() {
        return new TwitterEndpointServices();
    }

    /*
     * WARNING - void declaration
     */
    public void getRequestToken(HttpServletRequest request, HttpServletResponse response, String callbackUrl, String stateValue, SocialLoginConfig config) {
        TwitterEndpointServices twitter = this.getTwitterEndpointServices();
        twitter.setConsumerKey(config.getClientId());
        twitter.setConsumerSecret(config.getClientSecret());
        Map<String, Object> result = twitter.obtainRequestToken(config, callbackUrl);
        if (result == null || result.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_ERROR_OBTAINING_ENDPOINT_RESULT", (Object[])new Object[]{"/oauth/request_token"});
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("/oauth/request_token result: " + result.toString()), (Object[])new Object[0]);
        }
        try {
            if (!this.isSuccessfulResult(result, "/oauth/request_token")) {
                ErrorHandlerImpl.getInstance().handleErrorResponse(response);
                return;
            }
            String requestToken = (String)result.get("oauth_token");
            this.setCookies(request, response, requestToken, stateValue);
            String authzEndpoint = config.getAuthorizationEndpoint();
            try {
                SocialUtil.validateEndpointWithQuery(authzEndpoint);
            }
            catch (SocialLoginException socialLoginException) {
                void e;
                FFDCFilter.processException((Throwable)socialLoginException, (String)"com.ibm.ws.security.social.twitter.TwitterTokenServices", (String)"88", (Object)this, (Object[])new Object[]{request, response, callbackUrl, stateValue, config});
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_REDIRECT_TO_AUTHZ_ENDPOINT", (Object[])new Object[]{config.getUniqueId(), e.getMessage()});
                ErrorHandlerImpl.getInstance().handleErrorResponse(response);
                return;
            }
            String queryChar = authzEndpoint.contains("?") ? "&" : "?";
            response.sendRedirect(authzEndpoint + queryChar + "oauth_token" + "=" + requestToken);
        }
        catch (IOException requestToken) {
            void e;
            FFDCFilter.processException((Throwable)requestToken, (String)"com.ibm.ws.security.social.twitter.TwitterTokenServices", (String)"96", (Object)this, (Object[])new Object[]{request, response, callbackUrl, stateValue, config});
            Tr.error((TraceComponent)tc, (String)"TWITTER_REDIRECT_IOEXCEPTION", (Object[])new Object[]{"/oauth/request_token", e.getLocalizedMessage()});
            ErrorHandlerImpl.getInstance().handleErrorResponse(response, 400);
            return;
        }
    }

    @Sensitive
    public Map<String, Object> getAccessToken(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) {
        TwitterEndpointServices twitter = this.getTwitterEndpointServices();
        twitter.setConsumerKey(config.getClientId());
        twitter.setConsumerSecret(config.getClientSecret());
        Map params = request.getParameterMap();
        if (this.isMissingParameter(params, "/oauth/access_token")) {
            return null;
        }
        String token = request.getParameter("oauth_token");
        String cachedRequestToken = this.webUtils.getAndClearCookie(request, response, "WASSocialRequestToken");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Obtained token from request: [" + token + "], matching against: [" + cachedRequestToken + "]"), (Object[])new Object[0]);
        }
        if (!token.equals(cachedRequestToken)) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_TOKEN_DOES_NOT_MATCH", (Object[])new Object[0]);
            return null;
        }
        String oauthVerifier = request.getParameter("oauth_verifier");
        Map<String, Object> result = twitter.obtainAccessToken(config, cachedRequestToken, oauthVerifier);
        if (result == null || result.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_ERROR_OBTAINING_ENDPOINT_RESULT", (Object[])new Object[]{"/oauth/access_token"});
            return null;
        }
        if (!this.isSuccessfulResult(result, "/oauth/access_token")) {
            return null;
        }
        return result;
    }

    public Map<String, Object> verifyCredentials(HttpServletResponse response, String accessToken, @Sensitive String accessTokenSecret, SocialLoginConfig config) {
        TwitterEndpointServices twitter = this.getTwitterEndpointServices();
        twitter.setConsumerKey(config.getClientId());
        twitter.setConsumerSecret(config.getClientSecret());
        Map<String, Object> creds = twitter.verifyCredentials(config, accessToken, accessTokenSecret);
        if (creds == null || creds.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_ERROR_OBTAINING_ENDPOINT_RESULT", (Object[])new Object[]{"/1.1/account/verify_credentials.json"});
            return null;
        }
        if (!this.isSuccessfulResult(creds, "/1.1/account/verify_credentials.json")) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(creds);
        result.put("access_token", accessToken);
        return result;
    }

    protected void setCookies(HttpServletRequest request, HttpServletResponse response, String requestToken, String stateValue) {
        ReferrerURLCookieHandler referrerURLCookieHandler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
        Cookie requestTokenCookie = referrerURLCookieHandler.createCookie("WASSocialRequestToken", requestToken, request);
        response.addCookie(requestTokenCookie);
        String cookieName = "WASReqUrlSocial_" + stateValue.hashCode();
        Cookie c = referrerURLCookieHandler.createCookie(cookieName, this.webUtils.getRequestUrlWithEncodedQueryString(request), request);
        response.addCookie(c);
    }

    protected boolean isMissingParameter(Map<String, String[]> requestParams, String endpoint) {
        if ("/oauth/access_token".equals(endpoint)) {
            if (!requestParams.containsKey("oauth_token")) {
                Tr.error((TraceComponent)tc, (String)"TWITTER_REQUEST_MISSING_PARAMETER", (Object[])new Object[]{"/oauth/access_token", "oauth_token"});
                return true;
            }
            if (!requestParams.containsKey("oauth_verifier")) {
                Tr.error((TraceComponent)tc, (String)"TWITTER_REQUEST_MISSING_PARAMETER", (Object[])new Object[]{"/oauth/access_token", "oauth_verifier"});
                return true;
            }
        }
        return false;
    }

    protected boolean isSuccessfulResult(@Sensitive Map<String, Object> result, String endpoint) {
        String responseMsg;
        if (result == null) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_ERROR_OBTAINING_ENDPOINT_RESULT", (Object[])new Object[]{endpoint});
            return false;
        }
        String responseStatus = result.containsKey("response_status") ? (String)result.get("response_status") : null;
        String string = responseMsg = result.containsKey("message") ? (String)result.get("message") : null;
        if (responseStatus == null) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_RESPONSE_STATUS_MISSING", (Object[])new Object[]{endpoint});
            return false;
        }
        if (!responseStatus.equals("success")) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_RESPONSE_FAILURE", (Object[])new Object[]{endpoint, responseMsg == null ? "" : responseMsg});
            return false;
        }
        return true;
    }
}

