/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.helper.Tag;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Counting;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Sampling;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusBuilder {
    private static final TraceComponent tc = Tr.register(PrometheusBuilder.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private static final String QUANTILE = "quantile";
    static final long serialVersionUID = -5401066638543785269L;

    @FFDCIgnore(value={IllegalStateException.class})
    public static void buildGauge(StringBuilder builder, String name, Gauge<?> gauge, String description, Double conversionFactor, String tags, String appendUnit) {
        Number gaugeValNumber = null;
        Object gaugeValue = null;
        try {
            gaugeValue = gauge.getValue();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (!Number.class.isInstance(gaugeValue)) {
            Tr.event((TraceComponent)tc, (String)("Skipping Prometheus output for Gauge: " + name + " of type " + gauge.getValue().getClass()), (Object[])new Object[0]);
            return;
        }
        gaugeValNumber = (Number)gaugeValue;
        if (!Double.isNaN(conversionFactor)) {
            gaugeValNumber = gaugeValNumber.doubleValue() * conversionFactor;
        }
        PrometheusBuilder.getPromTypeLine(builder, name, "gauge", appendUnit);
        PrometheusBuilder.getPromHelpLine(builder, name, description, appendUnit);
        PrometheusBuilder.getPromValueLine(builder, name, gaugeValNumber, tags, appendUnit);
    }

    public static void buildCounter(StringBuilder builder, String name, Counter counter, String description, String tags) {
        PrometheusBuilder.getPromTypeLine(builder, name, "counter");
        PrometheusBuilder.getPromHelpLine(builder, name, description);
        PrometheusBuilder.getPromValueLine(builder, name, counter.getCount(), tags);
    }

    public static void buildTimer(StringBuilder builder, String name, Timer timer, String description, String tags) {
        PrometheusBuilder.buildMetered(builder, name, (Metered)timer, description, tags);
        double conversionFactor = 1.0E-9;
        PrometheusBuilder.buildSampling(builder, name, (Sampling)timer, description, conversionFactor, tags, "_seconds");
    }

    public static void buildHistogram(StringBuilder builder, String name, Histogram histogram, String description, Double conversionFactor, String tags, String appendUnit) {
        PrometheusBuilder.buildSampling(builder, name, (Sampling)histogram, description, conversionFactor, tags, appendUnit);
    }

    public static void buildMeter(StringBuilder builder, String name, Meter meter, String description, String tags) {
        PrometheusBuilder.buildCounting(builder, name, (Counting)meter, description, tags);
        PrometheusBuilder.buildMetered(builder, name, (Metered)meter, description, tags);
    }

    private static void buildSampling(StringBuilder builder, String name, Sampling sampling, String description, Double conversionFactor, String tags, String appendUnit) {
        double meanVal = sampling.getSnapshot().getMean();
        double maxVal = sampling.getSnapshot().getMax();
        double minVal = sampling.getSnapshot().getMin();
        double stdDevVal = sampling.getSnapshot().getStdDev();
        double medianVal = sampling.getSnapshot().getMedian();
        double percentile75th = sampling.getSnapshot().get75thPercentile();
        double percentile95th = sampling.getSnapshot().get95thPercentile();
        double percentile98th = sampling.getSnapshot().get98thPercentile();
        double percentile99th = sampling.getSnapshot().get99thPercentile();
        double percentile999th = sampling.getSnapshot().get999thPercentile();
        if (!Double.isNaN(conversionFactor)) {
            meanVal = sampling.getSnapshot().getMean() * conversionFactor;
            maxVal = (double)sampling.getSnapshot().getMax() * conversionFactor;
            minVal = (double)sampling.getSnapshot().getMin() * conversionFactor;
            stdDevVal = sampling.getSnapshot().getStdDev() * conversionFactor;
            medianVal = sampling.getSnapshot().getMedian() * conversionFactor;
            percentile75th = sampling.getSnapshot().get75thPercentile() * conversionFactor;
            percentile95th = sampling.getSnapshot().get95thPercentile() * conversionFactor;
            percentile98th = sampling.getSnapshot().get98thPercentile() * conversionFactor;
            percentile99th = sampling.getSnapshot().get99thPercentile() * conversionFactor;
            percentile999th = sampling.getSnapshot().get999thPercentile() * conversionFactor;
        }
        String lineName = name + "_mean";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        PrometheusBuilder.getPromValueLine(builder, lineName, meanVal, tags, appendUnit);
        lineName = name + "_max";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        PrometheusBuilder.getPromValueLine(builder, lineName, maxVal, tags, appendUnit);
        lineName = name + "_min";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        PrometheusBuilder.getPromValueLine(builder, lineName, minVal, tags, appendUnit);
        lineName = name + "_stddev";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        PrometheusBuilder.getPromValueLine(builder, lineName, stdDevVal, tags, appendUnit);
        PrometheusBuilder.getPromTypeLine(builder, name, "summary", appendUnit);
        PrometheusBuilder.getPromHelpLine(builder, name, description, appendUnit);
        if (Counting.class.isInstance(sampling)) {
            PrometheusBuilder.getPromValueLine(builder, name, ((Counting)sampling).getCount(), tags, appendUnit == null ? "_count" : appendUnit + "_count");
        }
        PrometheusBuilder.getPromValueLine(builder, name, medianVal, tags, new Tag(QUANTILE, "0.5"), appendUnit);
        PrometheusBuilder.getPromValueLine(builder, name, percentile75th, tags, new Tag(QUANTILE, "0.75"), appendUnit);
        PrometheusBuilder.getPromValueLine(builder, name, percentile95th, tags, new Tag(QUANTILE, "0.95"), appendUnit);
        PrometheusBuilder.getPromValueLine(builder, name, percentile98th, tags, new Tag(QUANTILE, "0.98"), appendUnit);
        PrometheusBuilder.getPromValueLine(builder, name, percentile99th, tags, new Tag(QUANTILE, "0.99"), appendUnit);
        PrometheusBuilder.getPromValueLine(builder, name, percentile999th, tags, new Tag(QUANTILE, "0.999"), appendUnit);
    }

    private static void buildCounting(StringBuilder builder, String name, Counting counting, String description, String tags) {
        String lineName = name + "_total";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "counter");
        PrometheusBuilder.getPromHelpLine(builder, lineName, description);
        PrometheusBuilder.getPromValueLine(builder, lineName, counting.getCount(), tags);
    }

    private static void buildMetered(StringBuilder builder, String name, Metered metered, String description, String tags) {
        String lineName = name + "_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        PrometheusBuilder.getPromValueLine(builder, lineName, metered.getMeanRate(), tags);
        lineName = name + "_one_min_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        PrometheusBuilder.getPromValueLine(builder, lineName, metered.getOneMinuteRate(), tags);
        lineName = name + "_five_min_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        PrometheusBuilder.getPromValueLine(builder, lineName, metered.getFiveMinuteRate(), tags);
        lineName = name + "_fifteen_min_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        PrometheusBuilder.getPromValueLine(builder, lineName, metered.getFifteenMinuteRate(), tags);
    }

    private static void getPromValueLine(StringBuilder builder, String name, Number value, String tags) {
        PrometheusBuilder.getPromValueLine(builder, name, value, tags, null);
    }

    private static void getPromValueLine(StringBuilder builder, String name, Number value, String tags, Tag quantile, String appendUnit) {
        tags = tags == null || tags.isEmpty() ? quantile.getKey() + "=\"" + quantile.getValue() + "\"" : tags + "," + quantile.getKey() + "=\"" + quantile.getValue() + "\"";
        PrometheusBuilder.getPromValueLine(builder, name, value, tags, appendUnit);
    }

    private static void getPromValueLine(StringBuilder builder, String name, Number value, String tags, String appendUnit) {
        String metricName = PrometheusBuilder.getPrometheusMetricName(name);
        builder.append(metricName);
        if (appendUnit != null) {
            builder.append(appendUnit);
        }
        if (tags != null && tags.length() > 0) {
            builder.append("{").append(tags).append("}");
        }
        builder.append(" ").append(value).append('\n');
    }

    private static void getPromHelpLine(StringBuilder builder, String name, String description) {
        PrometheusBuilder.getPromHelpLine(builder, name, description, null);
    }

    private static void getPromHelpLine(StringBuilder builder, String name, String description, String appendUnit) {
        String metricName = PrometheusBuilder.getPrometheusMetricName(name);
        if (description != null && !description.isEmpty()) {
            builder.append("# HELP ").append(metricName);
            if (appendUnit != null) {
                builder.append(appendUnit);
            }
            builder.append(" ").append(description).append("\n");
        }
    }

    private static void getPromTypeLine(StringBuilder builder, String name, String type) {
        PrometheusBuilder.getPromTypeLine(builder, name, type, null);
    }

    private static void getPromTypeLine(StringBuilder builder, String name, String type, String appendUnit) {
        String metricName = PrometheusBuilder.getPrometheusMetricName(name);
        builder.append("# TYPE ").append(metricName);
        if (appendUnit != null) {
            builder.append(appendUnit);
        }
        builder.append(" ").append(type).append("\n");
    }

    private static String getPrometheusMetricName(String name) {
        String out = name.replaceAll("(?<!^|:)(\\p{Upper})(?=\\p{Lower})", "_$1");
        out = out.replaceAll("(?<=\\p{Lower})(\\p{Upper})", "_$1").toLowerCase();
        out = out.replaceAll("[-_.\\s]+", "_");
        out = out.replaceAll("^_*(.*?)_*$", "$1");
        return out;
    }
}

