/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs21.component.LibertyJaxRsThreadPoolAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AsyncResponseImpl
implements AsyncResponse,
ContinuationCallback {
    private Continuation cont;
    private final Message inMessage;
    private TimeoutHandler timeoutHandler;
    private volatile boolean initialSuspend;
    private volatile boolean cancelled;
    private volatile boolean done;
    private volatile boolean resumedByApplication;
    private volatile Long pendingTimeout;
    private final List<CompletionCallback> completionCallbacks = new LinkedList<CompletionCallback>();
    private final List<ConnectionCallback> connectionCallbacks = new LinkedList<ConnectionCallback>();
    private Throwable unmappedThrowable;
    protected ScheduledFuture timeoutFuture;
    protected ScheduledExecutorService asyncScheduler;
    static final long serialVersionUID = -9041634583232631535L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AsyncResponseImpl(Message inMessage) {
        inMessage.put(AsyncResponse.class, (Object)this);
        inMessage.getExchange().put(ContinuationCallback.class, (Object)this);
        this.inMessage = inMessage;
        this.asyncScheduler = (ScheduledExecutorService)LibertyJaxRsThreadPoolAdapter.getScheduledexecutorserviceref().getService();
        this.initContinuation();
    }

    public boolean resume(Object response) {
        return this.doResume(response);
    }

    public boolean resume(Throwable response) {
        return this.doResume(response);
    }

    private boolean isCancelledOrNotSuspended() {
        return this.isCancelled() || !this.isSuspended();
    }

    private boolean doResume(Object response) {
        if (this.isCancelledOrNotSuspended()) {
            return false;
        }
        return this.doResumeFinal(response);
    }

    private synchronized boolean doResumeFinal(Object response) {
        this.inMessage.getExchange().put(AsyncResponse.class, (Object)this);
        this.cont.setObject(response);
        this.resumedByApplication = true;
        if (!this.initialSuspend) {
            this.cont.resume();
        } else {
            this.initialSuspend = false;
        }
        return true;
    }

    public boolean cancel() {
        return this.doCancel(null);
    }

    public boolean cancel(int retryAfter) {
        return this.doCancel(Integer.toString(retryAfter));
    }

    public boolean cancel(Date retryAfter) {
        return this.doCancel(HttpUtils.getHttpDateFormat().format(retryAfter));
    }

    private boolean doCancel(String retryAfterHeader) {
        if (this.cancelled) {
            return true;
        }
        if (!this.isSuspended()) {
            return false;
        }
        if (this.resumedByApplication) {
            return false;
        }
        this.cancelled = true;
        Response.ResponseBuilder rb = Response.status((int)503);
        if (retryAfterHeader != null) {
            rb.header("Retry-After", (Object)retryAfterHeader);
        }
        this.doResumeFinal(rb.build());
        return this.cancelled;
    }

    public boolean isSuspended() {
        if (this.cancelled || this.resumedByApplication) {
            return false;
        }
        return this.initialSuspend || this.cont.isPending();
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isDone() {
        return this.done;
    }

    public synchronized boolean setTimeout(long time, TimeUnit unit) throws IllegalStateException {
        if (this.isCancelledOrNotSuspended()) {
            return false;
        }
        long timeout = TimeUnit.MILLISECONDS.convert(time, unit);
        if (this.cont.isPending()) {
            if (this.timeoutFuture != null && !this.timeoutFuture.cancel(false)) {
                return false;
            }
            Runnable task = new Runnable(){
                static final long serialVersionUID = 3052140548829753536L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    AsyncResponseImpl.this.handleTimeout();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.impl.AsyncResponseImpl$1", 1.class, null, null);
                }
            };
            this.timeoutFuture = this.asyncScheduler.schedule(task, time, unit);
            return true;
        }
        this.setAsyncResponseOnExchange();
        this.initialSuspend = false;
        this.cont.suspend(timeout);
        return true;
    }

    private void setAsyncResponseOnExchange() {
        this.inMessage.getExchange().put(AsyncResponse.class, (Object)this);
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    public Collection<Class<?>> register(Class<?> callback) throws NullPointerException {
        return this.register(callback, new Class[0]).get(callback);
    }

    /*
     * WARNING - void declaration
     */
    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) throws NullPointerException {
        try {
            Object[] extraCallbacks = new Object[callbacks.length];
            for (int i = 0; i < callbacks.length; ++i) {
                extraCallbacks[i] = callbacks[i].newInstance();
            }
            return this.register(callback.newInstance(), extraCallbacks);
        }
        catch (NullPointerException extraCallbacks) {
            void e;
            FFDCFilter.processException((Throwable)extraCallbacks, (String)"org.apache.cxf.jaxrs.impl.AsyncResponseImpl", (String)"231", (Object)this, (Object[])new Object[]{callback, callbacks});
            throw e;
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.jaxrs.impl.AsyncResponseImpl", (String)"233", (Object)this, (Object[])new Object[]{callback, callbacks});
            return Collections.emptyMap();
        }
    }

    public Collection<Class<?>> register(Object callback) throws NullPointerException {
        return this.register(callback, new Object[0]).get(callback.getClass());
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) throws NullPointerException {
        HashMap map = new HashMap();
        Object[] allCallbacks = new Object[1 + callbacks.length];
        allCallbacks[0] = callback;
        System.arraycopy(callbacks, 0, allCallbacks, 1, callbacks.length);
        for (int i = 0; i < allCallbacks.length; ++i) {
            if (allCallbacks[i] == null) {
                throw new NullPointerException();
            }
            Class<?> callbackCls = allCallbacks[i].getClass();
            HashSet<Class> knownCallbacks = (HashSet<Class>)map.get(callbackCls);
            if (knownCallbacks == null) {
                knownCallbacks = new HashSet<Class>();
                map.put(callbackCls, knownCallbacks);
            }
            if (allCallbacks[i] instanceof CompletionCallback) {
                knownCallbacks.add(CompletionCallback.class);
                this.completionCallbacks.add((CompletionCallback)allCallbacks[i]);
                continue;
            }
            if (!(allCallbacks[i] instanceof ConnectionCallback)) continue;
            knownCallbacks.add(ConnectionCallback.class);
            this.connectionCallbacks.add((ConnectionCallback)allCallbacks[i]);
        }
        return map;
    }

    public void onComplete() {
        this.done = true;
        this.updateCompletionCallbacks(this.unmappedThrowable);
    }

    public void onError(Throwable error) {
        this.updateCompletionCallbacks(error);
    }

    private void updateCompletionCallbacks(Throwable error) {
        Throwable actualError = error instanceof Fault ? ((Fault)error).getCause() : error;
        for (CompletionCallback completionCallback : this.completionCallbacks) {
            completionCallback.onComplete(actualError);
        }
    }

    public void onDisconnect() {
        for (ConnectionCallback connectionCallback : this.connectionCallbacks) {
            connectionCallback.onDisconnect((AsyncResponse)this);
        }
    }

    public synchronized boolean suspendContinuationIfNeeded() {
        if (!(this.resumedByApplication || this.isDone() || this.cont.isPending() || this.cont.isResumed())) {
            this.cont.suspend(0L);
            this.initialSuspend = false;
            return true;
        }
        return false;
    }

    public Object getResponseObject() {
        Object obj = this.cont.getObject();
        if (!(obj instanceof Response) && !(obj instanceof Throwable)) {
            obj = obj == null ? Response.noContent().build() : Response.ok().entity(obj).build();
        }
        return obj;
    }

    public boolean isResumedByApplication() {
        return this.resumedByApplication;
    }

    public synchronized void handleTimeout() {
        if (!this.resumedByApplication) {
            if (this.pendingTimeout != null) {
                this.setAsyncResponseOnExchange();
                this.cont.suspend(this.pendingTimeout.longValue());
                this.pendingTimeout = null;
            } else if (this.timeoutHandler != null) {
                this.timeoutHandler.handleTimeout((AsyncResponse)this);
            } else {
                this.cont.setObject((Object)new ServiceUnavailableException());
            }
            if (this.cont.isPending()) {
                this.cont.resume();
                this.onComplete();
            }
        }
    }

    private void initContinuation() {
        ContinuationProvider provider = (ContinuationProvider)this.inMessage.get((Object)ContinuationProvider.class.getName());
        this.cont = provider.getContinuation();
        this.initialSuspend = true;
    }

    public void prepareContinuation() {
        this.initContinuation();
    }

    public void setUnmappedThrowable(Throwable t) {
        this.unmappedThrowable = t;
    }

    public void reset() {
        this.cont.reset();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.impl.AsyncResponseImpl", AsyncResponseImpl.class, null, null);
    }
}

