/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.validator.jca;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.service.ConnectionFactoryService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.handler.validator.jca.JMSValidator;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.validator.Validator;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={Validator.class}, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/validation", "com.ibm.wsspi.rest.handler.config.pid=com.ibm.ws.jca.connectionFactory", "com.ibm.wsspi.rest.handler.config.pid=com.ibm.ws.jca.connectionFactory.supertype", "com.ibm.wsspi.rest.handler.config.pid=com.ibm.ws.jca.jmsConnectionFactory", "com.ibm.wsspi.rest.handler.config.pid=com.ibm.ws.jca.jmsQueueConnectionFactory", "com.ibm.wsspi.rest.handler.config.pid=com.ibm.ws.jca.jmsTopicConnectionFactory"})
public class ConnectionFactoryValidator
implements Validator {
    private static final TraceComponent tc = Tr.register(ConnectionFactoryValidator.class, (String)"rest.validation", (String)"com.ibm.ws.rest.handler.validator.resources.CWWKOMessages");
    @Reference
    private ResourceConfigFactory resourceConfigFactory;
    static final long serialVersionUID = 8694408269633965413L;

    @FFDCIgnore(value={Throwable.class})
    private ConnectionSpec createConnectionSpec(ConnectionFactory cciConFactory, String conSpecClassName, String userName, @Sensitive String password) {
        try {
            Class<?> conSpecClass = cciConFactory.getClass().getClassLoader().loadClass(conSpecClassName);
            ConnectionSpec conSpec = (ConnectionSpec)conSpecClass.newInstance();
            conSpecClass.getMethod("setPassword", String.class).invoke((Object)conSpec, password);
            conSpecClass.getMethod("setUserName", String.class).invoke((Object)conSpec, userName);
            return conSpec;
        }
        catch (Throwable x) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to create or populate ConnectionSpec", (Object[])new Object[]{x.getMessage()});
            }
            return null;
        }
    }

    private JMSValidator getJMSValidator() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JMSValidator>(){
                static final long serialVersionUID = -3766822851486930995L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JMSValidator run() throws Exception {
                    Class<?> JMSConnectionFactoryValidator2 = this.getClass().getClassLoader().loadClass("com.ibm.ws.rest.handler.validator.jms.JMSConnectionFactoryValidator");
                    return (JMSValidator)JMSConnectionFactoryValidator2.newInstance();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator$1", 1.class, (String)"rest.validation", (String)"com.ibm.ws.rest.handler.validator.resources.CWWKOMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"108", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public LinkedHashMap<String, ?> validate(Object instance, @Sensitive Map<String, Object> props, Locale locale) {
        String methodName = "validate";
        String user = (String)props.get("user");
        String password = (String)props.get("password");
        String auth = (String)props.get("auth");
        String authAlias = (String)props.get("authAlias");
        String loginConfig = (String)props.get("loginConfig");
        Map loginConfigProps = (Map)props.get("loginConfigProps");
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"validate", (Object[])new Object[]{user, password == null ? null : "******", auth, authAlias, loginConfig, loginConfigProps == null ? null : loginConfigProps.entrySet()});
        }
        JMSValidator jmsValidator = null;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            Object cf;
            int authType;
            ResourceConfig config = null;
            int n = "container".equals(auth) ? 0 : (authType = "application".equals(auth) ? 1 : -1);
            if (authType >= 0) {
                List cfInterfaceNames = ((ConnectionFactoryService)instance).getConnectionFactoryInterfaceNames();
                if (cfInterfaceNames.isEmpty()) {
                    throw new RuntimeException("Connection factory cannot be accessed via resource reference because no connection factory interface is defined.");
                }
                config = this.resourceConfigFactory.createResourceConfig((String)cfInterfaceNames.get(0));
                config.setResAuthType(authType);
                if (authAlias != null) {
                    config.addLoginProperty("DefaultPrincipalMapping", authAlias);
                }
                if (loginConfig != null) {
                    config.setLoginConfigurationName(loginConfig);
                }
                if (loginConfigProps != null) {
                    for (Map.Entry entry : loginConfigProps.entrySet()) {
                        Object value = entry.getValue();
                        config.addLoginProperty((String)entry.getKey(), value == null ? null : value.toString());
                    }
                }
            }
            if ((cf = ((ResourceFactory)instance).createResource(config)) instanceof ConnectionFactory) {
                this.validateCCIConnectionFactory((ConnectionFactory)cf, (ConnectionFactoryService)instance, user, password, result);
            } else if (cf instanceof DataSource) {
                this.validateDataSource((DataSource)cf, user, password, result);
            } else {
                TreeSet<String> interfaces = new TreeSet<String>();
                LinkedList stack = new LinkedList();
                for (Class<?> c = cf.getClass(); c != null; c = c.getSuperclass()) {
                    for (Class<?> i : c.getInterfaces()) {
                        stack.add(i);
                    }
                }
                Class i = (Class)stack.poll();
                while (i != null) {
                    interfaces.add(i.getName());
                    for (Class<?> j : i.getInterfaces()) {
                        stack.add(j);
                    }
                    i = (Class)stack.poll();
                }
                if (interfaces.contains("javax.jms.ConnectionFactory")) {
                    jmsValidator = this.getJMSValidator();
                    if (jmsValidator == null) {
                        result.put("failure", Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"CWWKO1561_JMS_NOT_ENABLED", (Object[])new Object[0]));
                    } else {
                        jmsValidator.validate(cf, user, password, result);
                    }
                } else {
                    result.put("failure", Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"CWWKO1560_VALIDATION_NOT_IMPLEMENTED", (Object[])new Object[]{cf.getClass().getName(), interfaces}));
                }
            }
        }
        catch (Throwable config) {
            void x;
            Object[] objectArray = new Object[3];
            objectArray[0] = instance;
            objectArray[1] = "<sensitive java.util.Map>";
            objectArray[2] = locale;
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"181", (Object)this, (Object[])objectArray);
            ArrayList<String> sqlStates = new ArrayList<String>();
            ArrayList<String> errorCodes = new ArrayList<String>();
            HashSet<void> causes = new HashSet<void>();
            for (Throwable cause = x; cause != null && causes.add((void)cause); cause = cause.getCause()) {
                String sqlState = cause instanceof SQLException ? ((SQLException)cause).getSQLState() : null;
                sqlStates.add(sqlState);
                String errorCode = null;
                if (jmsValidator != null && jmsValidator.isJMSException(cause)) {
                    errorCode = jmsValidator.getErrorCode(cause);
                }
                if (cause instanceof ResourceException) {
                    errorCode = ((ResourceException)cause).getErrorCode();
                } else if (cause instanceof SQLException) {
                    int ec = ((SQLException)cause).getErrorCode();
                    errorCode = sqlState == null && ec == 0 ? null : Integer.toString(ec);
                }
                errorCodes.add(errorCode);
            }
            result.put("sqlState", sqlStates);
            result.put("errorCode", errorCodes);
            result.put("failure", x);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"validate", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCCIConnectionFactory(ConnectionFactory cf, ConnectionFactoryService cfSvc, String user, @Sensitive String password, LinkedHashMap<String, Object> result) throws ResourceException {
        Connection con;
        try {
            String spec;
            String desc;
            ResourceAdapterMetaData adapterData = cf.getMetaData();
            result.put("resourceAdapterName", adapterData.getAdapterName());
            result.put("resourceAdapterVersion", adapterData.getAdapterVersion());
            String vendor = adapterData.getAdapterVendorName();
            if (vendor != null && vendor.length() > 0) {
                result.put("resourceAdapterVendor", vendor);
            }
            if ((desc = adapterData.getAdapterShortDescription()) != null && desc.length() > 0) {
                result.put("resourceAdapterDescription", desc);
            }
            if ((spec = adapterData.getSpecVersion()) != null && spec.length() > 0) {
                result.put("connectorSpecVersion", spec);
            }
        }
        catch (NotSupportedException adapterData) {
            Object[] objectArray = new Object[5];
            objectArray[0] = cf;
            objectArray[1] = cfSvc;
            objectArray[2] = user;
            objectArray[3] = "<sensitive java.lang.String>";
            objectArray[4] = result;
            FFDCFilter.processException((Throwable)adapterData, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"241", (Object)this, (Object[])objectArray);
        }
        catch (UnsupportedOperationException adapterData) {
            Object[] objectArray = new Object[5];
            objectArray[0] = cf;
            objectArray[1] = cfSvc;
            objectArray[2] = user;
            objectArray[3] = "<sensitive java.lang.String>";
            objectArray[4] = result;
            FFDCFilter.processException((Throwable)adapterData, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"242", (Object)this, (Object[])objectArray);
        }
        ConnectionSpec conSpec = null;
        if (user != null || password != null) {
            String conSpecClassName;
            String conFactoryClassName = cf.getClass().getName();
            if (!conFactoryClassName.equals(conSpecClassName = conFactoryClassName.replace("ConnectionFactory", "ConnectionSpec"))) {
                conSpec = this.createConnectionSpec(cf, conSpecClassName, user, password);
            }
            if (conSpec == null) {
                throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKO1562_NO_CONSPEC", (Object[])new Object[0]));
            }
        }
        try {
            cfSvc.setValidating(true);
            con = conSpec == null ? cf.getConnection() : cf.getConnection(conSpec);
        }
        finally {
            cfSvc.setValidating(false);
        }
        try {
            try {
                ConnectionMetaData conData = con.getMetaData();
                try {
                    String prodName = conData.getEISProductName();
                    if (prodName != null && prodName.length() > 0) {
                        result.put("eisProductName", prodName);
                    }
                }
                catch (NotSupportedException prodName) {
                    Object[] objectArray = new Object[5];
                    objectArray[0] = cf;
                    objectArray[1] = cfSvc;
                    objectArray[2] = user;
                    objectArray[3] = "<sensitive java.lang.String>";
                    objectArray[4] = result;
                    FFDCFilter.processException((Throwable)prodName, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"273", (Object)this, (Object[])objectArray);
                }
                catch (UnsupportedOperationException prodName) {
                    Object[] objectArray = new Object[5];
                    objectArray[0] = cf;
                    objectArray[1] = cfSvc;
                    objectArray[2] = user;
                    objectArray[3] = "<sensitive java.lang.String>";
                    objectArray[4] = result;
                    FFDCFilter.processException((Throwable)prodName, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"274", (Object)this, (Object[])objectArray);
                }
                try {
                    String prodVersion = conData.getEISProductVersion();
                    if (prodVersion != null && prodVersion.length() > 0) {
                        result.put("eisProductVersion", prodVersion);
                    }
                }
                catch (NotSupportedException prodVersion) {
                    Object[] objectArray = new Object[5];
                    objectArray[0] = cf;
                    objectArray[1] = cfSvc;
                    objectArray[2] = user;
                    objectArray[3] = "<sensitive java.lang.String>";
                    objectArray[4] = result;
                    FFDCFilter.processException((Throwable)prodVersion, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"281", (Object)this, (Object[])objectArray);
                }
                catch (UnsupportedOperationException prodVersion) {
                    Object[] objectArray = new Object[5];
                    objectArray[0] = cf;
                    objectArray[1] = cfSvc;
                    objectArray[2] = user;
                    objectArray[3] = "<sensitive java.lang.String>";
                    objectArray[4] = result;
                    FFDCFilter.processException((Throwable)prodVersion, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"282", (Object)this, (Object[])objectArray);
                }
                String userName = conData.getUserName();
                if (userName != null && userName.length() > 0) {
                    result.put("user", userName);
                }
            }
            catch (NotSupportedException notSupportedException) {
                Object[] objectArray = new Object[5];
                objectArray[0] = cf;
                objectArray[1] = cfSvc;
                objectArray[2] = user;
                objectArray[3] = "<sensitive java.lang.String>";
                objectArray[4] = result;
                FFDCFilter.processException((Throwable)notSupportedException, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"288", (Object)this, (Object[])objectArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Object[] objectArray = new Object[5];
                objectArray[0] = cf;
                objectArray[1] = cfSvc;
                objectArray[2] = user;
                objectArray[3] = "<sensitive java.lang.String>";
                objectArray[4] = result;
                FFDCFilter.processException((Throwable)unsupportedOperationException, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"289", (Object)this, (Object[])objectArray);
            }
            try {
                con.createInteraction().close();
            }
            catch (NotSupportedException notSupportedException) {
                Object[] objectArray = new Object[5];
                objectArray[0] = cf;
                objectArray[1] = cfSvc;
                objectArray[2] = user;
                objectArray[3] = "<sensitive java.lang.String>";
                objectArray[4] = result;
                FFDCFilter.processException((Throwable)notSupportedException, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"294", (Object)this, (Object[])objectArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Object[] objectArray = new Object[5];
                objectArray[0] = cf;
                objectArray[1] = cfSvc;
                objectArray[2] = user;
                objectArray[3] = "<sensitive java.lang.String>";
                objectArray[4] = result;
                FFDCFilter.processException((Throwable)unsupportedOperationException, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"295", (Object)this, (Object[])objectArray);
            }
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDataSource(DataSource ds, String user, @Sensitive String password, LinkedHashMap<String, Object> result) throws SQLException {
        try (java.sql.Connection con = user == null ? ds.getConnection() : ds.getConnection(user, password);){
            DatabaseMetaData metadata = con.getMetaData();
            result.put("databaseProductName", metadata.getDatabaseProductName());
            result.put("databaseProductVersion", metadata.getDatabaseProductVersion());
            result.put("driverName", metadata.getDriverName());
            result.put("driverVersion", metadata.getDriverVersion());
            try {
                String catalog = con.getCatalog();
                if (catalog != null && catalog.length() > 0) {
                    result.put("catalog", catalog);
                }
            }
            catch (SQLFeatureNotSupportedException catalog) {
                Object[] objectArray = new Object[4];
                objectArray[0] = ds;
                objectArray[1] = user;
                objectArray[2] = "<sensitive java.lang.String>";
                objectArray[3] = result;
                FFDCFilter.processException((Throwable)catalog, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"326", (Object)this, (Object[])objectArray);
            }
            try {
                String schema = con.getSchema();
                if (schema != null && schema.length() > 0) {
                    result.put("schema", schema);
                }
            }
            catch (SQLFeatureNotSupportedException schema) {
                Object[] objectArray = new Object[4];
                objectArray[0] = ds;
                objectArray[1] = user;
                objectArray[2] = "<sensitive java.lang.String>";
                objectArray[3] = result;
                FFDCFilter.processException((Throwable)schema, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"333", (Object)this, (Object[])objectArray);
            }
            String userName = metadata.getUserName();
            if (userName != null && userName.length() > 0) {
                result.put("user", userName);
            }
            try {
                boolean isValid = con.isValid(120);
                if (!isValid) {
                    result.put("failure", "java.sql.Connection.isValid: false");
                }
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                Object[] objectArray = new Object[4];
                objectArray[0] = ds;
                objectArray[1] = user;
                objectArray[2] = "<sensitive java.lang.String>";
                objectArray[3] = result;
                FFDCFilter.processException((Throwable)sQLFeatureNotSupportedException, (String)"com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator", (String)"344", (Object)this, (Object[])objectArray);
            }
        }
    }
}

