/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.el;

import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.bval.el.MessageEvaluator;

public final class ELFacade
implements MessageEvaluator {
    private static final ExpressionFactory EXPRESSION_FACTORY;
    private static final ELResolver RESOLVER;

    @Override
    public String interpolate(String message, Map<String, Object> annotationParameters, Object validatedValue) {
        try {
            if (EXPRESSION_FACTORY != null) {
                BValELContext context = new BValELContext();
                VariableMapper variables = context.getVariableMapper();
                for (Map.Entry<String, Object> var : annotationParameters.entrySet()) {
                    variables.setVariable(var.getKey(), EXPRESSION_FACTORY.createValueExpression(var.getValue(), Object.class));
                }
                variables.setVariable("validatedValue", EXPRESSION_FACTORY.createValueExpression(validatedValue, Object.class));
                return EXPRESSION_FACTORY.createValueExpression((ELContext)context, message.replace("#{", "\\#{"), String.class).getValue((ELContext)context).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }

    private static ELResolver initResolver() {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new MapELResolver());
        resolver.add((ELResolver)new ListELResolver());
        resolver.add((ELResolver)new ArrayELResolver());
        resolver.add((ELResolver)new ResourceBundleELResolver());
        resolver.add((ELResolver)new BeanELResolver());
        return resolver;
    }

    static {
        ExpressionFactory ef;
        try {
            ef = ExpressionFactory.newInstance();
        }
        catch (Exception e) {
            ef = null;
        }
        EXPRESSION_FACTORY = ef;
        RESOLVER = ELFacade.initResolver();
    }

    public static class BValFormatter {
        private final Formatter formatter = new Formatter();

        public Formatter format(String format, Object ... args) {
            return this.formatter.format(format, args);
        }
    }

    private static class BValVariableMapper
    extends VariableMapper {
        private final Map<String, ValueExpression> variables = new HashMap<String, ValueExpression>();

        private BValVariableMapper() {
        }

        public ValueExpression resolveVariable(String variable) {
            if ("formatter".equals(variable)) {
                return EXPRESSION_FACTORY.createValueExpression((Object)new BValFormatter(), Object.class);
            }
            return this.variables.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            this.variables.put(variable, expression);
            return expression;
        }
    }

    private static class BValFunctionMapper
    extends FunctionMapper {
        private BValFunctionMapper() {
        }

        public Method resolveFunction(String prefix, String localName) {
            return null;
        }
    }

    private static class BValELContext
    extends ELContext {
        private final FunctionMapper functions;
        private final VariableMapper variables = new BValVariableMapper();

        public BValELContext() {
            this.functions = new BValFunctionMapper();
        }

        public ELResolver getELResolver() {
            return RESOLVER;
        }

        public FunctionMapper getFunctionMapper() {
            return this.functions;
        }

        public VariableMapper getVariableMapper() {
            return this.variables;
        }
    }
}

