/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.config;

import java.io.PrintWriter;

public class Timing {
    public static final String[] ALL_CONTEXT_INFO = new String[]{"*"};
    private final long requestThreshold;
    private final String type;
    private final String[] contextInfo;
    private final boolean[] contextInfoAsterisk;
    private final String contextInfoString;
    private final boolean interruptHungRequest;
    private final String timingPid;
    private static final int HISTORICAL_REQUEST_LIMIT = 5;
    private transient long requestCount = 0L;
    private transient String[] historicalRequestData = new String[5];

    public Timing(String type, long requestThreshold) {
        this(type, null, requestThreshold, false);
    }

    public Timing(String type, String[] contextInfo, long requestThreshold, boolean interruptHungRequest) {
        this(null, type, contextInfo, requestThreshold, interruptHungRequest);
    }

    public Timing(String timingPid, String type, String[] contextInfo, long requestThreshold, boolean interruptHungRequest) {
        this.timingPid = timingPid;
        this.type = type;
        this.requestThreshold = requestThreshold;
        this.interruptHungRequest = interruptHungRequest;
        if (contextInfo == null) {
            this.contextInfo = null;
            this.contextInfoAsterisk = null;
            this.contextInfoString = null;
        } else {
            this.contextInfo = new String[contextInfo.length];
            System.arraycopy(contextInfo, 0, this.contextInfo, 0, contextInfo.length);
            StringBuilder sb = new StringBuilder();
            this.contextInfoAsterisk = new boolean[this.contextInfo.length];
            for (int x = 0; x < this.contextInfoAsterisk.length; ++x) {
                if (x != 0) {
                    sb.append(" | ");
                }
                sb.append(this.contextInfo[x]);
                this.contextInfoAsterisk[x] = this.contextInfo[x].equals("*");
            }
            this.contextInfoString = sb.toString();
        }
    }

    public String getTimingPid() {
        return this.timingPid;
    }

    public long getRequestThreshold() {
        return this.requestThreshold;
    }

    public String getType() {
        return this.type;
    }

    public int getContextInfoMatchScore(String[] contextInfo) {
        if (this.contextInfo == null) {
            return Integer.MIN_VALUE;
        }
        int curMultiplier = 1;
        int multFactor = 10;
        int curScore = 0;
        for (int x = 0; x < this.contextInfo.length; ++x) {
            if (!this.contextInfoAsterisk[x]) {
                if (this.contextInfo[x].equals(contextInfo[x])) {
                    curScore += curMultiplier * this.contextInfo[x].length();
                } else {
                    return Integer.MIN_VALUE;
                }
            }
            curMultiplier *= multFactor;
        }
        return curScore;
    }

    public boolean isDefaultTiming() {
        if (this.contextInfoAsterisk == null || this.contextInfoAsterisk.length == 0) {
            return false;
        }
        for (boolean b : this.contextInfoAsterisk) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public String getContextInfoString() {
        return this.contextInfoString;
    }

    public boolean interruptHungRequest() {
        return this.interruptHungRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCount(String requestContextInfo) {
        String[] stringArray = this.historicalRequestData;
        synchronized (this.historicalRequestData) {
            this.historicalRequestData[(int)(this.requestCount % 5L)] = requestContextInfo;
            ++this.requestCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIntrospectionData(PrintWriter pw) {
        String[] stringArray = this.historicalRequestData;
        synchronized (this.historicalRequestData) {
            pw.println(" Context info pattern: " + this.contextInfoString + "  Request count: " + this.requestCount);
            if (this.requestCount > 0L) {
                for (int x = 0; x < 5; ++x) {
                    if (this.historicalRequestData[x] == null) continue;
                    pw.println("   Sample context info:" + this.historicalRequestData[x]);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Timing) {
            Timing that = (Timing)o;
            return this.requestThreshold == that.requestThreshold && this.objectEquals(this.type, that.type) && this.objectEquals(this.contextInfo, that.contextInfo);
        }
        return false;
    }

    private boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

