/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.io.async.IAsyncProvider;
import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.channelfw.CFEndPointCriteria;
import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChainGroupData;
import com.ibm.websphere.channelfw.ChainStartMode;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.websphere.channelfw.ChannelUtils;
import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.CFEndPointImpl;
import com.ibm.ws.channelfw.internal.ChainDataImpl;
import com.ibm.ws.channelfw.internal.ChainGroupDataImpl;
import com.ibm.ws.channelfw.internal.ChannelContainer;
import com.ibm.ws.channelfw.internal.ChannelDataImpl;
import com.ibm.ws.channelfw.internal.ChannelFactoryDataImpl;
import com.ibm.ws.channelfw.internal.ChildChannelDataImpl;
import com.ibm.ws.channelfw.internal.InboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channelfw.internal.OutboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channelfw.internal.RuntimeState;
import com.ibm.ws.channelfw.internal.chains.Chain;
import com.ibm.ws.channelfw.internal.chains.EndPointMgrImpl;
import com.ibm.ws.channelfw.internal.chains.InboundChain;
import com.ibm.ws.channelfw.internal.chains.OutboundChain;
import com.ibm.ws.channelfw.internal.chains.StopChainTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.wsspi.channelfw.BoundRegion;
import com.ibm.wsspi.channelfw.ChainEventListener;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.CrossRegionSharable;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChainGroupException;
import com.ibm.wsspi.channelfw.exception.ChainTimerException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.channelfw.exception.ChannelFrameworkException;
import com.ibm.wsspi.channelfw.exception.IncoherentChainException;
import com.ibm.wsspi.channelfw.exception.InvalidChainNameException;
import com.ibm.wsspi.channelfw.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.channelfw.exception.InvalidChannelNameException;
import com.ibm.wsspi.channelfw.exception.InvalidRuntimeStateException;
import com.ibm.wsspi.channelfw.exception.InvalidWeightException;
import com.ibm.wsspi.channelfw.exception.RetryableChannelException;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ChannelFrameworkImpl
implements ChannelFramework,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private static final String nl = System.getProperty("line.separator");
    private final Map<String, ChannelData> channelDataMap;
    private final Map<String, ChannelContainer> channelRunningMap;
    private final Map<String, ChainDataImpl> chainDataMap;
    private final Map<String, Chain> chainRunningMap;
    private final Map<Class<?>, ChannelFactoryDataImpl> channelFactories;
    protected Map<String, OutboundVirtualConnectionFactoryImpl> outboundVCFactories;
    private final VirtualConnectionFactory inboundVCFactory;
    private final Map<String, ChainGroupData> chainGroups;
    private final List<ChainEventListener> globalChainEventListeners;
    private final Timer stopTimer;
    public static final int DEFAULT_DISC_WEIGHT = 10;
    private Map<Class<?>, Object> services = null;
    public static final String PROPERTY_CHAIN_START_RETRY_INTERVAL = "chainStartRetryInterval";
    public static final String PROPERTY_CHAIN_START_RETRY_ATTEMPTS = "chainStartRetryAttempts";
    public static final String PROPERTY_CHAIN_QUIESCETIMEOUT = "chainQuiesceTimeout";
    public static final String PROPERTY_MISSING_CONFIG_WARNING = "warningWaitTime";
    public static final String PROPERTY_CONFIG_ALIAS = "channelfw";
    protected long chainStartRetryInterval = 5000L;
    protected int chainStartRetryAttempts = 60;
    private long missingConfigWarning = 10000L;
    private long chainQuiesceTimeout = 0L;
    private final Map<String, Integer> ChannelZRegions = new HashMap<String, Integer>();
    private Map<String, Class<? extends ChannelFactory>> factories = null;
    private Map<String, ChannelFactoryProvider> providers = null;
    private List<ChannelFactoryProvider> activatedProviders = null;
    private final AtomicLong chainNameCounter = new AtomicLong(0L);
    private final AtomicLong channelNameCounter = new AtomicLong(0L);
    private IAsyncProvider.AsyncIOHelper asyncIOHelper = null;
    private static volatile ChannelFrameworkImpl singleton = null;

    public ChannelFrameworkImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object[])new Object[0]);
        }
        this.channelDataMap = new HashMap<String, ChannelData>();
        this.channelRunningMap = new HashMap<String, ChannelContainer>();
        this.chainDataMap = new ConcurrentHashMap<String, ChainDataImpl>();
        this.chainRunningMap = new HashMap<String, Chain>();
        this.channelFactories = new HashMap();
        this.outboundVCFactories = new HashMap<String, OutboundVirtualConnectionFactoryImpl>();
        this.inboundVCFactory = new InboundVirtualConnectionFactoryImpl();
        this.chainGroups = new HashMap<String, ChainGroupData>();
        this.services = new HashMap();
        this.globalChainEventListeners = new ArrayList<ChainEventListener>();
        this.stopTimer = new Timer(true);
        this.factories = new HashMap<String, Class<? extends ChannelFactory>>();
        this.providers = new HashMap<String, ChannelFactoryProvider>();
        this.activatedProviders = new LinkedList<ChannelFactoryProvider>();
        singleton = this;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelFrameworkImpl getRef() {
        if (null != singleton) return singleton;
        Class<ChannelFrameworkImpl> clazz = ChannelFrameworkImpl.class;
        synchronized (ChannelFrameworkImpl.class) {
            if (null != singleton) return singleton;
            new ChannelFrameworkImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void setChainStartRetryInterval(Object value) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Setting chain start retry interval [" + value + "]"), (Object[])new Object[0]);
            }
            try {
                long num = MetatypeUtils.parseLong((Object)PROPERTY_CONFIG_ALIAS, (String)PROPERTY_CHAIN_START_RETRY_INTERVAL, (Object)value, (long)this.chainStartRetryInterval);
                if (0L <= num) {
                    this.chainStartRetryInterval = num;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Value is too low", (Object[])new Object[0]);
                }
            }
            catch (NumberFormatException nfe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                Tr.event((TraceComponent)tc, (String)"Value is not a number", (Object[])new Object[0]);
            }
        }
    }

    public void setChainStartRetryAttempts(Object value) throws NumberFormatException {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Setting chain start retry attempts [" + value + "]"), (Object[])new Object[0]);
            }
            try {
                int num = MetatypeUtils.parseInteger((Object)PROPERTY_CONFIG_ALIAS, (String)PROPERTY_CHAIN_START_RETRY_ATTEMPTS, (Object)value, (int)this.chainStartRetryAttempts);
                if (-1 <= num) {
                    this.chainStartRetryAttempts = num;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Value too low", (Object[])new Object[0]);
                }
            }
            catch (NumberFormatException nfe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                Tr.event((TraceComponent)tc, (String)"Vaue is not a number", (Object[])new Object[0]);
            }
        }
    }

    public void setDefaultChainQuiesceTimeout(Object value) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Setting default chain quiesce timeout [" + value + "]"), (Object[])new Object[0]);
            }
            try {
                long num = MetatypeUtils.parseLong((Object)PROPERTY_CONFIG_ALIAS, (String)PROPERTY_CHAIN_QUIESCETIMEOUT, (Object)value, (long)this.chainQuiesceTimeout);
                if (0L < num) {
                    this.chainQuiesceTimeout = num;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Timeout is too low", (Object[])new Object[0]);
                }
            }
            catch (NumberFormatException nfe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                Tr.event((TraceComponent)tc, (String)"Timeout is not a number", (Object[])new Object[0]);
            }
        }
    }

    public void setMissingConfigWarning(Object value) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Setting missing config warning delay to [" + value + "]"), (Object[])new Object[0]);
            }
            try {
                long num = MetatypeUtils.parseLong((Object)PROPERTY_CONFIG_ALIAS, (String)PROPERTY_MISSING_CONFIG_WARNING, (Object)value, (long)this.missingConfigWarning);
                if (0L <= num) {
                    this.missingConfigWarning = num;
                }
            }
            catch (NumberFormatException nfe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Value is not a number", (Object[])new Object[0]);
            }
        }
    }

    public void updateConfig(Map<String, Object> config) {
        Object value = config.get(PROPERTY_CHAIN_START_RETRY_ATTEMPTS);
        if (null != value) {
            this.setChainStartRetryAttempts(value);
        }
        if (null != (value = config.get(PROPERTY_CHAIN_START_RETRY_INTERVAL))) {
            this.setChainStartRetryInterval(value);
        }
        if (null != (value = config.get(PROPERTY_CHAIN_QUIESCETIMEOUT))) {
            this.setDefaultChainQuiesceTimeout(value);
        }
        if (null != (value = config.get(PROPERTY_MISSING_CONFIG_WARNING))) {
            this.setMissingConfigWarning(value);
        }
    }

    @Override
    public synchronized void destroy() throws ChannelException, ChainException, ChainGroupException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        this.stopTimer.cancel();
        this.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public synchronized void clear() throws ChannelException, ChainException, ChainGroupException {
        Class[] factoryList;
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clear", (Object[])new Object[0]);
        }
        StringBuilder sbErrors = new StringBuilder();
        Chain[] chains = this.chainRunningMap.values().toArray(new Chain[this.chainRunningMap.size()]);
        for (int i2 = 0; i2 < chains.length; ++i2) {
            Chain chain = chains[i2];
            if (chain.getState() == RuntimeState.STARTED || chain.getState() == RuntimeState.QUIESCED) {
                try {
                    this.stopChainInternal(chain, 0L);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".clear"), (String)"322", (Object)this, (Object[])new Object[]{chain, this});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Caught stopChainInternal exception " + e.getMessage()), (Object[])new Object[0]);
                    }
                    sbErrors.append(e.toString());
                }
            }
            try {
                this.destroyChainInternal(chain);
            }
            catch (ChannelException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught destroyChainInternal exception " + e.getMessage()), (Object[])new Object[0]);
                }
                sbErrors.append(e.toString());
            }
            catch (ChainException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught destroyChainInternal exception " + e.getMessage()), (Object[])new Object[0]);
                }
                sbErrors.append(e.toString());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".clear"), (String)"329", (Object)this, (Object[])new Object[]{chain, this});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught destroyChainInternal exception " + e.getMessage()), (Object[])new Object[0]);
                }
                sbErrors.append(e.toString());
            }
            try {
                this.removeChain(chain.getName());
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".clear"), (String)"335", (Object)this, (Object[])new Object[]{chain, this});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught removeChain exception " + e.getMessage()), (Object[])new Object[0]);
                }
                sbErrors.append(e.toString());
            }
        }
        this.chainRunningMap.clear();
        this.channelRunningMap.clear();
        String[] keys = this.chainGroups.keySet().toArray(new String[this.chainGroups.size()]);
        for (i = 0; i < keys.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Remove chainGroup, " + keys[i]), (Object[])new Object[0]);
            }
            try {
                this.removeChainGroup(keys[i]);
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".clear"), (String)"351", (Object)this, (Object[])new Object[]{keys[i], this});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught removeChainGroup exception " + e.getMessage()), (Object[])new Object[0]);
                }
                sbErrors.append(e.toString());
            }
        }
        this.chainGroups.clear();
        keys = this.channelDataMap.keySet().toArray(new String[this.channelDataMap.size()]);
        for (i = 0; i < keys.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Remove channelData, " + keys[i]), (Object[])new Object[0]);
            }
            try {
                String name = keys[i];
                if (name == null) continue;
                this.removeChannel(name);
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".clear"), (String)"366", (Object)this, (Object[])new Object[]{keys[i], this});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught removeChannel exception " + e.getMessage()), (Object[])new Object[0]);
                }
                sbErrors.append(e.toString());
            }
        }
        this.channelDataMap.clear();
        this.chainDataMap.clear();
        for (Class target : factoryList = this.channelFactories.keySet().toArray(new Class[this.channelFactories.size()])) {
            ChannelFactory factory;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Remove channelFactory, " + target), (Object[])new Object[0]);
            }
            if ((factory = this.channelFactories.remove(target).getChannelFactory()) == null) continue;
            try {
                factory.destroy();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".clear"), (String)"384", (Object)this, (Object[])new Object[]{factory, this});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught factory.destroy exception " + e.getMessage()), (Object[])new Object[0]);
                }
                sbErrors.append(e.toString());
            }
        }
        this.channelFactories.clear();
        this.globalChainEventListeners.clear();
        this.services.clear();
        if (sbErrors.length() > 0) {
            throw new ChannelException(sbErrors.toString());
        }
        this.activatedProviders.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized VirtualConnectionFactory getOutboundVCFactory(String chainName) throws ChannelException, ChainException {
        OutboundVirtualConnectionFactoryImpl vc;
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getOutboundVCFactory: " + chainName), (Object[])new Object[0]);
            }
            if (null == chainName) {
                throw new InvalidChainNameException("Unable to get VCFactory for null chain name");
            }
            vc = this.outboundVCFactories.get(chainName);
            if (vc == null) {
                ChainData chainData = this.chainDataMap.get(chainName);
                if (null != chainData) {
                    vc = this.createVirtualConnectionFactory(chainData);
                    this.outboundVCFactories.put(chainName, vc);
                    break block9;
                } else {
                    if (-1 == chainName.indexOf("_CFINTERNAL_CHILD_")) {
                        InvalidChainNameException exp = new InvalidChainNameException("Chain configuration not found in framework, " + chainName);
                        throw exp;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getOutboundVCFactory");
                    }
                    return this.getNestedOutboundVCFactory(chainName);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found existing VCF, " + chainName), (Object[])new Object[0]);
            }
            vc.incrementRefCount();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutboundVCFactory");
        }
        return vc;
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized VirtualConnectionFactory getNestedOutboundVCFactory(String channelName) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNestedOutboundVCFactory", (Object[])new Object[0]);
        }
        OutboundVirtualConnectionFactoryImpl vc = null;
        ChainData[] chainDataArray = this.getInternalRunningChains(channelName);
        if (chainDataArray.length == 0) {
            InvalidChainNameException exp = new InvalidChainNameException("Chain or channel not found in framework, " + channelName);
            FFDCFilter.processException((Throwable)exp, (String)(this.getClass().getName() + ".getNestedOutboundVCFactory"), (String)"548", (Object)this, (Object[])new Object[]{channelName});
            throw exp;
        }
        ChainData chainData = chainDataArray[0];
        ChannelData[] existingChannelData = chainData.getChannelList();
        int channelIndex = 0;
        boolean foundChannel = false;
        for (channelIndex = 0; channelIndex < existingChannelData.length; ++channelIndex) {
            if (!channelName.startsWith(existingChannelData[channelIndex].getName() + "_CFINTERNAL_CHILD_")) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found named channel, " + channelName + " in chain " + chainData.getName() + " at index " + channelIndex), (Object[])new Object[0]);
            }
            foundChannel = true;
            break;
        }
        if (!foundChannel) {
            InvalidChainNameException exp = new InvalidChainNameException("Chain or channel not found in framework, " + channelName);
            FFDCFilter.processException((Throwable)exp, (String)(this.getClass().getName() + ".getNestedOutboundVCFactory"), (String)"543", (Object)this, (Object[])new Object[]{chainData});
            throw exp;
        }
        int length = existingChannelData.length - channelIndex - 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Length of chain to build: " + length), (Object[])new Object[0]);
        }
        ChannelData[] newChannelData = new ChannelData[length];
        String[] newChannelNames = new String[length];
        int newIndex = 0;
        for (int i = channelIndex + 1; i < existingChannelData.length; ++newIndex, ++i) {
            newChannelData[newIndex] = existingChannelData[i];
            newChannelNames[newIndex] = newChannelData[newIndex].getName();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Channel '" + newChannelData[newIndex].getName() + "' added to new nested chain, index=" + newIndex), (Object[])new Object[0]);
        }
        ChainDataImpl newChainData = new ChainDataImpl(channelName, FlowType.OUTBOUND, newChannelData, null);
        this.addChain(channelName, FlowType.OUTBOUND, newChannelNames);
        vc = this.createVirtualConnectionFactory(newChainData);
        this.outboundVCFactories.put(channelName, vc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNestedOutboundVCFactory");
        }
        return vc;
    }

    @Override
    public VirtualConnectionFactory getInboundVCFactory() {
        return this.inboundVCFactory;
    }

    @Override
    public synchronized ChannelFactoryData updateAllChannelFactoryProperties(Class<?> factoryType, Map<Object, Object> properties) throws ChannelFactoryException {
        ChannelFactoryDataImpl cfd = this.findOrCreateChannelFactoryData(factoryType);
        cfd.setProperties(properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateAllChannelFactoryProperties for factory " + factoryType + ", properties:\n" + ChannelFrameworkImpl.stringForMap(properties)), (Object[])new Object[0]);
        }
        return cfd;
    }

    public static String stringForMap(Map<Object, Object> map) {
        StringBuilder sbOutput = new StringBuilder();
        if (map == null) {
            sbOutput.append("\tNULL");
        } else {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                sbOutput.append('\t').append(entry).append('\n');
            }
        }
        return sbOutput.toString();
    }

    @Override
    public synchronized ChannelFactoryData updateChannelFactoryProperty(Class<?> factoryType, Object key, Object value) throws ChannelFactoryException {
        ChannelFactoryDataImpl cfd = this.findOrCreateChannelFactoryData(factoryType);
        cfd.setProperty(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateChannelFactoryProperty for factory " + factoryType + ", key=" + key + ", value=" + value), (Object[])new Object[0]);
        }
        return cfd;
    }

    @Override
    public synchronized ChannelFactoryData getChannelFactory(Class<?> type) throws ChannelFactoryException {
        return this.findOrCreateChannelFactoryData(type);
    }

    public synchronized ChannelFactoryDataImpl findOrCreateChannelFactoryData(Class<?> type) throws ChannelFactoryException {
        ChannelFactoryDataImpl cfd = this.channelFactories.get(type);
        if (cfd == null) {
            ChannelFactory cf = this.getChannelFactoryInternal(type, false);
            Class<?>[] deviceInf = null;
            Class<?> applicationInf = null;
            try {
                deviceInf = cf.getDeviceInterface();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                applicationInf = cf.getApplicationInterface();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cfd = new ChannelFactoryDataImpl(type, deviceInf, applicationInf);
            this.channelFactories.put(type, cfd);
        }
        return cfd;
    }

    public synchronized ChannelFactory getChannelFactoryInternal(Class<?> type, boolean isPersistent) throws ChannelFactoryException {
        if (type == null) {
            throw new InvalidChannelFactoryException("ChannelFactory type is null");
        }
        ChannelFactory factory = null;
        ChannelFactoryDataImpl cfd = null;
        try {
            cfd = this.channelFactories.get(type);
            if (cfd != null) {
                factory = cfd.getChannelFactory();
            }
            if (null == factory) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create channel factory; " + type), (Object[])new Object[0]);
                }
                factory = (ChannelFactory)type.newInstance();
                if (isPersistent) {
                    this.initChannelFactory(type, factory, null);
                }
            }
        }
        catch (Exception exp) {
            FFDCFilter.processException((Throwable)exp, (String)(this.getClass().getName() + ".getChannelFactoryInternal"), (String)"675", (Object)this, (Object[])new Object[]{cfd});
            throw new InvalidChannelFactoryException("Can't create instance of channel factory " + type.getName() + " " + exp.getMessage());
        }
        return factory;
    }

    protected synchronized void initChannelFactory(Class<?> type, ChannelFactory factory, Map<Object, Object> properties) throws ChannelFactoryException {
        ChannelFactoryDataImpl cfd = this.findOrCreateChannelFactoryData(type);
        cfd.setChannelFactory(factory);
        if (properties != null) {
            cfd.setProperties(properties);
        }
        try {
            factory.init(cfd);
        }
        catch (ChannelFactoryException ce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Factory " + factory + " threw ChannelFactoryException " + ce.getMessage()), (Object[])new Object[0]);
            }
            throw ce;
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChannelFactory"), (String)"770", (Object)this, (Object[])new Object[]{factory});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Factory " + factory + " threw non-ChannelFactoryException " + e.getMessage()), (Object[])new Object[0]);
            }
            throw new ChannelFactoryException(e);
        }
    }

    @Override
    public synchronized ChannelData addChannel(String channelName, Class<?> factoryType, Map<Object, Object> inputPropertyBag, int weight) throws ChannelException {
        return this.addChannelInternal(channelName, factoryType, inputPropertyBag, weight);
    }

    @Override
    public synchronized ChannelData addChannel(String channelName, Class<?> factoryType, Map<Object, Object> inputPropertyBag) throws ChannelException {
        return this.addChannelInternal(channelName, factoryType, inputPropertyBag, 10);
    }

    private ChannelData addChannelInternal(String channelName, Class<?> factoryType, Map<Object, Object> inputPropertyBag, int weight) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addChannelInternal: channelName=" + channelName + ", factoryType=" + factoryType + ", weight=" + weight), (Object[])new Object[0]);
        }
        if (weight < 0) {
            throw new InvalidWeightException("Invalid weight for channel, " + weight);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Input channel name is null");
        }
        ChannelData channelData = this.channelDataMap.get(channelName);
        if (null != channelData) {
            throw new InvalidChannelNameException("Channel already exists: " + channelName);
        }
        this.getChannelFactoryInternal(factoryType, false);
        Map<Object, Object> propertyBag = inputPropertyBag;
        if (null == propertyBag) {
            propertyBag = new HashMap<Object, Object>();
        }
        channelData = this.createChannelData(channelName, factoryType, propertyBag, weight);
        this.channelDataMap.put(channelName, channelData);
        return channelData;
    }

    @Override
    public synchronized ChannelData removeChannel(String channelName) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeChannel: " + channelName), (Object[])new Object[0]);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Input channel name is null");
        }
        ChannelDataImpl channelData = (ChannelDataImpl)this.channelDataMap.get(channelName);
        if (null == channelData) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("removeChannel: " + channelName), (Object)"Channel not found");
            }
            return null;
        }
        if (0 != channelData.getNumChildren()) {
            throw new ChannelException("Can't remove channel config " + channelName + " in runtime.  Destroy must happen first. ");
        }
        this.channelDataMap.remove(channelName);
        Object[] chainDataArray = this.chainDataMap.values().toArray();
        ChainDataImpl chainData = null;
        for (int i = 0; i < chainDataArray.length; ++i) {
            chainData = (ChainDataImpl)chainDataArray[i];
            if (!chainData.containsChannel(channelName)) continue;
            this.removeChain(chainData.getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeChannel");
        }
        return channelData;
    }

    @Override
    public synchronized ChannelData updateAllChannelProperties(String channelName, Map<Object, Object> newProperties) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateAllChannelProperties: " + channelName), (Object[])new Object[0]);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Input channel name is null");
        }
        if (null == newProperties) {
            throw new ChannelException("Null properties found.");
        }
        ChannelDataImpl channelData = (ChannelDataImpl)this.channelDataMap.get(channelName);
        if (null == channelData) {
            throw new InvalidChannelNameException("Unable to find input channel, " + channelName);
        }
        channelData.setPropertyBag(newProperties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New properties for channel " + channelName + ", properties:\n" + ChannelFrameworkImpl.stringForMap(newProperties)), (Object[])new Object[0]);
        }
        this.updateRunningChannels(channelData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateAllChannelProperties");
        }
        return channelData;
    }

    @Override
    public synchronized ChannelData updateChannelProperty(String channelName, Object propertyKey, Object propertyValue) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateChannelProperty", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("channelName=" + channelName + "propertyKey=" + propertyKey + ", propertyValue=" + propertyValue), (Object[])new Object[0]);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Input channel name is null");
        }
        if (null == propertyKey || null == propertyValue) {
            throw new ChannelException("Null property key or value found.");
        }
        ChannelDataImpl channelData = (ChannelDataImpl)this.channelDataMap.get(channelName);
        if (null == channelData) {
            throw new InvalidChannelNameException("Unable to find input channel, " + channelName);
        }
        channelData.setProperty(propertyKey, propertyValue);
        this.updateRunningChannels(channelData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateChannelProperty");
        }
        return channelData;
    }

    @Override
    public synchronized ChannelData updateChannelWeight(String channelName, int newWeight) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateChannelWeight", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("channelName=" + channelName + ", newWeight=" + newWeight), (Object[])new Object[0]);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Input channel name is null");
        }
        if (newWeight < 0) {
            throw new InvalidWeightException("Invalid input weight, " + newWeight);
        }
        ChannelDataImpl channelData = (ChannelDataImpl)this.channelDataMap.get(channelName);
        if (null == channelData) {
            throw new InvalidChannelNameException("Unable to find input channel, " + channelName);
        }
        channelData.setDiscriminatorWeight(newWeight);
        this.updateRunningChannels(channelData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateChannelWeight");
        }
        return channelData;
    }

    private void updateRunningChannels(ChannelDataImpl channelData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRunningChannels", (Object[])new Object[0]);
        }
        Channel channel = null;
        ChannelContainer channelContainer = null;
        Iterator<ChildChannelDataImpl> children = channelData.children();
        while (children.hasNext()) {
            channelContainer = this.channelRunningMap.get(children.next().getName());
            channel = channelContainer.getChannel();
            channel.update(channelContainer.getChannelData());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRunningChannels");
        }
    }

    @Override
    public synchronized ChannelData getChannel(String channelName) {
        ChannelData channel = null;
        if (null != channelName) {
            channel = this.channelDataMap.get(channelName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getChannel: " + channelName + " found=" + (null != channel)), (Object[])new Object[0]);
        }
        return channel;
    }

    @Override
    public synchronized ChannelData[] getAllChannels() {
        return this.channelDataMap.values().toArray(new ChannelData[this.channelDataMap.size()]);
    }

    @Override
    public synchronized ChannelData[] getRunningChannels() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunningChannels", (Object[])new Object[0]);
        }
        ArrayList<ChannelDataImpl> list = new ArrayList<ChannelDataImpl>();
        for (ChannelContainer channel : this.channelRunningMap.values()) {
            list.add(channel.getChannelData().getParent());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunningChannels");
        }
        return list.toArray(new ChannelData[list.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getListeningPort(String chainName) throws ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getListeningPort: " + chainName), (Object[])new Object[0]);
        }
        int listeningPort = -1;
        Chain chain = this.chainRunningMap.get(chainName);
        if (null == chain) {
            throw new ChainException("Chain " + chainName + " not found in runtime.");
        }
        ChainData chainData = chain.getChainData();
        if (!chainData.getType().equals(FlowType.INBOUND)) throw new ChainException("Chain " + chainName + " is not inbound.");
        ChannelData channelData = chainData.getChannelList()[0];
        Map<Object, Object> channelProperties = channelData.getPropertyBag();
        if (channelProperties == null) throw new ChainException("Chain " + chainName + " has no properties.");
        String portString = (String)channelProperties.get("port");
        if (portString != null && !portString.trim().equals("0")) {
            listeningPort = Integer.parseInt(portString);
        } else {
            portString = (String)channelProperties.get("listeningPort");
            if (portString == null) throw new ChainException("Chain " + chainName + " has no port in the device channel properties.");
            listeningPort = Integer.parseInt(portString);
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return listeningPort;
        Tr.exit((TraceComponent)tc, (String)("getListeningPort: " + listeningPort));
        return listeningPort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getListeningHost(String chainName) throws ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getListeningHost: " + chainName), (Object[])new Object[0]);
        }
        String listeningHost = null;
        Chain chain = this.chainRunningMap.get(chainName);
        if (chain == null) throw new ChainException("Chain " + chainName + " not found in runtime.");
        ChainData chainData = chain.getChainData();
        if (!chainData.getType().equals(FlowType.INBOUND)) throw new ChainException("Chain " + chainName + " is not inbound.");
        ChannelData channelData = chainData.getChannelList()[0];
        Map<Object, Object> channelProperties = channelData.getPropertyBag();
        if (channelProperties == null) throw new ChainException("Chain " + chainName + " has no properties.");
        listeningHost = (String)channelProperties.get("hostname");
        if (listeningHost == null) {
            throw new ChainException("Chain " + chainName + " has no host in the device channel properties.");
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return listeningHost;
        Tr.exit((TraceComponent)tc, (String)("getListeningHost: " + listeningHost));
        return listeningHost;
    }

    private boolean initChannelInChain(Channel channel, Chain chain) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initChannelInChain", (Object[])new Object[0]);
        }
        String channelName = channel.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("channelName=" + channelName + " chainName=" + chain.getName()), (Object[])new Object[0]);
        }
        boolean channelInitialized = false;
        ChannelContainer channelContainer = this.channelRunningMap.get(channelName);
        if (null == channelContainer) {
            int index;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Channel not found in runtime so build it", (Object[])new Object[0]);
            }
            ChannelData[] channelsData = chain.getChannelsData();
            for (index = 0; index < channelsData.length && !channelsData[index].getName().equals(channel.getName()); ++index) {
            }
            if (index == channelsData.length) {
                ChannelException e = new ChannelException("Channel providing incorrect name; " + channel.getName());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Channel provided the wrong name, probably the external name instead of the internal one; " + channel.getName()), (Object[])new Object[0]);
                }
                throw e;
            }
            try {
                channel.init();
            }
            catch (ChannelException ce) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw ChannelException " + ce.getMessage()), (Object[])new Object[0]);
                }
                throw ce;
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChannelInChain"), (String)"1168", (Object)this, (Object[])new Object[]{channel});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw non-ChannelException " + e.getMessage()), (Object[])new Object[0]);
                }
                throw new ChannelException(e);
            }
            channelInitialized = true;
            channelContainer = new ChannelContainer(channel, (ChildChannelDataImpl)channelsData[index]);
            this.channelRunningMap.put(channelName, channelContainer);
        }
        channelContainer.addChainReference(chain);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initChannelInChain");
        }
        return channelInitialized;
    }

    private boolean startChannelInChain(Channel targetChannel, Chain chain) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startChannelInChain", (Object[])new Object[0]);
        }
        String channelName = targetChannel.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("channelName=" + channelName + " chainName=" + chain.getName()), (Object[])new Object[0]);
        }
        boolean channelStarted = false;
        ChannelContainer channelContainer = this.channelRunningMap.get(channelName);
        RuntimeState channelState = channelContainer.getState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found channel, state: " + channelState.ordinal), (Object[])new Object[0]);
        }
        Channel channel = channelContainer.getChannel();
        if (RuntimeState.INITIALIZED == channelState || RuntimeState.QUIESCED == channelState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Starting channel", (Object[])new Object[0]);
            }
            try {
                channel.start();
            }
            catch (ChannelException ce) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw ChannelException " + ce.getMessage()), (Object[])new Object[0]);
                }
                throw ce;
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".startChannelInChain"), (String)"1228", (Object)this, (Object[])new Object[]{channel});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw non-ChannelException " + e.getMessage()), (Object[])new Object[0]);
                }
                throw new ChannelException(e);
            }
            channelStarted = true;
            channelContainer.setState(RuntimeState.STARTED);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Skip channel start, invalid former state: " + channelState.ordinal), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startChannelInChain");
        }
        return channelStarted;
    }

    private boolean disableChannelInChain(Channel targetChannel, Chain chain) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"disableChannelInChain", (Object[])new Object[0]);
        }
        String channelName = targetChannel.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("channelName=" + channelName + " chainName=" + chain.getName()), (Object[])new Object[0]);
        }
        ChannelContainer channelContainer = this.channelRunningMap.get(channelName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found channel, state: " + channelContainer.getState().ordinal), (Object[])new Object[0]);
        }
        Channel channel = channelContainer.getChannel();
        RuntimeState chainState = null;
        boolean stillInUse = false;
        for (Chain channelChain : channelContainer.getChainMap().values()) {
            chainState = channelChain.getState();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found chain reference: " + channelChain.getName() + ", state: " + chainState.ordinal), (Object[])new Object[0]);
            }
            if (channelChain.getName().equals(chain.getName()) || RuntimeState.STARTED != chainState && RuntimeState.QUIESCED != chainState) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found chain that is not ready to stop, " + channelChain.getName()), (Object[])new Object[0]);
            }
            stillInUse = true;
            break;
        }
        if (!stillInUse) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Disabling channel, " + channelName), (Object[])new Object[0]);
            }
            ((InboundChain)chain).disableChannel(channel);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Skip channel stop, in use by other chain(s)", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"disableChannelInChain");
        }
        return !stillInUse;
    }

    private void stopChannel(Channel channel) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopChannel", (Object[])new Object[0]);
        }
        String channelName = channel.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("channelName=" + channelName), (Object[])new Object[0]);
        }
        ChannelContainer channelContainer = this.channelRunningMap.get(channelName);
        try {
            channel.stop(0L);
        }
        catch (ChannelException ce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw ChannelException " + ce.getMessage()), (Object[])new Object[0]);
            }
            throw ce;
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".stopChannel"), (String)"1338", (Object)this, (Object[])new Object[]{channel});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw non-ChannelException " + e.getMessage()), (Object[])new Object[0]);
            }
            throw new ChannelException(e);
        }
        channelContainer.setState(RuntimeState.INITIALIZED);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopChannel");
        }
    }

    private synchronized void destroyChannelInChain(Channel targetChannel, Chain chain, ChannelData channelData) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroyChannelInChain", (Object[])new Object[0]);
        }
        String channelName = targetChannel.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("channelName=" + channelName + " chainName=" + chain.getName()), (Object[])new Object[0]);
        }
        ChannelContainer channelContainer = this.channelRunningMap.get(channelName);
        Channel channel = channelContainer.getChannel();
        Map<String, Chain> chainMap = channelContainer.getChainMap();
        RuntimeState channelState = channelContainer.getState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Remove chain reference for channel, " + channelName), (Object[])new Object[0]);
        }
        channelContainer.removeChainReference(chain.getName());
        int numChains = chainMap.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Remaining chain refs, " + numChains), (Object[])new Object[0]);
        }
        if (numChains == 0) {
            if (RuntimeState.INITIALIZED != channelState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Skip channel destroy, not in correct state, state=" + channelState.ordinal), (Object[])new Object[0]);
                }
            } else {
                if (chain.getChainData().getType().equals(FlowType.INBOUND)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Disabling channel, " + channel.getName()), (Object[])new Object[0]);
                    }
                    ((InboundChain)chain).disableChannel(channel);
                }
                try {
                    channel.destroy();
                }
                catch (ChannelException ce) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw ChannelException " + ce.getMessage()), (Object[])new Object[0]);
                    }
                    throw ce;
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".destroyChannelInChain"), (String)"1408", (Object)this, (Object[])new Object[]{channel});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Channel " + channel + " threw non-ChannelException " + e.getMessage()), (Object[])new Object[0]);
                    }
                    throw new ChannelException(e);
                }
                this.channelRunningMap.remove(channelName);
                ChildChannelDataImpl child = (ChildChannelDataImpl)channelData;
                child.getParent().removeChild(child);
                ChainData[] rChains = this.getRunningChains(channelData.getFactoryType());
                if (rChains == null || rChains.length == 0 || rChains[0] == null || rChains.length == 1 && rChains[0].getName().equals(chain.getChainData().getName())) {
                    ChannelFactoryDataImpl cfd = this.channelFactories.remove(channelData.getFactoryType());
                    ChannelFactory factory = cfd.getChannelFactory();
                    cfd.setChannelFactory(null);
                    if (factory != null) {
                        try {
                            factory.destroy();
                        }
                        catch (Throwable e) {
                            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".destroyChannelInChain"), (String)"1450", (Object)this, (Object[])new Object[]{factory});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Factory " + factory + " threw non-ChannelFactoryException " + e.getMessage()), (Object[])new Object[0]);
                            }
                        }
                    }
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Skip channel destroy, in use by other chain(s)", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyChannelInChain");
        }
    }

    protected boolean currentlyOnZ() {
        return false;
    }

    protected int currentZRegion() {
        return 16;
    }

    @Override
    public synchronized ChainData addChain(String chainName, FlowType chainType, String[] channelNameList) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addChain: " + chainName), (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Input chain name is null");
        }
        if (null == channelNameList || 0 == channelNameList.length) {
            throw new InvalidChannelNameException("Invalid channel list");
        }
        ChainDataImpl chainData = this.chainDataMap.get(chainName);
        if (null != chainData) {
            InvalidChainNameException e = new InvalidChainNameException("Chain config already exists, " + chainName);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addChain"), (String)"1411", (Object)this, (Object[])new Object[]{chainData});
            throw e;
        }
        int zRegion = 16;
        boolean okToAdd = true;
        ChannelFactory factory = null;
        if (this.currentlyOnZ()) {
            zRegion = this.currentZRegion();
        }
        ChannelData[] channelDataArray = new ChannelData[channelNameList.length];
        ChannelData channelData = null;
        int i = 0;
        int lastIndex = channelNameList.length - 1;
        for (i = 0; i <= lastIndex; ++i) {
            factory = null;
            channelData = this.channelDataMap.get(channelNameList[i]);
            if (null == channelData) {
                InvalidChannelNameException e = new InvalidChannelNameException("Can't add chain config due to unknown channel, " + channelNameList[i]);
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addChain"), (String)"1443", (Object)this, (Object[])new Object[]{channelNameList[i]});
                throw e;
            }
            if (zRegion != 16 && chainType.equals(FlowType.INBOUND)) {
                if (i == lastIndex) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("On Z, looking at Application Channel, " + channelData.getName()), (Object[])new Object[0]);
                    }
                    factory = this.getChannelFactoryInternal(channelData.getFactoryType(), false);
                    if (zRegion == 8) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Operating in Servant Region", (Object[])new Object[0]);
                        }
                        if (factory instanceof BoundRegion && !((BoundRegion)((Object)factory)).isServantStartable(this.channelDataMap)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Channel says it is not startable in Servant Region", (Object[])new Object[0]);
                            }
                            okToAdd = false;
                        }
                    } else if (zRegion == 2 || zRegion == 4) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Operating in CR or CRA Region, Region constant: " + zRegion), (Object[])new Object[0]);
                        }
                        if (factory instanceof BoundRegion && zRegion != ((BoundRegion)((Object)factory)).getRegion(this.channelDataMap)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("This Channel says it is not startable in this Region: getRegion returned: " + ((BoundRegion)((Object)factory)).getRegion(this.channelDataMap)), (Object[])new Object[0]);
                            }
                            okToAdd = false;
                        }
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("On Z, looking at non-application Channel, " + channelData.getName()), (Object[])new Object[0]);
                    }
                    if (zRegion == 2 || zRegion == 4) {
                        Integer channelEntry;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Operating in CR or CRA Region, Region constant: " + zRegion), (Object[])new Object[0]);
                        }
                        if ((channelEntry = this.ChannelZRegions.get(channelData.getName())) == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"First time setting region entry for this channel", (Object[])new Object[0]);
                            }
                            this.ChannelZRegions.put(channelData.getName(), zRegion);
                        } else {
                            int entryValue = channelEntry;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Not first time setting region entry for this channel, current region entry is: " + entryValue), (Object[])new Object[0]);
                            }
                            if ((entryValue & zRegion) == 0) {
                                factory = this.getChannelFactoryInternal(channelData.getFactoryType(), false);
                                if (factory instanceof CrossRegionSharable && !((CrossRegionSharable)((Object)factory)).isSharable(this.channelDataMap)) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Channel says it is not sharable", (Object[])new Object[0]);
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"channel.shared.warning", (Object[])new Object[]{channelData.getName()});
                                }
                                this.ChannelZRegions.put(channelData.getName(), entryValue | zRegion);
                            }
                        }
                    }
                }
            }
            channelDataArray[i] = channelData;
        }
        if (okToAdd) {
            try {
                HashMap<Object, Object> chainProperties = null;
                if (FlowType.INBOUND.equals(chainType)) {
                    chainProperties = new HashMap<Object, Object>();
                    Map<Object, Object> tcpProperties = channelDataArray[0].getPropertyBag();
                    chainProperties.put("hostname", tcpProperties.get("hostname"));
                    chainProperties.put("port", tcpProperties.get("port"));
                    chainProperties.put("listeningPort", tcpProperties.get("listeningPort"));
                }
                chainData = (ChainDataImpl)this.createChainData(chainName, chainType, channelDataArray, chainProperties);
                this.chainDataMap.put(chainName, chainData);
                for (int j = 0; j < this.globalChainEventListeners.size(); ++j) {
                    chainData.addChainEventListener(this.globalChainEventListeners.get(j));
                }
            }
            catch (IncoherentChainException e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addChain"), (String)"1601", (Object)this, (Object[])new Object[]{chainName, chainType, channelDataArray});
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addChain");
        }
        return chainData;
    }

    @Override
    public synchronized ChainData removeChain(ChainData chain) throws ChainException {
        String chainName = null != chain ? chain.getName() : null;
        String entryMsg = "removeChain: " + chainName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)entryMsg, (Object[])new Object[0]);
        }
        if (null == chain) {
            throw new InvalidChainNameException("Input chain is null");
        }
        if (!this.chainDataMap.containsKey(chainName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)entryMsg, (Object)"Chain not found");
            }
            return null;
        }
        this.removeChainInternal(chain);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)entryMsg);
        }
        return chain;
    }

    @Override
    public synchronized ChainData removeChain(String chainName) throws ChainException {
        String entryMsg = "removeChain: " + chainName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)entryMsg, (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Input chain name is null");
        }
        Chain chain = this.chainRunningMap.get(chainName);
        if (chain != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)entryMsg, (Object)"Chain not found");
            }
            return null;
        }
        ChainData chainData = this.chainDataMap.get(chainName);
        if (null == chainData) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)entryMsg, (Object)"ChainData not found");
            }
            return null;
        }
        this.removeChainInternal(chainData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)entryMsg);
        }
        return chainData;
    }

    private synchronized void removeChainInternal(ChainData chaindata) {
        String chainName = chaindata.getName();
        ChainData[] chains = null;
        for (String groupName : this.chainGroups.keySet()) {
            int k;
            int j;
            chains = this.chainGroups.get(groupName).getChains();
            for (j = 0; j < chains.length; ++j) {
                if (!chainName.equals(chains[j].getName())) continue;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Removing chain from chain group, " + groupName), (Object[])new Object[0]);
                break;
            }
            if (j >= chains.length) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updating chain group with new chain config list, " + groupName), (Object[])new Object[0]);
            }
            ChainData[] newChains = new ChainData[chains.length - 1];
            for (k = 0; k < j; ++k) {
                newChains[k] = chains[k];
            }
            ++j;
            while (j < chains.length) {
                newChains[k] = chains[j];
                ++k;
                ++j;
            }
            this.chainGroups.put(groupName, this.createChainGroupData(groupName, newChains));
        }
        this.chainDataMap.remove(chainName);
    }

    @Override
    public synchronized ChainData updateChain(String chainName, String[] newChannelList) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateChain: " + chainName), (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Null chain name");
        }
        if (null == newChannelList || 0 == newChannelList.length) {
            throw new InvalidChannelNameException("Null or empty channel list");
        }
        ChainDataImpl oldChainData = this.chainDataMap.get(chainName);
        if (null == oldChainData) {
            InvalidChainNameException e = new InvalidChainNameException("Unable to update unknown chain, " + chainName);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".updateChain"), (String)"1724", (Object)this, (Object[])new Object[]{chainName});
            throw e;
        }
        Chain chain = this.chainRunningMap.get(chainName);
        if (chain != null) {
            ChainException e = new ChainException("Unable to update runtime chain " + chainName + ".  Destroy chain first.");
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".updateChain"), (String)"1733", (Object)this, (Object[])new Object[]{chain});
            throw e;
        }
        ChannelData[] newChannelData = new ChannelData[newChannelList.length];
        for (int i = 0; i < newChannelList.length; ++i) {
            newChannelData[i] = this.channelDataMap.get(newChannelList[i]);
            if (null != newChannelData[i]) continue;
            InvalidChannelNameException e = new InvalidChannelNameException("Unable to update chain config with unknown channel, " + newChannelList[i]);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".updateChain"), (String)"1752", (Object)this, (Object[])new Object[]{newChannelList[i]});
            throw e;
        }
        ChannelData[] oldChannelDataArray = oldChainData.getChannelList();
        boolean configurationDifferent = true;
        if (oldChannelDataArray.length == newChannelData.length) {
            String oldChannelName = null;
            Object var9_13 = null;
            boolean foundOldChannel = false;
            configurationDifferent = false;
            for (int j = 0; j < oldChannelDataArray.length; ++j) {
                oldChannelName = oldChannelDataArray[j].getName();
                foundOldChannel = false;
                for (int k = 0; k < newChannelData.length; ++k) {
                    String string = newChannelData[k].getName();
                    if (!oldChannelName.equals(string)) continue;
                    foundOldChannel = true;
                    break;
                }
                if (foundOldChannel) continue;
                configurationDifferent = true;
                break;
            }
        }
        if (!configurationDifferent) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Identical channel list, no update", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateChain");
            }
            return oldChainData;
        }
        ChainDataImpl newChainData = null;
        try {
            newChainData = (ChainDataImpl)this.createChainData(chainName, FlowType.INBOUND, newChannelData, oldChainData.getPropertyBag());
        }
        catch (IncoherentChainException incoherentChainException) {
            FFDCFilter.processException((Throwable)incoherentChainException, (String)(this.getClass().getName() + ".updateChain"), (String)"1792", (Object)this, (Object[])new Object[]{chainName, newChannelData});
            throw incoherentChainException;
        }
        newChainData.setChainEventListeners(oldChainData.removeAllChainEventListeners());
        this.chainDataMap.put(chainName, newChainData);
        Object var9_17 = null;
        for (ChainGroupDataImpl chainGroupDataImpl : this.chainGroups.values()) {
            if (!chainGroupDataImpl.containsChain(chainName)) continue;
            chainGroupDataImpl.updateChain(newChainData);
        }
        newChainData.chainUpdated();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateChain");
        }
        return newChainData;
    }

    @Override
    public synchronized ChainData getChain(String chainName) {
        ChainData chainData = null;
        if (null != chainName) {
            chainData = this.chainDataMap.get(chainName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getChain: " + chainName + " found=" + (null != chainData)), (Object[])new Object[0]);
        }
        return chainData;
    }

    @Override
    public synchronized ChainData[] getAllChains() {
        return this.chainDataMap.values().toArray(new ChainData[this.chainDataMap.size()]);
    }

    @Override
    public synchronized ChainData[] getAllChains(String channelName) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAllChains: " + channelName), (Object[])new Object[0]);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Null channelName found");
        }
        ChainDataImpl chainData2 = null;
        ArrayList<ChainDataImpl> chainDataList = new ArrayList<ChainDataImpl>();
        for (ChainDataImpl chainData2 : this.chainDataMap.values()) {
            if (!chainData2.containsChannel(channelName)) continue;
            chainDataList.add(chainData2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAllChains");
        }
        return chainDataList.toArray(new ChainData[chainDataList.size()]);
    }

    @Override
    public synchronized ChainData[] getAllChains(Class<?> factoryClass) throws InvalidChannelFactoryException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllChains(factory)", (Object[])new Object[0]);
        }
        if (null == factoryClass) {
            throw new InvalidChannelFactoryException("Null factory class found");
        }
        String inputFactoryClassName = factoryClass.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("factory=" + inputFactoryClassName), (Object[])new Object[0]);
        }
        ArrayList<ChainData> chainDataList = new ArrayList<ChainData>();
        ChannelData[] channels = null;
        for (ChainData chainData : this.chainDataMap.values()) {
            channels = chainData.getChannelList();
            for (int i = 0; i < channels.length; ++i) {
                if (!channels[i].getFactoryType().getName().equals(inputFactoryClassName)) continue;
                chainDataList.add(chainData);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAllChains");
        }
        return chainDataList.toArray(new ChainData[chainDataList.size()]);
    }

    @Override
    public synchronized ChainData[] getRunningChains() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunningChains", (Object[])new Object[0]);
        }
        ChainData[] chainDataArray = new ChainData[this.chainRunningMap.size()];
        ChainDataImpl chainData = null;
        int index = 0;
        Iterator<Chain> chainIter = this.chainRunningMap.values().iterator();
        while (chainIter.hasNext()) {
            chainData = (ChainDataImpl)chainIter.next().getChainData();
            chainDataArray[index++] = chainData.getExternalChainData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunningChains");
        }
        return chainDataArray;
    }

    @Override
    public synchronized ChainData[] getRunningChains(String channelName) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRunningChains: " + channelName), (Object[])new Object[0]);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Null channelName found");
        }
        ChannelDataImpl parent = (ChannelDataImpl)this.channelDataMap.get(channelName);
        if (parent == null) {
            throw new InvalidChannelNameException("Channel not found in config, " + channelName);
        }
        ChainDataImpl chainData = null;
        ArrayList<ChainDataImpl> chainDataList = new ArrayList<ChainDataImpl>();
        ChannelContainer channelContainer = null;
        Iterator<Chain> chainIter = null;
        Iterator<ChildChannelDataImpl> childIter = parent.children();
        while (childIter.hasNext()) {
            channelContainer = this.channelRunningMap.get(childIter.next().getName());
            chainIter = channelContainer.getChainMap().values().iterator();
            while (chainIter.hasNext()) {
                chainData = (ChainDataImpl)chainIter.next().getChainData();
                chainDataList.add(chainData.getExternalChainData());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunningChains");
        }
        return chainDataList.toArray(new ChainData[chainDataList.size()]);
    }

    @Override
    public ChainData[] getInternalRunningChains(String channelName) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInternalRunningChains: " + channelName), (Object[])new Object[0]);
        }
        if (null == channelName) {
            throw new InvalidChannelNameException("Null channelName found");
        }
        ChainDataImpl chainData = null;
        ArrayList<ChainDataImpl> chainDataList = new ArrayList<ChainDataImpl>();
        ChannelContainer channelContainer = this.channelRunningMap.get(channelName);
        if (channelContainer == null) {
            throw new InvalidChannelNameException("Channel not found in runtime, " + channelName);
        }
        Iterator<Chain> chainIter = channelContainer.getChainMap().values().iterator();
        while (chainIter.hasNext()) {
            chainData = (ChainDataImpl)chainIter.next().getChainData();
            chainDataList.add(chainData.getExternalChainData());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInternalRunningChains");
        }
        return chainDataList.toArray(new ChainData[chainDataList.size()]);
    }

    @Override
    public synchronized ChainData[] getRunningChains(Class<?> factoryClass) throws InvalidChannelFactoryException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunningChains", (Object[])new Object[0]);
        }
        if (null == factoryClass) {
            throw new InvalidChannelFactoryException("Null factory class found");
        }
        String inputFactoryClassName = factoryClass.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("factory=" + inputFactoryClassName), (Object[])new Object[0]);
        }
        ChainDataImpl chainData = null;
        ArrayList<ChainDataImpl> chainDataList = new ArrayList<ChainDataImpl>();
        ChannelData[] channels = null;
        for (Chain chain : this.chainRunningMap.values()) {
            chainData = (ChainDataImpl)chain.getChainData();
            channels = chainData.getChannelList();
            for (int i = 0; i < channels.length; ++i) {
                if (!channels[i].getFactoryType().getName().equals(inputFactoryClassName)) continue;
                chainDataList.add(chainData.getExternalChainData());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunningChains");
        }
        return chainDataList.toArray(new ChainData[chainDataList.size()]);
    }

    @Override
    public synchronized void initChain(String chainName) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initChain: " + chainName), (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Null chain name");
        }
        ChainData chainData = this.chainDataMap.get(chainName);
        if (null == chainData) {
            InvalidChainNameException e = new InvalidChainNameException("Unable to init unknown chain, " + chainName);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChain"), (String)"2142", (Object)this, (Object[])new Object[]{chainName});
            throw e;
        }
        if (FlowType.OUTBOUND.equals(chainData.getType())) {
            throw new InvalidChainNameException("Outbound chain cannot use this interface.");
        }
        Chain chain = this.getRunningChain(chainName);
        if (null != chain) {
            InvalidRuntimeStateException e = new InvalidRuntimeStateException("Chain cannot be initialized, its already in the runtime.");
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChain"), (String)"2158", (Object)this, (Object[])new Object[]{chain});
            throw e;
        }
        this.initChainInternal(chainData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initChain");
        }
    }

    synchronized void initChainInternal(ChainData inputChainData) throws ChannelException, ChainException {
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initChainInternal", (Object[])new Object[0]);
        }
        String inputChainName = inputChainData.getName();
        Chain chain = null;
        ChainDataImpl newChainData = null;
        ChannelData[] inputChannelDataArray = inputChainData.getChannelList();
        ChannelData[] newChannelDataArray = new ChannelData[inputChannelDataArray.length];
        ChannelDataImpl parent = null;
        ChildChannelDataImpl child = null;
        boolean[] childrenNew = new boolean[inputChannelDataArray.length];
        for (i = 0; i < childrenNew.length; ++i) {
            childrenNew[i] = false;
        }
        try {
            if (FlowType.INBOUND.equals(inputChainData.getType())) {
                newChannelDataArray = this.generateChildDataArray(inputChannelDataArray, childrenNew);
                newChainData = new ChainDataImpl((ChainDataImpl)inputChainData, newChannelDataArray);
                try {
                    chain = new InboundChain(newChainData, this);
                }
                catch (ChannelException e) {
                    if (!e.suppressFFDC()) {
                        FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChainInternal"), (String)"2206", (Object)this, (Object[])new Object[]{newChainData});
                        Tr.error((TraceComponent)tc, (String)"chain.initialization.error", (Object[])new Object[]{inputChainData.getName(), e.toString()});
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"An exception occurred when initializing chain", (Object[])new Object[]{inputChainData.getName(), e.toString()});
                    }
                    this.cleanChildRefsInParent(newChannelDataArray, childrenNew);
                    throw e;
                }
                catch (IncoherentChainException e) {
                    this.cleanChildRefsInParent(newChannelDataArray, childrenNew);
                    throw e;
                }
            }
            for (i = 0; i < inputChannelDataArray.length; ++i) {
                parent = (ChannelDataImpl)this.channelDataMap.get(inputChannelDataArray[i].getName());
                newChannelDataArray[i] = parent.getOutboundChild();
                if (null == newChannelDataArray[i]) {
                    newChannelDataArray[i] = parent.createChild();
                    childrenNew[i] = true;
                    continue;
                }
                childrenNew[i] = false;
            }
            newChainData = new ChainDataImpl(inputChainName, inputChainData.getType(), newChannelDataArray, null);
            try {
                chain = new OutboundChain(newChainData, this);
            }
            catch (ChannelException e) {
                if (!e.suppressFFDC()) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChainInternal"), (String)"2241", (Object)this, (Object[])new Object[]{newChainData});
                    Tr.error((TraceComponent)tc, (String)"chain.initialization.error", (Object[])new Object[]{inputChainData.getName(), e.toString()});
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"An exception occurred when initializing chain", (Object[])new Object[]{inputChainData.getName(), e.toString()});
                }
                this.cleanChildRefsInParent(newChannelDataArray, childrenNew);
                throw e;
            }
            catch (IncoherentChainException e) {
                this.cleanChildRefsInParent(newChannelDataArray, childrenNew);
                throw e;
            }
            Channel[] chainChannels = chain.getChannels();
            ArrayList<Channel> chainsDone = new ArrayList<Channel>();
            Channel channelX = null;
            try {
                for (int i2 = 0; i2 < chainChannels.length; ++i2) {
                    channelX = chainChannels[i2];
                    this.initChannelInChain(channelX, chain);
                    chainsDone.add(channelX);
                    channelX = null;
                }
                chain.init();
            }
            catch (ChannelException e) {
                int i3;
                if (e instanceof RetryableChannelException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Caught RetryableChannelException indicating the port is busy", (Object[])new Object[0]);
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"chain.initialization.error", (Object[])new Object[]{chain.getName(), e.toString()});
                    if (!e.suppressFFDC()) {
                        FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChainInternal"), (String)"2266", (Object)this, (Object[])new Object[]{chainChannels, chainsDone, chain});
                    }
                }
                for (i3 = 0; i3 < newChannelDataArray.length; ++i3) {
                    if (!childrenNew[i3]) continue;
                    child = (ChildChannelDataImpl)newChannelDataArray[i3];
                    child.getParent().removeChild(child);
                }
                if (channelX != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("calling destory on channel outside of destroyChannelInChain: " + channelX), (Object[])new Object[0]);
                    }
                    channelX.destroy();
                }
                for (i3 = 0; i3 < chainsDone.size(); ++i3) {
                    try {
                        this.destroyChannelInChain((Channel)chainsDone.get(i3), chain, newChannelDataArray[i3]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
            this.chainRunningMap.put(inputChainName, chain);
        }
        catch (IncoherentChainException e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChainInternal"), (String)"2290", (Object)this, (Object[])new Object[]{inputChainData, chain});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception during chain init: " + e), (Object[])new Object[0]);
            }
            throw e;
        }
        catch (InvalidChannelNameException e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChainInternal"), (String)"2298", (Object)this, (Object[])new Object[]{inputChainData, chain});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception during chain init: " + e), (Object[])new Object[0]);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initChainInternal");
        }
    }

    private void cleanChildRefsInParent(ChannelData[] channelDataArray, boolean[] childrenNew) {
        ChildChannelDataImpl child = null;
        for (int i = 0; i < channelDataArray.length; ++i) {
            if (!childrenNew[i]) continue;
            child = (ChildChannelDataImpl)channelDataArray[i];
            child.getParent().removeChild(child);
        }
    }

    public ChannelData[] generateChildDataArray(ChannelData[] parentChannelData, boolean[] childrenCreated) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateChildDataArray", (Object[])new Object[0]);
        }
        ChannelData[] newChannelDataArray = new ChannelData[parentChannelData.length];
        ChannelDataImpl parent = null;
        ChildChannelDataImpl child = null;
        ChainDataImpl runningChainData = null;
        List<Object> chainDataList = new ArrayList();
        for (int i = 0; i < parentChannelData.length; ++i) {
            parent = (ChannelDataImpl)this.channelDataMap.get(parentChannelData[i].getName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Find or create a child for parent " + parent.getName()), (Object[])new Object[0]);
            }
            if (parent.getNumChildren() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Parent not in runtime", (Object[])new Object[0]);
                }
                newChannelDataArray[i] = parent.createChild();
                childrenCreated[i] = true;
                for (int j = i + 1; j < newChannelDataArray.length; ++j) {
                    parent = (ChannelDataImpl)this.channelDataMap.get(parentChannelData[j].getName());
                    newChannelDataArray[j] = parent.createChild();
                    childrenCreated[j] = true;
                }
            } else {
                if (i == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found connector channel", (Object[])new Object[0]);
                    }
                    chainDataList = this.getRunningChains(parent);
                    newChannelDataArray[i] = parent.getInboundChild();
                    if (newChannelDataArray[i] == null) {
                        newChannelDataArray[i] = parent.createChild();
                        childrenCreated[i] = true;
                        continue;
                    }
                    childrenCreated[i] = false;
                    continue;
                }
                boolean foundChild = false;
                String inputChannelName = parentChannelData[i].getName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found non connector channel, " + inputChannelName), (Object[])new Object[0]);
                }
                while (chainDataList.size() > 0) {
                    runningChainData = (ChainDataImpl)chainDataList.get(0);
                    if (runningChainData.getType().equals(FlowType.OUTBOUND)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Removing chain that is outbound, " + runningChainData.getName()), (Object[])new Object[0]);
                        }
                        chainDataList.remove(runningChainData);
                        continue;
                    }
                    if (i + 1 > runningChainData.getChannelList().length) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Removing chain that is too short, " + runningChainData.getName()), (Object[])new Object[0]);
                        }
                        chainDataList.remove(runningChainData);
                        continue;
                    }
                    child = (ChildChannelDataImpl)runningChainData.getChannelList()[i];
                    if (!inputChannelName.equals(child.getExternalName())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Removing divergent chain, " + runningChainData.getName()), (Object[])new Object[0]);
                        }
                        chainDataList.remove(runningChainData);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found reusable channel from chain, " + runningChainData.getName()), (Object[])new Object[0]);
                    }
                    newChannelDataArray[i] = child;
                    childrenCreated[i] = false;
                    foundChild = true;
                    break;
                }
                if (foundChild) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Channel not in runtime so create it, " + parent.getName()), (Object[])new Object[0]);
                }
                newChannelDataArray[i] = parent.createChild();
                childrenCreated[i] = true;
                for (int j = i + 1; j < newChannelDataArray.length; ++j) {
                    parent = (ChannelDataImpl)this.channelDataMap.get(parentChannelData[j].getName());
                    newChannelDataArray[j] = parent.createChild();
                    childrenCreated[j] = true;
                }
            }
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generateChildDataArray");
        }
        return newChannelDataArray;
    }

    @Override
    public synchronized void startChain(ChainData chain) throws ChannelException, ChainException {
        String chainName;
        String string = chainName = null != chain ? chain.getName() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startChain: " + chainName), (Object[])new Object[0]);
        }
        if (null == chain) {
            throw new InvalidChainNameException("Null chain");
        }
        if (FlowType.OUTBOUND.equals(chain.getType())) {
            throw new InvalidChainNameException("Outbound chain cannot use this interface.");
        }
        this.startChainInternal(chain);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startChain");
        }
    }

    @Override
    public synchronized void startChain(String chainName) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startChain: " + chainName), (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Null chain name");
        }
        ChainData chainData = this.chainDataMap.get(chainName);
        if (null == chainData) {
            InvalidChainNameException e = new InvalidChainNameException("Nonexistent chain configuration");
            throw e;
        }
        if (FlowType.OUTBOUND.equals(chainData.getType())) {
            throw new InvalidChainNameException("Outbound chain cannot use this interface.");
        }
        this.startChainInternal(chainData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startChain");
        }
    }

    synchronized void startChainInternal(ChainData chainData) throws ChannelException, ChainException {
        this.startChainInternal(chainData, ChainStartMode.FAIL_EACH_SILENT);
    }

    public synchronized void startChainInternal(ChainData targetChainData, ChainStartMode startMode) throws ChannelException, ChainException {
        Chain chain;
        block31: {
            ChainData chainData;
            String chainName = targetChainData.getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("startChainInternal: " + chainName), (Object[])new Object[0]);
            }
            if (!targetChainData.isEnabled()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Chain " + chainName + " is disabled"), (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"startChainInternal");
                }
                return;
            }
            chain = this.getRunningChain(chainName);
            if (null == chain) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Chain not found running.  Double check it is configured.", (Object[])new Object[0]);
                }
                if (null == (chainData = (ChainData)this.chainDataMap.get(chainName))) {
                    throw new InvalidChainNameException("Unable to start unknown chain, " + chainName);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Chain exists, but not in runtime yet.  Initialize it.", (Object[])new Object[0]);
                }
                this.initChainInternal(chainData);
                chain = this.getRunningChain(chainName);
                if (null == chain) {
                    InvalidChainNameException e = new InvalidChainNameException("Unable to start unknown chain, " + chainName);
                    throw e;
                }
            }
            chainData = chain.getChainData();
            ArrayList<Channel> chainsDone = new ArrayList<Channel>();
            try {
                RuntimeState chainState = chain.getState();
                if (RuntimeState.INITIALIZED.equals(chainState)) {
                    if (chainData.getType().equals(FlowType.INBOUND)) {
                        ((InboundChain)chain).setupDiscProcess();
                        Channel[] chainChannels = chain.getChannels();
                        ChannelData[] channelData = chain.getChannelsData();
                        for (int i = chainChannels.length - 1; i >= 0; --i) {
                            if (this.startChannelInChain(chainChannels[i], chain)) {
                                chainsDone.add(chainChannels[i]);
                                if (i == 0) continue;
                                ((InboundChain)chain).startDiscProcessBetweenChannels((InboundChannel)chainChannels[i], (InboundChannel)chainChannels[i - 1], channelData[i].getDiscriminatorWeight());
                                continue;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Channel was already started; " + chainChannels[i].getName()), (Object[])new Object[0]);
                            }
                            break block31;
                        }
                        break block31;
                    }
                    Channel[] chainChannels = chain.getChannels();
                    for (int i = 0; i < chainChannels.length; ++i) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Start channel in chain: " + chainChannels[i].getName()), (Object[])new Object[0]);
                        }
                        if (!this.startChannelInChain(chainChannels[i], chain)) continue;
                        chainsDone.add(chainChannels[i]);
                    }
                    break block31;
                }
                if (!RuntimeState.STARTED.equals(chainState)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Cannot start chain " + chainData.getName() + ", state: " + chainState.ordinal), (Object[])new Object[0]);
                    }
                    InvalidRuntimeStateException e = new InvalidRuntimeStateException("Cannot start chain " + chainData.getName());
                    throw e;
                }
            }
            catch (ChannelException e) {
                if (!(e instanceof RetryableChannelException) || startMode != ChainStartMode.RETRY_EACH_ON_FAIL) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".startChainInternal"), (String)"2577", (Object)this, (Object[])new Object[]{chainData});
                    ((ChainDataImpl)chainData).chainStartFailed(1, 0);
                    Tr.error((TraceComponent)tc, (String)"chain.start.error", (Object[])new Object[]{chain.getName(), e.toString()});
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught RetryableException", (Object[])new Object[0]);
                }
                for (int i = 0; i < chainsDone.size(); ++i) {
                    try {
                        this.stopChannel((Channel)chainsDone.get(i));
                        continue;
                    }
                    catch (Exception e1) {
                        FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".startChainInternal"), (String)"2589", (Object)this, (Object[])new Object[]{chainsDone.get(i)});
                    }
                }
                throw e;
            }
            catch (ChainException e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".startChainInternal"), (String)"2595", (Object)this, (Object[])new Object[]{chainData});
                Tr.error((TraceComponent)tc, (String)"chain.start.error", (Object[])new Object[]{chain.getName(), e.toString()});
                for (int i = 0; i < chainsDone.size(); ++i) {
                    try {
                        this.stopChannel((Channel)chainsDone.get(i));
                        continue;
                    }
                    catch (Exception e1) {
                        FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".startChainInternal"), (String)"2602", (Object)this, (Object[])new Object[]{chainsDone.get(i)});
                    }
                }
                throw e;
            }
        }
        chain.start();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startChainInternal");
        }
    }

    @Override
    public synchronized void stopChain(ChainData chaindata, long millisec) throws ChannelException, ChainException {
        String chainName;
        String string = chainName = null != chaindata ? chaindata.getName() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopChain: " + chainName + " time=" + millisec), (Object[])new Object[0]);
        }
        if (null == chaindata) {
            throw new InvalidChainNameException("Null chain");
        }
        if (millisec < 0L) {
            throw new ChainTimerException("Invalid time length give to stopChain, " + millisec);
        }
        Chain chain = this.getRunningChain(chainName);
        if (null == chain) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("stopChain " + chainName), (Object)"chain is not running");
            }
            return;
        }
        if (FlowType.OUTBOUND.equals(chaindata.getType())) {
            throw new InvalidChainNameException("Outbound chain cannot use this interface.");
        }
        this.stopChainInternal(chain, millisec);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("stopChain " + chainName));
        }
    }

    @Override
    public synchronized void stopChain(String chainName, long millisec) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopChain: " + chainName + " time=" + millisec), (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Null chain name");
        }
        if (millisec < 0L) {
            throw new ChainTimerException("Invalid time length give to stopChain, " + millisec);
        }
        Chain chain = this.getRunningChain(chainName);
        if (null == chain) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("stopChain " + chainName), (Object)"chain is not running");
            }
            return;
        }
        if (FlowType.OUTBOUND.equals(chain.getChainData().getType())) {
            throw new InvalidChainNameException("Outbound chain cannot use this interface.");
        }
        this.stopChainInternal(chain, millisec);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopChain");
        }
    }

    synchronized void stopChainInternal(Chain chain, long millisec) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopChainInternal: " + chain.getName() + ", time=" + millisec), (Object[])new Object[0]);
        }
        RuntimeState chainState = chain.getState();
        Channel[] chainChannels = chain.getChannels();
        if (RuntimeState.STARTED == chainState || RuntimeState.QUIESCED == chainState) {
            if (millisec > 0L) {
                if (RuntimeState.QUIESCED == chainState) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("stopChain " + chain.getName()), (Object)"chain already quiesced");
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Quiescing chain: " + chain.getName()), (Object[])new Object[0]);
                }
                int i = 0;
                try {
                    for (i = 0; i < chainChannels.length; ++i) {
                        if (this.getNumStartedChainsUsingChannel(chainChannels[i].getName()) != 1) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Quiescing channel: " + chainChannels[i].getName()), (Object[])new Object[0]);
                        }
                        chainChannels[i].stop(millisec);
                        this.setChannelState(chainChannels[i].getName(), RuntimeState.QUIESCED);
                    }
                    StopChainTask task = new StopChainTask(chain.getName(), this);
                    chain.setStopTask(task);
                    chain.quiesce();
                    this.stopTimer.schedule((TimerTask)task, millisec);
                }
                catch (ChannelException e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".stopChainInternal"), (String)"2711", (Object)this, (Object[])new Object[]{chain, this});
                    Tr.error((TraceComponent)tc, (String)"chain.stop.error", (Object[])new Object[]{chain.getName(), e.toString()});
                    for (int j = 0; j < i; ++j) {
                        chainChannels[j].start();
                        this.setChannelState(chainChannels[j].getName(), RuntimeState.STARTED);
                    }
                    throw e;
                }
            } else {
                int i;
                StopChainTask task;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Stopping chain: " + chain.getName()), (Object[])new Object[0]);
                }
                if (RuntimeState.QUIESCED == chainState && (task = chain.getStopTask()) != null) {
                    task.cancel();
                    chain.setStopTask(null);
                }
                ArrayList<Channel> channelsToStop = new ArrayList<Channel>(chainChannels.length);
                for (i = 0; i < chainChannels.length; ++i) {
                    if (this.getNumStartedChainsUsingChannel(chainChannels[i].getName()) > 1) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Placing channel in list to stop: " + chainChannels[i].getName()), (Object[])new Object[0]);
                    }
                    if (chain.getChainData().getType().equals(FlowType.OUTBOUND)) {
                        channelsToStop.add(chainChannels[i]);
                        continue;
                    }
                    if (!this.disableChannelInChain(chainChannels[i], chain)) continue;
                    channelsToStop.add(chainChannels[i]);
                }
                i = 0;
                try {
                    for (i = channelsToStop.size() - 1; i >= 0; --i) {
                        this.stopChannel((Channel)channelsToStop.get(i));
                    }
                    chain.stop();
                }
                catch (ChannelException e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".stopChainInternal"), (String)"2763", (Object)this, (Object[])new Object[]{chain, this});
                    Tr.error((TraceComponent)tc, (String)"chain.stop.error", (Object[])new Object[]{chain.getName(), e.toString()});
                    if (FlowType.INBOUND.equals(chain.getChainData().getType())) {
                        ((InboundChain)chain).setupDiscProcess();
                    }
                    for (int j = 0; j < i; ++j) {
                        this.startChannelInChain((Channel)channelsToStop.get(j), chain);
                    }
                    throw e;
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("stopChainInternal " + chain.getName()), (Object[])new Object[]{"chain is not running"});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopChainInternal");
        }
    }

    @Override
    public synchronized void destroyChain(ChainData chaindata) throws ChannelException, ChainException {
        String chainName;
        String string = chainName = null != chaindata ? chaindata.getName() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyChain: " + chainName), (Object[])new Object[0]);
        }
        if (null == chaindata) {
            throw new InvalidChainNameException("Null chain");
        }
        if (FlowType.OUTBOUND.equals(chaindata.getType())) {
            throw new InvalidChainNameException("Outbound chain cannot use this interface.");
        }
        Chain chain = this.getRunningChain(chainName);
        if (null == chain) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroyChain: " + chainName + " does not exist -- may already have been destroyed"), (Object[])new Object[0]);
            }
            return;
        }
        this.destroyChainInternal(chain);
    }

    @Override
    public synchronized void destroyChain(String chainName) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyChain: " + chainName), (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Null chain name");
        }
        Chain chain = this.getRunningChain(chainName);
        if (null == chain) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroyChain: " + chainName + " does not exist -- may already have been destroyed"), (Object[])new Object[0]);
            }
            return;
        }
        if (FlowType.OUTBOUND.equals(chain.getChainData().getType())) {
            throw new InvalidChainNameException("Outbound chain cannot use this interface.");
        }
        this.destroyChainInternal(chain);
    }

    public synchronized void destroyChainInternal(Chain chain) throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyChainInternal: " + chain.getName()), (Object[])new Object[0]);
        }
        if (RuntimeState.INITIALIZED.equals(chain.getState())) {
            Channel[] chainChannels = chain.getChannels();
            ChannelData[] channelData = chain.getChannelsData();
            for (int i = 0; i < chainChannels.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Destroy channel in chain: " + chainChannels[i].getName()), (Object[])new Object[0]);
                }
                try {
                    this.destroyChannelInChain(chainChannels[i], chain, channelData[i]);
                    continue;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".destroyChainInternal"), (String)"2865", (Object)this, (Object[])new Object[]{chain, channelData[i]});
                    Tr.error((TraceComponent)tc, (String)"chain.destroy.error", (Object[])new Object[]{chain.getName(), e.toString()});
                }
            }
            chain.destroy();
            this.chainRunningMap.remove(chain.getName());
            if (FlowType.OUTBOUND.equals(chain.getChainData().getType())) {
                this.outboundVCFactories.remove(chain.getName());
            }
        } else {
            InvalidRuntimeStateException e = new InvalidRuntimeStateException("Unable to destroy chain: " + chain.getName() + ", state: " + chain.getState().ordinal);
            throw e;
        }
    }

    @Override
    public synchronized void addChainEventListener(ChainEventListener cel, String chainName) throws InvalidChainNameException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addChainEventListener: chain=" + chainName + " listener=" + cel), (Object[])new Object[0]);
        }
        ChainDataImpl chainData = null;
        if (null == chainName) {
            InvalidChainNameException e = new InvalidChainNameException("Unable to register a listener for a chain with null name");
            throw e;
        }
        if (chainName.equals("all_chains")) {
            for (ChainData chainData2 : this.chainDataMap.values()) {
                ((ChainDataImpl)chainData2).addChainEventListener(cel);
            }
            this.globalChainEventListeners.add(cel);
        } else {
            chainData = this.chainDataMap.get(chainName);
            if (null == chainData) {
                InvalidChainNameException e = new InvalidChainNameException("Unable to register listener for unknown chain config, " + chainName);
                throw e;
            }
            chainData.addChainEventListener(cel);
        }
    }

    @Override
    public synchronized void removeChainEventListener(ChainEventListener cel, String chainName) throws InvalidChainNameException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeChainEventListener: chainName=" + chainName + " listener=" + cel), (Object[])new Object[0]);
        }
        ChainDataImpl chainData = null;
        if (null == chainName) {
            InvalidChainNameException e = new InvalidChainNameException("Unregister listener for null chain name");
            throw e;
        }
        if (chainName.equals("all_chains")) {
            for (ChainData chainData2 : this.chainDataMap.values()) {
                ((ChainDataImpl)chainData2).removeChainEventListener(cel);
            }
            this.globalChainEventListeners.remove(cel);
        } else {
            chainData = this.chainDataMap.get(chainName);
            if (null == chainData) {
                InvalidChainNameException e = new InvalidChainNameException("Unable to unregister listener for unknown chain config, " + chainName);
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeChainEventListener"), (String)"2948", (Object)this, (Object[])new Object[]{chainName, this});
                throw e;
            }
            if (this.globalChainEventListeners.contains(cel)) {
                InvalidChainNameException e = new InvalidChainNameException("Can't remove a global listener from individual chains, " + chainName);
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeChainEventListener"), (String)"2953", (Object)this, (Object[])new Object[]{chainName, this});
                throw e;
            }
            chainData.removeChainEventListener(cel);
        }
    }

    @Override
    public synchronized void addGroupEventListener(ChainEventListener cel, String groupName) throws ChainGroupException {
        ChainGroupDataImpl groupData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addGroupEventListener", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("groupName=" + groupName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Listener=" + cel), (Object[])new Object[0]);
        }
        if (null == (groupData = (ChainGroupDataImpl)this.chainGroups.get(groupName))) {
            ChainGroupException e = new ChainGroupException("Unable to register listener for unknown group, " + groupName);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".registerGroupEventListener"), (String)"2982", (Object)this, (Object[])new Object[]{groupName});
            throw e;
        }
        groupData.addChainEventListener(cel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addGroupEventListener");
        }
    }

    @Override
    public synchronized void removeGroupEventListener(ChainEventListener cel, String groupName) throws ChainGroupException {
        ChainGroupDataImpl groupData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeGroupEventListener", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("groupName=" + groupName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Listener=" + cel), (Object[])new Object[0]);
        }
        if (null == (groupData = (ChainGroupDataImpl)this.chainGroups.get(groupName))) {
            ChainGroupException e = new ChainGroupException("Unable to unregister listener for unknown group, " + groupName);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeGroupEventListener"), (String)"3011", (Object)this, (Object[])new Object[]{groupName});
            throw e;
        }
        groupData.removeChainEventListener(cel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeGroupEventListener");
        }
    }

    @Override
    public synchronized ChainGroupData addChainGroup(String groupName, String[] chainNames) throws InvalidChainNameException, ChainGroupException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addChainGroup: " + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Null group name");
        }
        if (null == chainNames || 0 == chainNames.length) {
            throw new InvalidChainNameException("Null or empty chain name list");
        }
        ChainData[] chainDataArray = new ChainData[chainNames.length];
        ChainData chainData = null;
        for (int i = 0; i < chainNames.length; ++i) {
            chainData = this.chainDataMap.get(chainNames[i]);
            if (null != chainData) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found chain for group, " + chainNames[i]), (Object[])new Object[0]);
                }
            } else {
                InvalidChainNameException e = new InvalidChainNameException("Missing chain config during add: " + chainNames[i]);
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addChainGroup"), (String)"3071", (Object)this, (Object[])new Object[]{chainNames[i]});
                throw e;
            }
            chainDataArray[i] = chainData;
        }
        ChainGroupData groupData = this.createChainGroupData(groupName, chainDataArray);
        this.chainGroups.put(groupName, groupData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addChainGroup");
        }
        return groupData;
    }

    @Override
    public synchronized ChainGroupData removeChainGroup(String groupName) throws ChainGroupException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing chain group, " + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Input group name is null");
        }
        ChainGroupData groupData = this.chainGroups.remove(groupName);
        if (null == groupData) {
            throw new ChainGroupException("Null group name");
        }
        return groupData;
    }

    @Override
    public synchronized ChainGroupData updateChainGroup(String groupName, String[] chainNames) throws ChainGroupException, InvalidChainNameException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updating chain group, " + groupName), (Object[])new Object[0]);
        }
        return this.addChainGroup(groupName, chainNames);
    }

    @Override
    public synchronized ChainGroupData getChainGroup(String groupName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getChainGroup: " + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            return null;
        }
        return this.chainGroups.get(groupName);
    }

    @Override
    public synchronized ChainGroupData addChainToGroup(String groupName, String chainName) throws ChainGroupException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addChainToGroup chainName=" + chainName + ", groupName=" + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Null chain group");
        }
        if (null == chainName) {
            throw new ChainException("Null chain name");
        }
        ChainData chain = this.chainDataMap.get(chainName);
        if (null == chain) {
            throw new ChainException("Unable to find chain: " + chainName);
        }
        ChainGroupDataImpl group = (ChainGroupDataImpl)this.chainGroups.get(groupName);
        if (null == group) {
            throw new ChainGroupException("Unable to find group: " + groupName);
        }
        group.addChain(chain);
        return group;
    }

    @Override
    public synchronized ChainGroupData removeChainFromGroup(String groupName, String chainName) throws ChainGroupException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeChainFromGroup chainName=" + chainName + ", groupName=" + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Null chain group");
        }
        if (null == chainName) {
            throw new ChainException("Null chain name");
        }
        ChainData chain = this.chainDataMap.get(chainName);
        if (null == chain) {
            throw new ChainException("Unable to find chain: " + chainName);
        }
        ChainGroupDataImpl group = (ChainGroupDataImpl)this.chainGroups.get(groupName);
        if (null == group) {
            throw new ChainGroupException("Unable to find group: " + groupName);
        }
        group.removeChain(chain);
        return group;
    }

    @Override
    public synchronized ChainGroupData[] getAllChainGroups() {
        return this.chainGroups.values().toArray(new ChainGroupData[this.chainGroups.size()]);
    }

    @Override
    public synchronized ChainGroupData[] getAllChainGroups(String chainName) throws ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllChainGroups chainName=" + chainName), (Object[])new Object[0]);
        }
        if (null == chainName) {
            throw new InvalidChainNameException("Null chain name");
        }
        ChainData chain = this.chainDataMap.get(chainName);
        if (null == chain) {
            throw new ChainException("Unable to find chain: " + chainName);
        }
        int index = 0;
        int numGroups = this.getNumGroupsUsingChain(chainName);
        ChainGroupData[] groupArray = new ChainGroupData[numGroups];
        for (ChainGroupData group : this.chainGroups.values()) {
            if (!group.containsChain(chainName)) continue;
            groupArray[index++] = group;
        }
        return groupArray;
    }

    @Override
    public synchronized ChainData[] initChainGroup(String groupName) throws ChannelException, ChainException, ChainGroupException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initChainGroup: " + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Null chain group");
        }
        ChainGroupData groupData = this.chainGroups.get(groupName);
        if (null == groupData) {
            throw new ChainGroupException("Unable to find group: " + groupName);
        }
        ArrayList<ChainData> changedChains = new ArrayList<ChainData>();
        ChainData[] chainDataArray = groupData.getChains();
        StringBuilder sbErrors = new StringBuilder();
        boolean errorOccurred = false;
        String chainName = null;
        Chain chain = null;
        for (int i = 0; i < chainDataArray.length; ++i) {
            chainName = chainDataArray[i].getName();
            if (chainDataArray[i].getType().equals(FlowType.OUTBOUND)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Chain " + chainName + " is outbound so no action being taken."), (Object[])new Object[0]);
                continue;
            }
            try {
                chain = this.getRunningChain(chainName);
                if (null == chain) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Initialize the chain, " + chainName), (Object[])new Object[0]);
                    }
                    this.initChainInternal(chainDataArray[i]);
                    changedChains.add(chainDataArray[i]);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Chain already in initialized state, " + chainName), (Object[])new Object[0]);
                continue;
            }
            catch (Exception e) {
                String errorString = "Error initializing chain " + chainName + " in group " + groupName + ", exception=" + e;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)errorString, (Object[])new Object[0]);
                }
                errorOccurred = true;
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".initChainGroup"), (String)"3327", (Object)this, (Object[])new Object[]{chainName, groupName});
                sbErrors.append("\r\n");
                sbErrors.append(errorString);
            }
        }
        if (errorOccurred) {
            throw new ChainGroupException(sbErrors.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initChainGroup");
        }
        return changedChains.toArray(new ChainData[changedChains.size()]);
    }

    @Override
    public synchronized ChainData[] startChainGroup(String groupName) throws ChannelException, ChainException, ChainGroupException {
        return this.startChainGroup(groupName, ChainStartMode.FAIL_EACH_SILENT);
    }

    public ChainData[] startChainGroup(String groupName, ChainStartMode startMode) throws ChannelException, ChainException, ChainGroupException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startChainGroup: name=" + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Null chain group");
        }
        ChainGroupData groupData = this.chainGroups.get(groupName);
        if (null == groupData) {
            throw new ChainGroupException("Unable to find group: " + groupName);
        }
        ChainData[] chainDataArray = groupData.getChains();
        ArrayList<ChainData> changedChains = new ArrayList<ChainData>();
        String chainName = null;
        Chain chain = null;
        RuntimeState chainState = null;
        StringBuilder sbErrors = new StringBuilder();
        boolean errorOccurred = false;
        for (int i = 0; i < chainDataArray.length; ++i) {
            chainName = chainDataArray[i].getName();
            if (chainDataArray[i].getType().equals(FlowType.OUTBOUND)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Skipping outbound chain " + chainName), (Object[])new Object[0]);
                continue;
            }
            if (!chainDataArray[i].isEnabled()) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Skipping disabled chain " + chainName), (Object[])new Object[0]);
                continue;
            }
            try {
                chain = this.getRunningChain(chainName);
                if (null == chain) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Chain not found so build it.", (Object[])new Object[0]);
                    }
                    this.initChainInternal(chainDataArray[i]);
                    chain = this.getRunningChain(chainName);
                    if (null == chain) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Error starting chain " + chainName + " in group " + groupName), (Object[])new Object[0]);
                        continue;
                    }
                }
                chainState = chain.getState();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Consider starting chain: " + chainName + ", state: " + chainState.ordinal), (Object[])new Object[0]);
                }
                if (!RuntimeState.INITIALIZED.equals(chainState) && !RuntimeState.QUIESCED.equals(chainState)) continue;
                this.startChainInternal(chainDataArray[i], startMode);
                changedChains.add(chainDataArray[i]);
                continue;
            }
            catch (Exception e) {
                if (e instanceof RetryableChannelException && startMode == ChainStartMode.RETRY_EACH_ON_FAIL) {
                    this.retryChainStart(chainDataArray[i], e);
                    continue;
                }
                String errorString = "Error starting chain " + chainName + " in group " + groupName + ", exception=" + e;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)errorString, (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".startChainGroup"), (String)"3436", (Object)this, (Object[])new Object[]{chainName, groupName});
                errorOccurred = true;
                sbErrors.append("\r\n");
                sbErrors.append(errorString);
            }
        }
        if (errorOccurred) {
            throw new ChainGroupException(sbErrors.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startChainGroup");
        }
        return changedChains.toArray(new ChainData[changedChains.size()]);
    }

    protected void retryChainStart(ChainData chainData, Exception e) {
        FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".retryChainStart"), (String)"3470", (Object)this, (Object[])new Object[]{chainData});
        Tr.error((TraceComponent)tc, (String)"chain.retrystart.error", (Object[])new Object[]{chainData.getName(), 1});
        ((ChainDataImpl)chainData).chainStartFailed(1, 0);
    }

    @Override
    public synchronized ChainData[] stopChainGroup(String groupName, long millisec) throws ChannelException, ChainException, ChainGroupException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopChainGroup: " + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Null chain group");
        }
        ChainGroupData groupData = this.chainGroups.get(groupName);
        if (null == groupData) {
            throw new ChainGroupException("Unable to find group: " + groupName);
        }
        if (millisec < 0L) {
            throw new ChainTimerException("Invalid time length give to stopChain, " + millisec);
        }
        ArrayList<ChainData> changedChains = new ArrayList<ChainData>();
        ChainData[] chainDataArray = groupData.getChains();
        Chain chain = null;
        String chainName = null;
        StringBuilder sbErrors = new StringBuilder();
        boolean errorOccurred = false;
        RuntimeState chainState = null;
        for (int i = 0; i < chainDataArray.length; ++i) {
            chainName = chainDataArray[i].getName();
            if (chainDataArray[i].getType().equals(FlowType.OUTBOUND)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Chain " + chainName + " is outbound so no action being taken."), (Object[])new Object[0]);
                continue;
            }
            try {
                chain = this.getRunningChain(chainName);
                if (null != chain) {
                    chainState = chain.getState();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Consider stopping chain: " + chainName + ", state: " + chainState.ordinal), (Object[])new Object[0]);
                    }
                    if (!RuntimeState.STARTED.equals(chainState) && !RuntimeState.QUIESCED.equals(chainState)) continue;
                    if (RuntimeState.QUIESCED.equals(chainState) && millisec > 0L) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Stop notification already given for chain: " + chainName), (Object[])new Object[0]);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Stop the chain, " + chainName), (Object[])new Object[0]);
                    }
                    this.stopChainInternal(chain, millisec);
                    changedChains.add(chainDataArray[i]);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Chain doesn't exist, " + chainName), (Object[])new Object[0]);
                continue;
            }
            catch (Exception e) {
                String errorString = "Error stopping chain " + chainName + " in group " + groupName + ", exception=" + e;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)errorString, (Object[])new Object[0]);
                }
                errorOccurred = true;
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".stopChainGroup"), (String)"3558", (Object)this, (Object[])new Object[]{chainName, groupName});
                sbErrors.append("\r\n");
                sbErrors.append(errorString);
            }
        }
        if (errorOccurred) {
            throw new ChainGroupException(sbErrors.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopChainGroup");
        }
        return changedChains.toArray(new ChainData[changedChains.size()]);
    }

    @Override
    public synchronized ChainData[] destroyChainGroup(String groupName) throws ChannelException, ChainException, ChainGroupException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("destroyChainGroup: " + groupName), (Object[])new Object[0]);
        }
        if (null == groupName) {
            throw new ChainGroupException("Null chain group");
        }
        ChainGroupData groupData = this.chainGroups.get(groupName);
        if (null == groupData) {
            throw new ChainGroupException("Unable to find group: " + groupName);
        }
        ArrayList<ChainData> changedChains = new ArrayList<ChainData>();
        ChainData[] chainDataArray = groupData.getChains();
        Chain chain = null;
        String chainName = null;
        StringBuilder sbErrors = new StringBuilder();
        boolean errorOccurred = false;
        RuntimeState chainState = null;
        for (int i = 0; i < chainDataArray.length; ++i) {
            chainName = chainDataArray[i].getName();
            if (chainDataArray[i].getType().equals(FlowType.OUTBOUND)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Chain " + chainName + " is outbound so no action being taken."), (Object[])new Object[0]);
                continue;
            }
            try {
                chain = this.getRunningChain(chainName);
                if (null != chain) {
                    chainState = chain.getState();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Consider destroying chain: " + chainName + ", state: " + chainState.ordinal), (Object[])new Object[0]);
                    }
                    if (RuntimeState.INITIALIZED != chainState) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Destroy the chain, " + chainName), (Object[])new Object[0]);
                    }
                    this.destroyChainInternal(chain);
                    changedChains.add(chainDataArray[i]);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Chain doesn't exist, " + chainName), (Object[])new Object[0]);
                continue;
            }
            catch (Exception e) {
                String errorString = "Error destroying chain " + chainName + " in group " + groupName + ", exception=" + e;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)errorString, (Object[])new Object[0]);
                }
                errorOccurred = true;
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".destroyChainGroup"), (String)"3647", (Object)this, (Object[])new Object[]{chainName, groupName});
                sbErrors.append("\r\n");
                sbErrors.append(errorString);
            }
        }
        if (errorOccurred) {
            throw new ChainGroupException(sbErrors.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyChainGroup");
        }
        return changedChains.toArray(new ChainData[changedChains.size()]);
    }

    public synchronized List<ChainData> getRunningChains(ChannelDataImpl parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunningChains", (Object[])new Object[0]);
        }
        ChannelContainer channelContainer = null;
        ArrayList<ChainData> chainDataList = new ArrayList<ChainData>();
        Iterator<ChildChannelDataImpl> children = parent.children();
        while (children.hasNext()) {
            channelContainer = this.channelRunningMap.get(children.next().getName());
            for (Chain chain : channelContainer.getChainMap().values()) {
                chainDataList.add(chain.getChainData());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRunningChains: " + chainDataList.size()));
        }
        return chainDataList;
    }

    @Override
    public synchronized boolean isChainRunning(String chainName) {
        Chain c;
        boolean rc = false;
        if (null != chainName && null != (c = this.chainRunningMap.get(chainName))) {
            boolean bl = rc = c.getState().equals(RuntimeState.STARTED) || c.getState().equals(RuntimeState.QUIESCED);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isChainRunning: " + chainName + " " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public synchronized boolean isChainRunning(ChainData chain) {
        if (null == chain) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isChainRunning(null): false", (Object[])new Object[0]);
            }
            return false;
        }
        return this.isChainRunning(chain.getName());
    }

    public synchronized Chain getRunningChain(String chainName) {
        Chain chain = null;
        if (null != chainName) {
            chain = this.chainRunningMap.get(chainName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRunningChain: " + chainName + " found=" + (null != chain)), (Object[])new Object[0]);
        }
        return chain;
    }

    public synchronized Channel getRunningChannel(String inputChannelName, Chain chain) {
        if (inputChannelName == null || chain == null) {
            return null;
        }
        Channel channel = null;
        if (null != this.chainRunningMap.get(chain.getName())) {
            ChannelData[] channels = chain.getChannelsData();
            for (int index = 0; index < channels.length; ++index) {
                if (!channels[index].getExternalName().equals(inputChannelName)) continue;
                channel = chain.getChannels()[index];
                break;
            }
        }
        return channel;
    }

    public synchronized RuntimeState getChannelState(String channelName, Chain chain) {
        ChannelContainer channelContainer;
        RuntimeState state = null;
        Channel channel = this.getRunningChannel(channelName, chain);
        if (channel != null && null != (channelContainer = this.channelRunningMap.get(channel.getName()))) {
            state = channelContainer.getState();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getChannelState: " + channelName + "=" + state), (Object[])new Object[0]);
        }
        return state;
    }

    private synchronized void setChannelState(String channelName, RuntimeState state) {
        ChannelContainer channelContainer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setChannelState channelName=" + channelName + ", state=" + state.ordinal), (Object[])new Object[0]);
        }
        if (null != channelName && null != (channelContainer = this.channelRunningMap.get(channelName))) {
            channelContainer.setState(state);
        }
    }

    public synchronized boolean doesChannelReferenceChain(String channelName, String chainName) {
        boolean foundRef = false;
        Chain chain = this.chainRunningMap.get(chainName);
        if (chain != null) {
            ChannelData[] channelsData = chain.getChannelsData();
            ChildChannelDataImpl childChannelData = null;
            for (int i = 0; i < channelsData.length; ++i) {
                childChannelData = (ChildChannelDataImpl)channelsData[i];
                if (!childChannelData.getExternalName().equals(channelName)) continue;
                foundRef = true;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doesChannelReferenceChain: channel=" + channelName + ", chain=" + chainName + ", rc=" + foundRef), (Object[])new Object[0]);
        }
        return foundRef;
    }

    public synchronized int getNumStartedChainsUsingChannel(String channelName) {
        int numStartedChains = 0;
        ChannelContainer channelContainer = this.channelRunningMap.get(channelName);
        if (null != channelContainer) {
            for (Chain chain : channelContainer.getChainMap().values()) {
                if (chain.getState() != RuntimeState.STARTED) continue;
                ++numStartedChains;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getNumStartedChainsUsingChannel: " + channelName + "=" + numStartedChains), (Object[])new Object[0]);
        }
        return numStartedChains;
    }

    public synchronized int getNumRunningChannels() {
        return this.channelRunningMap.size();
    }

    public synchronized int getNumChannels() {
        return this.channelDataMap.size();
    }

    public synchronized int getNumChannelFactories() {
        return this.channelFactories.size();
    }

    public synchronized int getNumRunningChains() {
        return this.chainRunningMap.size();
    }

    public synchronized int getNumChains() {
        return this.chainDataMap.size();
    }

    public synchronized int getNumChainGroups() {
        return this.chainGroups.size();
    }

    public synchronized int getNumGroupsUsingChain(String chainName) {
        int numGroups = 0;
        for (ChainGroupData chaingroup : this.chainGroups.values()) {
            if (!chaingroup.containsChain(chainName)) continue;
            ++numGroups;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getNumGroupsUsingChain: " + chainName + "=" + numGroups), (Object[])new Object[0]);
        }
        return numGroups;
    }

    public synchronized int getNumOutboundVCFs() {
        return this.outboundVCFactories.size();
    }

    public long getMissingConfigDelay() {
        return this.missingConfigWarning;
    }

    public long getChainStartRetryAttempts() {
        return this.chainStartRetryAttempts;
    }

    public long getChainStartRetryInterval() {
        return this.chainStartRetryInterval;
    }

    @Override
    public long getDefaultChainQuiesceTimeout() {
        return this.chainQuiesceTimeout;
    }

    protected ChannelData createChannelData(String name, Class<?> factoryClass, Map<Object, Object> properties, int weight) {
        return new ChannelDataImpl(name, factoryClass, properties, weight, this);
    }

    protected ChainData createChainData(String name, FlowType type, ChannelData[] channels, Map<Object, Object> properties) throws IncoherentChainException {
        return new ChainDataImpl(name, type, channels, properties);
    }

    protected ChainGroupData createChainGroupData(String name, ChainData[] chains) {
        return new ChainGroupDataImpl(name, chains, this);
    }

    protected OutboundVirtualConnectionFactoryImpl createVirtualConnectionFactory(ChainData chainData) throws ChannelException, ChainException {
        return new OutboundVirtualConnectionFactoryImpl(chainData, this);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(nl);
        sb.append("**********************************").append(nl);
        sb.append("**    Outbound Conn Factories   **").append(nl);
        sb.append("**********************************").append(nl);
        Iterator<OutboundVirtualConnectionFactoryImpl> outFactoryIterator = this.outboundVCFactories.values().iterator();
        while (outFactoryIterator.hasNext()) {
            sb.append(outFactoryIterator.next()).append(nl);
        }
        sb.append(nl);
        sb.append("**********************************").append(nl);
        sb.append("**       Channel Factories      **").append(nl);
        sb.append("**********************************").append(nl);
        Iterator<ChannelFactoryDataImpl> channelFactoryIterator = this.channelFactories.values().iterator();
        while (channelFactoryIterator.hasNext()) {
            sb.append(channelFactoryIterator.next()).append("\r\n");
        }
        sb.append(nl);
        sb.append("**********************************").append(nl);
        sb.append("**   Channel Configurations     **").append(nl);
        sb.append("**********************************").append(nl);
        Iterator<ChannelData> channelDataIterator = this.channelDataMap.values().iterator();
        while (channelDataIterator.hasNext()) {
            sb.append(channelDataIterator.next().toString());
        }
        sb.append(nl);
        sb.append("**********************************").append(nl);
        sb.append("**    Chain Configurations      **").append(nl);
        sb.append("**********************************").append(nl);
        Iterator<ChainDataImpl> chainDataIterator = this.chainDataMap.values().iterator();
        while (chainDataIterator.hasNext()) {
            sb.append(chainDataIterator.next().toString());
        }
        sb.append(nl);
        sb.append("**********************************").append(nl);
        sb.append("**          Chain Groups        **").append(nl);
        sb.append("**********************************").append(nl);
        for (ChainGroupData groupData : this.chainGroups.values()) {
            sb.append("Group: ").append(groupData.getName()).append("\r\n");
            ChainData[] chainDataArray = groupData.getChains();
            for (int j = 0; j < chainDataArray.length; ++j) {
                sb.append("\tchain: ").append(chainDataArray[j]).append("\r\n");
            }
        }
        sb.append(nl);
        sb.append("**********************************").append(nl);
        sb.append("**      Runtime Channels        **").append(nl);
        sb.append("**********************************").append(nl);
        Iterator<String> runtimeChannels = this.channelRunningMap.keySet().iterator();
        while (runtimeChannels.hasNext()) {
            ChannelContainer channelContainer = this.channelRunningMap.get(runtimeChannels.next());
            sb.append("Channel: ").append(channelContainer.getChannel().getName()).append("\r\n");
            sb.append("\tState: ").append(channelContainer.getState().ordinal).append("\r\n");
            sb.append("\tReferenced Chains:\r\n");
            Iterator<String> chainNames = channelContainer.getChainMap().keySet().iterator();
            while (chainNames.hasNext()) {
                sb.append("\t\t").append(chainNames.next()).append("\r\n");
            }
        }
        sb.append(nl);
        sb.append("**********************************").append(nl);
        sb.append("**       Runtime Chains         **").append(nl);
        sb.append("**********************************").append(nl);
        for (Chain chain : this.chainRunningMap.values()) {
            sb.append(chain).append("\r\n");
            ChannelData[] channelsData = chain.getChannelsData();
            sb.append("\tReferenced Channels:\r\n");
            for (int i = 0; i < channelsData.length; ++i) {
                sb.append("\t\t").append(channelsData[i].getName()).append("\r\n");
            }
        }
        return sb.toString();
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    @Override
    public void registerService(Class<?> clazz, Object service) {
        this.services.put(clazz, service);
    }

    @Override
    public Object deregisterService(Class<?> clazz) {
        return this.services.remove(clazz);
    }

    @Override
    public Object lookupService(Class<?> clazz) {
        return this.services.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterFactory(String name) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing factory registration: " + name), (Object[])new Object[0]);
        }
        Class<? extends ChannelFactory> factory = null;
        Map<String, Class<? extends ChannelFactory>> map = this.factories;
        synchronized (map) {
            factory = this.factories.remove(name);
        }
        if (null != factory) {
            String factoryName = factory.getName();
            final ArrayList<String> chains = new ArrayList<String>();
            ChannelFrameworkImpl channelFrameworkImpl = this;
            synchronized (channelFrameworkImpl) {
                block6: for (ChainData chainData : this.chainDataMap.values()) {
                    for (ChannelData channel : chainData.getChannelList()) {
                        if (!channel.getFactoryType().getName().equals(factoryName)) continue;
                        chains.add(chainData.getName());
                        continue block6;
                    }
                }
            }
            Runnable cleanup = new Runnable(){

                @Override
                public void run() {
                    for (String chainName : chains) {
                        ChannelFrameworkImpl.this.cleanupChain(chainName);
                    }
                }
            };
            ChannelUtils.stopChains(chains, -1L, cleanup);
        }
    }

    protected synchronized void cleanupChain(String chainName) {
        LinkedList<ChannelData> channels;
        block7: {
            channels = new LinkedList<ChannelData>();
            ChainData cd = this.chainDataMap.get(chainName);
            if (null == cd) {
                return;
            }
            try {
                if (!FlowType.OUTBOUND.equals(cd.getType())) {
                    for (ChannelData channel : cd.getChannelList()) {
                        if (channels.contains(channel)) continue;
                        channels.add(channel);
                    }
                    if (cd.isEnabled()) {
                        this.destroyChain(cd);
                    }
                    this.removeChain(cd);
                }
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event((TraceComponent)tc, (String)("Error removing chain based on factory; " + cd.getName() + " " + t), (Object[])new Object[0]);
            }
        }
        for (ChannelData channel : channels) {
            this.channelDataMap.remove(channel.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends ChannelFactory> lookupFactory(String name) {
        ChannelFactoryProvider provider;
        Class<? extends ChannelFactory> clazz = null;
        Map<String, Class<? extends ChannelFactory>> map = this.factories;
        synchronized (map) {
            clazz = this.factories.get(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lookupFactory: " + name + ": " + clazz), (Object[])new Object[0]);
        }
        if (null != clazz && null != (provider = this.providers.get(name)) && !this.activatedProviders.contains(provider)) {
            this.activatedProviders.add(provider);
            provider.init();
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFactory(String name, Class<? extends ChannelFactory> factory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("registerFactory: " + name + "; " + factory), (Object[])new Object[0]);
        }
        Map<String, Class<? extends ChannelFactory>> map = this.factories;
        synchronized (map) {
            Class<? extends ChannelFactory> prevFactory;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && null != (prevFactory = this.factories.get(name)) && factory != prevFactory) {
                Tr.event((TraceComponent)tc, (String)("WARNING: overlaying existing factory: " + prevFactory), (Object[])new Object[0]);
            }
            this.factories.put(name, factory);
        }
        ChannelUtils.loadConfig(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFactories(ChannelFactoryProvider provider) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Register factory provider; " + provider.getClass().getName()), (Object[])new Object[0]);
        }
        Map<String, Class<? extends ChannelFactory>> map = this.factories;
        synchronized (map) {
            for (Map.Entry<String, Class<? extends ChannelFactory>> entry : provider.getTypes().entrySet()) {
                Class<? extends ChannelFactory> prevFactory;
                this.providers.put(entry.getKey(), provider);
                Class<? extends ChannelFactory> newFactory = entry.getValue();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && null != (prevFactory = this.factories.get(entry.getKey())) && newFactory != prevFactory) {
                    Tr.event((TraceComponent)tc, (String)("WARNING: overlaying existing factory: " + prevFactory), (Object[])new Object[0]);
                }
                this.factories.put(entry.getKey(), newFactory);
            }
        }
        ChannelUtils.loadConfig(null);
    }

    @Override
    public void deregisterFactories(ChannelFactoryProvider provider) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Removing factory provider; " + provider.getClass().getName()), (Object[])new Object[0]);
        }
        for (Map.Entry<String, Class<? extends ChannelFactory>> entry : provider.getTypes().entrySet()) {
            this.providers.remove(entry.getKey());
            this.deregisterFactory(entry.getKey());
        }
        this.activatedProviders.remove(provider);
    }

    @Override
    public CFEndPoint determineBestEndPoint(CFEndPoint[] endPointList, CFEndPointCriteria criteria) {
        if (null == endPointList) {
            return null;
        }
        CFEndPoint chosenEndPoint = null;
        CFEndPoint[] matchedEps = this.commonGetEndPoints(endPointList, criteria, true);
        if (null != matchedEps) {
            chosenEndPoint = matchedEps[matchedEps.length - 1];
        }
        return chosenEndPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CFEndPoint getEndPoint(String chainName) throws ChannelFrameworkException {
        CFEndPoint rc = null;
        if (null != chainName) {
            ChannelFrameworkImpl channelFrameworkImpl = this;
            synchronized (channelFrameworkImpl) {
                ChainDataImpl chain = this.chainDataMap.get(chainName);
                if (null != chain) {
                    rc = chain.getEndPoint();
                }
            }
        }
        return rc;
    }

    @Override
    public CFEndPoint[] getEndPoints(CFEndPoint[] endPointList, CFEndPointCriteria criteria) {
        return this.commonGetEndPoints(endPointList, criteria, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CFEndPoint[] commonGetEndPoints(CFEndPoint[] endPointList, CFEndPointCriteria criteria, boolean getBestOnly) {
        LinkedList<CFEndPoint> chosenEndPoints;
        block30: {
            block33: {
                int n;
                CFEndPoint[] cFEndPointArray;
                ArrayList<CFEndPoint> vhostNullEndPoints;
                ArrayList<CFEndPoint> vhostMatchingEndPoints;
                String vhost;
                block34: {
                    String chainName;
                    block32: {
                        block31: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.entry((TraceComponent)tc, (String)"commonGetEndPoints", (Object[])new Object[0]);
                            }
                            if (null == endPointList || 0 == endPointList.length || null == criteria) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"commonGetEndPoints", null);
                                }
                                return null;
                            }
                            chainName = criteria.getChainName();
                            chosenEndPoints = new LinkedList<CFEndPoint>();
                            if (null == chainName) break block31;
                            break block32;
                        }
                        vhost = criteria.getVirtualHost();
                        if (null == vhost) break block33;
                        vhostMatchingEndPoints = new ArrayList<CFEndPoint>();
                        vhostNullEndPoints = new ArrayList<CFEndPoint>();
                        cFEndPointArray = endPointList;
                        n = cFEndPointArray.length;
                        break block34;
                    }
                    for (int i = 0; i < endPointList.length; ++i) {
                        if (null == endPointList[i] || !chainName.equals(endPointList[i].getName())) continue;
                        chosenEndPoints.add(endPointList[i]);
                        if (!getBestOnly) {
                            continue;
                        }
                        break block30;
                    }
                    break block30;
                }
                block1: for (int i = 0; i < n; ++i) {
                    CFEndPoint tempEndPoint = cFEndPointArray[i];
                    if (tempEndPoint == null) continue;
                    List<String> vhostList = tempEndPoint.getVirtualHosts();
                    if (vhostList.isEmpty()) {
                        vhostNullEndPoints.add(tempEndPoint);
                        continue;
                    }
                    for (String value : vhostList) {
                        if (!vhost.equalsIgnoreCase(value)) continue;
                        vhostMatchingEndPoints.add(tempEndPoint);
                        continue block1;
                    }
                }
                if (0 != vhostMatchingEndPoints.size()) {
                    endPointList = new CFEndPoint[vhostMatchingEndPoints.size()];
                    vhostMatchingEndPoints.toArray(endPointList);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found matching vhost in " + vhostMatchingEndPoints.size() + " CFEndPoints."), (Object[])new Object[0]);
                    }
                } else {
                    endPointList = new CFEndPoint[vhostNullEndPoints.size()];
                    vhostNullEndPoints.toArray(endPointList);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("No matching vhost found.  New CFEndPoint list size " + vhostNullEndPoints.size()), (Object[])new Object[0]);
                    }
                }
            }
            boolean sslRequired = criteria.isSSLRequired();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Criteria specification if SSL is required: " + sslRequired), (Object[])new Object[0]);
            }
            Class<?>[] requiredFactories = criteria.getOptionalChannelFactories();
            for (CFEndPoint tempEndPoint : endPointList) {
                if (tempEndPoint == null) continue;
                if (tempEndPoint.getChannelAccessor() == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Skipping over end point with null channel accessor, " + tempEndPoint.getName()), (Object[])new Object[0]);
                    continue;
                }
                if (requiredFactories != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found required factories to match", (Object[])new Object[0]);
                    }
                    boolean foundFactory = true;
                    Class<?> ocdFactory = null;
                    List<OutboundChannelDefinition> ocdList = tempEndPoint.getOutboundChannelDefs();
                    for (Class<?> requiredFactory : requiredFactories) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RequiredFactory: " + requiredFactory), (Object[])new Object[0]);
                        }
                        foundFactory = false;
                        for (OutboundChannelDefinition def : ocdList) {
                            ocdFactory = def.getOutboundFactory();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("OCD Factory: " + ocdFactory), (Object[])new Object[0]);
                            }
                            if (!requiredFactory.isAssignableFrom(ocdFactory) && !ocdFactory.isAssignableFrom(requiredFactory)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Found a match", (Object[])new Object[0]);
                            }
                            foundFactory = true;
                            break;
                        }
                        if (!foundFactory) break;
                    }
                    if (!foundFactory) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Skipping over endpoint with missing required factory.", (Object[])new Object[0]);
                        continue;
                    }
                }
                if (!tempEndPoint.getChannelAccessor().equals(criteria.getChannelAccessor())) continue;
                if (sslRequired) {
                    if (!tempEndPoint.isSSLEnabled()) continue;
                    if (chosenEndPoints.size() == 0) {
                        chosenEndPoints.add(tempEndPoint);
                        if (!tempEndPoint.isLocal() || !getBestOnly) continue;
                        break;
                    }
                    if (getBestOnly) {
                        if (!tempEndPoint.isLocal()) continue;
                        chosenEndPoints.add(tempEndPoint);
                        break;
                    } else {
                        chosenEndPoints.add(tempEndPoint);
                        continue;
                    }
                }
                if (tempEndPoint.isSSLEnabled()) continue;
                chosenEndPoints.add(tempEndPoint);
                if (!tempEndPoint.isLocal() || !getBestOnly) {
                    continue;
                }
                break;
            }
        }
        int rtnSize = chosenEndPoints.size();
        CFEndPoint[] rtnEPs = null;
        if (rtnSize > 0) {
            rtnEPs = new CFEndPoint[rtnSize];
            chosenEndPoints.toArray(rtnEPs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("commonGetEndPoints " + rtnSize));
        }
        return rtnEPs;
    }

    public List<String> getVhost(String address, String port) {
        if (null == address || null == port) {
            return null;
        }
        int portnum = Integer.parseInt(port);
        List<EndPointInfo> eps = EndPointMgrImpl.getRef().getEndPoints(address, portnum);
        ArrayList<String> rc = new ArrayList<String>(eps.size());
        for (EndPointInfo ep : eps) {
            rc.add(ep.getName());
        }
        return rc;
    }

    public ChainData createOutboundChain(CFEndPoint endpoint) throws ChannelFrameworkException {
        List<OutboundChannelDefinition> defs = endpoint.getOutboundChannelDefs();
        String[] namelist = new String[defs.size()];
        int i = 0;
        for (OutboundChannelDefinition def : defs) {
            namelist[i] = "channel_" + this.channelNameCounter.getAndIncrement();
            this.addChannel(namelist[i], def.getOutboundFactory(), def.getOutboundChannelProperties());
            ++i;
        }
        return this.addChain("chain_" + this.chainNameCounter.getAndIncrement(), FlowType.OUTBOUND, namelist);
    }

    private synchronized VirtualConnectionFactory getOutboundVCFactory(List<OutboundChannelDefinition> channelDefs) throws ChannelFrameworkException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutboundVCFactory", (Object[])new Object[0]);
        }
        ChainDataImpl chainData = null;
        boolean found = false;
        int hashKey = 0;
        for (OutboundChannelDefinition def : channelDefs) {
            hashKey += def.getOutboundFactory().hashCode();
        }
        OutboundVirtualConnectionFactoryImpl vcf2 = null;
        for (OutboundVirtualConnectionFactoryImpl vcf2 : this.outboundVCFactories.values()) {
            ChannelData[] channelDataList;
            chainData = (ChainDataImpl)vcf2.getChain().getChainData();
            if (hashKey != chainData.getChannelFactoryHash()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found matching hash keys", (Object[])new Object[0]);
            }
            if ((channelDataList = chainData.getChannelList()).length != channelDefs.size()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found matching number of channels", (Object[])new Object[0]);
            }
            found = true;
            for (int i = 0; i < channelDataList.length; ++i) {
                ChannelData existingDef = channelDataList[i];
                ChannelFactoryData existingFactoryData = this.getChannelFactory(existingDef.getFactoryType());
                OutboundChannelDefinition inputDef = channelDefs.get(i);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Comparing existing def " + existingDef.getFactoryType() + "to new def " + inputDef.getOutboundFactory()), (Object[])new Object[0]);
                }
                boolean sameFactoryType = existingDef.getFactoryType() == inputDef.getOutboundFactory();
                boolean sameChannelProps = this.propertiesIncluded(inputDef.getOutboundChannelProperties(), existingDef.getPropertyBag());
                boolean sameFactoryProps = this.propertiesIncluded(inputDef.getOutboundFactoryProperties(), existingFactoryData.getProperties());
                if (sameFactoryType && sameChannelProps && sameFactoryProps) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Keys matched, but factories didn't", (Object[])new Object[0]);
                }
                found = false;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No existing VCF, create one.", (Object[])new Object[0]);
            }
            String[] channelNameList = new String[channelDefs.size()];
            String channelName = null;
            int i = 0;
            for (OutboundChannelDefinition def : channelDefs) {
                channelName = "channel_" + this.channelNameCounter.getAndIncrement();
                channelNameList[i++] = channelName;
                this.addChannel(channelName, def.getOutboundFactory(), def.getOutboundChannelProperties());
            }
            String chainName = "chain_" + this.chainNameCounter.getAndIncrement();
            this.addChain(chainName, FlowType.OUTBOUND, channelNameList);
            vcf2 = (OutboundVirtualConnectionFactoryImpl)this.getOutboundVCFactory(chainName);
        } else if (null != vcf2) {
            vcf2.incrementRefCount();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found an existing vcf " + vcf2.hashCode()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutboundVCFactory");
        }
        return vcf2;
    }

    private boolean propertiesIncluded(Map<Object, Object> inputMap, Map<Object, Object> existingMap) {
        if (inputMap == null) {
            return true;
        }
        if (existingMap == null || inputMap.size() > existingMap.size()) {
            return false;
        }
        for (Map.Entry<Object, Object> entry : inputMap.entrySet()) {
            Object existingValue = existingMap.get(entry.getKey());
            if (existingValue != null && existingValue.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public void prepareEndPoint(CFEndPointImpl endpoint) throws ChannelFrameworkException {
        if (null == endpoint.getOutboundChainData()) {
            VirtualConnectionFactory vcf = this.getOutboundVCFactory(endpoint.getOutboundChannelDefs());
            endpoint.setOutboundVCFactory(vcf);
            endpoint.setOutboundChainData(this.getChain(vcf.getName()));
        }
    }

    public void setAsyncIOHelper(IAsyncProvider.AsyncIOHelper asyncIOHelper) {
        this.asyncIOHelper = asyncIOHelper;
    }

    public IAsyncProvider.AsyncIOHelper getAsyncIOHelper() {
        return this.asyncIOHelper;
    }

    public boolean getAsyncIOEnabled() {
        IAsyncProvider.AsyncIOHelper asyncIOHelper = this.asyncIOHelper;
        return asyncIOHelper != null && asyncIOHelper.enableAsyncIO();
    }
}

