/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ConnectionDescriptorImpl;
import com.ibm.ws.tcpchannel.internal.BindInfo;
import com.ibm.ws.tcpchannel.internal.NewConnectionInitialReadCallback;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.wsspi.channelfw.ConnectionDescriptor;
import com.ibm.wsspi.channelfw.InboundVirtualConnectionFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.RetryableChannelException;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class TCPPort {
    private TCPChannel tcpChannel = null;
    private ServerSocket serverSocket = null;
    protected InboundVirtualConnectionFactory vcf = null;
    private TCPReadCompletedCallback cc = null;
    private int listenPort = 0;
    private static final TraceComponent tc = Tr.register(TCPPort.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    protected TCPPort(TCPChannel _tcpChannel, VirtualConnectionFactory _vcf) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TCPPort", (Object[])new Object[0]);
        }
        this.tcpChannel = _tcpChannel;
        this.vcf = (InboundVirtualConnectionFactory)_vcf;
        this.cc = new NewConnectionInitialReadCallback(this.tcpChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TCPPort");
        }
    }

    protected synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private void attemptSocketBind(InetSocketAddress address, boolean reuseflag) throws IOException {
        this.serverSocket.setReuseAddress(reuseflag);
        this.serverSocket.bind(address, this.tcpChannel.getConfig().getListenBacklog());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ServerSocket bind worked, reuse=" + this.serverSocket.getReuseAddress()), (Object[])new Object[0]);
        }
    }

    private BindInfo portBoundEarly(int port) {
        Map binds;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("portBoundEarly(int): " + port), (Object[])new Object[0]);
        }
        if ((binds = TCPFactoryConfiguration.getEarlyBinds()) != null) {
            BindInfo b;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Got Map of early binds", (Object[])new Object[0]);
            }
            if ((b = (BindInfo)binds.get(port)) != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found Bind: " + b), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"portBoundEarly(int)");
            }
            return b;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"portBoundEarly(int)");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ServerSocket initServerSocket() throws IOException, RetryableChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ServerSocket called, new ServerSocket needs to be created", (Object[])new Object[0]);
        }
        TCPChannelConfiguration channelConfig = this.tcpChannel.getConfig();
        IOException bindError = null;
        BindInfo earlyBind = this.portBoundEarly(channelConfig.getPort());
        if (earlyBind == null) {
            block32: {
                InetSocketAddress socketAddress = null;
                socketAddress = channelConfig.getHostname() == null ? new InetSocketAddress((InetAddress)null, channelConfig.getPort()) : new InetSocketAddress(channelConfig.getHostname(), channelConfig.getPort());
                if (socketAddress.isUnresolved()) {
                    String displayableHostName = channelConfig.getDisplayableHostname();
                    Tr.error((TraceComponent)tc, (String)"LOCAL_HOST_UNRESOLVED", (Object[])new Object[]{channelConfig.getChannelData().getExternalName(), displayableHostName, String.valueOf(channelConfig.getPort())});
                    throw new RetryableChannelException(new IOException("local address unresolved"));
                }
                this.serverSocket = this.openServerSocket();
                if (channelConfig.getReceiveBufferSize() >= 4 && channelConfig.getReceiveBufferSize() <= 0x1000000) {
                    this.serverSocket.setReceiveBufferSize(channelConfig.getReceiveBufferSize());
                }
                if (!channelConfig.getSoReuseAddress()) {
                    try {
                        this.attemptSocketBind(socketAddress, false);
                    }
                    catch (IOException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Forced re-use==false bind attempt failed, ioe=" + e), (Object[])new Object[0]);
                        }
                        bindError = e;
                    }
                } else {
                    try {
                        this.attemptSocketBind(socketAddress, false);
                        if (TCPFactoryConfiguration.isWindows()) break block32;
                        this.serverSocket.setReuseAddress(true);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"ServerSocket reuse set to true to allow for later override", (Object[])new Object[0]);
                        }
                    }
                    catch (IOException ioe) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ServerSocket bind failed on first attempt with IOException: " + ioe.getMessage()), (Object[])new Object[0]);
                        }
                        bindError = ioe;
                        try {
                            InetSocketAddress testAddr;
                            String hostName = channelConfig.getHostname();
                            if (hostName == null) {
                                hostName = "localhost";
                            }
                            if (!(testAddr = new InetSocketAddress(hostName, channelConfig.getPort())).isUnresolved()) {
                                SocketChannel testChannel = SocketChannel.open(testAddr);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"attempt to connect to port to check listen status worked, someone else is using the port!", (Object[])new Object[0]);
                                }
                                testChannel.close();
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Test connection addr is unresolvable; " + testAddr), (Object[])new Object[0]);
                            }
                        }
                        catch (IOException testioe) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("attempt to connect to port to check listen status failed with IOException: " + testioe.getMessage()), (Object[])new Object[0]);
                            }
                            try {
                                this.attemptSocketBind(socketAddress, true);
                                bindError = null;
                            }
                            catch (IOException newioe) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("ServerSocket bind failed on second attempt with IOException: " + newioe.getMessage()), (Object[])new Object[0]);
                                }
                                bindError = newioe;
                            }
                        }
                    }
                }
            }
            if (bindError != null) {
                String displayableHostName = channelConfig.getDisplayableHostname();
                Tr.error((TraceComponent)tc, (String)"BIND_ERROR", (Object[])new Object[]{channelConfig.getChannelData().getExternalName(), displayableHostName, String.valueOf(channelConfig.getPort()), bindError.getMessage()});
                throw new RetryableChannelException(bindError.getMessage());
            }
            this.listenPort = this.serverSocket.getLocalPort();
        } else {
            Exception e = earlyBind.getBindException();
            if (e == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found early bind, setting serverSocket and listenPort", (Object[])new Object[0]);
                }
                this.serverSocket = earlyBind.getServerSocket();
                this.listenPort = this.serverSocket.getLocalPort();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Early Bind generated the following exception: " + e), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"BIND_ERROR", (Object[])new Object[]{channelConfig.getChannelData().getExternalName(), earlyBind.getHostname(), String.valueOf(earlyBind.getPort()), e.getMessage()});
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RetryableChannelException) {
                    throw (RetryableChannelException)e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"new ServerSocket successfully created", (Object[])new Object[0]);
        }
        return this.serverSocket;
    }

    protected ServerSocket openServerSocket() throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        return ssc.socket();
    }

    protected synchronized void destroyServerSocket() {
        if (null == this.serverSocket) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ServerSocket being closed for port " + this.listenPort), (Object[])new Object[0]);
        }
        this.closeServerSocket();
        this.serverSocket = null;
    }

    protected void closeServerSocket() {
        block2: {
            try {
                this.serverSocket.close();
            }
            catch (IOException ioe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("IOExeption on ServerSocket.close " + ioe.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    protected TCPChannel getTCPChannel() {
        return this.tcpChannel;
    }

    public void processNewConnection(SocketIOChannel socket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processNewConnection", (Object[])new Object[0]);
        }
        VirtualConnection vc = this.vcf.createConnection();
        TCPConnLink bc = (TCPConnLink)this.tcpChannel.getConnectionLink(vc);
        TCPReadRequestContextImpl bcRead = bc.getTCPReadConnLink();
        bc.setSocketIOChannel(socket);
        ConnectionDescriptor cd = vc.getConnectionDescriptor();
        Socket s = socket.getSocket();
        InetAddress remote = s.getInetAddress();
        InetAddress local = s.getLocalAddress();
        if (cd != null) {
            cd.setAddrs(remote, local);
        } else {
            ConnectionDescriptorImpl cdi = new ConnectionDescriptorImpl(remote, local);
            vc.setConnectionDescriptor(cdi);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Processing Connection: " + vc.getConnectionDescriptor()), (Object[])new Object[0]);
        }
        int rc = vc.attemptToSetFileChannelCapable(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("FileChannelCapable set in VC to: " + rc), (Object[])new Object[0]);
        }
        bcRead.setJITAllocateSize(bc.getConfig().getNewConnectionBufferSize());
        int timeout = bc.getConfig().getInactivityTimeout();
        if (timeout == 0) {
            timeout = -1;
        }
        vc.getStateMap().put("REMOTE_ADDRESS", bc.getRemoteAddress().getHostAddress());
        bcRead.read(1L, this.cc, true, timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processNewConnection");
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }
}

