/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.connmgmt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.connmgmt.ConnectionType;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionHandle {
    private static final TraceComponent tc = Tr.register(ConnectionHandle.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    public static final int CONNECTION_ID_LENGTH = 16;
    protected static final String CONNECTION_HANDLE_VC_KEY = "CFW_CONNECTION_HANDLE";
    protected static final ConnectionHandleFactory factory = new ConnectionHandleFactory();
    protected final long connID;
    protected final int seqNum;
    protected final byte connHandleCreatorId;
    protected byte myType;
    protected byte myFlags;

    public static ConnectionHandle getConnectionHandle(VirtualConnection vc) {
        if (vc == null) {
            return null;
        }
        ConnectionHandle connHandle = (ConnectionHandle)vc.getStateMap().get(CONNECTION_HANDLE_VC_KEY);
        if (connHandle != null) {
            return connHandle;
        }
        connHandle = factory.createConnectionHandle();
        if (connHandle != null) {
            connHandle.setConnectionType(vc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getConnectionHandle - created new connection handle: " + connHandle), (Object[])new Object[0]);
        }
        ConnectionHandle.setConnectionHandle(vc, connHandle);
        return connHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectionHandle(VirtualConnection vc, ConnectionHandle handle) {
        Object vcLock;
        if (vc == null || handle == null) {
            return;
        }
        Map<Object, Object> map = vc.getStateMap();
        Object object = vcLock = vc.getLockObject();
        synchronized (object) {
            Object tmpHandle = map.get(CONNECTION_HANDLE_VC_KEY);
            if (tmpHandle != null) {
                throw new IllegalStateException("Connection " + tmpHandle + " has already been created");
            }
            map.put(CONNECTION_HANDLE_VC_KEY, handle);
        }
    }

    protected ConnectionHandle(long connID, int seqNum, byte creatorId) {
        this.connID = connID;
        this.seqNum = seqNum;
        this.myType = 0;
        this.myFlags = 0;
        this.connHandleCreatorId = creatorId;
    }

    public ConnectionHandle(byte[] bytes) {
        if (bytes == null || bytes.length < 16) {
            throw new IllegalArgumentException("Cannot create a valid connection handle");
        }
        ByteBuffer bbuf = ByteBuffer.wrap(bytes);
        this.connID = bbuf.getLong();
        this.seqNum = bbuf.getInt();
        this.connHandleCreatorId = bbuf.get();
        this.myFlags = bbuf.get();
        this.myType = bbuf.get();
        bbuf.get();
    }

    protected void setConnectionType(VirtualConnection vc) {
        if (this.myType == 0 || vc == null) {
            ConnectionType newType = ConnectionType.getVCConnectionType(vc);
            this.myType = newType == null ? (byte)0 : newType.export();
        }
    }

    public byte[] getBytes() {
        byte[] me = new byte[16];
        ByteBuffer bbuf = ByteBuffer.wrap(me);
        this.putBytes(bbuf);
        return me;
    }

    public void putBytes(ByteBuffer writeBuffer) {
        if (writeBuffer.remaining() < 16) {
            throw new IllegalArgumentException("Could not add ConnectionHandle to byte buffer: not enough space.");
        }
        writeBuffer.putLong(this.connID);
        writeBuffer.putInt(this.seqNum);
        writeBuffer.put(this.connHandleCreatorId);
        writeBuffer.put(this.myFlags);
        writeBuffer.put(this.myType);
        writeBuffer.put((byte)-1);
    }

    public boolean isOutbound() {
        if (this.myType == 0) {
            return false;
        }
        return ConnectionType.isOutbound(this.myType);
    }

    public boolean isInbound() {
        if (this.myType == 0) {
            return true;
        }
        return ConnectionType.isInbound(this.myType);
    }

    public ConnectionType getConnectionType() {
        return ConnectionType.getConnectionType(this.myType);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ConnectionHandle that = (ConnectionHandle)o;
        return that.connHandleCreatorId == this.connHandleCreatorId && that.connID == this.connID && that.seqNum == this.seqNum;
    }

    public int hashCode() {
        return (int)this.connID;
    }

    public String toString() {
        String type = this.myType == 0 ? "<type>" : ConnectionType.getConnectionType(this.myType).toString();
        return this.getClass().getSimpleName() + "[0x" + Long.toHexString(this.connID) + "/0x" + Integer.toHexString(this.seqNum) + "/" + type + "]";
    }

    public static class ConnectionHandleFactory {
        protected static final byte ConnectionHandleFactoryCreatorId = 1;
        private static final AtomicLong nextConnectionId = new AtomicLong(0L);
        private static final AtomicInteger sharedSequenceNum = new AtomicInteger(0);

        public ConnectionHandle createConnectionHandle() {
            int seqNum;
            long connID = nextConnectionId.incrementAndGet();
            if (nextConnectionId.compareAndSet(Long.MAX_VALUE, Long.MIN_VALUE)) {
                seqNum = sharedSequenceNum.incrementAndGet();
                sharedSequenceNum.compareAndSet(Integer.MAX_VALUE, Integer.MIN_VALUE);
            } else {
                seqNum = sharedSequenceNum.get();
            }
            return new ConnectionHandle(connID, seqNum, 1);
        }
    }
}

