/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.writer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.helper.PrometheusBuilder;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusMetricWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(PrometheusMetricWriter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private final Writer writer;
    private final Locale locale;
    static final long serialVersionUID = -7116240231147487873L;

    public PrometheusMetricWriter(Writer writer, Locale locale) {
        this.writer = writer;
        this.locale = locale;
    }

    @Override
    public void write(String registryName, String metricName) throws NoSuchMetricException, NoSuchRegistryException, IOException, EmptyRegistryException {
        StringBuilder builder = new StringBuilder();
        this.writeMetricsAsPrometheus(builder, registryName, metricName);
        this.serialize(builder);
    }

    @Override
    public void write(String registryName) throws NoSuchRegistryException, EmptyRegistryException, IOException {
        StringBuilder builder = new StringBuilder();
        this.writeMetricsAsPrometheus(builder, registryName);
        this.serialize(builder);
    }

    @Override
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchRegistryException.class})
    public void write() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String registryName : Constants.REGISTRY_NAMES_LIST) {
            try {
                this.writeMetricsAsPrometheus(builder, registryName);
            }
            catch (NoSuchRegistryException noSuchRegistryException) {
            }
            catch (EmptyRegistryException emptyRegistryException) {}
        }
        this.serialize(builder);
    }

    private void writeMetricsAsPrometheus(StringBuilder builder, String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util.getMetricsAsMap(registryName), Util.getMetricsMetadataAsMap(registryName));
    }

    private void writeMetricsAsPrometheus(StringBuilder builder, String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util.getMetricsAsMap(registryName, metricName), Util.getMetricsMetadataAsMap(registryName));
    }

    private void writeMetricMapAsPrometheus(StringBuilder builder, String registryName, Map<String, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        for (Map.Entry<String, Metric> entry : metricMap.entrySet()) {
            String metricNamePrometheus = registryName + ":" + entry.getKey();
            Metric metric = entry.getValue();
            String entryName = entry.getKey();
            Metadata metricMetaData = metricMetadataMap.get(entryName);
            String description = "";
            description = metricMetaData.getDescription() == null || metricMetaData.getDescription().trim().isEmpty() ? "" : Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)metricMetaData.getDescription(), (Object[])new Object[0]);
            String tags = metricMetaData.getTagsAsString();
            String unit = metricMetaData.getUnit();
            double conversionFactor = 0.0;
            String appendUnit = null;
            if (unit == null || unit.trim().isEmpty() || unit.equals("none")) {
                conversionFactor = Double.NaN;
                appendUnit = null;
            } else if (unit.equals("nanoseconds")) {
                conversionFactor = 1.0E-9;
                appendUnit = "_seconds";
            } else if (unit.equals("microseconds")) {
                conversionFactor = 1.0E-6;
                appendUnit = "_seconds";
            } else if (unit.equals("seconds")) {
                conversionFactor = 1.0;
                appendUnit = "_seconds";
            } else if (unit.equals("minutes")) {
                conversionFactor = 60.0;
                appendUnit = "_seconds";
            } else if (unit.equals("hours")) {
                conversionFactor = 3600.0;
                appendUnit = "_seconds";
            } else if (unit.equals("days")) {
                conversionFactor = 86400.0;
                appendUnit = "_seconds";
            } else if (unit.equals("percent")) {
                conversionFactor = Double.NaN;
                appendUnit = "_percent";
            } else if (unit.equals("bytes")) {
                conversionFactor = 1.0;
                appendUnit = "_bytes";
            } else if (unit.equals("kilobytes")) {
                conversionFactor = 1024.0;
                appendUnit = "_bytes";
            } else if (unit.equals("megabytes")) {
                conversionFactor = 1048576.0;
                appendUnit = "_bytes";
            } else if (unit.equals("gigabytes")) {
                conversionFactor = 1.073741824E9;
                appendUnit = "_bytes";
            } else if (unit.equals("kilobits")) {
                conversionFactor = 125.0;
                appendUnit = "_bytes";
            } else if (unit.equals("megabits")) {
                conversionFactor = 125000.0;
                appendUnit = "_bytes";
            } else if (unit.equals("gigabits")) {
                conversionFactor = 1.25E8;
                appendUnit = "_bytes";
            } else if (unit.equals("kibibits")) {
                conversionFactor = 128.0;
                appendUnit = "_bytes";
            } else if (unit.equals("mebibits")) {
                conversionFactor = 131072.0;
                appendUnit = "_bytes";
            } else if (unit.equals("gibibits")) {
                conversionFactor = 1.342E8;
                appendUnit = "_bytes";
            } else if (unit.equals("milliseconds")) {
                conversionFactor = 0.001;
                appendUnit = "_seconds";
            } else {
                conversionFactor = Double.NaN;
                appendUnit = "_" + unit;
            }
            if (Counter.class.isInstance(metric)) {
                PrometheusBuilder.buildCounter(builder, metricNamePrometheus, (Counter)metric, description, tags);
                continue;
            }
            if (Gauge.class.isInstance(metric)) {
                PrometheusBuilder.buildGauge(builder, metricNamePrometheus, (Gauge)metric, description, conversionFactor, tags, appendUnit);
                continue;
            }
            if (Timer.class.isInstance(metric)) {
                PrometheusBuilder.buildTimer(builder, metricNamePrometheus, (Timer)metric, description, tags);
                continue;
            }
            if (Histogram.class.isInstance(metric)) {
                PrometheusBuilder.buildHistogram(builder, metricNamePrometheus, (Histogram)metric, description, conversionFactor, tags, appendUnit);
                continue;
            }
            if (Meter.class.isInstance(metric)) {
                PrometheusBuilder.buildMeter(builder, metricNamePrometheus, (Meter)metric, description, tags);
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metric type '" + metric.getClass() + " for " + entryName + " is invalid."), (Object[])new Object[0]);
        }
    }

    private void serialize(StringBuilder builder) throws IOException {
        try {
            this.writer.write(builder.toString());
        }
        finally {
            this.writer.flush();
        }
    }
}

