/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.servlet.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.request.timing.config.RequestTimingConfigParser;
import com.ibm.ws.request.timing.config.Timing;
import com.ibm.ws.request.timing.config.TimingConfigGroup;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, service={RequestTimingConfigParser.class})
public class ConfigParser
implements RequestTimingConfigParser {
    public static final String RT_SERVLET_TIMING = "servletTiming";
    public static final String RT_APP_NAME = "appName";
    public static final String RT_SERVLET_NAME = "servletName";
    public static final String EVENT_TYPE = "websphere.servlet.service";
    private static final TraceComponent tc = Tr.register(ConfigParser.class, (String)"requestTiming", null);
    static final long serialVersionUID = -4610263643573307481L;

    public String getElementName() {
        return RT_SERVLET_TIMING;
    }

    public TimingConfigGroup parseConfiguration(List<Dictionary<String, Object>> configElementList, long defaultSlowRequestThreshold, long defaultHungRequestThreshold, boolean defaultInterruptHungRequest) {
        final LinkedList<Timing> slowRequestTimings = new LinkedList<Timing>();
        final LinkedList<Timing> hungRequestTimings = new LinkedList<Timing>();
        for (Dictionary<String, Object> configElement : configElementList) {
            try {
                String pid = null;
                boolean typeInterruptHungRequest = false;
                long typeSlowReqThreshold = 0L;
                long typeHungReqThreshold = 0L;
                String[] contextInfo = new String[2];
                if (configElement.get("service.pid") != null) {
                    pid = configElement.get("service.pid").toString();
                }
                typeSlowReqThreshold = configElement.get("slowRequestThreshold") != null ? Long.parseLong(configElement.get("slowRequestThreshold").toString()) : defaultSlowRequestThreshold;
                typeHungReqThreshold = configElement.get("hungRequestThreshold") != null ? Long.parseLong(configElement.get("hungRequestThreshold").toString()) : defaultHungRequestThreshold;
                Object appName = configElement.get(RT_APP_NAME);
                Object servletName = configElement.get(RT_SERVLET_NAME);
                contextInfo[0] = appName != null ? appName.toString() : "*";
                contextInfo[1] = servletName != null ? servletName.toString() : "*";
                typeInterruptHungRequest = configElement.get("interruptHungRequests") != null ? Boolean.parseBoolean(configElement.get("interruptHungRequests").toString()) : defaultInterruptHungRequest;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Nested servlet timing element found", (Object[])new Object[]{contextInfo, typeSlowReqThreshold, typeHungReqThreshold, typeInterruptHungRequest});
                }
                slowRequestTimings.add(new Timing(pid, EVENT_TYPE, contextInfo, typeSlowReqThreshold, false));
                hungRequestTimings.add(new Timing(pid, EVENT_TYPE, contextInfo, typeHungReqThreshold, typeInterruptHungRequest));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.request.timing.servlet.internal.ConfigParser", (String)"120", (Object)this, (Object[])new Object[]{configElementList, defaultSlowRequestThreshold, defaultHungRequestThreshold, defaultInterruptHungRequest});
            }
        }
        return new TimingConfigGroup(){
            static final long serialVersionUID = -8537890689186788447L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public List<Timing> getSlowRequestTimings() {
                return slowRequestTimings;
            }

            public List<Timing> getHungRequestTimings() {
                return hungRequestTimings;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.request.timing.servlet.internal.ConfigParser$1", 1.class, (String)"requestTiming", null);
            }
        };
    }
}

