/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.bus.extension.TextExtensionFragmentParser;
import org.apache.cxf.bus.osgi.CXFActivator;
import org.apache.cxf.common.logging.LogUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class CXFExtensionBundleListener
implements SynchronousBundleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFActivator.class);
    private long id;
    private ConcurrentMap<Long, List<Extension>> extensions;
    static final long serialVersionUID = -8655887942213996533L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public CXFExtensionBundleListener(long bundleId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "<init>", new Object[]{bundleId});
        }
        this.extensions = new ConcurrentHashMap<Long, List<Extension>>(16, 0.75f, 4);
        this.id = bundleId;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerExistingBundles(BundleContext context) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "registerExistingBundles", new Object[]{context});
        }
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16 || bundle.getBundleId() == context.getBundle().getBundleId()) continue;
            this.register(bundle);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "registerExistingBundles");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void bundleChanged(BundleEvent event) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "bundleChanged", new Object[]{event});
        }
        if (event.getType() == 32 && this.id != event.getBundle().getBundleId()) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "bundleChanged");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void register(Bundle bundle) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "register", new Object[]{bundle});
        }
        if (bundle.getSymbolicName().contains("jaxrs")) {
            LOG.fine("register: Skipping jaxrs bundle...");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "register");
            }
            return;
        }
        Enumeration e = bundle.findEntries("META-INF/cxf/", "bus-extensions.txt", false);
        while (e != null && e.hasMoreElements()) {
            List<Extension> orig = new TextExtensionFragmentParser().getExtensions((URL)e.nextElement());
            this.addExtensions(bundle, orig);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "register");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addExtensions(Bundle bundle, List<Extension> orig) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "addExtensions", new Object[]{bundle, orig});
        }
        if (orig.isEmpty()) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "addExtensions");
            }
            return;
        }
        ArrayList<String> names = new ArrayList<String>(orig.size());
        for (Extension ext : orig) {
            names.add(ext.getName());
        }
        LOG.info("Adding the extensions from bundle " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ") " + names);
        List<Extension> list = (CopyOnWriteArrayList<Extension>)this.extensions.get(bundle.getBundleId());
        if (list == null) {
            list = new CopyOnWriteArrayList<Extension>();
            List preList = this.extensions.putIfAbsent(bundle.getBundleId(), list);
            if (preList != null) {
                list = preList;
            }
        }
        for (Extension ext : orig) {
            list.add(new OSGiExtension(ext, bundle));
        }
        ExtensionRegistry.addExtensions(list);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "addExtensions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unregister(long bundleId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "unregister", new Object[]{bundleId});
        }
        List list = (List)this.extensions.remove(bundleId);
        if (list != null) {
            LOG.info("Removing the extensions for bundle " + bundleId);
            ExtensionRegistry.removeExtensions(list);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "unregister");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "shutdown", new Object[0]);
        }
        while (!this.extensions.isEmpty()) {
            this.unregister((Long)this.extensions.keySet().iterator().next());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.bus.osgi.CXFExtensionBundleListener", "shutdown");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public class OSGiExtension
    extends Extension {
        final Bundle bundle;
        static final long serialVersionUID = 6323160420069210772L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OSGiExtension(Extension e, Bundle b) {
            super(e);
            this.bundle = b;
        }

        @Override
        public Class<?> getClassObject(ClassLoader cl) {
            if (this.clazz == null) {
                try {
                    this.clazz = this.bundle.loadClass(this.className);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return super.getClassObject(cl);
        }

        @Override
        public Class<?> loadInterface(ClassLoader cl) {
            try {
                return this.bundle.loadClass(this.interfaceName);
            }
            catch (Throwable throwable) {
                return super.loadInterface(cl);
            }
        }

        @Override
        public Extension cloneNoObject() {
            OSGiExtension ext = new OSGiExtension(this, this.bundle);
            ext.obj = null;
            return ext;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.bus.osgi.CXFExtensionBundleListener$OSGiExtension", OSGiExtension.class, null, null);
        }
    }
}

