/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.MessagePartInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class DataReaderImpl<T>
extends JAXBDataBase
implements DataReader<T> {
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    JAXBDataBinding databinding;
    boolean unwrapJAXBElement;
    ValidationEventHandler veventHandler;
    boolean setEventHandler;
    static final long serialVersionUID = -4053932493074630766L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataReaderImpl(JAXBDataBinding binding, boolean unwrap) {
        super(binding.getContext());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "<init>", new Object[]{binding, unwrap});
        }
        this.unwrapJAXBElement = true;
        this.setEventHandler = true;
        this.unwrapJAXBElement = unwrap;
        this.databinding = binding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object read(T input) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "read", new Object[]{input});
        }
        Object object = this.read(null, input);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object);
        }
        return object;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperty(String prop, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "setProperty", new Object[]{prop, value});
        }
        if (prop.equals("unwrap.jaxb.element")) {
            this.unwrapJAXBElement = Boolean.TRUE.equals(value);
        } else if (prop.equals(Message.class.getName())) {
            Message m = (Message)value;
            this.veventHandler = (ValidationEventHandler)m.getContextualProperty("jaxb-validation-event-handler");
            if (this.veventHandler == null) {
                this.veventHandler = this.databinding.getValidationEventHandler();
            }
            this.setEventHandler = MessageUtils.getContextualBoolean((Message)m, (String)"set-jaxb-validation-event-handler", (boolean)true);
            Object unwrapProperty = m.get((Object)"unwrap.jaxb.element");
            if (unwrapProperty == null) {
                unwrapProperty = m.getExchange().get((Object)"unwrap.jaxb.element");
            }
            if (unwrapProperty != null) {
                this.unwrapJAXBElement = Boolean.TRUE.equals(unwrapProperty);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "setProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Unmarshaller createUnmarshaller() {
        Unmarshaller unmarshaller;
        block11: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "createUnmarshaller", new Object[0]);
            }
            try {
                Unmarshaller um = this.databinding.getJAXBUnmarshaller();
                if (this.setEventHandler) {
                    um.setEventHandler((ValidationEventHandler)new WSUIDValidationHandler(this.veventHandler));
                }
                if (um.getAttachmentUnmarshaller() == null) {
                    if (this.databinding.getUnmarshallerListener() != null) {
                        um.setListener(this.databinding.getUnmarshallerListener());
                    }
                    if (this.databinding.getUnmarshallerProperties() != null) {
                        for (Map.Entry<String, Object> propEntry : this.databinding.getUnmarshallerProperties().entrySet()) {
                            try {
                                um.setProperty(propEntry.getKey(), propEntry.getValue());
                            }
                            catch (PropertyException pe) {
                                LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                            }
                        }
                    }
                }
                um.setSchema(this.schema);
                um.setAttachmentUnmarshaller(this.getAttachmentUnmarshaller());
                unmarshaller = um;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block11;
            }
            catch (JAXBException ex) {
                if (ex instanceof UnmarshalException) {
                    UnmarshalException unmarshalEx = (UnmarshalException)ex;
                    throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, new Object[]{unmarshalEx.getLinkedException().getMessage()}), (Throwable)ex);
                }
                throw new Fault(new org.apache.cxf.common.i18n.Message("UNMARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            unmarshaller = unmarshaller;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "createUnmarshaller", unmarshaller);
        }
        return unmarshaller;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object read(MessagePartInfo part, T reader) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "read", new Object[]{part, reader});
        }
        boolean honorJaxbAnnotation = this.honorJAXBAnnotations(part);
        Annotation[] anns = null;
        if (honorJaxbAnnotation && (anns = this.getJAXBAnnotation(part)).length > 0) {
            QName qname = new QName(null, part.getConcreteName().getLocalPart());
            Object object = JAXBEncoderDecoder.unmarshalWithBridge(qname, part.getTypeClass(), anns, this.databinding.getContextClasses(), reader, this.getAttachmentUnmarshaller());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object);
            }
            return object;
        }
        Unmarshaller unmarshaller = this.createUnmarshaller();
        Object result = JAXBEncoderDecoder.unmarshall(unmarshaller, reader, part, this.unwrapJAXBElement);
        this.databinding.releaseJAXBUnmarshaller(unmarshaller);
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object read(QName name, T input, Class<?> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataReaderImpl", "read", new Object[]{name, input, type});
        }
        Unmarshaller unmarshaller = this.createUnmarshaller();
        Object result = JAXBEncoderDecoder.unmarshall(unmarshaller, input, name, type, this.unwrapJAXBElement);
        this.databinding.releaseJAXBUnmarshaller(unmarshaller);
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.io.DataReaderImpl", "read", object);
        }
        return object;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class WSUIDValidationHandler
    implements ValidationEventHandler {
        ValidationEventHandler origHandler;
        static final long serialVersionUID = 5919812788361131098L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WSUIDValidationHandler(ValidationEventHandler o) {
            this.origHandler = o;
        }

        public boolean handleEvent(ValidationEvent event) {
            String msg = event.getMessage();
            if (msg != null && msg.contains(":Id") && (msg.startsWith("cvc-type.3.1.1: ") || msg.startsWith("cvc-type.3.2.2: ") || msg.startsWith("cvc-complex-type.3.1.1: ") || msg.startsWith("cvc-complex-type.3.2.2: "))) {
                return true;
            }
            if (this.origHandler != null) {
                return this.origHandler.handleEvent(event);
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.io.DataReaderImpl$WSUIDValidationHandler", WSUIDValidationHandler.class, null, null);
        }
    }
}

