/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.appbnd.internal.delegation;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.javaee.dd.appbnd.RunAs;
import com.ibm.ws.javaee.dd.appbnd.SecurityRole;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.appbnd.internal.delegation.NoRunAs;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.IdentityStoreHandlerService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.authentication.helper.AuthenticateUserHelper;
import com.ibm.ws.security.delegation.DelegationProvider;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DefaultDelegationProvider
implements DelegationProvider {
    private static final TraceComponent tc = Tr.register(DefaultDelegationProvider.class, (String)"security", (String)"com.ibm.ws.security.appbnd.internal.resources.AppBndMessages");
    private final ConcurrentHashMap<String, Collection<SecurityRole>> appToSecurityRolesMap = new ConcurrentHashMap();
    private final Map<String, Map<String, RunAs>> roleToRunAsMappingPerApp = new HashMap<String, Map<String, RunAs>>();
    private final Map<String, Map<String, Boolean>> roleToWarningMappingPerApp = new HashMap<String, Map<String, Boolean>>();
    private SecurityService securityService;
    private AtomicServiceReference<IdentityStoreHandlerService> identityStoreHandlerServiceRef = null;
    public String delegationUser = "";
    static final long serialVersionUID = 5805596676456727739L;

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setIdentityStoreHandlerService(AtomicServiceReference<IdentityStoreHandlerService> identityStoreHandlerServiceRef) {
        this.identityStoreHandlerServiceRef = identityStoreHandlerServiceRef;
    }

    public Subject getRunAsSubject(String roleName, String appName) throws AuthenticationException {
        Subject runAsSubject = null;
        RunAs runAs = this.getRunAs(roleName, appName);
        if (this.isValidRunAs(runAs)) {
            this.setDelegationUser(runAs);
            runAsSubject = this.authenticateRunAsUser(runAs);
        } else if (!this.isWarningAlreadyIssued(roleName, appName).booleanValue()) {
            Tr.warning((TraceComponent)tc, (String)"RUNAS_INVALID_CONFIG", (Object[])new Object[]{roleName, appName});
            this.markWarningAlreadyIssued(roleName, appName);
        }
        return runAsSubject;
    }

    private RunAs getRunAs(String roleName, String appName) {
        RunAs runAs = this.getRunAsFromCache(roleName, appName);
        if (runAs == null) {
            runAs = this.getRunAsFromConfig(roleName, appName);
            this.addRunAsToCache(roleName, appName, runAs);
        }
        return runAs;
    }

    private RunAs getRunAsFromCache(String roleName, String appName) {
        RunAs runAs = null;
        Map<String, RunAs> roleToRunAsMap = this.roleToRunAsMappingPerApp.get(appName);
        if (roleToRunAsMap != null) {
            runAs = roleToRunAsMap.get(roleName);
        }
        return runAs;
    }

    private RunAs getRunAsFromConfig(String roleName, String appName) {
        Collection<SecurityRole> securityRoles;
        NoRunAs runAs = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using the hashmap: " + this.appToSecurityRolesMap.toString()), (Object[])new Object[0]);
        }
        if ((securityRoles = this.appToSecurityRolesMap.get(appName)) != null) {
            for (SecurityRole securityRole : securityRoles) {
                String roleNameFromConfig = securityRole.getName();
                if (!roleName.equals(roleNameFromConfig)) continue;
                runAs = securityRole.getRunAs();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The app " + appName + " was not found in the map, " + this.appToSecurityRolesMap), (Object[])new Object[0]);
        }
        if (runAs == null) {
            runAs = new NoRunAs();
        }
        return runAs;
    }

    private void addRunAsToCache(String roleName, String appName, RunAs runAs) {
        Map<String, RunAs> roleToRunAsMap = this.getRoleToRunAsMap(appName);
        roleToRunAsMap.put(roleName, runAs);
    }

    private Map<String, RunAs> getRoleToRunAsMap(String appName) {
        Map<String, RunAs> roleToRunAsMap = this.roleToRunAsMappingPerApp.get(appName);
        if (roleToRunAsMap == null) {
            roleToRunAsMap = new HashMap<String, RunAs>();
            this.roleToRunAsMappingPerApp.put(appName, roleToRunAsMap);
        }
        return roleToRunAsMap;
    }

    public void setDelegationUser(RunAs runAs) {
        this.delegationUser = runAs.getUserid();
    }

    public String getDelegationUser() {
        return this.delegationUser;
    }

    private Boolean isWarningAlreadyIssued(String roleName, String appName) {
        Boolean warningIssued = false;
        Map<String, Boolean> roleToWarningMap = this.roleToWarningMappingPerApp.get(appName);
        if (roleToWarningMap != null && (warningIssued = roleToWarningMap.get(roleName)) == null) {
            warningIssued = false;
        }
        return warningIssued;
    }

    private void markWarningAlreadyIssued(String roleName, String appName) {
        Map<String, Boolean> roleToWarningMap = this.getRoleToWarningMap(appName);
        roleToWarningMap.put(roleName, true);
    }

    private Map<String, Boolean> getRoleToWarningMap(String appName) {
        Map<String, Boolean> roleToWarningMap = this.roleToWarningMappingPerApp.get(appName);
        if (roleToWarningMap == null) {
            roleToWarningMap = new HashMap<String, Boolean>();
            this.roleToWarningMappingPerApp.put(appName, roleToWarningMap);
        }
        return roleToWarningMap;
    }

    private boolean isValidRunAs(RunAs runAs) {
        return runAs != null && runAs.getUserid() != null;
    }

    private Subject authenticateRunAsUser(RunAs runAs) throws AuthenticationException {
        String username = runAs.getUserid();
        String password = PasswordUtil.passwordDecode((String)runAs.getPassword());
        IdentityStoreHandlerService identityStoreHandlerService = this.getIdentityStoreHandlerService();
        if (identityStoreHandlerService != null && identityStoreHandlerService.isIdentityStoreAvailable()) {
            Subject inSubject = password != null ? identityStoreHandlerService.createHashtableInSubject(username, password) : identityStoreHandlerService.createHashtableInSubject(username);
            return this.securityService.getAuthenticationService().authenticate("system.WEB_INBOUND", inSubject);
        }
        if (password != null) {
            AuthenticationData authenticationData = this.createAuthenticationData(username, password);
            return this.securityService.getAuthenticationService().authenticate("system.WEB_INBOUND", authenticationData, null);
        }
        AuthenticateUserHelper authHelper = new AuthenticateUserHelper();
        return authHelper.authenticateUser(this.securityService.getAuthenticationService(), username, "system.WEB_INBOUND");
    }

    public void createAppToSecurityRolesMapping(String appName, Collection<SecurityRole> securityRoles) {
        this.appToSecurityRolesMap.putIfAbsent(appName, securityRoles);
    }

    public void removeRoleToRunAsMapping(String appName) {
        Map<String, RunAs> roleToRunAsMap = this.roleToRunAsMappingPerApp.get(appName);
        if (roleToRunAsMap != null) {
            roleToRunAsMap.clear();
        }
        this.appToSecurityRolesMap.remove(appName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updated the appToSecurityRolesMap: " + this.appToSecurityRolesMap.toString()), (Object[])new Object[0]);
        }
        this.removeRoleToWarningMapping(appName);
    }

    public void removeRoleToWarningMapping(String appName) {
        Map<String, Boolean> roleToWarningMap = this.roleToWarningMappingPerApp.get(appName);
        if (roleToWarningMap != null) {
            roleToWarningMap.clear();
        }
        this.roleToWarningMappingPerApp.remove(appName);
    }

    @Trivial
    protected AuthenticationData createAuthenticationData(String username, String password) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("USERNAME", (Object)username);
        if (password != null) {
            authenticationData.set("PASSWORD", (Object)password.toCharArray());
        }
        return authenticationData;
    }

    private IdentityStoreHandlerService getIdentityStoreHandlerService() {
        if (this.identityStoreHandlerServiceRef != null) {
            return (IdentityStoreHandlerService)this.identityStoreHandlerServiceRef.getService();
        }
        return null;
    }
}

