/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.jaxb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.CachedClass;
import org.apache.cxf.common.util.StringUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public final class JAXBContextCache {
    private static final Map<Set<Class<?>>, CachedContextAndSchemasInternal> JAXBCONTEXT_CACHE;
    private static final Map<Package, CachedClass> OBJECT_FACTORY_CACHE;
    static final long serialVersionUID = 7278033398841762488L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JAXBContextCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<Object, Object> map = JAXBCONTEXT_CACHE;
        synchronized (map) {
            JAXBCONTEXT_CACHE.clear();
        }
        map = OBJECT_FACTORY_CACHE;
        synchronized (map) {
            OBJECT_FACTORY_CACHE.clear();
        }
    }

    public static void scanPackages(Set<Class<?>> classes) {
        JAXBUtils.scanPackages(classes, OBJECT_FACTORY_CACHE);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(Class<?> cls) throws JAXBException {
        HashSet classes = new HashSet();
        classes.add(cls);
        JAXBContextCache.scanPackages(classes);
        return JAXBContextCache.getCachedContextAndSchemas(classes, null, null, null, false);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(String pkg, Map<String, Object> props, ClassLoader loader) throws JAXBException {
        HashSet classes = new HashSet();
        JAXBContextCache.addPackage(classes, pkg, loader);
        return JAXBContextCache.getCachedContextAndSchemas(classes, null, props, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedContextAndSchemas getCachedContextAndSchemas(final Set<Class<?>> classes, String defaultNs, Map<String, Object> props, Collection<Object> typeRefs, boolean exact) throws JAXBException {
        for (Class<?> clz : classes) {
            if (!clz.getName().endsWith("ObjectFactory") || !JAXBContextCache.checkObjectFactoryNamespaces(clz)) continue;
            defaultNs = null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (defaultNs != null) {
            map.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNs);
        }
        if (props != null) {
            map.putAll(props);
        }
        CachedContextAndSchemasInternal cachedContextAndSchemasInternal = null;
        Map<Set<Class<?>>, CachedContextAndSchemasInternal> map2 = JAXBCONTEXT_CACHE;
        synchronized (map2) {
            JAXBContext context;
            block20: {
                context = null;
                if (typeRefs == null || typeRefs.isEmpty()) {
                    if (exact) {
                        cachedContextAndSchemasInternal = JAXBCONTEXT_CACHE.get(classes);
                    } else {
                        for (Map.Entry<Set<Class<?>>, CachedContextAndSchemasInternal> k : JAXBCONTEXT_CACHE.entrySet()) {
                            Set<Class<Class<?>>> key = k.getKey();
                            if (key == null || !key.containsAll(classes)) continue;
                            cachedContextAndSchemasInternal = k.getValue();
                            break;
                        }
                    }
                    if (cachedContextAndSchemasInternal != null) {
                        context = cachedContextAndSchemasInternal.getContext();
                        if (context == null) {
                            JAXBCONTEXT_CACHE.remove(cachedContextAndSchemasInternal.getClasses());
                            cachedContextAndSchemasInternal = null;
                        } else {
                            return new CachedContextAndSchemas(cachedContextAndSchemasInternal);
                        }
                    }
                }
                if (context == null) {
                    try {
                        context = JAXBContextCache.createContext(classes, map, typeRefs);
                    }
                    catch (JAXBException ex) {
                        boolean added = JAXBContextCache.addJaxbObjectFactory(ex, classes);
                        while (cachedContextAndSchemasInternal == null && added) {
                            try {
                                context = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){
                                    static final long serialVersionUID = -4562750980222792404L;
                                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                                    @Override
                                    public JAXBContext run() throws Exception {
                                        return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), null);
                                    }

                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    static {
                                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.jaxb.JAXBContextCache$1", 1.class, null, null);
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                throw ex;
                            }
                        }
                        if (context != null) break block20;
                        throw ex;
                    }
                }
            }
            cachedContextAndSchemasInternal = new CachedContextAndSchemasInternal(context, classes);
            if (typeRefs == null || typeRefs.isEmpty()) {
                JAXBCONTEXT_CACHE.put(classes, cachedContextAndSchemasInternal);
            }
            return new CachedContextAndSchemas(context, classes, cachedContextAndSchemasInternal);
        }
    }

    private static boolean checkObjectFactoryNamespaces(Class<?> clz) {
        for (Method meth : clz.getMethods()) {
            XmlElementDecl decl = meth.getAnnotation(XmlElementDecl.class);
            if (decl == null || !XmlElementDecl.GLOBAL.class.equals((Object)decl.scope()) || !StringUtils.isEmpty(decl.namespace())) continue;
            return true;
        }
        return false;
    }

    private static JAXBContext createContext(final Set<Class<?>> classes, final Map<String, Object> map, Collection<Object> typeRefs) throws JAXBException {
        JAXBContext ctx;
        if (typeRefs != null && !typeRefs.isEmpty()) {
            Class<?> fact = null;
            String pfx = "com.sun.xml.bind.";
            try {
                fact = ClassLoaderUtils.loadClass("com.sun.xml.bind.v2.ContextFactory", JAXBContextCache.class);
            }
            catch (Throwable t) {
                try {
                    fact = ClassLoaderUtils.loadClass("com.sun.xml.internal.bind.v2.ContextFactory", JAXBContextCache.class);
                    pfx = "com.sun.xml.internal.bind.";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (fact != null) {
                for (Method m : fact.getMethods()) {
                    if (!"createContext".equals(m.getName()) || m.getParameterTypes().length != 9) continue;
                    try {
                        return (JAXBContext)m.invoke(null, classes.toArray(new Class[classes.size()]), typeRefs, map.get(pfx + "subclassReplacements"), map.get(pfx + "defaultNamespaceRemap"), map.get(pfx + "c14n") == null ? Boolean.FALSE : map.get(pfx + "c14n"), map.get(pfx + "v2.model.annotation.RuntimeAnnotationReader"), map.get(pfx + "XmlAccessorFactory") == null ? Boolean.FALSE : map.get(pfx + "XmlAccessorFactory"), map.get(pfx + "treatEverythingNillable") == null ? Boolean.FALSE : map.get(pfx + "treatEverythingNillable"), map.get("retainReferenceToInfo") == null ? Boolean.FALSE : map.get("retainReferenceToInfo"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            ctx = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){
                static final long serialVersionUID = -2580568697754933556L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JAXBContext run() throws Exception {
                    return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), (Map)map);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.jaxb.JAXBContextCache$2", 2.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException e2) {
            if (e2.getException() instanceof JAXBException) {
                JAXBException ex = (JAXBException)((Object)e2.getException());
                if (map.containsKey("com.sun.xml.bind.defaultNamespaceRemap") && ex.getMessage() != null && ex.getMessage().contains("com.sun.xml.bind.defaultNamespaceRemap")) {
                    map.put("com.sun.xml.internal.bind.defaultNamespaceRemap", map.remove("com.sun.xml.bind.defaultNamespaceRemap"));
                    ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
                }
                throw ex;
            }
            throw new RuntimeException(e2.getException());
        }
        return ctx;
    }

    private static boolean addJaxbObjectFactory(JAXBException e1, Set<Class<?>> classes) {
        boolean added = false;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        e1.printStackTrace(pout);
        String str = new String(bout.toByteArray());
        Pattern pattern = Pattern.compile("(?<=There's\\sno\\sObjectFactory\\swith\\san\\s@XmlElementDecl\\sfor\\sthe\\selement\\s\\{)\\S*(?=\\})");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String pkgName = JAXBUtils.namespaceURIToPackage(matcher.group());
            try {
                Class<?> clz = JAXBContextCache.class.getClassLoader().loadClass(pkgName + ".ObjectFactory");
                if (classes.contains(clz)) continue;
                classes.add(clz);
                added = true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return added;
    }

    public static void addPackage(Set<Class<?>> classes, String pkg, ClassLoader loader) {
        try {
            classes.add(Class.forName(pkg + ".ObjectFactory", false, loader));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            InputStream ins = loader.getResourceAsStream("/" + pkg.replace('.', '/') + "/jaxb.index");
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            if (!StringUtils.isEmpty(pkg)) {
                pkg = pkg + ".";
            }
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).indexOf("#") != -1) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (!StringUtils.isEmpty(line)) {
                    try {
                        Class<?> ncls = Class.forName(pkg + line, false, loader);
                        classes.add(ncls);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.jaxb.JAXBContextCache", JAXBContextCache.class, null, null);
        JAXBCONTEXT_CACHE = new CacheMap();
        OBJECT_FACTORY_CACHE = new CacheMap<Package, CachedClass>();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static final class CachedContextAndSchemasInternal {
        private final WeakReference<JAXBContext> context;
        private final WeakReference<Set<Class<?>>> classes;
        private Collection<DOMSource> schemas;
        static final long serialVersionUID = -1085161064936652561L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CachedContextAndSchemasInternal(JAXBContext context, Set<Class<?>> classes) {
            this.context = new WeakReference<JAXBContext>(context);
            this.classes = new WeakReference(classes);
        }

        public JAXBContext getContext() {
            return (JAXBContext)this.context.get();
        }

        public Set<Class<?>> getClasses() {
            return (Set)this.classes.get();
        }

        public Collection<DOMSource> getSchemas() {
            return this.schemas;
        }

        public void setSchemas(Collection<DOMSource> schemas) {
            this.schemas = schemas;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.jaxb.JAXBContextCache$CachedContextAndSchemasInternal", CachedContextAndSchemasInternal.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public static final class CachedContextAndSchemas {
        private final JAXBContext context;
        private final Set<Class<?>> classes;
        private final WeakReference<CachedContextAndSchemasInternal> ccas;
        static final long serialVersionUID = -55549062883562803L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CachedContextAndSchemas(JAXBContext context, Set<Class<?>> classes, CachedContextAndSchemasInternal i) {
            this.context = context;
            this.classes = classes;
            this.ccas = new WeakReference<CachedContextAndSchemasInternal>(i);
        }

        private CachedContextAndSchemas(CachedContextAndSchemasInternal i) {
            this.context = i.getContext();
            this.classes = i.getClasses();
            this.ccas = new WeakReference<CachedContextAndSchemasInternal>(i);
        }

        public JAXBContext getContext() {
            return this.context;
        }

        public Set<Class<?>> getClasses() {
            return this.classes;
        }

        public Collection<DOMSource> getSchemas() {
            CachedContextAndSchemasInternal i = (CachedContextAndSchemasInternal)this.ccas.get();
            if (i != null) {
                return i.getSchemas();
            }
            return null;
        }

        public void setSchemas(Collection<DOMSource> schemas) {
            CachedContextAndSchemasInternal i = (CachedContextAndSchemasInternal)this.ccas.get();
            if (i != null) {
                i.setSchemas(schemas);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.jaxb.JAXBContextCache$CachedContextAndSchemas", CachedContextAndSchemas.class, null, null);
        }
    }
}

