/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class Base64Utility {
    private static final Logger LOG;
    private static final char[] BCS;
    private static final char PAD = '=';
    private static final int BDTSIZE = 128;
    private static final byte[] BDT;
    private static final int PAD_SIZE0 = 1;
    private static final int PAD_SIZE4 = 2;
    private static final int PAD_SIZE8 = 3;
    static final long serialVersionUID = -3546242646080821771L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Base64Utility() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static byte[] decodeChunk(char[] id, int o, int l) throws Base64Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "decodeChunk", new Object[]{id, o, l});
        }
        if (l - o < 4) {
            byte[] byArray = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                byArray = byArray;
                LOG.exiting("org.apache.cxf.common.util.Base64Utility", "decodeChunk", byArray);
            }
            return byArray;
        }
        char[] ib = new char[4];
        int ibcount = 0;
        int octetCount = 3 * (l / 4);
        if (id[l - 1] == '=') {
            octetCount -= id[l - 2] == '=' ? 2 : 1;
        }
        byte[] ob = new byte[octetCount];
        int obcount = 0;
        for (int i = o; i < o + l && i < id.length; ++i) {
            if (id[i] != '=' && (id[i] >= BDT.length || BDT[id[i]] == 127)) continue;
            ib[ibcount++] = id[i];
            if (ibcount != ib.length) continue;
            ibcount = 0;
            obcount += Base64Utility.processEncodeme(ib, ob, obcount);
        }
        if (obcount != ob.length) {
            byte[] tmp = new byte[obcount];
            System.arraycopy(ob, 0, tmp, 0, obcount);
            ob = tmp;
        }
        byte[] byArray = ob;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            byArray = byArray;
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "decodeChunk", byArray);
        }
        return byArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static byte[] decode(String id) throws Base64Exception {
        byte[] byArray;
        block3: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.common.util.Base64Utility", "decode", new Object[]{id});
            }
            try {
                char[] cd = id.toCharArray();
                byArray = Base64Utility.decodeChunk(cd, 0, cd.length);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block3;
            }
            catch (Exception e) {
                LOG.warning("Invalid base64 encoded string : " + id);
                throw new Base64Exception(new Message("BASE64_RUNTIME_EXCEPTION", LOG, new Object[0]), (Throwable)e);
            }
            byArray = byArray;
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "decode", byArray);
        }
        return byArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void decode(char[] id, int o, int l, OutputStream ostream) throws Base64Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "decode", new Object[]{id, o, l, ostream});
        }
        try {
            ostream.write(Base64Utility.decodeChunk(id, o, l));
        }
        catch (Exception e) {
            LOG.warning("Invalid base64 encoded string : " + new String(id));
            throw new Base64Exception(new Message("BASE64_RUNTIME_EXCEPTION", LOG, new Object[0]), (Throwable)e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "decode");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void decode(String id, OutputStream ostream) throws Base64Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "decode", new Object[]{id, ostream});
        }
        try {
            char[] cd = id.toCharArray();
            ostream.write(Base64Utility.decodeChunk(cd, 0, cd.length));
        }
        catch (IOException ioe) {
            throw new Base64Exception(new Message("BASE64_DECODE_IOEXCEPTION", LOG, new Object[0]), (Throwable)ioe);
        }
        catch (Exception e) {
            LOG.warning("Invalid base64 encoded string : " + id);
            throw new Base64Exception(new Message("BASE64_RUNTIME_EXCEPTION", LOG, new Object[0]), (Throwable)e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "decode");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String encode(byte[] id) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "encode", new Object[]{id});
        }
        char[] cd = Base64Utility.encodeChunk(id, 0, id.length);
        String string = new String(cd, 0, cd.length);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "encode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static char[] encodeChunk(byte[] id, int o, int l) {
        int i;
        int rest;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "encodeChunk", new Object[]{id, o, l});
        }
        if (l <= 0) {
            char[] cArray = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                cArray = cArray;
                LOG.exiting("org.apache.cxf.common.util.Base64Utility", "encodeChunk", cArray);
            }
            return cArray;
        }
        char[] out = (l - o) % 3 == 0 ? new char[l / 3 * 4] : new char[l / 3 * 4 + 4];
        int rindex = o;
        int windex = 0;
        for (rest = l - o; rest >= 3; rest -= 3) {
            i = ((id[rindex] & 0xFF) << 16) + ((id[rindex + 1] & 0xFF) << 8) + (id[rindex + 2] & 0xFF);
            out[windex++] = BCS[i >> 18];
            out[windex++] = BCS[i >> 12 & 0x3F];
            out[windex++] = BCS[i >> 6 & 0x3F];
            out[windex++] = BCS[i & 0x3F];
            rindex += 3;
        }
        if (rest == 1) {
            i = id[rindex] & 0xFF;
            out[windex++] = BCS[i >> 2];
            out[windex++] = BCS[i << 4 & 0x3F];
            out[windex++] = 61;
            out[windex++] = 61;
        } else if (rest == 2) {
            i = ((id[rindex] & 0xFF) << 8) + (id[rindex + 1] & 0xFF);
            out[windex++] = BCS[i >> 10];
            out[windex++] = BCS[i >> 4 & 0x3F];
            out[windex++] = BCS[i << 2 & 0x3F];
            out[windex++] = 61;
        }
        char[] cArray = out;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            cArray = cArray;
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "encodeChunk", cArray);
        }
        return cArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void encodeChunk(byte[] id, int o, int l, OutputStream ostream) throws Base64Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "encodeChunk", new Object[]{id, o, l, ostream});
        }
        try {
            ostream.write(new String(Base64Utility.encodeChunk(id, o, l)).getBytes());
        }
        catch (IOException e) {
            throw new Base64Exception(new Message("BASE64_ENCODE_IOEXCEPTION", LOG, new Object[0]), (Throwable)e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "encodeChunk");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void encode(byte[] id, int o, int l, Writer writer) throws Base64Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "encode", new Object[]{id, o, l, writer});
        }
        try {
            writer.write(Base64Utility.encodeChunk(id, o, l));
        }
        catch (IOException e) {
            throw new Base64Exception(new Message("BASE64_ENCODE_WRITER_IOEXCEPTION", LOG, new Object[0]), (Throwable)e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "encode");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static int processEncodeme(char[] ib, byte[] ob, int p) throws Base64Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "processEncodeme", new Object[]{ib, ob, p});
        }
        int spad = 3;
        if (ib[3] == '=') {
            spad = 2;
        }
        if (ib[2] == '=') {
            spad = 1;
        }
        byte b0 = BDT[ib[0]];
        byte b1 = BDT[ib[1]];
        byte b2 = BDT[ib[2]];
        byte b3 = BDT[ib[3]];
        switch (spad) {
            case 1: {
                ob[p] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                int n = 1;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.common.util.Base64Utility", "processEncodeme", n);
                }
                return n;
            }
            case 2: {
                ob[p++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                ob[p] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                int n = 2;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.common.util.Base64Utility", "processEncodeme", n);
                }
                return n;
            }
            case 3: {
                ob[p++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                ob[p++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                ob[p] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                int n = 3;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    n = n;
                    LOG.exiting("org.apache.cxf.common.util.Base64Utility", "processEncodeme", n);
                }
                return n;
            }
        }
        throw new IllegalStateException();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isValidBase64(int ch) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.Base64Utility", "isValidBase64", new Object[]{ch});
        }
        boolean bl = ch == 61 || BDT[ch] != 127;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.common.util.Base64Utility", "isValidBase64", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        int i;
        LOG = LogUtils.getL7dLogger(Base64Utility.class);
        BCS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        BDT = new byte[128];
        for (i = 0; i < 128; ++i) {
            Base64Utility.BDT[i] = 127;
        }
        for (i = 0; i < BCS.length; ++i) {
            Base64Utility.BDT[Base64Utility.BCS[i]] = (byte)i;
        }
    }
}

