/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class ServiceUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceUtils.class);
    static final long serialVersionUID = 2368466172952657069L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ServiceUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.helpers.ServiceUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "<init>", this);
        }
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isSchemaValidationEnabled(SchemaValidation.SchemaValidationType type, Message message) {
        LOG.entering("ServiceUtils", "isSchemaValidationEnabled");
        SchemaValidation.SchemaValidationType messageType = ServiceUtils.getSchemaValidationType(message);
        LOG.exiting("ServiceUtils", "isSchemaValidationEnabled");
        return messageType.equals((Object)type) || (SchemaValidation.SchemaValidationType.IN.equals((Object)type) || SchemaValidation.SchemaValidationType.OUT.equals((Object)type)) && SchemaValidation.SchemaValidationType.BOTH.equals((Object)messageType);
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static SchemaValidation.SchemaValidationType getSchemaValidationType(Message message) {
        LOG.entering("ServiceUtils", "getSchemaValidationType");
        Object obj = message.getContextualProperty("schema-validation-enabled");
        if (obj instanceof SchemaValidation.SchemaValidationType) {
            LOG.exiting("ServiceUtils", "getSchemaValidationType");
            return (SchemaValidation.SchemaValidationType)((Object)obj);
        }
        if (obj != null) {
            String value = obj.toString().toUpperCase();
            if ("TRUE".equals(value)) {
                LOG.exiting("ServiceUtils", "getSchemaValidationType");
                return SchemaValidation.SchemaValidationType.BOTH;
            }
            if ("FALSE".equals(value)) {
                LOG.exiting("ServiceUtils", "getSchemaValidationType");
                return SchemaValidation.SchemaValidationType.NONE;
            }
            if (value.length() > 0) {
                LOG.exiting("ServiceUtils", "getSchemaValidationType");
                return SchemaValidation.SchemaValidationType.valueOf(value);
            }
        }
        LOG.exiting("ServiceUtils", "getSchemaValidationType");
        return SchemaValidation.SchemaValidationType.NONE;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String makeServiceNameFromClassName(Class<?> clazz) {
        int inner;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.helpers.ServiceUtils", "makeServiceNameFromClassName", new Object[]{clazz});
        }
        String name = clazz.getName();
        int last = name.lastIndexOf(".");
        if (last != -1) {
            name = name.substring(last + 1);
        }
        if ((inner = name.lastIndexOf("$")) != -1) {
            name = name.substring(inner + 1);
        }
        String string = name;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "makeServiceNameFromClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static QName makeQualifiedNameFromClass(Class<?> clazz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.helpers.ServiceUtils", "makeQualifiedNameFromClass", new Object[]{clazz});
        }
        String namespace = ServiceUtils.makeNamespaceFromClassName(clazz.getName(), "http");
        String localPart = ServiceUtils.makeServiceNameFromClassName(clazz);
        QName qName = new QName(namespace, localPart);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "makeQualifiedNameFromClass", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getMethodName(Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.helpers.ServiceUtils", "getMethodName", new Object[]{m});
        }
        StringBuilder sb = new StringBuilder();
        sb.append(m.getDeclaringClass().getName());
        sb.append('.');
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            sb.append(param.getName());
            if (i >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "getMethodName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String makeNamespaceFromClassName(String className, String protocol) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.helpers.ServiceUtils", "makeNamespaceFromClassName", new Object[]{className, protocol});
        }
        int index = className.lastIndexOf(".");
        if (index == -1) {
            String string = protocol + "://DefaultNamespace";
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "makeNamespaceFromClassName", string);
            }
            return string;
        }
        String packageName = className.substring(0, index);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        String string = protocol + "://" + sb.toString() + "/";
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "makeNamespaceFromClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String makePackageName(String namespace) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.helpers.ServiceUtils", "makePackageName", new Object[]{namespace});
        }
        String hostname = null;
        String path = "";
        try {
            URL u = new URL(namespace);
            hostname = u.getHost();
            path = u.getPath();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "makePackageName", string);
            }
            return string;
        }
        hostname = hostname.replace('-', '_');
        if ((path = path.replace('-', '_')).length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(hostname, ".:");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(namespace.length());
        for (int i = words.length - 1; i >= 0; --i) {
            ServiceUtils.addWordToPackageBuffer(sb, words[i], i == words.length - 1);
        }
        StringTokenizer st2 = new StringTokenizer(path, "/");
        while (st2.hasMoreTokens()) {
            ServiceUtils.addWordToPackageBuffer(sb, st2.nextToken(), false);
        }
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "makePackageName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void addWordToPackageBuffer(StringBuilder sb, String word, boolean firstWord) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.helpers.ServiceUtils", "addWordToPackageBuffer", new Object[]{sb, word, firstWord});
        }
        if (JavaUtils.isJavaKeyword(word)) {
            word = JavaUtils.makeNonJavaKeyword(word);
        }
        if (!firstWord) {
            sb.append('.');
        }
        if (Character.isDigit(word.charAt(0))) {
            sb.append('_');
        }
        if (word.indexOf(46) != -1) {
            char[] buf = word.toCharArray();
            for (int i = 0; i < word.length(); ++i) {
                if (buf[i] != '.') continue;
                buf[i] = 95;
            }
            word = new String(buf);
        }
        sb.append(word);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.helpers.ServiceUtils", "addWordToPackageBuffer");
        }
    }
}

