/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class StaxInEndingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxInEndingInterceptor.class);
    public static final String STAX_IN_NOCLOSE = StaxInEndingInterceptor.class.getName() + ".dontClose";
    public static final StaxInEndingInterceptor INSTANCE = new StaxInEndingInterceptor();
    static final long serialVersionUID = -3729594688595184571L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StaxInEndingInterceptor() {
        super("post-invoke");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.StaxInEndingInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.interceptor.StaxInEndingInterceptor", "<init>", this);
        }
    }

    @Override
    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) throws Fault {
        LOG.entering("StaxInEndingInterceptor", "handleMessage");
        XMLStreamReader xtr = message.getContent(XMLStreamReader.class);
        if (xtr != null && !MessageUtils.getContextualBoolean(message, STAX_IN_NOCLOSE, false)) {
            StaxUtils.close(xtr);
            message.removeContent(XMLStreamReader.class);
        }
        LOG.exiting("StaxInEndingInterceptor", "handleMessage");
    }
}

