/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class StaxInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxInInterceptor.class);
    private static Map<Object, XMLInputFactory> factories = new HashMap<Object, XMLInputFactory>();
    static final long serialVersionUID = -6687875209246336863L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StaxInInterceptor() {
        super("post-stream");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.StaxInInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StaxInInterceptor(String phase) {
        super(phase);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.StaxInInterceptor", "<init>", new Object[]{phase});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) {
        XMLStreamReader xreader;
        block20: {
            Map<String, List<String>> m;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.interceptor.StaxInInterceptor", "handleMessage", new Object[]{message});
            }
            if (this.isGET(message) || message.getContent(XMLStreamReader.class) != null) {
                LOG.fine("StaxInInterceptor skipped.");
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "handleMessage");
                }
                return;
            }
            InputStream is = message.getContent(InputStream.class);
            Reader reader = null;
            if (is == null && (reader = message.getContent(Reader.class)) == null) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "handleMessage");
                }
                return;
            }
            String contentType = (String)message.get("Content-Type");
            if (contentType != null && contentType.contains("text/html") && MessageUtils.isRequestor(message)) {
                StringBuilder htmlMessage = new StringBuilder(1024);
                try {
                    if (reader == null) {
                        reader = new InputStreamReader(is, (String)message.get(Message.ENCODING));
                    }
                    char[] s = new char[1024];
                    int i = reader.read(s);
                    while (htmlMessage.length() < 64536 && i > 0) {
                        htmlMessage.append(s, 0, i);
                        i = reader.read(s);
                    }
                }
                catch (IOException e) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_HTML_RESPONSETYPE", LOG, "(none)"));
                }
                throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_HTML_RESPONSETYPE", LOG, htmlMessage == null || htmlMessage.length() == 0 ? "(none)" : htmlMessage));
            }
            if (contentType == null && (m = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS))) != null) {
                List<String> contentLen = HttpHeaderHelper.getHeader(m, "Content-Length");
                List<String> contentTE = HttpHeaderHelper.getHeader(m, "Content-Transfer-Encoding");
                if ((StringUtils.isEmpty(contentLen) || "0".equals(contentLen.get(0))) && StringUtils.isEmpty(contentTE)) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "handleMessage");
                    }
                    return;
                }
            }
            String encoding = (String)message.get(Message.ENCODING);
            try {
                XMLInputFactory factory = StaxInInterceptor.getXMLInputFactory(message);
                if (factory == null) {
                    xreader = reader != null ? StaxUtils.createXMLStreamReader(reader) : StaxUtils.createXMLStreamReader(is, encoding);
                    break block20;
                }
                XMLInputFactory xMLInputFactory = factory;
                synchronized (xMLInputFactory) {
                    xreader = reader != null ? factory.createXMLStreamReader(reader) : factory.createXMLStreamReader(is, encoding);
                }
            }
            catch (XMLStreamException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("STREAM_CREATE_EXC", LOG, encoding), (Throwable)e);
            }
        }
        message.setContent(XMLStreamReader.class, xreader);
        message.getInterceptorChain().add(StaxInEndingInterceptor.INSTANCE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLInputFactory getXMLInputFactory(Message m) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.interceptor.StaxInInterceptor", "getXMLInputFactory", new Object[]{m});
        }
        Object o = m.getContextualProperty(XMLInputFactory.class.getName());
        if (o instanceof XMLInputFactory) {
            XMLInputFactory xMLInputFactory = (XMLInputFactory)o;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                xMLInputFactory = xMLInputFactory;
                LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "getXMLInputFactory", xMLInputFactory);
            }
            return xMLInputFactory;
        }
        if (o != null) {
            XMLInputFactory xif = factories.get(o);
            if (xif == null) {
                Class<?> cls;
                if (o instanceof Class) {
                    cls = (Class<?>)o;
                } else if (o instanceof String) {
                    try {
                        cls = ClassLoaderUtils.loadClass((String)o, StaxInInterceptor.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new Fault(e);
                    }
                } else {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_INPUT_FACTORY", LOG, o));
                }
                try {
                    xif = (XMLInputFactory)cls.newInstance();
                    factories.put(o, xif);
                }
                catch (InstantiationException e) {
                    throw new Fault(e);
                }
                catch (IllegalAccessException e) {
                    throw new Fault(e);
                }
            }
            XMLInputFactory xMLInputFactory = xif;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                xMLInputFactory = xMLInputFactory;
                LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "getXMLInputFactory", xMLInputFactory);
            }
            return xMLInputFactory;
        }
        XMLInputFactory xMLInputFactory = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLInputFactory = xMLInputFactory;
            LOG.exiting("org.apache.cxf.interceptor.StaxInInterceptor", "getXMLInputFactory", xMLInputFactory);
        }
        return xMLInputFactory;
    }
}

