/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.reactive.messaging.kafka.AckTracker;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRebalanceListener;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecord;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecords;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaConsumer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.WakeupException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KafkaInput<K, V> {
    private static final TraceComponent tc = Tr.register(KafkaInput.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private static final Duration FOREVER = Duration.ofMillis(Long.MAX_VALUE);
    private final KafkaConsumer<K, V> kafkaConsumer;
    private final ExecutorService executor;
    private final Collection<String> topics;
    private PublisherBuilder<Message<V>> publisher;
    private boolean subscribed = false;
    private volatile boolean running = true;
    private final ConcurrentLinkedQueue<KafkaConsumerAction> tasks;
    private final AckTracker ackTracker;
    private final ReentrantLock lock = new ReentrantLock();
    static final long serialVersionUID = 5473976236015471039L;

    public KafkaInput(KafkaAdapterFactory kafkaAdapterFactory, KafkaConsumer<K, V> kafkaConsumer, ExecutorService executor, String topic, AckTracker ackTracker) {
        this.kafkaConsumer = kafkaConsumer;
        this.executor = executor;
        this.topics = Collections.singleton(topic);
        this.tasks = new ConcurrentLinkedQueue();
        this.ackTracker = ackTracker;
        if (ackTracker != null) {
            this.ackTracker.setCommitAction(this::commitOffsets);
        }
    }

    public PublisherBuilder<Message<V>> getPublisher() {
        if (this.publisher == null) {
            this.publisher = this.createPublisher();
        }
        return this.publisher;
    }

    private PublisherBuilder<Message<V>> createPublisher() {
        PublisherBuilder kafkaStream = this.ackTracker != null ? ReactiveStreams.generate(() -> 0).flatMapCompletionStage(x -> this.ackTracker.waitForAckThreshold().thenCompose(y -> this.pollKafkaAsync())).flatMap(Function.identity()).map(this::wrapInMessage).takeWhile(record -> this.running) : ReactiveStreams.generate(() -> 0).flatMapCompletionStage(x -> this.pollKafkaAsync()).flatMap(Function.identity()).map(r -> Message.of((Object)r.value())).takeWhile(record -> this.running);
        return kafkaStream;
    }

    /*
     * WARNING - void declaration
     */
    private CompletionStage<Void> commitOffsets(TopicPartition partition, OffsetAndMetadata offset) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(partition, offset);
            this.runAction(c -> c.commitAsync(offsets, (o, e) -> {
                if (e != null) {
                    Tr.warning((TraceComponent)tc, (String)"kafka.read.offsets.commit.warning.CWMRX1001W", (Object[])new Object[]{e});
                    result.completeExceptionally(e);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Committed offsets successfully", (Object[])new Object[]{o});
                    }
                    result.complete(null);
                }
            }));
            return result;
        }
        catch (Throwable offsets) {
            void t;
            FFDCFilter.processException((Throwable)offsets, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput", (String)"128", (Object)this, (Object[])new Object[]{partition, offset});
            Tr.warning((TraceComponent)tc, (String)"kafka.read.offsets.commit.warning.CWMRX1001W", (Object[])new Object[]{t});
            result.completeExceptionally((Throwable)t);
            return result;
        }
    }

    private static <T> Void logPollFailure(T result, Throwable t) {
        if (t != null) {
            Tr.error((TraceComponent)tc, (String)"kafka.poll.error.CWMRX1002E", (Object[])new Object[]{t});
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Message<V> wrapInMessage(ConsumerRecord<K, V> record) {
        try {
            return Message.of((Object)record.value(), this.ackTracker.trackRecord(record));
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput", (String)"145", (Object)this, (Object[])new Object[]{record});
            Tr.error((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{t});
            throw t;
        }
    }

    public void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Shutting down Kafka connection", (Object[])new Object[0]);
        }
        this.running = false;
        this.kafkaConsumer.wakeup();
        this.lock.lock();
        try {
            this.kafkaConsumer.close();
        }
        finally {
            this.lock.unlock();
        }
        if (this.ackTracker != null) {
            this.ackTracker.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={WakeupException.class, RejectedExecutionException.class})
    private CompletionStage<PublisherBuilder<ConsumerRecord<K, V>>> pollKafkaAsync() {
        if (!this.subscribed) {
            this.lock.lock();
            try {
                if (this.ackTracker != null) {
                    this.kafkaConsumer.subscribe(this.topics, (ConsumerRebalanceListener)this.ackTracker);
                } else {
                    this.kafkaConsumer.subscribe(this.topics);
                }
                this.subscribed = true;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.running) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Not running, returning incomplete future", (Object[])new Object[0]);
            }
            return new CompletableFuture<PublisherBuilder<ConsumerRecord<K, V>>>();
        }
        CompletableFuture<PublisherBuilder<ConsumerRecord<K, V>>> result = new CompletableFuture<PublisherBuilder<ConsumerRecord<K, V>>>();
        result.handle(KafkaInput::logPollFailure);
        ConsumerRecords records = null;
        while (this.lock.tryLock()) {
            try {
                records = this.kafkaConsumer.poll(Duration.ZERO);
                break;
            }
            catch (WakeupException wakeupException) {
            }
            finally {
                this.lock.unlock();
            }
            this.runPendingActions();
        }
        if (records != null && !records.isEmpty()) {
            result.complete(ReactiveStreams.fromIterable((Iterable)records));
        } else {
            try {
                this.executor.submit(() -> this.executePollActions(result));
            }
            catch (RejectedExecutionException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Asynchronous execution rejected, returning incomplete future", (Object[])new Object[0]);
                }
                return new CompletableFuture<PublisherBuilder<ConsumerRecord<K, V>>>();
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={WakeupException.class})
    private void executePollActions(CompletableFuture<PublisherBuilder<ConsumerRecord<K, V>>> result) {
        this.lock.lock();
        try {
            while (this.running) {
                try {
                    this.runPendingActions();
                    ConsumerRecords asyncRecords = this.kafkaConsumer.poll(FOREVER);
                    result.complete(ReactiveStreams.fromIterable((Iterable)asyncRecords));
                    break;
                }
                catch (WakeupException asyncRecords) {
                }
                catch (Throwable asyncRecords) {
                    void t;
                    FFDCFilter.processException((Throwable)asyncRecords, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput", (String)"245", (Object)this, (Object[])new Object[]{result});
                    result.completeExceptionally((Throwable)t);
                    break;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.runPendingActions();
    }

    public void runAction(KafkaConsumerAction action) {
        this.tasks.add(action);
        this.kafkaConsumer.wakeup();
        this.runPendingActions();
    }

    /*
     * WARNING - void declaration
     */
    private void runPendingActions() {
        while (!this.tasks.isEmpty() && this.lock.tryLock()) {
            try {
                if (this.running) {
                    KafkaConsumerAction task = null;
                    while ((task = this.tasks.poll()) != null) {
                        try {
                            task.run(this.kafkaConsumer);
                        }
                        catch (Throwable throwable) {
                            void t;
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput", (String)"288", (Object)this, (Object[])new Object[0]);
                            Tr.error((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{t});
                            throw t;
                        }
                    }
                    continue;
                }
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @FunctionalInterface
    public static interface KafkaConsumerAction {
        public void run(KafkaConsumer<?, ?> var1);
    }
}

