/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaProducer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KafkaOutput<K, V> {
    private static final TraceComponent tc = Tr.register(KafkaOutput.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private final KafkaProducer<K, V> kafkaProducer;
    private final String topic;
    private volatile boolean running = true;
    static final long serialVersionUID = 1299932867547398308L;

    public KafkaOutput(String topic, KafkaProducer<K, V> kafkaProducer) {
        this.topic = topic;
        this.kafkaProducer = kafkaProducer;
    }

    public SubscriberBuilder<Message<V>, Void> getSubscriber() {
        return ReactiveStreams.builder().takeWhile(m -> this.running).onError(KafkaOutput::reportErrorSignal).forEach(this::sendMessage);
    }

    public void shutdown(Duration timeout) {
        this.running = false;
        this.kafkaProducer.close(timeout);
    }

    /*
     * WARNING - void declaration
     */
    private void sendMessage(Message<V> message) {
        try {
            this.kafkaProducer.send(this.topic, message.getPayload(), (r, e) -> {
                if (e == null) {
                    message.ack();
                } else {
                    KafkaOutput.reportSendException(e);
                }
            });
        }
        catch (Exception exception) {
            void e2;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaOutput", (String)"53", (Object)this, (Object[])new Object[]{message});
            KafkaOutput.reportSendException((Throwable)e2);
            throw e2;
        }
    }

    private static void reportSendException(Throwable t) {
        Tr.error((TraceComponent)tc, (String)"kafka.send.error.CWMRX1003E", (Object[])new Object[]{t});
    }

    private static void reportErrorSignal(Throwable t) {
        Tr.error((TraceComponent)tc, (String)"kafka.output.error.signal.CWMRX1004E", (Object[])new Object[]{t});
    }
}

