/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAIntrospection;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.jpa.management.JPAPuScope;
import com.ibm.ws.jpa.management.JPAScopeInfo;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class JPAApplInfo {
    private static final TraceComponent tc = Tr.register(JPAApplInfo.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final AbstractJPAComponent ivJPAComponent;
    private final String applName;
    private Map<String, JPAScopeInfo> puScopes = null;

    protected JPAApplInfo(AbstractJPAComponent jpaComponent, String applName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{applName});
        }
        this.ivJPAComponent = jpaComponent;
        this.applName = applName;
        this.puScopes = new HashMap<String, JPAScopeInfo>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    AbstractJPAComponent getJPAComponent() {
        return this.ivJPAComponent;
    }

    public String getApplName() {
        return this.applName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistenceUnits(JPAPXml pxml) {
        JPAPuScope puScope;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addPersistenceUnits", (Object[])new Object[]{pxml});
        }
        String scopeKey = (puScope = pxml.getPuScope()) == JPAPuScope.EAR_Scope ? "EAR_Scope_Module" : pxml.getArchiveName();
        JPAScopeInfo scopeInfo = null;
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            scopeInfo = this.puScopes.get(scopeKey);
            if (scopeInfo == null) {
                scopeInfo = new JPAScopeInfo(scopeKey, puScope);
                this.puScopes.put(scopeKey, scopeInfo);
            }
        }
        JPAIntrospection.beginPUScopeVisit(scopeInfo);
        try {
            scopeInfo.processPersistenceUnit(pxml, this);
        }
        finally {
            JPAIntrospection.endPUScopeVisit();
        }
    }

    protected abstract JPAPUnitInfo createJPAPUnitInfo(JPAPuId var1, JPAPXml var2, JPAScopeInfo var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void close(String modName, boolean remove) {
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            JPAScopeInfo scopeInfo = this.puScopes.get(modName);
            if (scopeInfo != null) {
                scopeInfo.close();
                if (remove) {
                    this.puScopes.remove(modName);
                }
            }
        }
    }

    void closeModule(String modName) {
        this.close(modName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllScopeModules() {
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            for (String module : this.puScopes.keySet()) {
                this.close(module, false);
            }
            this.puScopes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPAPUnitInfo getPersistenceUnitInfo(String modName, String puName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPersistenceUnitInfo", (Object[])new Object[]{modName, puName, this});
        }
        JPAPUnitInfo rtnVal = null;
        JPAScopeInfo scopeInfo = null;
        if (puName == null || puName.length() == 0) {
            rtnVal = this.getUniquePU(modName);
        } else if (puName.startsWith("../")) {
            Map<String, JPAScopeInfo> map = this.puScopes;
            synchronized (map) {
                scopeInfo = this.puScopes.get("EAR_Scope_Module");
            }
            if (scopeInfo != null) {
                String earPuName = puName.substring("../".length());
                rtnVal = scopeInfo.getPuInfo(earPuName);
            }
        } else {
            Map<String, JPAScopeInfo> map = this.puScopes;
            synchronized (map) {
                scopeInfo = this.puScopes.get(modName);
            }
            if (scopeInfo != null) {
                rtnVal = scopeInfo.getPuInfo(puName);
            }
            if (rtnVal == null) {
                map = this.puScopes;
                synchronized (map) {
                    scopeInfo = this.puScopes.get("EAR_Scope_Module");
                }
                if (scopeInfo != null) {
                    rtnVal = scopeInfo.getPuInfo(puName);
                }
            }
        }
        if (rtnVal == null) {
            Tr.error((TraceComponent)tc, (String)"PU_NOT_FOUND_CWWJP0029E", (Object[])new Object[]{this.applName, modName, puName == null || puName.length() == 0 ? "<default>" : puName});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPersistenceUnitInfo", (Object)(rtnVal != null ? rtnVal.getPersistenceUnitName() : "PU not found"));
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPAPUnitInfo getUniquePU(String modName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniquePU", (Object[])new Object[]{modName});
        }
        JPAPUnitInfo rtnVal = null;
        JPAScopeInfo scopeInfo = null;
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            scopeInfo = this.puScopes.get(modName);
        }
        int totalPus = scopeInfo != null ? scopeInfo.getAllPuCount() : 0;
        switch (totalPus) {
            case 1: {
                rtnVal = scopeInfo.getUniquePuInfo();
                break;
            }
            case 0: {
                Map<String, JPAScopeInfo> map2 = this.puScopes;
                synchronized (map2) {
                    scopeInfo = this.puScopes.get("EAR_Scope_Module");
                }
                int n = totalPus = scopeInfo != null ? scopeInfo.getAllPuCount() : 0;
                if (totalPus == 1) {
                    rtnVal = scopeInfo.getUniquePuInfo();
                    break;
                }
            }
            default: {
                Tr.error((TraceComponent)tc, (String)"PU_NOT_SPECIFIED_AND_NO_UNIQUE_PU_FOUND_CWWJP0012E", (Object[])new Object[]{this.applName, modName});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniquePU", (Object)rtnVal);
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getScopeSize() {
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            return this.puScopes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPersistenceUnitsDefined() {
        HashMap<String, JPAScopeInfo> puScopesClone = new HashMap<String, JPAScopeInfo>();
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            puScopesClone.putAll(this.puScopes);
        }
        for (Map.Entry entry : puScopesClone.entrySet()) {
            JPAScopeInfo scopeInfo = (JPAScopeInfo)entry.getValue();
            if (scopeInfo.getAllPuCount() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("  ApplInfo: Appl = ").append(this.applName);
            for (JPAScopeInfo scopeInfo : this.puScopes.values()) {
                scopeInfo.toStringBuilder(sbuf);
            }
            return sbuf.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIntrospect(PrintWriter out, Set<String> archivesSet) {
        HashMap<String, JPAScopeInfo> puScopesClone = new HashMap<String, JPAScopeInfo>();
        Map<String, JPAScopeInfo> map = this.puScopes;
        synchronized (map) {
            puScopesClone.putAll(this.puScopes);
        }
        JPAIntrospection.registerArchiveSet(archivesSet);
        for (Map.Entry entry : puScopesClone.entrySet()) {
            JPAScopeInfo scopeInfo = (JPAScopeInfo)entry.getValue();
            JPAIntrospection.beginPUScopeVisit(scopeInfo);
            try {
                scopeInfo.doIntrospect(out);
            }
            finally {
                JPAIntrospection.endPUScopeVisit();
            }
        }
    }
}

