/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.ContentTypeHeader;

public class ContentTypeHeaderImpl
extends ParametersHeaderImpl
implements ContentTypeHeader {
    private static final long serialVersionUID = 354547676897011474L;
    private String m_type;
    private String m_subType;
    private final boolean m_compactForm;

    public ContentTypeHeaderImpl() {
        this(false);
    }

    public ContentTypeHeaderImpl(boolean compactForm) {
        this.m_compactForm = compactForm;
    }

    @Override
    public String getContentType() {
        return this.m_type;
    }

    @Override
    public String getContentSubType() {
        return this.m_subType;
    }

    @Override
    public void setContentSubType(String contentSubType) throws IllegalArgumentException, SipParseException {
        if (contentSubType == null) {
            throw new IllegalArgumentException("ConTypeHeader: null arg");
        }
        this.m_subType = contentSubType;
    }

    @Override
    public void setContentType(String contentType) throws IllegalArgumentException, SipParseException {
        if (contentType == null) {
            throw new IllegalArgumentException("ConTypeHeader: null arg");
        }
        this.m_type = contentType;
    }

    public boolean hasType() {
        return this.m_type != null;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.parseType(parser);
        super.parseValue(parser);
    }

    protected void parseType(SipParser parser) throws SipParseException {
        String type = parser.nextToken('/');
        this.setContentType(type);
        parser.match('/');
        String subType = parser.nextToken(';');
        this.setContentSubType(subType);
    }

    @Override
    protected void encodeValue(CharsBuffer buffer) {
        this.encodeType(buffer);
        super.encodeValue(buffer);
    }

    protected void encodeType(CharsBuffer buffer) {
        if (this.hasType()) {
            buffer.append(this.m_type);
            buffer.append('/');
            buffer.append(this.m_subType);
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof ContentTypeHeaderImpl)) {
            return false;
        }
        ContentTypeHeaderImpl o = (ContentTypeHeaderImpl)other;
        if (this.m_type == null || this.m_type.length() == 0 ? o.m_type != null && o.m_type.length() > 0 : o.m_type == null || o.m_type.length() == 0) {
            return false;
        }
        if (this.m_subType == null || this.m_subType.length() == 0) {
            return o.m_subType == null || o.m_subType.length() == 0;
        }
        if (o.m_subType == null || o.m_subType.length() == 0) {
            return false;
        }
        return this.m_subType.equals(o.m_subType);
    }

    @Override
    public String getName() {
        return "Content-Type";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }

    @Override
    public String getName(boolean isUseCompactHeaders) {
        if (isUseCompactHeaders) {
            return String.valueOf('c');
        }
        return this.getName();
    }

    @Override
    public boolean isCompactFormSupported() {
        return true;
    }

    @Override
    public boolean isCompactForm() {
        return this.m_compactForm;
    }
}

