/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.ws.sip.channel.resolver.dns.impl.Dns;
import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.ResourceRecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.SOARecord;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class DnsMessage {
    private Header _header;
    private Vector<Question> _questions;
    private Vector<ResourceRecord> _answers;
    private Vector<ResourceRecord> _authority;
    private Vector<ResourceRecord> _additional;
    private static final AtomicInteger _nextId = new AtomicInteger(1);
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DnsMessage(short type, String qname) {
        this._header = new Header();
        this._header.identification = this.nextId();
        this._header.numQuestions = (short)1;
        this._header.numAnswers = (short)0;
        this._header.numAuthority = (short)0;
        this._header.numAdditional = (short)0;
        this._header.flags = (short)256;
        this._header.bitSetFlags.set(7);
        Name n = new Name(qname);
        Question q = new Question(type, n);
        this._questions = new Vector(1);
        this._questions.add(q);
        this._answers = new Vector(0);
        this._additional = new Vector(1);
        this._authority = new Vector(0);
    }

    private int nextId() {
        int newId;
        int oldId;
        boolean done;
        while (!(done = _nextId.compareAndSet(oldId = _nextId.get(), newId = oldId + 1 & 0xFFFF))) {
        }
        return oldId;
    }

    public DnsMessage(short type, String qname, boolean eDNS) {
        this(type, qname);
        ResourceRecord record = ResourceRecord.createRecord((short)41);
        this._additional.add(record);
        Header.access$408(this._header);
    }

    public int getId() {
        return this._header.identification;
    }

    public short getQclass() {
        return this._questions.firstElement().qclass;
    }

    public short getQtype() {
        return this._questions.firstElement().qtype;
    }

    public WsByteBuffer toBuffer(WsByteBufferPoolManager wsByteBufferPoolManager) {
        Class clazz2;
        ResourceRecord rr;
        WsByteBuffer buffer = wsByteBufferPoolManager.allocate(1024);
        buffer.mark();
        buffer.put((byte)(this._header.identification >>> 8 & 0xFF));
        buffer.put((byte)(this._header.identification & 0xFF));
        this._header.bitSetToShort();
        buffer.putShort(this._header.flags);
        buffer.putShort(this._header.numQuestions);
        buffer.putShort(this._header.numAnswers);
        buffer.putShort(this._header.numAuthority);
        buffer.putShort(this._header.numAdditional);
        Enumeration<Object> e2 = this._questions.elements();
        while (e2.hasMoreElements()) {
            Question q = e2.nextElement();
            q.qname.toBuffer(buffer);
            buffer.putShort(q.qtype);
            buffer.putShort(q.qclass);
        }
        e2 = this._answers.elements();
        while (e2.hasMoreElements()) {
            rr = (ResourceRecord)e2.nextElement();
            try {
                clazz2 = rr.className();
                clazz2.cast(rr);
                rr.toBuffer(buffer);
            }
            catch (Exception clazz2) {}
        }
        e2 = this._authority.elements();
        while (e2.hasMoreElements()) {
            rr = (SOARecord)e2.nextElement();
            ((SOARecord)rr).toBuffer(buffer);
        }
        e2 = this._additional.elements();
        while (e2.hasMoreElements()) {
            rr = (ResourceRecord)e2.nextElement();
            try {
                clazz2 = rr.className();
                clazz2.cast(rr);
                rr.toBuffer(buffer);
            }
            catch (Exception exception) {}
        }
        buffer.limit(buffer.position());
        buffer.reset();
        return buffer;
    }

    public DnsMessage(DnsMessage m) throws Exception {
        try {
            this._questions = new Vector(1);
            this._answers = new Vector(4);
            this._authority = new Vector(4);
            this._additional = new Vector(4);
            this._header = new Header();
            this._header.identification = m._header.identification;
            this._header.bitSetFlags.set(0);
            this._header.bitSetFlags.set(5);
            this._header.bitSetFlags.set(14);
            this._header.bitSetFlags.set(15);
            Question question = new Question();
            question.qname = new Name(m._questions.firstElement().qname.toString());
            question.qtype = m._questions.firstElement().qtype;
            question.qclass = m._questions.firstElement().qclass;
            this._questions.add(question);
            Header.access$108(this._header);
        }
        catch (Exception e2) {
            System.out.println("DnsMessage:  Exception = " + e2);
            throw e2;
        }
    }

    public DnsMessage(WsByteBuffer buffer) throws Exception {
        this._header = new Header();
        this._header.parse(buffer);
        this._questions = new Vector(this._header.numQuestions);
        this._answers = new Vector(this._header.numAnswers);
        this._authority = new Vector(this._header.numAuthority);
        this._additional = new Vector(this._header.numAdditional);
        for (int i = 0; i < this._header.numQuestions; ++i) {
            Question question = new Question(buffer);
            this._questions.add(question);
        }
        ResourceRecord rr = null;
        for (int j = 0; j < this._header.numAnswers; ++j) {
            rr = ResourceRecord.createRecord(buffer);
            this._answers.add(j, rr);
        }
        for (int k = 0; k < this._header.numAuthority; ++k) {
            rr = ResourceRecord.createRecord(buffer);
            this._authority.add(k, rr);
        }
        for (int l = 0; l < this._header.numAdditional; ++l) {
            rr = ResourceRecord.createRecord(buffer);
            this._additional.add(l, rr);
        }
    }

    public void addQuestion(ResourceRecord rr) {
        this._answers.add(rr);
        Header.access$108(this._header);
    }

    public void addAnswer(ResourceRecord rr) {
        this._answers.add(rr);
        Header.access$208(this._header);
    }

    public void addAuthority(ResourceRecord rr) {
        this._authority.add(rr);
        Header.access$308(this._header);
    }

    public void addAdditional(ResourceRecord rr) {
        this._additional.add(rr);
        Header.access$408(this._header);
    }

    public Name getQname() {
        return this._questions.firstElement().qname;
    }

    public short numAnswers() {
        return this._header.numAnswers;
    }

    public Vector<ResourceRecord> getAnswers() {
        return this._answers;
    }

    public Vector<ResourceRecord> getAdditional() {
        return this._additional;
    }

    protected void flagstoBitSetFlags() {
        for (int i = 0; i < 16; ++i) {
            if ((this._header.flags & 1 << 15 - i) == 0) continue;
            this._header.bitSetFlags.set(i);
        }
    }

    protected boolean getQR() {
        return this._header.bitSetFlags.get(0);
    }

    protected void setQR() {
        this._header.bitSetFlags.set(0);
    }

    protected boolean getAA() {
        return this._header.bitSetFlags.get(5);
    }

    protected void setAA() {
        this._header.bitSetFlags.set(5);
    }

    public boolean getTC() {
        return this._header.bitSetFlags.get(6);
    }

    protected void setTC() {
        this._header.bitSetFlags.set(6);
    }

    protected boolean getRD() {
        return this._header.bitSetFlags.get(7);
    }

    protected void setRD() {
        this._header.bitSetFlags.set(7);
    }

    protected boolean getRA() {
        return this._header.bitSetFlags.get(8);
    }

    protected void setRA() {
        this._header.bitSetFlags.set(8);
    }

    public int getRCODE() {
        int code = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this._header.bitSetFlags.get(i + 12)) continue;
            code |= 1 << 3 - i;
        }
        return code;
    }

    public void setRCODE(byte b) {
        for (int i = 0; i < 4; ++i) {
            if ((b & 1 << 3 - i) > 0) {
                this._header.bitSetFlags.set(i + 12);
                continue;
            }
            this._header.bitSetFlags.clear(i + 12);
        }
    }

    public String toString() {
        Class clazz;
        ResourceRecord rr;
        String s = new String();
        s = this._header.toString();
        s = s + this._questions.firstElement().toString();
        Enumeration<ResourceRecord> e2 = null;
        e2 = this._answers.elements();
        while (e2.hasMoreElements()) {
            s = s + " Answer\n";
            rr = e2.nextElement();
            try {
                clazz = rr.className();
                clazz.cast(rr);
                s = s + rr.toString();
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("DnsMessage::toString ClassNotFoundException" + cnfe.toString());
            }
        }
        e2 = this._authority.elements();
        while (e2.hasMoreElements()) {
            s = s + " Authority\n";
            rr = e2.nextElement();
            try {
                clazz = rr.className();
                clazz.cast(rr);
                s = s + rr.toString();
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("DnsMessage::toString ClassNotFoundException" + cnfe.toString());
            }
        }
        e2 = this._additional.elements();
        while (e2.hasMoreElements()) {
            s = s + " Additional\n";
            rr = e2.nextElement();
            try {
                clazz = rr.className();
                clazz.cast(rr);
                s = s + rr.toString();
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("DnsMessage::toString ClassNotFoundException" + cnfe.toString());
            }
        }
        return s;
    }

    public boolean isNameError() {
        boolean b = false;
        int rcode = this._header.getRCODE();
        if (rcode == 3) {
            b = true;
        }
        return b;
    }

    class Question {
        private Name qname;
        private short qtype;
        private short qclass;

        protected Question(short type, Name name) {
            this.qname = name;
            this.qtype = type;
            this.qclass = 1;
        }

        protected Question() {
            this.qname = null;
            this.qtype = 0;
            this.qclass = 1;
        }

        protected Question(WsByteBuffer buffer) {
            this.qname = new Name(buffer);
            this.qtype = buffer.getShort();
            this.qclass = buffer.getShort();
        }

        public String toString() {
            String s = new String();
            s = " Question\n  qname: " + this.qname.toString() + "\n  qtype: " + new Short(this.qtype).toString() + "(" + Dns.TYPESTRING[this.qtype].toString() + ")\n  qclass:" + new Short(this.qclass).toString() + "\n";
            return s;
        }
    }

    class Header {
        private int identification;
        private short flags;
        private short numQuestions;
        private short numAnswers;
        private short numAuthority;
        private short numAdditional;
        private BitSet bitSetFlags = new BitSet(16);

        protected Header() {
        }

        protected void parse(WsByteBuffer buffer) {
            this.identification = buffer.getShort() & 0xFFFF;
            this.flags = buffer.getShort();
            this.numQuestions = buffer.getShort();
            this.numAnswers = buffer.getShort();
            this.numAuthority = buffer.getShort();
            this.numAdditional = buffer.getShort();
            for (int i = 0; i < 16; ++i) {
                if ((this.flags & 1 << 15 - i) == 0) continue;
                this.bitSetFlags.set(i);
            }
        }

        protected void bitSetToShort() {
            for (int i = 0; i < 16; ++i) {
                if (!this.bitSetFlags.get(i)) continue;
                this.flags = (short)(this.flags | 1 << 15 - i);
            }
        }

        protected int getRCODE() {
            int code = 0;
            for (int i = 0; i < 4; ++i) {
                if (!this.bitSetFlags.get(i + 12)) continue;
                code |= 1 << 3 - i;
            }
            return code;
        }

        public String toString() {
            String s = new String();
            s = "Dns Message: " + Dns.TYPESTRING[((Question)DnsMessage.this._questions.firstElement()).qtype].toString() + " ";
            s = this.bitSetFlags.get(0) ? s + "Response\n" : s + "Query\n";
            s = s + " Header\n  identification: " + new Integer(this.identification).toString() + "\n  Flags \n    QR: " + this.bitSetFlags.get(0) + "\n";
            short sh = 0;
            if (this.bitSetFlags.get(1)) {
                sh = (short)(sh | 0x1000);
            }
            if (this.bitSetFlags.get(2)) {
                sh = (short)(sh | 0x100);
            }
            if (this.bitSetFlags.get(3)) {
                sh = (short)(sh | 0x10);
            }
            if (this.bitSetFlags.get(4)) {
                sh = (short)(sh | 1);
            }
            s = s + "    opcode: " + new Short(sh).toString() + "\n    AA: " + this.bitSetFlags.get(5) + "\n    TC: " + this.bitSetFlags.get(6) + "\n    RD: " + this.bitSetFlags.get(7) + "\n    RA: " + this.bitSetFlags.get(8) + "\n";
            sh = 0;
            if (this.bitSetFlags.get(9)) {
                sh = (short)(sh | 0x100);
            }
            if (this.bitSetFlags.get(10)) {
                sh = (short)(sh | 0x10);
            }
            if (this.bitSetFlags.get(11)) {
                sh = (short)(sh | 1);
            }
            s = s + "    zero: " + new Short(sh).toString() + "\n";
            s = s + "    rcode: " + new Integer(this.getRCODE()).toString() + "\n";
            s = s + "  num Questions : " + new Short(this.numQuestions).toString() + "\n  num Answers   : " + new Short(this.numAnswers).toString() + "\n  num Authority : " + new Short(this.numAuthority).toString() + "\n  num Additional: " + new Short(this.numAdditional).toString() + "\n";
            return s;
        }

        static /* synthetic */ short access$408(Header x0) {
            short s = x0.numAdditional;
            x0.numAdditional = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$108(Header x0) {
            short s = x0.numQuestions;
            x0.numQuestions = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$208(Header x0) {
            short s = x0.numAnswers;
            x0.numAnswers = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$308(Header x0) {
            short s = x0.numAuthority;
            x0.numAuthority = (short)(s + 1);
            return s;
        }
    }
}

