/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.asynch;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.AsynchronousWorkListener;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.servlet.sip.SipServletResponse;

public class AsynchronousWorkTaskListener
implements AsynchronousWorkListener {
    private static final LogMgr c_logger = Log.get(AsynchronousWorkTaskListener.class);
    private SipServletRequestImpl _sipRequest = null;
    public static final String CONTENT_TYPE = "asynchwork/type";

    public AsynchronousWorkTaskListener(SipServletRequestImpl request) {
        this._sipRequest = request;
    }

    @Override
    public void onCompleted(Serializable result) {
        block6: {
            if (this._sipRequest != null) {
                try {
                    SipServletResponse response = this._sipRequest.createResponse(200);
                    if (result != null) {
                        response.setContent(this.dataToByteArray(result), CONTENT_TYPE);
                    }
                    response.send();
                }
                catch (UnsupportedEncodingException e2) {
                    if (c_logger.isErrorEnabled()) {
                        c_logger.error("error.exception.UnsupportedEncodingException", "Request.COMPLETED", null, (Throwable)e2);
                    }
                }
                catch (IOException e3) {
                    if (!c_logger.isErrorEnabled()) break block6;
                    c_logger.error("error.exception.io", "Request.COMPLETED", null, (Throwable)e3);
                }
            }
        }
    }

    private byte[] dataToByteArray(Serializable obj) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "dataToByteArray", new Object[]{obj});
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(obj);
        byte[] bits = bout.toByteArray();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "dataToByteArray", (Object)bits);
        }
        return bits;
    }

    @Override
    public void onFailed(int reasonCode, String reason) {
        block5: {
            if (this._sipRequest != null) {
                try {
                    SipServletResponse response = this._sipRequest.createResponse(reasonCode, reason);
                    response.send();
                }
                catch (UnsupportedEncodingException e2) {
                    if (c_logger.isErrorEnabled()) {
                        c_logger.error("error.exception.UnsupportedEncodingException", "Request.COMPLETED", null, (Throwable)e2);
                    }
                }
                catch (IOException e3) {
                    if (!c_logger.isErrorEnabled()) break block5;
                    c_logger.error("error.exception.io", "Request.COMPLETED", null, (Throwable)e3);
                }
            }
        }
    }
}

