/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.parser;

import com.ibm.ws.sip.container.parser.SecurityResourceCollection;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.rules.Condition;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SipServletDesc {
    private SipAppDesc m_sipApp;
    private String m_className;
    private String m_name;
    private int m_servletLoadOnStartup;
    private boolean m_hasLoadOnStartupTag;
    private Map<String, String> m_initParams = new LinkedHashMap<String, String>();
    private Condition m_condition;
    private List m_securityResourceCollections = new LinkedList();
    private boolean isMainServlet = false;

    public SipServletDesc(SipAppDesc app, String name, String className) {
        this.m_sipApp = app;
        this.m_name = name;
        this.m_className = className;
    }

    public SipServletDesc(SipAppDesc app, String name, String className, boolean mainServlet, int servletLoadOnStartup, boolean hasLoadOnStartupTag) {
        this.m_sipApp = app;
        this.m_name = name;
        this.m_className = className;
        this.m_servletLoadOnStartup = servletLoadOnStartup;
        this.m_hasLoadOnStartupTag = hasLoadOnStartupTag;
        this.isMainServlet = mainServlet;
    }

    public SipServletDesc(SipAppDesc app, String name, String className, int servletLoadOnStartup, boolean hasLoadOnStartupTag) {
        this.m_sipApp = app;
        this.m_name = name;
        this.m_className = className;
        this.m_servletLoadOnStartup = servletLoadOnStartup;
        this.m_hasLoadOnStartupTag = hasLoadOnStartupTag;
    }

    public String getName() {
        return this.m_name;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(64);
        b.append(this.m_name);
        b.append("(");
        b.append(this.m_className);
        b.append(")");
        return b.toString();
    }

    public Condition getTriggeringRule() {
        return this.m_condition;
    }

    public void setTriggeringCondition(Condition condition) {
        this.m_condition = condition;
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof SipServletDesc) {
            SipServletDesc other = (SipServletDesc)obj;
            if (other.m_className.equals(this.m_className) && other.m_name.equals(this.m_name)) {
                rc = true;
            }
        }
        return rc;
    }

    public int hashCode() {
        return this.m_name.hashCode() ^ this.m_className.hashCode();
    }

    public SipAppDesc getSipApp() {
        return this.m_sipApp;
    }

    public void addSecurityResourceCollection(SecurityResourceCollection collection) {
        this.m_securityResourceCollections.add(collection);
    }

    public boolean isServletLoadOnStartup() {
        return this.m_servletLoadOnStartup >= 0;
    }

    public int getServletLoadOnStartup() {
        return this.m_servletLoadOnStartup;
    }

    public void setServletLoadOnStartup(int servletLoadOnStartup) {
        if (!this.m_hasLoadOnStartupTag) {
            this.m_hasLoadOnStartupTag = true;
            this.m_servletLoadOnStartup = servletLoadOnStartup;
        }
    }

    public Map<String, String> getInitParams() {
        return this.m_initParams;
    }

    public void setInitParam(String paramName, String paramValue) {
        this.m_initParams.put(paramName, paramValue);
    }

    public List getSecurityResourceCollections() {
        return this.m_securityResourceCollections;
    }

    public boolean isMainServlet() {
        return this.isMainServlet;
    }

    public void setMainServlet(boolean isMainServlet) {
        this.isMainServlet = isMainServlet;
    }
}

