/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.AsynchronousWork;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jain.protocol.ip.sip.SipProviderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.appqueue.MessageDispatcher;
import com.ibm.ws.sip.container.asynch.AsynchronousWorkTask;
import com.ibm.ws.sip.container.asynch.AsynchronousWorkTaskListener;
import com.ibm.ws.sip.container.asynch.AsynchronousWorkTasksManager;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.matching.SipServletsMatcher;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.pmi.LoadManager;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.router.ApplicationPathSelector;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.router.SipServletInvokerListener;
import com.ibm.ws.sip.container.router.tasks.EmulateProxyRoute;
import com.ibm.ws.sip.container.router.tasks.InitialRequestRoutedTask;
import com.ibm.ws.sip.container.router.tasks.ResponseRoutedTask;
import com.ibm.ws.sip.container.router.tasks.RoutedTask;
import com.ibm.ws.sip.container.router.tasks.StrayResponseRoutedTask;
import com.ibm.ws.sip.container.router.tasks.SubsequentRequestRoutedTask;
import com.ibm.ws.sip.container.router.tasks.TimeoutRoutedTask;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.sessions.SipTransactionUserTable;
import com.ibm.ws.sip.container.transaction.ClientTransaction;
import com.ibm.ws.sip.container.transaction.ServerTransaction;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.transaction.TransactionTable;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.util.ThreadContextInputStream;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.container.was.WebsphereInvoker;
import com.ibm.ws.webcontainer.webapp.WebApp;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.TransactionDoesNotExistException;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ParametersHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.message.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import javax.servlet.sip.ar.SipTargetedRequestType;

public class SipRouter {
    private static final LogMgr c_logger = Log.get(SipRouter.class);
    private static SipRouter s_instance = new SipRouter();
    private WebsphereInvoker m_sipletsInvoker;
    private ApplicationPathSelector appPathSelector;
    private SipTransactionUserTable m_transactionUserTable = SipTransactionUserTable.getInstance();
    private TransactionTable m_transactionTable = TransactionTable.getInstance();
    private boolean m_initialized = false;

    private SipRouter() {
    }

    public static SipRouter getInstance() {
        return s_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(SipApplicationRouter applicationRouter) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "initialize");
        }
        SipRouter sipRouter = this;
        synchronized (sipRouter) {
            if (this.m_initialized) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "initialize", "The SIP Router has already been initialized");
                }
                return;
            }
            this.m_initialized = true;
            SipServletsMatcher sipletMatcher = new SipServletsMatcher();
            this.appPathSelector = new ApplicationPathSelector(sipletMatcher, applicationRouter);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "initialize");
        }
    }

    public void setInvoker(WebsphereInvoker invoker) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "setInvoker", (Object)("Invoker=" + invoker));
        }
        this.m_sipletsInvoker = invoker;
    }

    public void stop() {
        if (this.m_sipletsInvoker != null) {
            this.m_sipletsInvoker.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(SipServletRequestImpl request) {
        block11: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "handleRequest", (Object)("Request=" + request.getMethod() + " ,callID=" + request.getCallId()));
            }
            try {
                PerformanceMgr perfMgr = PerformanceMgr.getInstance();
                if (perfMgr != null) {
                    perfMgr.requestReceived();
                }
                request.setArrivedTime(System.currentTimeMillis());
                try {
                    if (request.getMethod().equals("CANCEL")) {
                        this.handleCancelRequest(request);
                        break block11;
                    }
                    if (SipUtil.isSubsequestRequest(request.getMethod())) {
                        this.handleSubsequentRequest(request);
                        break block11;
                    }
                    if (request.getMethod().equals("ACK")) {
                        this.handleAckRequest(request);
                        break block11;
                    }
                    this.handleInitialRequest(request);
                }
                catch (IllegalStateException e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.container.router.SipRouter.handleRequest", (String)"1");
                }
            }
            finally {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit(this, "handleRequest");
                }
            }
        }
    }

    private void handleInitialRequest(SipServletRequestImpl request) {
        TransactionUserWrapper transactionUser = this.m_transactionUserTable.getTransactionUserForInboundRequest(request);
        if ((request.getHeader("Join") != null || request.getHeader("Replaces") != null) && transactionUser == null) {
            this.handleJoinReplaceRequest(request);
        } else if (request.getMethod().equals("ASYNWORK")) {
            this.handleAsynchWorkRequest(request);
        } else {
            String toTag;
            ServerTransaction serverTransaction = null;
            if (!this.validateInitalDialogRequest(request)) {
                SipRouter.sendErrorResponse(request, 400);
                return;
            }
            if (transactionUser == null && (toTag = request.getRequest().getToHeader().getTag()) != null) {
                SipRouter.sendErrorResponse(request, 481);
                SipRouter.forwardUnmatchedRequest(request);
                return;
            }
            serverTransaction = this.m_transactionTable.createServerTransaction(request);
            this.handleRequest(request, transactionUser, serverTransaction);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "handleRequest");
            }
        }
    }

    private boolean validateInitalDialogRequest(SipServletRequestImpl request) {
        if (SipUtil.isDialogInitialRequest(request.getMethod())) {
            if (request.getHeader("Contact") == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "validateInitalDialogRequest", "This is dialog inital request - should contain CONTACT header");
                }
                return false;
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "validateInitalDialogRequest", "This is not dialog inital request.");
        }
        return true;
    }

    private void handleJoinReplaceRequest(SipServletRequestImpl request) {
        if (this.hasValidJoinReplaceHeaders(request)) {
            try {
                this.processJoinReplaceRequest(request);
            }
            catch (HeaderParseException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "handleJoinReplaceRequest", "The request contains parsing errors for Join/Replace headers");
                }
                SipRouter.sendErrorResponse(request, 400);
            }
            catch (IllegalArgumentException e3) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "handleJoinReplaceRequest", "The request contains parsing errors for Join/Replace headers");
                }
                SipRouter.sendErrorResponse(request, 400);
            }
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleJoinReplaceRequest", "The request contains illegal number of Join/Replace headers");
            }
            SipRouter.sendErrorResponse(request, 400);
        }
    }

    private void processJoinReplaceRequest(SipServletRequestImpl request) throws HeaderParseException, IllegalArgumentException {
        boolean isJoin = false;
        ParametersHeader header = null;
        header = (ParametersHeader)request.getRequest().getHeader("Join", true);
        if (header != null) {
            isJoin = true;
        } else {
            header = (ParametersHeader)request.getRequest().getHeader("Replaces", true);
        }
        TransactionUserWrapper transactionUser = this.m_transactionUserTable.geTUFromJoinReplace(header);
        if (transactionUser != null) {
            if (!transactionUser.isTerminated()) {
                if (transactionUser.getInitialDialogMethod().equals("INVITE")) {
                    this.processJoinReplace(request, transactionUser, header, isJoin);
                } else {
                    SipRouter.sendErrorResponse(request, 481);
                    SipRouter.forwardUnmatchedRequest(request);
                }
            } else {
                SipRouter.sendErrorResponse(request, 603);
            }
        } else {
            this.processJoinReplace(request, header, isJoin);
        }
    }

    private void processJoinReplace(SipServletRequestImpl request, ParametersHeader header, boolean isJoin) {
        boolean foundSession = false;
        TransactionUserWrapper transactionUser = null;
        if (isJoin && (transactionUser = this.m_transactionUserTable.getTuAccordingToUri(request)) != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processJoinReplaceRequest", "Request will be processed as subsequent request...");
            }
            this.processSubsequentRequest(request, transactionUser);
            foundSession = true;
        }
        if (!foundSession) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processJoinReplaceRequest", "Failed to find session related session - Forward to Application. Req = " + request);
            }
            request.setIsInital(true);
            this.processLegalJoinReplaceRequest(request, null);
        }
    }

    private void processJoinReplace(SipServletRequestImpl request, TransactionUserWrapper transactionUser, ParametersHeader header, boolean isJoin) {
        try {
            transactionUser.ensureTUActive();
            boolean toContinue = true;
            if (!isJoin) {
                if (transactionUser.getState() == SipSession.State.CONFIRMED) {
                    if (header.getParameter("early-only") != null) {
                        SipRouter.sendErrorResponse(request, 486);
                        toContinue = false;
                    }
                } else if (transactionUser.getState() == SipSession.State.EARLY && transactionUser.isServerTransaction()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "processJoinReplace", "State is EARLY but container is notthe initiator of this request");
                    }
                    toContinue = false;
                }
            }
            if (toContinue) {
                this.processLegalJoinReplaceRequest(request, transactionUser);
            } else {
                SipRouter.sendErrorResponse(request, 481);
                SipRouter.forwardUnmatchedRequest(request);
            }
        }
        catch (IllegalStateException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("The Dialog was already terminated = ");
                buff.append(transactionUser);
                c_logger.traceDebug(this, "processJoinReplaceRequest", buff.toString());
            }
            SipRouter.sendErrorResponse(request, 603);
        }
    }

    private void processLegalJoinReplaceRequest(SipServletRequestImpl request, TransactionUserWrapper transactionUser) {
        TransactionUserWrapper tuForNewIncomingRequest = null;
        SipApplicationSessionImpl appSession = null;
        String relatedHeader = null;
        SipServletDesc sipDesc = null;
        if (transactionUser != null) {
            String applicationName = "";
            SipTargetedRequestType sipTargetedRequestType = null;
            if (request.getHeader("Join") != null) {
                sipTargetedRequestType = SipTargetedRequestType.JOIN;
                relatedHeader = "Join";
            }
            if (request.getHeader("Replaces") != null) {
                sipTargetedRequestType = SipTargetedRequestType.REPLACES;
                relatedHeader = "Replaces";
            }
            applicationName = transactionUser.getAppName();
            SipTargetedRequestInfo sipTargetedRequestInfo = new SipTargetedRequestInfo(sipTargetedRequestType, applicationName);
            sipDesc = this.appPathSelector.findSippletMatch(request, sipTargetedRequestInfo);
        } else {
            sipDesc = this.appPathSelector.findSippletMatch(request, null);
        }
        if (transactionUser != null) {
            appSession = (SipApplicationSessionImpl)transactionUser.getApplicationSession(true);
            if (sipDesc != null && sipDesc.getSipApp() == appSession.getAppDescriptor()) {
                tuForNewIncomingRequest = this.m_transactionUserTable.createTransactionUserWrapper(request, true, appSession, appSession != null);
                SipSession sipsession = transactionUser.getSipSessionFromBase(true);
                tuForNewIncomingRequest.setRelatedSessionData(sipsession.getId(), relatedHeader);
            } else if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Matched application = ");
                buff.append(sipDesc);
                buff.append(" different then related to the TU according to Replaces / Join header, app = ");
                buff.append(appSession.getAppDescriptor());
                c_logger.traceDebug(this, "processLegalJoinReplaceRequest", buff.toString());
            }
        }
        if (tuForNewIncomingRequest == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processLegalJoinReplaceRequest", "Create a new TU for this incoming request");
            }
            tuForNewIncomingRequest = this.m_transactionUserTable.createTransactionUserWrapper(request, true, null, appSession != null);
        }
        ServerTransaction serverTransaction = this.m_transactionTable.createServerTransaction(request);
        request.setTransaction(serverTransaction);
        request.setIsInital(true);
        InitialRequestRoutedTask task = InitialRequestRoutedTask.getInstance(tuForNewIncomingRequest, serverTransaction, request, sipDesc);
        if (task != null) {
            MessageDispatcher.dispatchRoutedTask(task);
        }
    }

    private boolean hasValidJoinReplaceHeaders(SipServletRequestImpl request) {
        boolean isOK = true;
        boolean hasJoinHeader = false;
        if (request.getMethod() == "INVITE") {
            ListIterator headers = request.getHeaders("Join");
            if (headers != null && headers.hasNext()) {
                hasJoinHeader = true;
                headers.next();
                if (headers.hasNext()) {
                    isOK = false;
                }
            }
            if (isOK && (headers = request.getHeaders("Replaces")) != null && headers.hasNext()) {
                if (hasJoinHeader) {
                    isOK = false;
                } else {
                    headers.next();
                    if (headers.hasNext()) {
                        isOK = false;
                    }
                }
            }
        } else {
            isOK = false;
        }
        if (!isOK && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "hasMultipleJoinReplaceHeaders", "This request has illegal number of Join / Replace headers.");
        }
        return isOK;
    }

    private void handleAckRequest(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "handleAckRequest");
        }
        TransactionUserWrapper transactionUser = null;
        ServerTransaction serverTransaction = null;
        serverTransaction = (ServerTransaction)this.m_transactionTable.getTransaction(request.getTransactionId());
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "handleAckRequest", "serverTransaction=" + serverTransaction);
        }
        if (null == serverTransaction) {
            transactionUser = this.m_transactionUserTable.getTransactionUserForInboundRequest(request);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAckRequest", "serverTransaction=null tranasctionUser=" + transactionUser);
            }
            if (transactionUser != null) {
                serverTransaction = this.m_transactionTable.createServerTransaction(request);
            }
        } else {
            ((IncomingSipServletRequest)request).setAckOnErrorResponse(true);
            transactionUser = serverTransaction.getOriginalRequest().getTransactionUser();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAckRequest", "serverTransaction=" + serverTransaction + " tranasctionUser=" + transactionUser + " on the error response");
            }
        }
        this.handleRequest(request, transactionUser, serverTransaction);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleAckRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsynchTimeOut(SipTransaction transaction) {
        AsynchronousWorkTask task;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "handleAsynchTimeOut");
        }
        TransactionUserWrapper transactionUser = transaction.getOriginalRequest().getTransactionUser();
        String callid = transaction.getOriginalRequest().getCallId();
        if (transaction instanceof ClientTransaction) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAsynchTimeOut", "removing transaction from table, call-id: " + callid);
            }
            ((ClientTransaction)transaction).clearTransaction();
            ThreadLocalStorage.cleanTuForInvalidate();
        }
        if ((task = AsynchronousWorkTasksManager.instance().getAsynchronousWorkTask(callid)) == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAsynchTimeOut", "Can not find AsynchronousWorkTask for call-id" + callid);
            }
            return;
        }
        try {
            task.sendFailedResponse(408);
        }
        finally {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAsynchTimeOut", "Response is sent. Removing AsynchronousWorkTask for call-id" + callid);
            }
            AsynchronousWorkTasksManager.instance().removeAsynchronousWorkTask(callid);
            transactionUser.invalidateTU(true, true);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleAsynchTimeOut");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsynchWorkResponse(SipServletResponse response, SipTransaction transaction) {
        AsynchronousWorkTask task;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "handleAsynchWorkResponse");
        }
        TransactionUserWrapper transactionUser = transaction.getOriginalRequest().getTransactionUser();
        if (transaction instanceof ClientTransaction) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAsynchWorkResponse", "removing transaction from table, call-id: " + response.getCallId());
            }
            ((ClientTransaction)transaction).clearTransaction();
            ThreadLocalStorage.cleanTuForInvalidate();
        }
        if ((task = AsynchronousWorkTasksManager.instance().getAsynchronousWorkTask(response.getCallId())) == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAsynchWorkResponse", "Can not find AsynchronousWorkTask for call-id" + response.getCallId());
            }
            return;
        }
        ClassLoader currentThreadClassLoader = null;
        currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(task.getCl());
        try {
            if (this.is2xx(response.getStatus())) {
                byte[] data = response.getRawContent();
                Serializable obj = null;
                if (data != null) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(data);
                    ThreadContextInputStream ois = new ThreadContextInputStream(bin);
                    obj = (Serializable)ois.readObject();
                }
                task.sendCompletedResponse(obj);
            } else {
                task.sendFailedResponse(response.getStatus());
            }
        }
        catch (IOException e2) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.io", "Other", null, (Throwable)e2);
            }
        }
        catch (ClassNotFoundException e3) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.cnf", "Other", null, (Throwable)e3);
            }
        }
        finally {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleAsynchWorkResponse", "Response is sent. Removing AsynchronousWorkTask for call-id" + response.getCallId());
            }
            AsynchronousWorkTasksManager.instance().removeAsynchronousWorkTask(response.getCallId());
            if (currentThreadClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
            }
            transactionUser.invalidateTU(true, true);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleAsynchWorkResponse");
        }
    }

    private void handleAsynchWorkRequest(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "handleAsynchWorkRequest");
        }
        ServerTransaction serverTransaction = this.m_transactionTable.createServerTransaction(request);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "handleAsynchWorkRequest", "serverTransaction=" + serverTransaction);
        }
        request.setTransaction(serverTransaction);
        this.processAsynchWorkRequest(request);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleAsynchWorkRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsynchWorkRequest(SipServletRequestImpl request) {
        if (this.isRetransmission(request)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processAsynchWorkRequest", "Got retrasmitted asynchronois work request, do nothing");
            }
            return;
        }
        byte[] body = request.getMessage().getBodyAsBytes();
        SipURI uri = (SipURI)request.getRequestURI();
        String appSessionId = uri.getParameter("ibmappid");
        SipApplicationSessionImpl sipAppSession = SipApplicationSessionImpl.getAppSession(appSessionId);
        TransactionUserWrapper transactionUser = this.m_transactionUserTable.createTransactionUserWrapper(request, true, null, false);
        request.setTransactionUser(transactionUser);
        ContextEstablisher contextEstablisher = null;
        ClassLoader currentThreadClassLoader = null;
        Object obj = null;
        try {
            if (sipAppSession == null) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("SipApplicationSession wasn't found for id:" + appSessionId);
                }
                SipRouter.sendErrorResponse(request, 481);
                return;
            }
            String appName = sipAppSession.getApplicationId();
            SipAppDesc sipAD = SipContainer.getInstance().getRouter().getSipApp(appName);
            ByteArrayInputStream bin = new ByteArrayInputStream(body);
            ThreadContextInputStream tcis = new ThreadContextInputStream(bin);
            contextEstablisher = sipAD.getContextEstablisher();
            if (contextEstablisher != null) {
                currentThreadClassLoader = contextEstablisher.getThreadCurrentClassLoader();
                contextEstablisher.establishContext();
            }
            if ((obj = tcis.readObject()) != null) {
                ((AsynchronousWork)obj).dispatch(new AsynchronousWorkTaskListener(request));
            }
            if (contextEstablisher != null) {
                contextEstablisher.removeContext(currentThreadClassLoader);
            }
        }
        catch (IOException e2) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.io", "Other", null, (Throwable)e2);
            }
        }
        catch (ClassNotFoundException e3) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.cnf", "Other", null, (Throwable)e3);
            }
        }
        finally {
            if (obj != null) {
                ((AsynchronousWork)obj).dispatch(new AsynchronousWorkTaskListener(request));
            }
            if (contextEstablisher != null) {
                contextEstablisher.removeContext(currentThreadClassLoader);
            }
        }
    }

    private boolean isRetransmission(SipServletRequestImpl request) {
        return AsynchronousWorkTasksManager.instance().getAsynchronousWorkTask(request.getCallId()) != null;
    }

    private void handleSubsequentRequest(SipServletRequestImpl request) {
        TransactionUserWrapper transactionUser = null;
        transactionUser = this.m_transactionUserTable.getTransactionUserForInboundRequest(request);
        if (transactionUser == null) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Unable to find dialog for Subsequent request ");
                buff.append(request.getMethod());
                buff.append(" with Call-Id");
                buff.append(request.getCallId());
                c_logger.traceDebug(this, "handleSubsequentRequest", buff.toString());
            }
            if (request.getMethod().equals("NOTIFY")) {
                this.handleInitialRequest(request);
                return;
            }
            SipRouter.sendErrorResponse(request, 481);
            SipRouter.forwardUnmatchedRequest(request);
        } else {
            if (transactionUser.isTransactionUserInvalidated() || transactionUser.isInvalidating()) {
                if (request.getMethod().equals("ACK")) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "handleSubsequentRequest", "ACK request (callid=" + request.getCallId() + ")will not be processed since " + transactionUser + " was already invalidated");
                    }
                    return;
                }
                SipRouter.sendErrorResponse(request, 481);
                SipRouter.forwardUnmatchedRequest(request);
                return;
            }
            this.processSubsequentRequest(request, transactionUser);
        }
    }

    private void processSubsequentRequest(SipServletRequestImpl request, TransactionUserWrapper transactionUser) {
        boolean isInitial;
        ServerTransaction serverTransaction = null;
        boolean bl = isInitial = transactionUser.getState() == SipSession.State.INITIAL;
        if (isInitial && !request.getMethod().equals("NOTIFY")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processSubsequentRequest", "found sub request on a dialog in INITIAL state. aborting. returning 481");
            }
            SipRouter.sendErrorResponse(request, 481);
            SipRouter.forwardUnmatchedRequest(request);
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processSubsequentRequest", "state initial " + isInitial + " ,request method: " + request.getMethod());
        }
        if (transactionUser.getState() != SipSession.State.CONFIRMED && !SipUtil.canReceiveOnDialog(request.getMethod(), transactionUser) && c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("This dialog is not confirmed yet. Is it UAS = ");
            buff.append(transactionUser.isServerTransaction());
            c_logger.traceDebug(this, "handleSubsequentRequest", buff.toString());
        }
        serverTransaction = this.m_transactionTable.createServerTransaction(request);
        this.handleRequest(request, transactionUser, serverTransaction);
    }

    private void handleCancelRequest(SipServletRequestImpl request) {
        TransactionUserWrapper transactoinUser = null;
        ServerTransaction serverTransaction = null;
        RequestImpl jainReq = (RequestImpl)request.getRequest();
        long trId = jainReq.getOriginInviteTransaction();
        ServerTransaction inviteTr = (ServerTransaction)this.m_transactionTable.getTransaction(trId);
        if (null != inviteTr) {
            transactoinUser = inviteTr.getOriginalRequest().getTransactionUser();
        }
        if (transactoinUser == null) {
            transactoinUser = this.m_transactionUserTable.getTransactionUserForInboundRequest(request);
        }
        if (transactoinUser != null && !transactoinUser.isInvalidating()) {
            serverTransaction = this.m_transactionTable.createServerTransaction(request);
            this.handleRequest(request, transactoinUser, serverTransaction);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRequest", "Error processing CANCEL request, unmatched INVITE transaction");
            }
            SipRouter.sendErrorResponse(request, 481);
            SipRouter.forwardUnmatchedRequest(request);
        }
    }

    private boolean handleContainerWarningsAndErrors(SipServletRequestImpl request, TransactionUserWrapper transactionUser, ServerTransaction serverTransaction) {
        if (null == serverTransaction) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRequest", "Error processing request, unmatched transaction/dialog");
            }
            if (!request.getMethod().equals("ACK")) {
                SipRouter.sendErrorResponse(request, 487);
            }
            return true;
        }
        if (LoadManager.getInstance().shouldThrowMsgs() && transactionUser == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRequest", "The container is overload - error will be sent...");
            }
            if (!request.getMethod().equals("ACK")) {
                SipRouter.sendErrorResponse(request, 480);
            }
            return true;
        }
        if (SipContainer.getInstance().isInQuiesce()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRequest", "Container in QUIESCE_MODE. No new calls are allowed - error will be sent...");
            }
            SipRouter.sendErrorResponse(request, 503);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "handleRequest");
            }
            return true;
        }
        return false;
    }

    private void handleRequest(SipServletRequestImpl request, TransactionUserWrapper transactionUser, ServerTransaction serverTransaction) {
        request.setTransaction(serverTransaction);
        SipServletDesc sipDesc = null;
        if (this.handleContainerWarningsAndErrors(request, transactionUser, serverTransaction)) {
            return;
        }
        RoutedTask task = null;
        if (transactionUser != null) {
            task = SubsequentRequestRoutedTask.getInstance(transactionUser, serverTransaction, request);
        } else {
            request.setIsInital(true);
            SipApplicationSessionImpl sipApplication = SipUtil.getApplicationSessionAccordingToEncodedUri(request);
            SipTargetedRequestInfo sipTargetedRequestInfo = null;
            String applicationName = null;
            if (sipApplication != null) {
                Serializable stateInfo = (Serializable)sipApplication.getAttribute("com.ibm.ws.sip.ibm.state.info");
                if (stateInfo != null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "handleRequest", "handling route back request with stateInfo: " + stateInfo);
                    }
                    request.setStateInfo(stateInfo);
                    request.setDirective(SipApplicationRoutingDirective.CONTINUE);
                    sipApplication.invalidate();
                    sipApplication = null;
                } else {
                    applicationName = sipApplication.getAppDescriptor().getApplicationName();
                    sipTargetedRequestInfo = new SipTargetedRequestInfo(SipTargetedRequestType.ENCODED_URI, applicationName);
                }
            }
            if ((sipDesc = this.appPathSelector.findSippletMatch(request, sipTargetedRequestInfo)) == null && !request.isExternalRoute()) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.mapping.to.nonexisting.siplet", "Request", new Object[]{"Method=" + request.getMethod() + ", callID=" + request.getCallId(), "Unknown"});
                }
                int errorCode = PropertiesStore.getInstance().getProperties().getInt("sipNoRouteErrorCode");
                SipRouter.sendErrorResponse(request, errorCode);
                return;
            }
            if (request.isExternalRoute()) {
                transactionUser = this.m_transactionUserTable.createTransactionUserWrapper(request, true, sipApplication, sipApplication != null);
                request.setTransactionUser(transactionUser);
                task = EmulateProxyRoute.getInstance(request);
            }
            if (null != sipDesc) {
                if (applicationName != null && !applicationName.equals(sipDesc.getSipApp().getApplicationName())) {
                    sipApplication = null;
                }
                String sipAppKeyBase = null;
                if (sipDesc.getSipApp().isJSR289Application() && sipApplication == null) {
                    sipAppKeyBase = SipUtil.getKeyBaseTargetingKey(sipDesc.getSipApp(), request);
                    if (sipAppKeyBase != null) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "handleRequest", "found session key base key: " + sipAppKeyBase);
                        }
                        String sipAppID = SessionRepository.getInstance().getKeyBaseAppSession(sipAppKeyBase);
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "handleRequest", "sipAppID = " + sipAppID);
                        }
                        if (sipAppID != null) {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug(this, "handleRequest", "found session app id: " + sipAppID);
                            }
                            sipApplication = SipApplicationSessionImpl.getAppSession(sipAppID);
                        }
                    } else if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "handleRequest", "There is no session key method defined for this application");
                    }
                }
                transactionUser = this.m_transactionUserTable.createTransactionUserWrapper(request, true, sipApplication, sipApplication != null);
                request.setTransactionUser(transactionUser);
                if (sipAppKeyBase != null && sipApplication == null) {
                    transactionUser.setSessionKeyBase(sipAppKeyBase);
                }
                task = InitialRequestRoutedTask.getInstance(transactionUser, serverTransaction, request, sipDesc);
            }
        }
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null && PropertiesStore.getInstance().getProperties().getBoolean("pmiCountAllMessages")) {
            perfMgr.updatePmiInRequest(request.getMethod(), transactionUser, sipDesc);
        }
        if (task != null) {
            MessageDispatcher.dispatchRoutedTask(task);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleRequest");
        }
    }

    public static void sendErrorResponse(SipServletRequestImpl request, int response) {
        SipRouter.sendErrorResponse(request, response, null);
    }

    public static void sendErrorResponse(SipServletRequestImpl request, int response, String reasonPhrase) {
        block22: {
            try {
                String toTag;
                PerformanceMgr perfMgr;
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry((Object)SipRouter.class, "com.ibm.ws.sip.container.router.SipRouter.sendErrorResponse", (Object)response);
                }
                if ((perfMgr = PerformanceMgr.getInstance()) != null) {
                    perfMgr.updateRejectedMessagesCounter();
                }
                if ((toTag = request.getRequest().getToHeader().getTag()) == null || toTag.length() == 0) {
                    String tag = null;
                    if (request.getTransactionUser() != null) {
                        tag = request.getTransactionUser().generateLocalTag();
                    } else {
                        StringBuilder builder = new StringBuilder();
                        builder.append(Math.random());
                        tag = builder.substring(2);
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(SipRouter.class, "com.ibm.ws.sip.container.router.SipRouter.sendErrorResponse", "To-Tag was added to an error initial request, tag:" + tag);
                    }
                    request.getRequest().getToHeader().setTag(tag);
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(SipRouter.class, "com.ibm.ws.sip.container.router.SipRouter.sendErrorResponse", "To-Tag was found, no need to add to-tag, tag:" + toTag);
                }
                request.getSipProvider().sendResponse(request.getTransactionId(), response, reasonPhrase);
                boolean avayaDebug = PropertiesStore.getInstance().getProperties().getBoolean("avaya.debug.load");
                TransactionTable transactionTable = TransactionTable.getInstance();
                SipTransaction transaction = request.getTransaction();
                if (transaction == null) {
                    if (avayaDebug) {
                        System.out.println("transaction was not found on request when sending error: " + response);
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug((Object)null, "sendErrorResponse", "transaction was not found on request when sending error: " + response);
                    }
                } else {
                    if (avayaDebug) {
                        System.out.println("removing transaction after error response send: " + response);
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug((Object)null, "sendErrorResponse", "removing transaction after error response send: " + response);
                    }
                    transaction.markAsTerminated();
                    boolean removed = transactionTable.removeTransaction(transaction);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(SipRouter.class, "sendErrorResponse", "Transaction was removed from table = " + removed);
                    }
                }
            }
            catch (TransactionDoesNotExistException e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.container.router.SipRouter.sendErrorResponse", (String)"1");
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(SipRouter.class, "com.ibm.ws.sip.container.router.SipRouter.sendErrorResponse", "error.sending.response", e2);
                }
            }
            catch (SipParseException e3) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.sending.response", "Create", null, (Throwable)e3);
                }
            }
            catch (SipException e4) {
                if (!c_logger.isErrorEnabled()) break block22;
                c_logger.error("error.sending.response", "Create", null, (Throwable)e4);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SipRouter.class, "com.ibm.ws.sip.container.router.SipRouter.sendErrorResponse");
        }
    }

    public void handleResponse(SipServletResponseImpl response) {
        SipTransaction transaction;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "handleResponse");
        }
        response.setArrivedTime(System.currentTimeMillis());
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null) {
            perfMgr.responseReceived();
        }
        if (null == (transaction = this.m_transactionTable.getTransaction(response.getTransactionId()))) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleResponse", "got response for null transaction: " + response);
            }
        } else if (response.getMessage().getCSeqHeader().getMethod().equals("ASYNWORK")) {
            this.handleAsynchWorkResponse(response, transaction);
        } else {
            int generatedContainerErrorOnToTagDuplication;
            TransactionUserWrapper transactionUser = transaction.getOriginalRequest().getTransactionUser();
            String sessionId = null;
            Response resp = (Response)response.getMessage();
            if (transactionUser == null) {
                sessionId = this.m_transactionUserTable.getTransactionUserIdAccordingToTopVia(resp);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "handleResponse", "Retrieved TU from response: " + sessionId);
                }
            }
            if ((generatedContainerErrorOnToTagDuplication = PropertiesStore.getInstance().getProperties().getInt("generatedContainerErrorOnToTagDuplication")) != 0) {
                this.detectDuplicatedToTag(response, transaction, generatedContainerErrorOnToTagDuplication);
            }
            ResponseRoutedTask task = sessionId != null ? ResponseRoutedTask.getInstance(transaction, sessionId, response) : ResponseRoutedTask.getInstance(transaction, transactionUser, response);
            MessageDispatcher.dispatchRoutedTask(task);
            if (perfMgr != null && PropertiesStore.getInstance().getProperties().getBoolean("pmiCountAllMessages")) {
                perfMgr.updatePmiInResponse(response.getStatus(), transactionUser);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleResponse");
        }
    }

    private void detectDuplicatedToTag(SipServletResponseImpl response, SipTransaction transaction, int generatedContainerErrorOnToTagDuplication) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "detectDuplicatedToTag");
        }
        Response resp = (Response)response.getMessage();
        String sessId = this.m_transactionUserTable.getTransactionUserIdAccordingToTopVia(resp);
        String fromTag = resp.getFromHeader().getTag();
        String toTag = resp.getToHeader().getTag();
        if (fromTag != null && toTag != null && sessId != null) {
            TUKey key = ThreadLocalStorage.getTUKey();
            key.setup(fromTag, toTag, sessId, true);
            TransactionUserWrapper respTuw = SessionRepository.getInstance().getTuWrapper(key);
            if (respTuw != null && transaction instanceof ClientTransaction) {
                ClientTransaction clientTran;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "detectDuplicatedToTag", "Found the same transaction of the response already exist in client transaction mode");
                }
                if ((clientTran = (ClientTransaction)transaction).getListener() instanceof ProxyBranchImpl) {
                    ProxyBranchImpl pbi = (ProxyBranchImpl)clientTran.getListener();
                    try {
                        if (!pbi.getBranchId().equals(respTuw.getBranch().getBranchId()) && c_logger.isErrorEnabled()) {
                            c_logger.error("error.same.to.tag");
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug("Detected 2 responses for proxy with the same to-tag in different branches! branch1=  " + pbi.getBranchId() + ", branch2= " + respTuw.getBranch().getBranchId());
                            }
                            response.setStatus(generatedContainerErrorOnToTagDuplication, "Invalid dialog ID received");
                            ToHeader toHeader = resp.getToHeader();
                            toHeader.setTag(this.generateToHeaderForSameToTag(toHeader.getTag()));
                            resp.setToHeader(toHeader);
                        }
                    }
                    catch (SipParseException e2) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "detectDuplicatedToTag", "parse error: " + e2.getMessage(), e2);
                        }
                        return;
                    }
                    catch (IllegalArgumentException e3) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "detectDuplicatedToTag", "illegal argument error: " + e3.getMessage(), e3);
                        }
                        return;
                    }
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "detectDuplicatedToTag");
        }
    }

    private String generateToHeaderForSameToTag(String original_duplicated_tag) {
        String generatedToTag = "DuplicatedTag(" + original_duplicated_tag + ")" + System.nanoTime() / 100000L;
        return generatedToTag;
    }

    public void handleTimeout(long transactionId) {
        SipTransaction transaction;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{Long.toString(transactionId)};
            c_logger.traceEntry((Object)this, "handleTimeout", params);
        }
        if (null != (transaction = this.m_transactionTable.getTransaction(transactionId))) {
            if (transaction.getOriginalRequest().getMethod().equals("ASYNWORK")) {
                this.handleAsynchTimeOut(transaction);
            } else {
                TimeoutRoutedTask task = TimeoutRoutedTask.getInstance(transaction);
                MessageDispatcher.dispatchRoutedTask(task);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "handleTimeout", "Timeout for non existing transaction, " + transactionId);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleTimeout");
        }
    }

    public void invokeSipServlet(SipServletRequest request, SipServletResponse response, SipServletDesc sipServletDescParam, SipServletInvokerListener listener) {
        SipServletDesc sipServletDesc = sipServletDescParam;
        if (null == sipServletDesc) {
            this.appPathSelector.getDefaultHandler();
        }
        if (null != sipServletDesc) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invokeSipServlet", "Invoking Siplet: " + sipServletDesc);
            }
            this.m_sipletsInvoker.invokeSipServlet(request, response, sipServletDesc, listener);
        } else if (c_logger.isErrorEnabled()) {
            c_logger.error("error.default.invoke.siplet.not.found", "Request", null);
        }
    }

    public void unloadAppConfiguration(String appName) {
        if (this.appPathSelector != null) {
            this.appPathSelector.unloadApplicationConfiguration(appName);
        }
    }

    public SipServletDesc getSipletByName(String name) {
        return this.appPathSelector.getSipletByName(name);
    }

    public String checkForApplicationComposition(SipServletRequestImpl request) {
        String nextApplication = null;
        SipServletDesc sipplet = this.appPathSelector.findSippletMatch(request, null);
        if (sipplet != null) {
            nextApplication = sipplet.getSipApp().getApplicationName();
        }
        return nextApplication;
    }

    public LinkedList<SipAppDesc> getAllApps() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getAllApps");
        }
        LinkedList<SipAppDesc> list = null;
        if (this.appPathSelector != null) {
            list = this.appPathSelector.getAllApps();
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getAllApps", "appPathSelector is null");
        }
        return list;
    }

    public SipAppDesc getSipApp(String name) {
        SipAppDesc appDesc = null;
        if (this.appPathSelector != null) {
            appDesc = this.appPathSelector.getSipApp(name);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSipApp", "appPathSelector is null, probably because the SIP Container was not started. Check that there is a SIP module installed.");
        }
        if (appDesc == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSipApp", "Try to get this application from SipAppDescManager.");
            }
            if ((appDesc = SipAppDescManager.getInstance().getSipAppDescByAppName(name)) == null) {
                appDesc = SipAppDescManager.getInstance().getSipAppDesc(name);
            }
        }
        return appDesc;
    }

    public void handleStrayResponses(Response response, SipProvider provider) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "hanldeStrayResponses", response.toString());
        }
        if (!this.isExpectedStrayResponse(response)) {
            SipRouter.forwardUnmatchedResponse(response, provider);
            PerformanceMgr perfMgr = PerformanceMgr.getInstance();
            if (perfMgr != null) {
                perfMgr.updateRejectedMessagesCounter();
            }
            return;
        }
        TransactionUserWrapper transactionUser = this.m_transactionUserTable.getTransactionUserInboundResponse(response);
        StrayResponseRoutedTask task = null;
        if (null != transactionUser) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "hanldeStrayResponses", "Transaction: " + transactionUser.getId());
            }
            task = StrayResponseRoutedTask.getInstance(transactionUser, response, provider, false);
        } else {
            transactionUser = this.m_transactionUserTable.getBaseTUForDerived(response);
            if (transactionUser != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "hanldeStrayResponses", "New derived should be created for base = " + transactionUser.getId());
                }
                task = StrayResponseRoutedTask.getInstance(transactionUser, response, provider, true);
            }
        }
        if (task == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "hanldeStrayResponses", "No transaction");
            }
            SipRouter.sendResponseDirectlyToTransport(provider, response, true);
        } else {
            MessageDispatcher.dispatchRoutedTask(task);
        }
    }

    public static void sendResponseDirectlyToTransport(SipProvider provider, Response response, boolean containsOurVia) {
        block9: {
            PerformanceMgr perfMgr = PerformanceMgr.getInstance();
            if (!response.hasViaHeaders()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(SipRouter.class, "sendResponseDirectlyToTransport", "Dropping response, no via headers available - 1, call Id" + response.getCallIdHeader().getCallId());
                }
                SipRouter.forwardUnmatchedResponse(response, provider);
                if (perfMgr != null) {
                    perfMgr.updateRejectedMessagesCounter();
                }
                return;
            }
            if (containsOurVia) {
                response.removeViaHeader();
                if (!response.hasViaHeaders()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(SipRouter.class, "sendResponseDirectlyToTransport", "Dropping response, no more via headers available - 2, call Id" + response.getCallIdHeader().getCallId());
                    }
                    SipRouter.forwardUnmatchedResponse(response, provider);
                    if (perfMgr != null) {
                        perfMgr.updateRejectedMessagesCounter();
                    }
                    return;
                }
            }
            try {
                ((SipProviderImpl)provider).sendResponse(response);
            }
            catch (SipException e2) {
                if (!c_logger.isErrorEnabled()) break block9;
                c_logger.error("error.exception", "Send Failure", null, (Throwable)e2);
            }
        }
    }

    public static void forwardUnmatchedRequest(SipServletRequestImpl req) {
        if (req == null) {
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(SipRouter.class, "forwardUnmatchedRequest", "Unmatched request" + req);
        }
        IncomingSipServletRequest inReq = (IncomingSipServletRequest)req;
        inReq.setUnmatchedReqeust();
        EventsDispatcher.unmatchedRequestReceived(inReq);
    }

    private static void forwardUnmatchedResponse(Response response, SipProvider provider) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(SipRouter.class, "forwardUnmatchedStrayResponse", "Unmatched response" + response);
        }
        IncomingSipServletResponse servletResponse = new IncomingSipServletResponse(response, -1L, provider);
        servletResponse.setIsCommited(false);
        EventsDispatcher.unmatchedResponseReceived(servletResponse);
    }

    private boolean isExpectedStrayResponse(Response response) {
        boolean rc;
        block4: {
            rc = false;
            try {
                int statusCode = response.getStatusCode();
                if (this.is2xx(statusCode) && response.getCSeqHeader().getMethod().equals("INVITE")) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "hanldeStrayResponses", "Handled");
                    }
                    rc = true;
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block4;
                c_logger.error("error.exception", "Parse Failure", null, (Throwable)e2);
            }
        }
        return rc;
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public void loadAppConfiguration(WebApp webApp) {
        if (this.appPathSelector != null) {
            this.appPathSelector.loadAppConfiguration(webApp);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "loadAppConfiguration", "App installed: " + webApp.getName());
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "loadAppConfiguration", "appPathSelector is not initialized yet, will update about loaded applications later in  notifyRouterOnDeployedApps() method.");
        }
    }

    public void notifyRouterOnDeployedApps() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "notifyRouterOnDeployedApps", "");
        }
        this.appPathSelector.notifyRouterOnDeployedApps();
    }

    public synchronized boolean isInitialized() {
        return this.m_initialized;
    }
}

